/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ServerIndianSettlement
extends IndianSettlement
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerIndianSettlement.class.getName());
    public static final int ALARM_NEW_MISSIONARY = -100;
    public static final int MAX_CONVERT_DISTANCE = 10;
    public static final int MAX_HORSES_PER_TURN = 2;

    public ServerIndianSettlement(Game game, String id) {
        super(game, id);
    }

    public ServerIndianSettlement(Game game, Player owner, String name, Tile tile, boolean isCapital, UnitType learnableSkill, Unit missionary) {
        super(game, owner, name, tile);
        this.setGoodsContainer(new GoodsContainer(game, this));
        this.learnableSkill = learnableSkill;
        this.setCapital(isCapital);
        this.missionary = missionary;
        this.convertProgress = 0;
        this.updateWantedGoods();
    }

    public ServerIndianSettlement(Game game, Player owner, Tile tile, IndianSettlement template) {
        super(game, owner, template.getName(), tile);
        this.setLearnableSkill(template.getLearnableSkill());
        this.setCapital(template.isCapital());
        for (Unit unit : template.getUnitList()) {
            ServerUnit newUnit = new ServerUnit(game, this, unit);
            this.add(newUnit);
            this.addOwnedUnit(newUnit);
        }
        Unit missionary = template.getMissionary();
        if (missionary != null) {
            this.missionary = new ServerUnit(game, this, missionary);
        }
        this.setConvertProgress(template.getConvertProgress());
        this.setLastTribute(template.getLastTribute());
        this.setGoodsContainer(new GoodsContainer(game, this));
        Specification spec = this.getSpecification();
        for (Goods goods : template.getCompactGoods()) {
            GoodsType type = spec.getGoodsType(goods.getType().getId());
            this.addGoods(type, goods.getAmount());
        }
        this.wantedGoods = template.getWantedGoods();
    }

    public void csStartTurn(Random random, ChangeSet cs) {
        Specification spec = this.getSpecification();
        Unit missionary = this.getMissionary();
        if (missionary == null) {
            return;
        }
        ServerPlayer other = (ServerPlayer)missionary.getOwner();
        Tile tile = this.getTile();
        Turn turn = this.getGame().getTurn();
        float convert = this.getConvertProgress();
        float cMiss = missionary.applyModifiers(missionary.getType().getSkill(), turn, "model.modifier.conversionSkill");
        int alarm = Math.min(this.getAlarm(other).getValue(), Tension.TENSION_MAX);
        float cAlarm = missionary.applyModifiers(alarm, turn, "model.modifier.conversionAlarmRate");
        logger.finest("Conversion at " + this.getName() + " alarm=" + alarm + " " + (convert += cMiss + (cAlarm - (float)alarm)) + " = " + this.getConvertProgress() + " + " + cMiss + " + " + cAlarm);
        Settlement colony = tile.getNearestSettlement(other, 10, true);
        if (convert < (float)this.getType().getConvertThreshold() || this.getUnitCount() + tile.getUnitCount() <= 2 || colony == null) {
            this.setConvertProgress((int)Math.floor(convert));
        } else {
            this.setConvertProgress(0);
            List<Unit> ul = tile.getUnitList();
            if (ul.isEmpty()) {
                ul.addAll(this.getUnitList());
            }
            ServerUnit brave = (ServerUnit)RandomUtils.getRandomMember(logger, "Convert", ul, random);
            ServerPlayer owner = (ServerPlayer)this.getOwner();
            if (owner.csChangeOwner(brave, other, UnitTypeChange.ChangeType.CONVERSION, colony.getTile(), cs)) {
                brave.changeRole(spec.getDefaultRole(), 0);
                brave.setMovesLeft(0);
                brave.setState(Unit.UnitState.ACTIVE);
                cs.addDisappear(other, tile, brave);
                cs.add(ChangeSet.See.only(other), colony.getTile());
                StringTemplate nation = owner.getNationName();
                cs.addMessage(ChangeSet.See.only(other), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newConvert", brave).addStringTemplate("%nation%", nation).addName("%colony%", colony.getName()));
                other.invalidateCanSeeTiles();
                logger.fine("Convert at " + this.getName() + " for " + colony.getName());
            }
        }
    }

    public void addUnits(Random random) {
        int low = this.getType().getMinimumSize();
        int high = this.getType().getMaximumSize();
        int count = random == null ? (high + low) / 2 : RandomUtils.randomInt(logger, "Units at " + this.getName(), random, high - low + 1) + low;
        this.addUnits(count);
    }

    public void addUnits(int count) {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        UnitType brave = spec.getUnitType("model.unit.brave");
        for (int i = 0; i < count; ++i) {
            ServerUnit unit = new ServerUnit(game, this, this.getOwner(), brave, brave.getDefaultRole());
            unit.setHomeIndianSettlement(this);
            unit.setLocation(this);
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add(this);
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        Specification spec = this.getSpecification();
        List<GoodsType> goodsList = spec.getGoodsTypeList();
        for (GoodsType g : goodsList) {
            this.addGoods(g.getStoredAs(), this.getTotalProductionOf(g));
        }
        for (GoodsType g : goodsList) {
            this.consumeGoods(g, this.getConsumptionOf(g));
        }
        int storedFood = this.getGoodsCount(spec.getPrimaryFoodType());
        if (storedFood <= 0 && this.getUnitCount() > 0) {
            Unit victim = RandomUtils.getRandomMember(logger, "Choose starver", this.getUnitList(), random);
            cs.addRemove(ChangeSet.See.only(owner), this, victim);
            victim.dispose();
            lb.add(" FAMINE");
        }
        if (this.getUnitCount() <= 0) {
            if (this.tile.isEmpty()) {
                lb.add(" COLLAPSED, ");
                owner.csDisposeSettlement(this, cs);
                return;
            }
            this.tile.getFirstUnit().setLocation(this);
        }
        GoodsType foodType = spec.getPrimaryFoodType();
        GoodsType rumType = spec.getGoodsType("model.goods.rum");
        List<UnitType> unitTypes = spec.getUnitTypesWithAbility("model.ability.bornInIndianSettlement");
        if (!unitTypes.isEmpty() && this.getGoodsCount(foodType) + 4 * this.getGoodsCount(rumType) > 250) {
            if (this.ownedUnits.size() <= this.getType().getMaximumSize()) {
                UnitType type = RandomUtils.getRandomMember(logger, "Choose birth", unitTypes, random);
                ServerUnit unit = new ServerUnit(this.getGame(), this.getTile(), owner, type);
                this.consumeGoods(rumType, 50);
                this.addOwnedUnit(unit);
                unit.setHomeIndianSettlement(this);
                lb.add(" new ", unit);
            }
            this.consumeGoods(foodType, 200);
        }
        GoodsType horsesType = spec.getGoodsType("model.goods.horses");
        GoodsType grainType = spec.getGoodsType("model.goods.grain");
        int foodProdAvail = this.getTotalProductionOf(grainType) - this.getFoodConsumption();
        if (this.getGoodsCount(horsesType) >= horsesType.getBreedingNumber() && foodProdAvail > 0) {
            int nHorses = Math.min(2, foodProdAvail);
            this.addGoods(horsesType, nHorses);
            lb.add(" bred ", nHorses, " horses");
        }
        this.getGoodsContainer().removeAbove(this.getWarehouseCapacity());
        this.updateWantedGoods();
        cs.add(ChangeSet.See.only(owner), this);
        lb.add(", ");
    }

    private void consumeGoods(GoodsType type, int amount) {
        if (this.getGoodsCount(type) > 0) {
            amount = Math.min(amount, this.getGoodsCount(type));
            this.removeGoods(type, amount);
        }
    }

    @Override
    public void setAlarm(Player player, Tension newAlarm) {
        if (player != null && player != this.owner) {
            super.setAlarm(player, newAlarm);
            this.updateMostHated();
        }
    }

    public void removeAlarm(Player player) {
        if (player != null) {
            this.alarm.remove(player);
            this.updateMostHated();
        }
    }

    public boolean updateMostHated() {
        Player old = this.mostHated;
        this.mostHated = null;
        int bestValue = Integer.MIN_VALUE;
        for (Player p : this.getGame().getLiveEuropeanPlayers(null)) {
            int value;
            Tension alarm = this.getAlarm(p);
            if (alarm == null || alarm.getLevel() == Tension.Level.HAPPY || bestValue >= (value = alarm.getValue())) continue;
            bestValue = value;
            this.mostHated = p;
        }
        return this.mostHated != old;
    }

    private boolean changeAlarm(Player player, int amount) {
        Tension alarm = this.getAlarm(player);
        if (alarm == null) {
            this.initializeAlarm(player);
            alarm = this.getAlarm(player);
        }
        Tension.Level oldLevel = alarm.getLevel();
        alarm.modify(amount);
        boolean change = this.updateMostHated();
        return change || oldLevel != alarm.getLevel();
    }

    private boolean csChangeAlarm(Player player, int add, boolean propagate, ChangeSet cs) {
        boolean change = this.changeAlarm(player, add);
        if (propagate) {
            ((ServerPlayer)this.getOwner()).csModifyTension(player, this.isCapital() ? add : add / 2, this, cs);
        }
        logger.finest("Alarm at " + this.getName() + " toward " + player.getName() + " modified by " + add + " now = " + this.getAlarm(player).getValue());
        return change;
    }

    public boolean csModifyAlarm(Player player, int add, boolean propagate, ChangeSet cs) {
        Tile copied = this.getTile().getTileToCache();
        boolean change = this.csChangeAlarm(player, add, propagate, cs);
        if (change) {
            this.getTile().cacheUnseen(copied);
            cs.add(ChangeSet.See.perhaps(), this);
        }
        return change;
    }

    public void csChangeMissionary(Unit missionary, ChangeSet cs) {
        Unit old = this.getMissionary();
        if (missionary == old) {
            return;
        }
        Tile tile = this.getTile();
        ServerPlayer newOwner = missionary == null ? null : (ServerPlayer)missionary.getOwner();
        tile.cacheUnseen(newOwner);
        if (old != null) {
            ServerPlayer oldOwner = (ServerPlayer)old.getOwner();
            this.setMissionary(null);
            tile.updateIndianSettlement(oldOwner);
            cs.addRemove(ChangeSet.See.only(oldOwner), null, old);
            old.dispose();
            cs.add(ChangeSet.See.only(oldOwner), tile);
            oldOwner.invalidateCanSeeTiles();
        }
        if (missionary != null) {
            this.setMissionary(missionary);
            missionary.setLocation(null);
            missionary.setLocationNoUpdate(this);
            missionary.setMovesLeft(0);
            cs.add(ChangeSet.See.only(newOwner), missionary);
            this.setConvertProgress(0);
            this.csChangeAlarm(newOwner, -100, true, cs);
            tile.updateIndianSettlement(newOwner);
            int radius = this.getMissionaryLineOfSight();
            for (Tile t : tile.getSurroundingTiles(1, radius)) {
                if (!newOwner.exploreTile(t) && newOwner.canSee(t)) continue;
                cs.add(ChangeSet.See.only(newOwner), t);
            }
            cs.add(ChangeSet.See.perhaps().always(newOwner), tile);
            newOwner.invalidateCanSeeTiles();
        }
    }

    public void csKillMissionary(String messageId, ChangeSet cs) {
        Unit missionary = this.getMissionary();
        if (missionary == null) {
            return;
        }
        this.csChangeMissionary(null, cs);
        ServerPlayer missionaryOwner = (ServerPlayer)missionary.getOwner();
        if ("indianSettlement.mission.denounced".equals(messageId)) {
            cs.addMessage(ChangeSet.See.only(missionaryOwner), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, this).addStringTemplate("%settlement%", this.getLocationLabelFor(missionaryOwner)));
        } else if ("indianSettlement.mission.destroyed".equals(messageId)) {
            cs.addMessage(ChangeSet.See.only(missionaryOwner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, messageId, this).addStringTemplate("%settlement%", this.getLocationLabelFor(missionaryOwner)));
        }
    }

    public boolean csEquipForRole(Unit unit, Role role, int roleCount, Random random, ChangeSet cs) {
        boolean ret = this.equipForRole(unit, role, roleCount);
        if (ret) {
            cs.add(ChangeSet.See.only((ServerPlayer)this.getOwner()), this.getTile());
        }
        return ret;
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverIndianSettlement";
    }
}

