/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.EnumMap;
import java.util.Map;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public class RiverSection {
    private static final char[] template = new char[]{'0', '1', '2', '3'};
    private Map<Map.Direction, Integer> branches = new EnumMap<Map.Direction, Integer>(Map.Direction.class);
    private int size = 1;
    public Map.Direction direction;
    private Tile tile;

    public RiverSection(Map<Map.Direction, Integer> branches) {
        this.branches = branches;
    }

    public RiverSection(Tile tile, Map.Direction direction) {
        this.tile = tile;
        this.direction = direction;
        this.setBranch(direction, 1);
    }

    public final Tile getTile() {
        return this.tile;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setBranch(Map.Direction direction, int size) {
        if (size != 1) {
            size = 2;
        }
        this.branches.put(direction, size);
    }

    public final int getBranch(Map.Direction direction) {
        if (this.branches.containsKey((Object)direction)) {
            return this.branches.get((Object)direction);
        }
        return 0;
    }

    public final void removeBranch(Map.Direction direction) {
        this.branches.remove((Object)direction);
    }

    public final void growBranch(Map.Direction direction, int increment) {
        int newSize = Math.min(2, Math.max(0, this.getBranch(direction) + increment));
        this.setBranch(direction, newSize);
    }

    public void grow() {
        ++this.size;
        this.setBranch(this.direction, 2);
    }

    public String encodeStyle() {
        StringBuilder sb = new StringBuilder();
        for (Map.Direction direction : Map.Direction.longSides) {
            sb.append(Integer.toString(this.getBranch(direction), 36));
        }
        return sb.toString();
    }
}

