/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.FreeColServerHolder;
import net.sf.freecol.server.control.InputHandler;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class UserConnectionHandler
extends FreeColServerHolder
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(UserConnectionHandler.class.getName());

    public UserConnectionHandler(FreeColServer freeColServer) {
        super(freeColServer);
    }

    @Override
    public synchronized Element handle(Connection conn, Element element) {
        String tag = element.getTagName();
        return "disconnect".equals(tag) ? this.disconnect(conn, element) : ("gameState".equals(tag) ? this.gameState(conn, element) : ("getVacantPlayers".equals(tag) ? this.getVacantPlayers(conn, element) : ("login".equals(tag) ? this.login(conn, element) : this.unknown(tag))));
    }

    private Element disconnect(Connection connection, Element element) {
        connection.reallyClose();
        return null;
    }

    private Element gameState(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        Element reply = DOMMessage.createMessage("gameState", new String[0]);
        reply.setAttribute("state", freeColServer.getGameState().toString());
        return reply;
    }

    private Element getVacantPlayers(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame game = this.getGame();
        Element reply = DOMMessage.createMessage("vacantPlayers", new String[0]);
        Document doc = reply.getOwnerDocument();
        for (Player p : game.getLiveEuropeanPlayers(null)) {
            if (p.isREF() || !p.isAI() && ((ServerPlayer)p).isConnected()) continue;
            Element playerElement = doc.createElement("player");
            playerElement.setAttribute("username", p.getNationId());
            reply.appendChild(playerElement);
        }
        return reply;
    }

    private Element login(Connection connection, Element element) {
        InputHandler mh;
        ServerPlayer player;
        ServerGame game;
        boolean starting;
        String userName = element.getAttribute("userName");
        String version = element.getAttribute("version");
        if (userName == null || userName.isEmpty()) {
            return DOMMessage.createError("server.missingUserName", null);
        }
        if (version == null || version.isEmpty()) {
            return DOMMessage.createError("server.missingVersion", null);
        }
        if (!version.equals(FreeCol.getVersion())) {
            return DOMMessage.createError("server.wrongFreeColVersion", version + " != " + FreeCol.getVersion());
        }
        FreeColServer freeColServer = this.getFreeColServer();
        Server server = freeColServer.getServer();
        Unit active = null;
        boolean isCurrentPlayer = false;
        boolean bl = starting = freeColServer.getGameState() == FreeColServer.GameState.STARTING_GAME;
        if (starting) {
            int timeOut = 20000;
            while (freeColServer.getGame() == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((timeOut -= 1000) > 0) continue;
                return DOMMessage.createError("server.timeOut", null);
            }
            game = freeColServer.getGame();
            if (!game.canAddNewPlayer()) {
                return DOMMessage.createError("server.maximumPlayers", null);
            }
            if (game.playerNameInUse(userName)) {
                return DOMMessage.createError("server.userNameInUse", userName + " is already in use.");
            }
            boolean admin = game.getLivePlayers(null).isEmpty();
            player = new ServerPlayer(game, admin, game.getVacantNation(), connection.getSocket(), connection);
            player.setName(userName);
            game.addPlayer(player);
            Element add = DOMMessage.createMessage("addPlayer", new String[0]);
            add.appendChild(player.toXMLElement(add.getOwnerDocument()));
            server.sendToAll(add, connection);
            mh = freeColServer.getPreGameInputHandler();
        } else {
            game = freeColServer.getGame();
            player = (ServerPlayer)game.getPlayerByName(userName);
            if (player == null) {
                StringBuilder sb = new StringBuilder("Player \"");
                sb.append(userName).append("\" is not present in the game.").append("\n  Known players = ( ");
                for (Player p : game.getLiveEuropeanPlayers(null)) {
                    sb.append(p.getName()).append(" ");
                }
                sb.append(")");
                return DOMMessage.createError("server.userNameNotPresent", sb.toString());
            }
            if (player.isConnected() && !player.isAI()) {
                return DOMMessage.createError("server.userNameInUse", userName + " is already in use.");
            }
            player.setConnection(connection);
            player.setConnected(true);
            if (player.isAI()) {
                player.setAI(false);
                server.sendToAll(DOMMessage.createMessage("setAI", "player", player.getId(), "ai", Boolean.toString(false)));
            }
            boolean bl2 = isCurrentPlayer = game.getCurrentPlayer() == null;
            if (isCurrentPlayer) {
                game.setCurrentPlayer(player);
                active = freeColServer.getActiveUnit();
            }
            mh = freeColServer.getInGameInputHandler();
        }
        connection.setMessageHandler(mh);
        server.addConnection(connection);
        try {
            freeColServer.updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            logger.log(Level.WARNING, "Unable to update meta-server.", e);
        }
        return new LoginMessage(player, userName, version, !starting, freeColServer.isSinglePlayer(), isCurrentPlayer, active, game).toXMLElement();
    }

    private Element unknown(String tag) {
        logger.warning("Unknown user connection request: " + tag);
        return null;
    }
}

