/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.GoodsForSaleMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.RearrangeColonyMessage;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.model.DiplomacySession;
import net.sf.freecol.server.model.LootSession;
import net.sf.freecol.server.model.MonarchSession;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TradeSession;
import net.sf.freecol.server.model.TransactionSession;
import org.w3c.dom.Element;

public final class InGameController
extends Controller {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    public static final int SCORE_INDEPENDENCE_YEAR = 1780;
    public static final Turn.Season SCORE_INDEPENDENCE_SEASON = Turn.Season.SPRING;
    private final Random random;
    private int debugOnlyAITurns = 0;
    private Monarch.MonarchAction debugMonarchAction = null;
    private ServerPlayer debugMonarchPlayer = null;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public InGameController(FreeColServer freeColServer, Random random) {
        super(freeColServer);
        this.random = random;
    }

    public int getSkippedTurns() {
        return FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? this.debugOnlyAITurns : -1;
    }

    public void setSkippedTurns(int turns) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.debugOnlyAITurns = turns;
        }
    }

    public void setMonarchAction(ServerPlayer serverPlayer, Monarch.MonarchAction action) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.debugMonarchPlayer = serverPlayer;
            this.debugMonarchAction = action;
        }
    }

    public int stepRandom() {
        return RandomUtils.randomInt(logger, "step random", this.random, 100);
    }

    public void yearlyGoodsAdjust(ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csYearlyGoodsAdjust(this.random, cs);
        this.sendElement(serverPlayer, cs);
    }

    public void addFoundingFather(ServerPlayer serverPlayer, FoundingFather father) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csAddFoundingFather(father, this.random, cs);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "flush", Boolean.TRUE.toString());
        this.sendElement(serverPlayer, cs);
    }

    public void changeStance(ServerPlayer serverPlayer, Player.Stance stance, ServerPlayer other, boolean symmetric) {
        ChangeSet cs = new ChangeSet();
        if (serverPlayer.csChangeStance(stance, other, symmetric, cs)) {
            this.sendToAll(cs, new ServerPlayer[0]);
        }
    }

    public void debugChangeOwner(ServerColony colony, ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        ServerPlayer owner = (ServerPlayer)colony.getOwner();
        colony.csChangeOwner(serverPlayer, cs);
        cs.add(ChangeSet.See.perhaps().always(owner), colony.getOwnedTiles());
        serverPlayer.invalidateCanSeeTiles();
        owner.invalidateCanSeeTiles();
        this.sendToAll(cs, new ServerPlayer[0]);
    }

    public void debugChangeOwner(ServerUnit unit, ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        ServerPlayer owner = (ServerPlayer)unit.getOwner();
        owner.csChangeOwner(unit, serverPlayer, null, null, cs);
        cs.add(ChangeSet.See.perhaps().always(owner), unit.getTile());
        serverPlayer.invalidateCanSeeTiles();
        owner.invalidateCanSeeTiles();
        this.sendToAll(cs, new ServerPlayer[0]);
    }

    public int debugApplyDisaster(ServerColony colony, Disaster disaster) {
        ChangeSet cs = new ChangeSet();
        ServerPlayer owner = (ServerPlayer)colony.getOwner();
        List<ModelMessage> messages = owner.csApplyDisaster(this.random, colony, disaster, cs);
        if (!messages.isEmpty()) {
            cs.addMessage(ChangeSet.See.all(), new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.strikes", owner).addName("%colony%", colony.getName()).addName("%disaster%", disaster));
            for (ModelMessage message : messages) {
                cs.addMessage(ChangeSet.See.all(), message);
            }
            this.sendToAll(cs, new ServerPlayer[0]);
        }
        return messages.size();
    }

    private void moveGoods(GoodsLocation src, GoodsType goodsType, int amount, GoodsLocation dst) {
        src.getGoodsContainer().saveState();
        src.removeGoods(goodsType, amount);
        if (dst != null) {
            dst.getGoodsContainer().saveState();
            dst.addGoods(goodsType, amount);
        }
    }

    public NationSummary getNationSummary(ServerPlayer serverPlayer, Player player) {
        return new NationSummary(player, serverPlayer);
    }

    public ServerPlayer createREFPlayer(ServerPlayer serverPlayer) {
        Nation refNation = serverPlayer.getNation().getREFNation();
        Monarch monarch = serverPlayer.getMonarch();
        ServerPlayer refPlayer = this.getFreeColServer().addAIPlayer(refNation);
        Europe europe = refPlayer.getEurope();
        HashSet<Tile> explore = new HashSet<Tile>();
        for (Tile t : this.getGame().getMap().getAllTiles()) {
            if (!t.isExploredBy(serverPlayer) || t.isLand() && !t.isCoastland() && t.getOwner() != serverPlayer) continue;
            explore.add(t);
        }
        refPlayer.exploreTiles(explore);
        refPlayer.setEntryLocation(null);
        Player.makeContact(serverPlayer, refPlayer);
        Monarch.Force exf = monarch.getExpeditionaryForce();
        UnitType ut = monarch.getNavalREFUnitType();
        while (exf.getSpaceRequired() < exf.getCapacity()) {
            AbstractUnit au = new AbstractUnit(ut, "model.role.default", 1);
            exf.add(au);
        }
        List<Unit> landUnits = refPlayer.createUnits(exf.getLandUnits(), europe);
        List<Unit> navalUnits = refPlayer.createUnits(exf.getNavalUnits(), europe);
        refPlayer.loadShips(landUnits, navalUnits, this.random);
        return refPlayer;
    }

    private Future<DOMMessage> askFuture(ServerPlayer serverPlayer, DOMMessage question, DOMMessageHandler handler) {
        DOMMessageCallable callable = new DOMMessageCallable(serverPlayer.getConnection(), this.getGame(), question, handler);
        return this.executor.submit(callable);
    }

    private DOMMessage askTimeout(ServerPlayer serverPlayer, DOMMessage request) {
        DOMMessage reply;
        Future<DOMMessage> future = this.askFuture(serverPlayer, request, new DOMMessageHandler(){

            @Override
            public DOMMessage handle(DOMMessage message) {
                return message;
            }
        });
        try {
            boolean single = this.getFreeColServer().isSinglePlayer();
            reply = future.get(FreeCol.getTimeout(single), TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            this.sendElement(serverPlayer, new ChangeSet().addTrivial(ChangeSet.See.only(serverPlayer), "closeMenus", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]));
            reply = null;
        }
        catch (Exception e) {
            reply = null;
            logger.log(Level.WARNING, "Exception completing future", e);
        }
        return reply;
    }

    private List<ServerPlayer> getOtherLivePlayers(ServerPlayer ... serverPlayers) {
        ArrayList<ServerPlayer> result = new ArrayList<ServerPlayer>();
        block0: for (Player otherPlayer : this.getGame().getLivePlayers(null)) {
            ServerPlayer enemyPlayer = (ServerPlayer)otherPlayer;
            if (!enemyPlayer.isConnected()) continue;
            for (ServerPlayer exclude : serverPlayers) {
                if (enemyPlayer == exclude) continue block0;
            }
            result.add(enemyPlayer);
        }
        return result;
    }

    private void sendToAll(ChangeSet cs, ServerPlayer ... serverPlayers) {
        List<ServerPlayer> live = this.getOtherLivePlayers(new ServerPlayer[0]);
        for (ServerPlayer sp : serverPlayers) {
            if (live.contains(sp)) continue;
            live.add(sp);
        }
        this.sendToList(live, cs);
    }

    private void sendToOthers(ServerPlayer serverPlayer, ChangeSet cs) {
        this.sendToList(this.getOtherLivePlayers(serverPlayer), cs);
    }

    private void sendToOthers(ServerPlayer serverPlayer, Element element) {
        this.sendToList(this.getOtherLivePlayers(serverPlayer), element);
    }

    private void sendToList(List<ServerPlayer> serverPlayers, ChangeSet cs) {
        for (ServerPlayer s : serverPlayers) {
            this.sendElement(s, cs);
        }
    }

    private void sendToList(List<ServerPlayer> serverPlayers, Element element) {
        if (element != null) {
            for (ServerPlayer s : serverPlayers) {
                this.askElement(s, element);
            }
        }
    }

    private void sendElement(ServerPlayer serverPlayer, ChangeSet cs) {
        this.askElement(serverPlayer, cs.build(serverPlayer));
    }

    private void askElement(ServerPlayer serverPlayer, Element request) {
        Connection connection = serverPlayer.getConnection();
        if (connection == null) {
            return;
        }
        while (request != null) {
            Element reply;
            block7: {
                try {
                    reply = connection.ask(request);
                    if (reply == null) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not send \"" + request.getTagName() + "\"-message.", e);
                }
                break;
            }
            try {
                request = connection.handle(reply);
            }
            catch (FreeColException fce) {
                logger.log(Level.WARNING, "Exception processing reply \"" + reply.getTagName() + "\"-message.", fce);
                break;
            }
        }
    }

    private void csVisit(ServerPlayer serverPlayer, IndianSettlement is, int scout, ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)is.getOwner();
        if (serverPlayer.csContact(owner, cs)) {
            serverPlayer.csNativeFirstContact(owner, null, cs);
        }
        is.setVisited(serverPlayer);
        if (scout > 0 || scout == 0 && this.getGame().getSpecification().getBoolean("model.option.settlementActionsContactChief")) {
            is.setScouted(serverPlayer);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public Element endTurn(ServerPlayer serverPlayer) {
        ChangeSet cs;
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame game = this.getGame();
        ServerPlayer winner = (ServerPlayer)game.checkForWinner();
        ServerPlayer player = (ServerPlayer)game.getCurrentPlayer();
        if (serverPlayer != player) {
            throw new IllegalArgumentException("It is not " + serverPlayer.getName() + "'s turn, it is " + (player == null ? "noone" : player.getName()) + "'s!");
        }
        block4: while (true) {
            boolean debugSkip;
            Object p2;
            logger.finest("Ending turn for " + player.getName());
            player.clearModelMessages();
            cs = new ChangeSet();
            if (game.isNextPlayerInNewTurn()) {
                ChangeSet next = new ChangeSet();
                game.csNextTurn(next);
                this.sendToAll(next, new ServerPlayer[0]);
                LogBuilder lb = new LogBuilder(512);
                lb.add("New turn ", game.getTurn(), " for ");
                game.csNewTurn(this.random, lb, cs);
                lb.shrink(", ");
                lb.log(logger, Level.FINEST);
                if (this.debugOnlyAITurns > 0 && --this.debugOnlyAITurns <= 0) {
                    FreeColDebugger.signalEndDebugRun();
                }
            }
            if ((player = (ServerPlayer)game.getNextPlayer()) == null) {
                return DOMMessage.clientError("Can not get next player");
            }
            switch (player.checkForDeath()) {
                case -1: {
                    player.csWithdraw(cs);
                    logger.info("For " + serverPlayer.getSuffix() + ", " + player.getNation() + " is dead.");
                    this.sendToAll(cs, player);
                    continue block4;
                }
                case 0: {
                    if (!player.isREF() || !player.checkForREFDefeat()) break;
                    for (Object p2 : player.getRebels()) {
                        this.csGiveIndependence(player, (ServerPlayer)p2, cs);
                    }
                    player.csWithdraw(cs);
                    logger.info(player.getNation() + " is defeated.");
                    this.sendToAll(cs, player);
                    continue block4;
                }
                default: {
                    player.csEmigrate(0, Europe.MigrationType.SURVIVAL, this.random, cs);
                }
            }
            boolean human = false;
            p2 = game.getLivePlayers(null).iterator();
            while (p2.hasNext()) {
                Player p3 = p2.next();
                if (p3.isAI() || !((ServerPlayer)p3).isConnected()) continue;
                human = true;
                break;
            }
            if (!human) {
                logger.info("No human player left.");
                if (this.debugOnlyAITurns > 0) {
                    FreeColDebugger.signalEndDebugRun();
                }
                game.setCurrentPlayer(null);
                cs.addTrivial(ChangeSet.See.all(), "gameEnded", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]);
                this.sendToOthers(serverPlayer, cs);
                return cs.build(serverPlayer);
            }
            if (!(winner != player || freeColServer.isSinglePlayer() && winner.isAI())) {
                boolean highScore = !winner.isAI() && HighScore.newHighScore(winner);
                cs.addTrivial(ChangeSet.See.all(), "gameEnded", ChangeSet.ChangePriority.CHANGE_NORMAL, "highScore", String.valueOf(highScore), "winner", winner.getId());
            }
            game.setCurrentPlayer(player);
            if (player.isREF() && player.getEntryLocation() == null) {
                boolean teleport;
                REFAIPlayer refAIPlayer = (REFAIPlayer)freeColServer.getAIPlayer(player);
                if (refAIPlayer.initialize(teleport = this.getGame().getSpecification().getBoolean("model.option.teleportREF"))) {
                    this.csLaunchREF(player, teleport, cs);
                } else {
                    logger.severe("REF failed to initialize.");
                }
            }
            player.csStartTurn(this.random, cs);
            cs.addTrivial(ChangeSet.See.all(), "setCurrentPlayer", ChangeSet.ChangePriority.CHANGE_LATE, "player", player.getId());
            if (player.getPlayerType() == Player.PlayerType.COLONIAL) {
                Monarch monarch = player.getMonarch();
                Monarch.MonarchAction action = null;
                if (this.debugMonarchAction != null && player == this.debugMonarchPlayer) {
                    action = this.debugMonarchAction;
                    this.debugMonarchAction = null;
                    this.debugMonarchPlayer = null;
                    logger.finest("Debug monarch action: " + (Object)((Object)action));
                } else {
                    action = (Monarch.MonarchAction)((Object)RandomChoice.getWeightedRandom(logger, "Choose monarch action", monarch.getActionChoices(), this.random));
                }
                if (action != null) {
                    if (monarch.actionIsValid(action)) {
                        logger.finest("Monarch action: " + (Object)((Object)action));
                        this.csMonarchAction(player, action, cs);
                    } else {
                        logger.finest("Skipping invalid monarch action: " + (Object)((Object)action));
                    }
                }
            }
            boolean bl = debugSkip = !player.isAI() && freeColServer.isSinglePlayer() && this.debugOnlyAITurns > 0;
            if (!debugSkip) break;
            this.sendToOthers(player, cs);
            this.sendElement(player, cs);
        }
        this.sendToList(this.getOtherLivePlayers(player, serverPlayer), cs);
        if (player != serverPlayer) {
            this.sendElement(player, cs);
        }
        return cs.build(serverPlayer);
    }

    private void csLaunchREF(ServerPlayer serverPlayer, boolean teleport, ChangeSet cs) {
        Iterator<FreeColGameObject> iterator = serverPlayer.getRebels().iterator();
        if (iterator.hasNext()) {
            Player p = iterator.next();
            serverPlayer.setEntryLocation(p.getEntryLocation().getTile());
        }
        if (teleport) {
            HashSet<Tile> seen = new HashSet<Tile>();
            for (Unit u : serverPlayer.getUnits()) {
                if (!u.isNaval()) continue;
                Tile entry = u.getEntryLocation().getTile();
                u.setLocation(entry);
                u.setWorkLeft(-1);
                u.setState(Unit.UnitState.ACTIVE);
                if (seen.contains(entry)) continue;
                seen.add(entry);
                cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.exploreForUnit(u));
                cs.add(ChangeSet.See.perhaps().except(serverPlayer), entry);
            }
            serverPlayer.invalidateCanSeeTiles();
        } else {
            for (Unit u : serverPlayer.getUnits()) {
                if (!u.isNaval()) continue;
                u.setWorkLeft(1);
                u.setDestination(u.getEntryLocation());
                u.setLocation(u.getOwner().getHighSeas());
            }
        }
    }

    private void csGiveIndependence(ServerPlayer serverPlayer, ServerPlayer independent, ChangeSet cs) {
        serverPlayer.csChangeStance(Player.Stance.PEACE, independent, true, cs);
        independent.changePlayerType(Player.PlayerType.INDEPENDENT);
        ServerGame game = this.getGame();
        Turn turn = game.getTurn();
        independent.setTax(0);
        independent.reinitialiseMarket();
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.EventType.INDEPENDENCE, independent);
        int n = 0;
        for (Player p : game.getLiveEuropeanPlayers(independent)) {
            if (p.getPlayerType() != Player.PlayerType.INDEPENDENT) continue;
            ++n;
        }
        h.setScore(n);
        cs.addGlobalHistory(game, h);
        cs.addMessage(ChangeSet.See.only(independent), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.independence", independent).addStringTemplate("%ref%", serverPlayer.getNationName()));
        ArrayList<Unit> surrenderUnits = new ArrayList<Unit>();
        for (Unit u : serverPlayer.getUnits()) {
            if (!u.hasTile() || u.isNaval() || u.isOnCarrier() || !serverPlayer.csChangeOwner(u, independent, UnitTypeChange.ChangeType.CAPTURE, null, cs)) continue;
            u.setMovesLeft(0);
            u.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), u.getTile());
            surrenderUnits.add(u);
        }
        if (!surrenderUnits.isEmpty()) {
            cs.addMessage(ChangeSet.See.only(independent), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.independence.unitsAcquired", independent).addStringTemplate("%units%", this.unitTemplate(", ", surrenderUnits)));
            independent.invalidateCanSeeTiles();
            serverPlayer.invalidateCanSeeTiles();
        }
        cs.addPartial(ChangeSet.See.all().except(independent), independent, "playerType");
        cs.addMessage(ChangeSet.See.all().except(independent), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.independence.announce", independent).addStringTemplate("%nation%", independent.getNationName()).addStringTemplate("%ref%", serverPlayer.getNationName()));
        cs.add(ChangeSet.See.only(independent), independent);
        cs.add(ChangeSet.See.only(independent), independent.exploreMap(true));
    }

    private StringTemplate unitTemplate(String base, List<Unit> units) {
        StringTemplate template = StringTemplate.label(base);
        for (Unit u : units) {
            template.addStringTemplate(u.getLabel(Unit.UnitLabelType.PLAIN));
        }
        return template;
    }

    private StringTemplate abstractUnitTemplate(String base, List<AbstractUnit> units) {
        StringTemplate template = StringTemplate.label(base);
        for (AbstractUnit au : units) {
            template.addStringTemplate(au.getLabel());
        }
        return template;
    }

    private void raiseTax(ServerPlayer serverPlayer, int taxRaise, Goods goods, boolean result) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csRaiseTax(taxRaise, goods, result, cs);
        this.sendElement(serverPlayer, cs);
    }

    private void csMonarchAction(ServerPlayer serverPlayer, Monarch.MonarchAction action, ChangeSet cs) {
        Monarch monarch = serverPlayer.getMonarch();
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        boolean valid = monarch.actionIsValid(action);
        if (!valid) {
            return;
        }
        String messageId = "model.monarch.action." + (Object)((Object)action);
        String monarchKey = serverPlayer.getMonarchKey();
        switch (action) {
            case NO_ACTION: {
                break;
            }
            case RAISE_TAX_WAR: 
            case RAISE_TAX_ACT: {
                int taxRaise = monarch.raiseTax(this.random);
                Goods goods = serverPlayer.getMostValuableGoods();
                if (goods == null) {
                    logger.finest("Ignoring tax raise, no goods to boycott.");
                    break;
                }
                StringTemplate template = StringTemplate.template("model.monarch.action." + (Object)((Object)action)).addStringTemplate("%goods%", goods.getType().getLabel()).addAmount("%amount%", taxRaise);
                if (action == Monarch.MonarchAction.RAISE_TAX_WAR) {
                    template = template.add("%nation%", Nation.getRandomNonPlayerNationNameKey(game, this.random));
                } else if (action == Monarch.MonarchAction.RAISE_TAX_ACT) {
                    template = template.addAmount("%number%", RandomUtils.randomInt(logger, "Tax act goods", this.random, 6)).addName("%newWorld%", serverPlayer.getNewLandName());
                }
                MonarchActionMessage message = new MonarchActionMessage(action, template, monarchKey).setTax(taxRaise);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_EARLY, message);
                new MonarchSession(serverPlayer, action, taxRaise, goods);
                break;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                int oldTax = serverPlayer.getTax();
                int taxLower = monarch.lowerTax(this.random);
                serverPlayer.csSetTax(taxLower, cs);
                StringTemplate template = StringTemplate.template(messageId).addAmount("%difference%", oldTax - taxLower).addAmount("%newTax%", taxLower);
                template = action == Monarch.MonarchAction.LOWER_TAX_WAR ? template.add("%nation%", Nation.getRandomNonPlayerNationNameKey(game, this.random)) : template.addAmount("%number%", RandomUtils.randomInt(logger, "Lower tax reason", this.random, 5));
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, template, monarchKey));
                break;
            }
            case WAIVE_TAX: {
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_NORMAL, new MonarchActionMessage(action, StringTemplate.template(messageId), monarchKey));
                break;
            }
            case ADD_TO_REF: {
                AbstractUnit refAdditions = monarch.chooseForREF(this.random);
                if (refAdditions == null) break;
                monarch.getExpeditionaryForce().add(refAdditions);
                StringTemplate template = StringTemplate.template(messageId).addAmount("%number%", refAdditions.getNumber()).add("%unit%", refAdditions.getType(spec).getNameKey());
                cs.add(ChangeSet.See.only(serverPlayer), monarch);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, template, monarchKey));
                break;
            }
            case DECLARE_PEACE: {
                List<Player> friends = monarch.collectPotentialFriends();
                if (friends.isEmpty()) break;
                Player friend = RandomUtils.getRandomMember(logger, "Choose friend", friends, this.random);
                serverPlayer.csChangeStance(Player.Stance.PEACE, (ServerPlayer)friend, true, cs);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, StringTemplate.template(messageId).addStringTemplate("%nation%", friend.getNationName()), monarchKey));
                break;
            }
            case DECLARE_WAR: {
                List<Player> enemies = monarch.collectPotentialEnemies();
                if (enemies.isEmpty()) break;
                Player enemy = RandomUtils.getRandomMember(logger, "Choose enemy", enemies, this.random);
                serverPlayer.csChangeStance(Player.Stance.WAR, (ServerPlayer)enemy, true, cs);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, StringTemplate.template(messageId).addStringTemplate("%nation%", enemy.getNationName()), monarchKey));
                break;
            }
            case SUPPORT_LAND: 
            case SUPPORT_SEA: {
                boolean sea = action == Monarch.MonarchAction.SUPPORT_SEA;
                List<AbstractUnit> support = monarch.getSupport(this.random, sea);
                if (support.isEmpty()) break;
                serverPlayer.createUnits(support, serverPlayer.getEurope());
                cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.getEurope());
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, StringTemplate.template(messageId).addStringTemplate("%addition%", this.abstractUnitTemplate(", ", support)), monarchKey));
                break;
            }
            case MONARCH_MERCENARIES: {
                List<AbstractUnit> mercenaries = monarch.getMercenaries(this.random);
                if (mercenaries.isEmpty()) break;
                int mercPrice = serverPlayer.priceMercenaries(mercenaries);
                MonarchActionMessage message = new MonarchActionMessage(action, StringTemplate.template("model.monarch.action.MONARCH_MERCENARIES").addAmount("%gold%", mercPrice).addStringTemplate("%mercenaries%", this.abstractUnitTemplate(", ", mercenaries)), monarchKey);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_EARLY, message);
                new MonarchSession(serverPlayer, action, mercenaries, mercPrice);
                break;
            }
            case HESSIAN_MERCENARIES: {
                List<AbstractUnit> hessians = monarch.getMercenaries(this.random);
                if (hessians.isEmpty()) break;
                int n = Messages.getMercenaryLeaderCount();
                n = RandomUtils.randomInt(logger, "Mercenary leader", this.random, n);
                int hessPrice = serverPlayer.priceMercenaries(hessians);
                MonarchActionMessage message = new MonarchActionMessage(action, StringTemplate.template("model.monarch.action.HESSIAN_MERCENARIES").addName("%leader%", Messages.getMercenaryLeaderName(n)).addAmount("%gold%", hessPrice).addStringTemplate("%mercenaries%", this.abstractUnitTemplate(", ", hessians)), "model.mercenaries." + n + ".image");
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_EARLY, message);
                new MonarchSession(serverPlayer, action, hessians, hessPrice);
                break;
            }
            default: {
                logger.warning("Bogus action: " + (Object)((Object)action));
            }
        }
    }

    public Element monarchAction(ServerPlayer serverPlayer, Monarch.MonarchAction action, boolean result) {
        MonarchSession session = TransactionSession.lookup(MonarchSession.class, serverPlayer.getId(), "");
        if (session == null) {
            return DOMMessage.clientError("Bogus monarch action: " + (Object)((Object)action));
        }
        if (action != session.getAction()) {
            return DOMMessage.clientError("Session action mismatch, " + (Object)((Object)session.getAction()) + " expected: " + (Object)((Object)action));
        }
        ChangeSet cs = new ChangeSet();
        session.complete(result, cs);
        return cs.build(serverPlayer);
    }

    public Element retire(ServerPlayer serverPlayer) {
        boolean highScore = HighScore.newHighScore(serverPlayer);
        ChangeSet cs = new ChangeSet();
        serverPlayer.csWithdraw(cs);
        this.sendToOthers(serverPlayer, cs);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "highScore", Boolean.toString(highScore));
        return cs.build(serverPlayer);
    }

    public Element continuePlaying(ServerPlayer serverPlayer) {
        ServerGame game = this.getGame();
        Object reply = null;
        if (!this.getFreeColServer().isSinglePlayer()) {
            logger.warning("Can not continue playing in multiplayer!");
        } else if (serverPlayer != game.checkForWinner()) {
            logger.warning("Can not continue playing, as " + serverPlayer.getName() + " has not won the game!");
        } else {
            Specification spec = game.getSpecification();
            spec.getBooleanOption("model.option.victoryDefeatREF").setValue(Boolean.FALSE);
            spec.getBooleanOption("model.option.victoryDefeatEuropeans").setValue(Boolean.FALSE);
            spec.getBooleanOption("model.option.victoryDefeatHumans").setValue(Boolean.FALSE);
            logger.info("Disabled victory conditions, as " + serverPlayer.getName() + " has won, but is continuing to play.");
        }
        return null;
    }

    public Element cashInTreasureTrain(ServerPlayer serverPlayer, Unit unit) {
        String messageId;
        int cashInAmount;
        ChangeSet cs = new ChangeSet();
        int fullAmount = unit.getTreasureAmount();
        if (serverPlayer.getPlayerType() == Player.PlayerType.COLONIAL) {
            cashInAmount = (fullAmount - unit.getTransportFee()) * (100 - serverPlayer.getTax()) / 100;
            messageId = "model.unit.cashInTreasureTrain.colonial";
        } else {
            cashInAmount = fullAmount;
            messageId = "model.unit.cashInTreasureTrain.independent";
        }
        serverPlayer.modifyGold(cashInAmount);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(messageId, serverPlayer, (FreeColObject)unit).addAmount("%amount%", fullAmount).addAmount("%cashInAmount%", cashInAmount));
        messageId = serverPlayer.isRebel() || serverPlayer.getPlayerType() == Player.PlayerType.INDEPENDENT ? "model.unit.cashInTreasureTrain.other.independent" : "model.unit.cashInTreasureTrain.other.colonial";
        cs.addMessage(ChangeSet.See.all().except(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, serverPlayer).addAmount("%amount%", fullAmount).addStringTemplate("%nation%", serverPlayer.getNationName()));
        cs.add(ChangeSet.See.only(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        cs.addRemove(ChangeSet.See.only(serverPlayer), null, unit);
        unit.dispose();
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element declareIndependence(ServerPlayer serverPlayer, String nationName, String countryName) {
        ChangeSet cs = new ChangeSet();
        StringTemplate oldNation = serverPlayer.getNationName();
        serverPlayer.setIndependentNationName(nationName);
        serverPlayer.setNewLandName(countryName);
        serverPlayer.changePlayerType(Player.PlayerType.REBEL);
        Turn turn = this.getGame().getTurn();
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.EventType.DECLARE_INDEPENDENCE, serverPlayer);
        h.setScore(Math.max(0, Turn.yearToTurn(1780, SCORE_INDEPENDENCE_SEASON) - turn.getNumber()));
        cs.addGlobalHistory(this.getGame(), h);
        serverPlayer.clearModelMessages();
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "warOfIndependence.independenceDeclared", serverPlayer));
        Europe europe = serverPlayer.getEurope();
        StringTemplate seized = StringTemplate.label(", ");
        for (Unit u : europe.getUnitList()) {
            seized.addStringTemplate(u.getLabel());
            cs.addRemoves(ChangeSet.See.only(serverPlayer), null, u.getDisposeList());
            u.dispose();
        }
        for (Unit u : serverPlayer.getHighSeas().getUnitList()) {
            if (u.getDestination() != europe) continue;
            seized.addStringTemplate(u.getLabel());
            cs.addRemoves(ChangeSet.See.only(serverPlayer), null, u.getDisposeList());
            u.dispose();
        }
        if (!seized.getReplacements().isEmpty()) {
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.player.independence.unitsSeized", serverPlayer).addStringTemplate("%units%", seized));
        }
        serverPlayer.csLoseLocation(europe, cs);
        HashMap<UnitType, UnitType> upgrades = new HashMap<UnitType, UnitType>();
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        for (UnitType unitType : spec.getUnitTypeList()) {
            UnitType upgrade = unitType.getTargetType(UnitTypeChange.ChangeType.INDEPENDENCE, serverPlayer);
            if (upgrade == null) continue;
            upgrades.put(unitType, upgrade);
        }
        HashMap<UnitType, ArrayList<Unit>> unitMap = new HashMap<UnitType, ArrayList<Unit>>();
        for (Colony colony : serverPlayer.getColonies()) {
            ArrayList<Unit> allUnits = new ArrayList<Unit>();
            allUnits.addAll(colony.getTile().getUnitList());
            allUnits.addAll(colony.getUnitList());
            int limit = (allUnits.size() + 2) * (colony.getSoL() - 50) / 100;
            if (limit <= 0) continue;
            unitMap.clear();
            for (Unit unit : allUnits) {
                if (!upgrades.containsKey(unit.getType())) continue;
                ArrayList<Unit> unitList = (ArrayList<Unit>)unitMap.get(unit.getType());
                if (unitList == null) {
                    unitList = new ArrayList<Unit>();
                    unitMap.put(unit.getType(), unitList);
                }
                unitList.add(unit);
            }
            for (Map.Entry entry : unitMap.entrySet()) {
                int n;
                UnitType type = (UnitType)entry.getKey();
                List units = (List)entry.getValue();
                for (n = 0; !units.isEmpty() && n < limit; ++n) {
                    Unit unit = (Unit)units.remove(0);
                    unit.changeType((UnitType)upgrades.get(type));
                    cs.add(ChangeSet.See.only(serverPlayer), unit);
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.player.continentalArmyMuster", serverPlayer, colony).addName("%colony%", colony.getName()).addAmount("%number%", n).add("%oldUnit%", type.getNameKey()).add("%unit%", ((UnitType)upgrades.get(type)).getNameKey()));
                limit -= n;
            }
        }
        ServerPlayer serverPlayer2 = this.createREFPlayer(serverPlayer);
        serverPlayer.getMonarch().updateInterventionForce();
        String otherKey = Nation.getRandomNonPlayerNationNameKey(game, this.random);
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.interventionForce", serverPlayer).add("%nation%", otherKey).addAmount("%number%", spec.getInteger("model.option.interventionBells")));
        cs.addRemove(ChangeSet.See.only(serverPlayer), null, europe);
        europe.dispose();
        cs.addPartial(ChangeSet.See.all().except(serverPlayer), serverPlayer, "playerType", "independentNationName", "newLandName");
        cs.addMessage(ChangeSet.See.all().except(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.announce", serverPlayer).addStringTemplate("%oldNation%", oldNation).addStringTemplate("%newNation%", serverPlayer.getNationName()).add("%ruler%", serverPlayer.getRulerNameKey()));
        cs.add(ChangeSet.See.only(serverPlayer), serverPlayer);
        serverPlayer.csChangeStance(Player.Stance.WAR, serverPlayer2, true, cs);
        serverPlayer.invalidateCanSeeTiles();
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element renameObject(ServerPlayer serverPlayer, Nameable object, String newName) {
        ChangeSet cs = new ChangeSet();
        if (object instanceof Settlement) {
            ((Settlement)object).getTile().cacheUnseen();
        }
        object.setName(newName);
        FreeColGameObject fcgo = (FreeColGameObject)((Object)object);
        cs.addPartial(ChangeSet.See.all(), fcgo, "name");
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element getTransaction(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        TradeSession session = TransactionSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            if (unit.getMovesLeft() <= 0) {
                return DOMMessage.clientError("Unit " + unit.getId() + " has no moves left.");
            }
            session = new TradeSession(unit, settlement);
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        }
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "canBuy", Boolean.toString(session.getBuy()));
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "canSell", Boolean.toString(session.getSell()));
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "canGift", Boolean.toString(session.getGift()));
        return cs.build(serverPlayer);
    }

    public Element closeTransaction(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("No such transaction session.");
        }
        ChangeSet cs = new ChangeSet();
        if (!session.getActionTaken()) {
            unit.setMovesLeft(session.getMovesLeft());
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        }
        session.complete(cs);
        return cs.build(serverPlayer);
    }

    public Element getGoodsForSale(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        List<Goods> sellGoods = null;
        if (settlement instanceof IndianSettlement) {
            IndianSettlement indianSettlement = (IndianSettlement)settlement;
            AIPlayer aiPlayer = this.getFreeColServer().getAIPlayer(indianSettlement.getOwner());
            sellGoods = indianSettlement.getSellGoods(3, unit);
            for (Goods goods : sellGoods) {
                aiPlayer.registerSellGoods(goods);
            }
        } else {
            return DOMMessage.clientError("Bogus settlement");
        }
        return new GoodsForSaleMessage(unit, settlement, sellGoods).toXMLElement();
    }

    public Element buyProposition(ServerPlayer serverPlayer, Unit unit, Settlement settlement, Goods goods, int price) {
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Proposing to buy without opening a transaction session?!");
        }
        if (!session.getBuy()) {
            return DOMMessage.clientError("Proposing to buy in a session where buying is not allowed.");
        }
        ChangeSet cs = new ChangeSet();
        if (settlement instanceof IndianSettlement) {
            this.csVisit(serverPlayer, (IndianSettlement)settlement, 0, cs);
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int gold = ai.buyProposition(unit, settlement, goods, price);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(gold));
        return cs.build(serverPlayer);
    }

    public Element sellProposition(ServerPlayer serverPlayer, Unit unit, Settlement settlement, Goods goods, int price) {
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Proposing to sell without opening a transaction session");
        }
        if (!session.getSell()) {
            return DOMMessage.clientError("Proposing to sell in a session where selling is not allowed.");
        }
        ChangeSet cs = new ChangeSet();
        if (settlement instanceof IndianSettlement) {
            this.csVisit(serverPlayer, (IndianSettlement)settlement, 0, cs);
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int gold = ai.sellProposition(unit, settlement, goods, price);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(gold));
        return cs.build(serverPlayer);
    }

    public Element buyGoods(ServerPlayer serverPlayer, GoodsType type, int amount, Unit carrier) {
        if (!serverPlayer.canTrade(type, Market.Access.EUROPE)) {
            return DOMMessage.clientError("Can not trade boycotted goods");
        }
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = carrier.getGoodsContainer();
        container.saveState();
        if (serverPlayer.buy(container, type, amount) < 0) {
            return DOMMessage.clientError("Player " + serverPlayer.getName() + " tried to buy " + amount + " " + type);
        }
        serverPlayer.propagateToEuropeanMarkets(type, -amount, this.random);
        serverPlayer.csFlushMarket(type, cs);
        carrier.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), carrier);
        return cs.build(serverPlayer);
    }

    public Element sellGoods(ServerPlayer serverPlayer, GoodsType type, int amount, Unit carrier) {
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = carrier.getGoodsContainer();
        container.saveState();
        if (serverPlayer.canTrade(type, Market.Access.EUROPE)) {
            if ((amount = serverPlayer.sell(container, type, amount)) > 0) {
                serverPlayer.propagateToEuropeanMarkets(type, amount, this.random);
            }
            serverPlayer.csFlushMarket(type, cs);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        } else {
            this.moveGoods(carrier, type, amount, null);
            logger.finest(carrier + " dumped " + amount + " " + type.getSuffix() + " in Europe");
        }
        carrier.setMovesLeft(0);
        cs.add(ChangeSet.See.only(serverPlayer), carrier);
        return cs.build(serverPlayer);
    }

    public Element emigrate(ServerPlayer serverPlayer, int slot, Europe.MigrationType type) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csEmigrate(slot, type, this.random, cs);
        return cs.build(serverPlayer);
    }

    public Element move(ServerPlayer serverPlayer, ServerUnit unit, Tile newTile) {
        ChangeSet cs = new ChangeSet();
        unit.csMove(newTile, this.random, cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element declineMounds(ServerPlayer serverPlayer, Tile tile) {
        tile.cacheUnseen();
        tile.removeLostCityRumour();
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.perhaps(), tile);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element setNewLandName(ServerPlayer serverPlayer, Unit unit, String name) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.setNewLandName(name);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "newLandName");
        Turn turn = serverPlayer.getGame().getTurn();
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.EventType.DISCOVER_NEW_WORLD, serverPlayer).addName("%name%", name);
        cs.addHistory(serverPlayer, h);
        return cs.build(serverPlayer);
    }

    public Element setNewRegionName(ServerPlayer serverPlayer, Unit unit, Region region, String name) {
        ChangeSet cs = new ChangeSet();
        cs.addRegion(serverPlayer, unit, region, name);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element moveTo(ServerPlayer serverPlayer, Unit unit, Location destination) {
        ChangeSet cs = new ChangeSet();
        HighSeas highSeas = serverPlayer.getHighSeas();
        Location current = unit.getDestination();
        boolean others = false;
        boolean invalid = false;
        if (!unit.getType().canMoveToHighSeas()) {
            invalid = true;
        } else if (destination instanceof Europe) {
            if (!highSeas.getDestinations().contains(destination)) {
                return DOMMessage.clientError("HighSeas does not connect to: " + destination.getId());
            }
            if (unit.getLocation() == highSeas) {
                if (!(current instanceof Europe)) {
                    unit.setWorkLeft(unit.getSailTurns() - unit.getWorkLeft() + 1);
                }
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), unit, highSeas);
            } else if (unit.hasTile()) {
                Tile tile = unit.getTile();
                unit.setEntryLocation(tile);
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                serverPlayer.invalidateCanSeeTiles();
                cs.addDisappear(serverPlayer, tile, unit);
                cs.add(ChangeSet.See.only(serverPlayer), tile, highSeas);
                others = true;
            } else {
                invalid = true;
            }
        } else if (destination instanceof Map) {
            if (!highSeas.getDestinations().contains(destination)) {
                return DOMMessage.clientError("HighSeas does not connect to: " + destination.getId());
            }
            if (unit.getLocation() == highSeas) {
                if (current != destination && (current == null || current.getTile() == null || current.getTile().getMap() != destination)) {
                    unit.setWorkLeft(unit.getSailTurns() - unit.getWorkLeft() + 1);
                }
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), highSeas);
            } else if (unit.getLocation() instanceof Europe) {
                Europe europe = (Europe)unit.getLocation();
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.add(ChangeSet.See.only(serverPlayer), europe, highSeas);
            } else {
                invalid = true;
            }
        } else if (destination instanceof Settlement) {
            Tile tile = destination.getTile();
            if (!highSeas.getDestinations().contains(tile.getMap())) {
                return DOMMessage.clientError("HighSeas does not connect to: " + destination.getId());
            }
            if (unit.getLocation() == highSeas) {
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), highSeas);
            } else if (unit.getLocation() instanceof Europe) {
                Europe europe = (Europe)unit.getLocation();
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.add(ChangeSet.See.only(serverPlayer), europe, highSeas);
            } else {
                invalid = true;
            }
        } else {
            return DOMMessage.clientError("Bogus moveTo destination: " + destination.getId());
        }
        if (invalid) {
            return DOMMessage.clientError("Invalid moveTo: unit=" + unit.getId() + " from=" + unit.getLocation().getId() + " to=" + destination.getId());
        }
        if (others) {
            this.sendToOthers(serverPlayer, cs);
        }
        return cs.build(serverPlayer);
    }

    public Element embarkUnit(ServerPlayer serverPlayer, ServerUnit serverUnit, Unit carrier) {
        if (serverUnit.isNaval()) {
            return DOMMessage.clientError("Naval unit " + serverUnit.getId() + " can not embark.");
        }
        UnitLocation.NoAddReason reason = carrier.getNoAddReason(serverUnit);
        if (reason != UnitLocation.NoAddReason.NONE) {
            return DOMMessage.clientError("Carrier: " + carrier.getId() + " can not carry " + serverUnit.getId() + ": " + (Object)((Object)reason));
        }
        ChangeSet cs = new ChangeSet();
        serverUnit.csEmbark(carrier, cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element disembarkUnit(ServerPlayer serverPlayer, ServerUnit serverUnit) {
        if (serverUnit.isNaval()) {
            return DOMMessage.clientError("Naval unit " + serverUnit.getId() + " can not disembark.");
        }
        Unit carrier = serverUnit.getCarrier();
        if (carrier == null) {
            return DOMMessage.clientError("Unit " + serverUnit.getId() + " is not embarked.");
        }
        ChangeSet cs = new ChangeSet();
        Location newLocation = carrier.getLocation();
        List<Tile> newTiles = newLocation.getTile() == null ? null : serverUnit.collectNewTiles(newLocation.getTile());
        serverUnit.setLocation(newLocation);
        serverPlayer.invalidateCanSeeTiles();
        serverUnit.setMovesLeft(0);
        cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)newLocation));
        if (newTiles != null) {
            serverPlayer.csSeeNewTiles(newTiles, cs);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element combat(ServerPlayer attackerPlayer, FreeColGameObject attacker, FreeColGameObject defender, List<CombatModel.CombatResult> crs) {
        ChangeSet cs = new ChangeSet();
        try {
            attackerPlayer.csCombat(attacker, defender, crs, this.random, cs);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Combat FAIL", e);
            return DOMMessage.clientError(e.getMessage());
        }
        this.sendToOthers(attackerPlayer, cs);
        return cs.build(attackerPlayer);
    }

    public Element askLearnSkill(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        this.csVisit(serverPlayer, settlement, 0, cs);
        Tile tile = settlement.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        return cs.build(serverPlayer);
    }

    public Element learnFromIndianSettlement(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            return DOMMessage.clientError("No skill to learn at " + settlement.getName());
        }
        if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            return DOMMessage.clientError("Unit " + unit + " can not learn skill " + skill + " at " + settlement.getName());
        }
        Specification spec = this.getGame().getSpecification();
        ChangeSet cs = new ChangeSet();
        unit.setMovesLeft(0);
        this.csVisit(serverPlayer, settlement, 0, cs);
        switch (settlement.getAlarm(serverPlayer).getLevel()) {
            case HATEFUL: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
                cs.addRemove(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
                unit.dispose();
                serverPlayer.invalidateCanSeeTiles();
                break;
            }
            case ANGRY: {
                cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
                break;
            }
            default: {
                unit.changeType(skill);
                serverPlayer.invalidateCanSeeTiles();
                cs.add(ChangeSet.See.perhaps(), unit);
                if (settlement.isCapital() || settlement.hasMissionary(serverPlayer) && spec.getBoolean("model.option.enhancedMissionaries")) break;
                settlement.setLearnableSkill(null);
            }
        }
        Tile tile = settlement.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element demandTribute(ServerPlayer serverPlayer, Unit unit, ServerIndianSettlement settlement) {
        ModelMessage m;
        ChangeSet cs = new ChangeSet();
        int TURNS_PER_TRIBUTE = 5;
        this.csVisit(serverPlayer, settlement, 0, cs);
        Player indianPlayer = settlement.getOwner();
        int gold = 0;
        int year = this.getGame().getTurn().getNumber();
        RandomRange gifts = settlement.getType().getGifts(unit);
        if (settlement.getLastTribute() + 5 < year && gifts != null) {
            switch (indianPlayer.getTension(serverPlayer).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    gold = Math.min(gifts.getAmount("Tribute", this.random, true) / 10, 100);
                    break;
                }
                case DISPLEASED: {
                    gold = Math.min(gifts.getAmount("Tribute", this.random, true) / 20, 100);
                    break;
                }
                default: {
                    gold = 0;
                }
            }
        }
        settlement.csModifyAlarm(serverPlayer, 200, true, cs);
        settlement.setLastTribute(year);
        if (gold > 0) {
            indianPlayer.modifyGold(-gold);
            serverPlayer.modifyGold(gold);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
            m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "scoutSettlement.tributeAgree", unit, settlement).addAmount("%amount%", gold);
        } else {
            m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "scoutSettlement.tributeDisagree", unit, settlement);
        }
        cs.addMessage(ChangeSet.See.only(serverPlayer), m);
        Tile tile = settlement.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        return cs.build(serverPlayer);
    }

    public Element scoutIndianSettlement(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        this.csVisit(serverPlayer, settlement, -1, cs);
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "settlements", Integer.toString(settlement.getOwner().getSettlements().size()));
        return cs.build(serverPlayer);
    }

    public Element scoutSpeakToChief(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        String result;
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        boolean tileDirty = settlement.setVisited(serverPlayer);
        Tension tension = settlement.getAlarm(serverPlayer);
        if (tension.getLevel() == Tension.Level.HATEFUL) {
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
            cs.addRemove(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
            unit.dispose();
            serverPlayer.invalidateCanSeeTiles();
            result = "die";
        } else {
            List<UnitType> scoutTypes = this.getGame().getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
            UnitType scoutSkill = scoutTypes.isEmpty() ? null : scoutTypes.get(0);
            int radius = unit.getLineOfSight();
            UnitType skill = settlement.getLearnableSkill();
            int rnd = RandomUtils.randomInt(logger, "scouting", this.random, 10);
            if (settlement.hasAnyScouted()) {
                result = "nothing";
            } else if (scoutSkill != null && unit.getType() != scoutSkill && (skill != null && skill.hasAbility("model.ability.expertScout") || rnd == 0)) {
                unit.changeType(scoutSkill);
                serverPlayer.invalidateCanSeeTiles();
                result = "expert";
            } else {
                int gold;
                RandomRange gifts = settlement.getType().getGifts(unit);
                int n = gold = gifts == null ? 0 : gifts.getAmount("Base beads amount", this.random, true);
                if (gold <= 0 || rnd <= 3) {
                    radius = Math.max(radius, 6);
                    result = "tales";
                } else {
                    if (unit.hasAbility("model.ability.expertScout")) {
                        gold = gold * 11 / 10;
                    }
                    serverPlayer.modifyGold(gold);
                    settlement.getOwner().modifyGold(-gold);
                    result = "beads";
                }
            }
            this.csVisit(serverPlayer, settlement, 1, cs);
            tileDirty = true;
            HashSet<Tile> tiles = new HashSet<Tile>();
            for (Tile t : tile.getSurroundingTiles(1, radius)) {
                if (serverPlayer.canSee(t) || !t.isLand() && !t.isShore()) continue;
                tiles.add(t);
            }
            cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.exploreTiles(tiles));
            unit.setMovesLeft(0);
            if ("expert".equals(result)) {
                cs.add(ChangeSet.See.perhaps(), unit);
            } else {
                cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
                if ("beads".equals(result)) {
                    cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
                }
            }
        }
        if (tileDirty) {
            tile.updateIndianSettlement(serverPlayer);
            cs.add(ChangeSet.See.only(serverPlayer), tile);
        }
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "result", result);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element denounceMission(ServerPlayer serverPlayer, Unit unit, ServerIndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        this.csVisit(serverPlayer, settlement, 0, cs);
        Unit missionary = settlement.getMissionary();
        if (missionary == null) {
            return DOMMessage.clientError("Denouncing null missionary");
        }
        ServerPlayer enemy = (ServerPlayer)missionary.getOwner();
        double denounce = RandomUtils.randomDouble(logger, "Denounce base", this.random) * (double)enemy.getImmigration() / (double)(serverPlayer.getImmigration() + 1);
        if (missionary.hasAbility("model.ability.expertMissionary")) {
            denounce += 0.2;
        }
        if (unit.hasAbility("model.ability.expertMissionary")) {
            denounce -= 0.2;
        }
        if (denounce < 0.5) {
            return this.establishMission(serverPlayer, unit, settlement);
        }
        Player owner = settlement.getOwner();
        cs.add(ChangeSet.See.only(serverPlayer), settlement);
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission.noDenounce", serverPlayer, unit).addStringTemplate("%nation%", owner.getNationName()));
        cs.addMessage(ChangeSet.See.only(enemy), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission.enemyDenounce", enemy, settlement).addStringTemplate("%enemy%", serverPlayer.getNationName()).addStringTemplate("%settlement%", settlement.getLocationLabelFor(enemy)).addStringTemplate("%nation%", owner.getNationName()));
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        cs.addRemove(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
        unit.dispose();
        serverPlayer.invalidateCanSeeTiles();
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element establishMission(ServerPlayer serverPlayer, Unit unit, ServerIndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        this.csVisit(serverPlayer, settlement, 0, cs);
        Tension tension = settlement.getAlarm(serverPlayer);
        switch (tension.getLevel()) {
            case HATEFUL: 
            case ANGRY: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
                cs.addRemove(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
                unit.dispose();
                serverPlayer.invalidateCanSeeTiles();
                break;
            }
            case HAPPY: 
            case CONTENT: 
            case DISPLEASED: {
                if (settlement.hasMissionary()) {
                    settlement.csKillMissionary("indianSettlement.mission.denounced", cs);
                }
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), unit.getTile());
                settlement.csChangeMissionary(unit, cs);
            }
        }
        StringTemplate nation = settlement.getOwner().getNationName();
        String messageId = "indianSettlement.mission." + tension.getKey();
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, serverPlayer, unit).addStringTemplate("%nation%", nation));
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element incite(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement, ServerPlayer enemy, int gold) {
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        this.csVisit(serverPlayer, settlement, 0, cs);
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        ServerPlayer enemyPlayer = enemy;
        ServerPlayer nativePlayer = (ServerPlayer)settlement.getOwner();
        int payingValue = nativePlayer.getTension(serverPlayer).getValue();
        int targetValue = nativePlayer.getTension(enemyPlayer).getValue();
        int goldToPay = payingValue > targetValue ? 10000 : 5000;
        goldToPay += 20 * (payingValue - targetValue);
        goldToPay = Math.max(goldToPay, 650);
        if (gold < 0) {
            cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(goldToPay));
        } else if (gold < goldToPay || !serverPlayer.checkGold(gold)) {
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.inciteGoldFail", serverPlayer, settlement).addStringTemplate("%player%", enemyPlayer.getNationName()).addAmount("%amount%", goldToPay));
            cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", "0");
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        } else {
            nativePlayer.csModifyTension(enemyPlayer, Tension.WAR_MODIFIER, cs);
            enemyPlayer.csModifyTension(serverPlayer, 250, cs);
            cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(gold));
            serverPlayer.modifyGold(-gold);
            nativePlayer.modifyGold(gold);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element setDestination(ServerPlayer serverPlayer, Unit unit, Location destination) {
        if (unit.getTradeRoute() != null) {
            if (destination == null && unit.isAtSea()) {
                destination = unit.getStop().getLocation();
            }
            unit.setTradeRoute(null);
        }
        unit.setDestination(destination);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element setCurrentStop(ServerPlayer serverPlayer, Unit unit, int index) {
        TradeRoute tr = unit.getTradeRoute();
        if (tr == null) {
            return DOMMessage.clientError("Unit has no trade route to set stop for.");
        }
        if (index < 0 || index >= tr.getStops().size()) {
            return DOMMessage.clientError("Stop index out of range [0.." + tr.getStops().size() + "]: " + index);
        }
        unit.setCurrentStop(index);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element buyFromSettlement(ServerPlayer serverPlayer, Unit unit, ServerIndianSettlement settlement, Goods goods, int amount) {
        ChangeSet cs = new ChangeSet();
        this.csVisit(serverPlayer, settlement, 0, cs);
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Trying to buy without opening a transaction session");
        }
        if (!session.getBuy()) {
            return DOMMessage.clientError("Trying to buy in a session where buying is not allowed.");
        }
        if (!unit.hasSpaceLeft()) {
            return DOMMessage.clientError("Unit is full, unable to buy.");
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int returnGold = ai.buyProposition(unit, settlement, goods, amount);
        if (returnGold != amount) {
            return DOMMessage.clientError("This was not the price we agreed upon! Cheater?");
        }
        if (!serverPlayer.checkGold(amount)) {
            return DOMMessage.clientError("Insufficient gold to buy.");
        }
        this.moveGoods(settlement, goods.getType(), goods.getAmount(), unit);
        cs.add(ChangeSet.See.perhaps(), unit);
        Player settlementPlayer = settlement.getOwner();
        Tile tile = settlement.getTile();
        settlement.updateWantedGoods();
        settlementPlayer.modifyGold(amount);
        serverPlayer.modifyGold(-amount);
        settlement.csModifyAlarm(serverPlayer, -amount / 50, true, cs);
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        session.setBuy();
        logger.finest(serverPlayer.getName() + " " + unit + " buys " + goods + " at " + settlement.getName() + " for " + amount);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element sellToSettlement(ServerPlayer serverPlayer, Unit unit, ServerIndianSettlement settlement, Goods goods, int amount) {
        ChangeSet cs = new ChangeSet();
        this.csVisit(serverPlayer, settlement, 0, cs);
        TradeSession session = TransactionSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Trying to sell without opening a transaction session");
        }
        if (!session.getSell()) {
            return DOMMessage.clientError("Trying to sell in a session where selling is not allowed.");
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int returnGold = ai.sellProposition(unit, settlement, goods, amount);
        if (returnGold != amount) {
            return DOMMessage.clientError("This was not the price we agreed upon! Cheater?");
        }
        this.moveGoods(unit, goods.getType(), goods.getAmount(), settlement);
        cs.add(ChangeSet.See.perhaps(), unit);
        Player settlementPlayer = settlement.getOwner();
        settlementPlayer.modifyGold(-amount);
        serverPlayer.modifyGold(amount);
        settlement.csModifyAlarm(serverPlayer, -amount / 500, true, cs);
        Tile tile = settlement.getTile();
        settlement.updateWantedGoods();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        session.setSell();
        cs.addSale(serverPlayer, settlement, goods.getType(), Math.round((float)amount / (float)goods.getAmount()));
        logger.finest(serverPlayer.getName() + " " + unit + " sells " + goods + " at " + settlement.getName() + " for " + amount);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element deliverGiftToSettlement(ServerPlayer serverPlayer, Unit unit, Settlement settlement, Goods goods) {
        TradeSession session = TransactionSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Trying to deliver gift without opening a session");
        }
        if (!session.getGift()) {
            return DOMMessage.clientError("Trying to deliver gift in a session where gift giving is not allowed: " + unit + " " + settlement + " " + session);
        }
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        this.moveGoods(unit, goods.getType(), goods.getAmount(), settlement);
        cs.add(ChangeSet.See.perhaps(), unit);
        if (settlement instanceof ServerIndianSettlement) {
            ServerIndianSettlement sis = (ServerIndianSettlement)settlement;
            this.csVisit(serverPlayer, sis, 0, cs);
            sis.csModifyAlarm(serverPlayer, -sis.getPriceToBuy(goods) / 50, true, cs);
            sis.updateWantedGoods();
            tile.updateIndianSettlement(serverPlayer);
            cs.add(ChangeSet.See.only(serverPlayer), tile);
        }
        session.setGift();
        ModelMessage m = new ModelMessage(ModelMessage.MessageType.GIFT_GOODS, "model.unit.gift", settlement, goods.getType()).addStringTemplate("%player%", serverPlayer.getNationName()).add("%type%", goods.getNameKey()).addAmount("%amount%", goods.getAmount()).addName("%settlement%", settlement.getName());
        cs.addMessage(ChangeSet.See.only(serverPlayer), m);
        ServerPlayer receiver = (ServerPlayer)settlement.getOwner();
        if (receiver.isConnected() && settlement instanceof Colony) {
            cs.add(ChangeSet.See.only(receiver), unit);
            cs.add(ChangeSet.See.only(receiver), settlement);
            cs.addMessage(ChangeSet.See.only(receiver), m);
        }
        logger.info("Gift delivered by unit: " + unit.getId() + " to settlement: " + settlement.getName());
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element loadGoods(ServerPlayer serverPlayer, GoodsType goodsType, int amount, Unit carrier) {
        if (carrier.getLoadableAmount(goodsType) < amount) {
            return DOMMessage.clientError("Too much goods");
        }
        if (carrier.isInEurope()) {
            return this.buyGoods(serverPlayer, goodsType, amount, carrier);
        }
        Settlement settlement = carrier.getSettlement();
        if (settlement == null) {
            return DOMMessage.clientError("Carrier not at settlement");
        }
        if (settlement.getGoodsCount(goodsType) < amount) {
            return DOMMessage.clientError("Not enough goods");
        }
        ChangeSet cs = new ChangeSet();
        this.moveGoods(settlement, goodsType, amount, carrier);
        logger.finest(settlement.getName() + " loaded " + amount + " " + goodsType.getSuffix() + " onto " + carrier);
        cs.add(ChangeSet.See.only(serverPlayer), settlement.getGoodsContainer());
        cs.add(ChangeSet.See.only(serverPlayer), carrier.getGoodsContainer());
        if (carrier.getInitialMovesLeft() != carrier.getMovesLeft()) {
            carrier.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), carrier, "movesLeft");
        }
        return cs.build(serverPlayer);
    }

    public Element unloadGoods(ServerPlayer serverPlayer, GoodsType goodsType, int amount, Unit carrier) {
        if (carrier.getGoodsCount(goodsType) < amount) {
            return DOMMessage.clientError("Too few goods");
        }
        if (carrier.isInEurope()) {
            return this.sellGoods(serverPlayer, goodsType, amount, carrier);
        }
        ChangeSet cs = new ChangeSet();
        if (carrier.getSettlement() != null) {
            Settlement settlement = carrier.getSettlement();
            this.moveGoods(carrier, goodsType, amount, settlement);
            logger.finest(carrier + " unloaded " + amount + " " + goodsType.getSuffix() + " to " + settlement.getName());
            cs.add(ChangeSet.See.only(serverPlayer), settlement.getGoodsContainer());
            cs.add(ChangeSet.See.only(serverPlayer), carrier.getGoodsContainer());
            if (carrier.getInitialMovesLeft() != carrier.getMovesLeft()) {
                carrier.setMovesLeft(0);
                cs.addPartial(ChangeSet.See.only(serverPlayer), carrier, "movesLeft");
            }
        } else {
            this.moveGoods(carrier, goodsType, amount, null);
            logger.finest(carrier + " dumped " + amount + " " + goodsType.getSuffix() + " to " + carrier.getLocation());
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)carrier.getLocation()));
            this.sendToOthers(serverPlayer, cs);
        }
        return cs.build(serverPlayer);
    }

    public Element clearSpeciality(ServerPlayer serverPlayer, Unit unit) {
        UnitType newType = unit.getTypeChange(UnitTypeChange.ChangeType.CLEAR_SKILL, serverPlayer);
        if (newType == null) {
            return DOMMessage.clientError("Can not clear unit speciality: " + unit.getId());
        }
        if (unit.getStudent() != null) {
            return DOMMessage.clientError("Can not clear speciality of a teacher.");
        }
        unit.changeType(newType);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element disbandUnit(ServerPlayer serverPlayer, Unit unit) {
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        cs.addRemove(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
        unit.dispose();
        serverPlayer.invalidateCanSeeTiles();
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element buildSettlement(ServerPlayer serverPlayer, Unit unit, String name) {
        Settlement settlement;
        Game game = serverPlayer.getGame();
        Specification spec = game.getSpecification();
        ChangeSet cs = new ChangeSet();
        Tile tile = unit.getTile();
        if ("".equals(name)) {
            name = serverPlayer.getSettlementName(this.random);
        }
        if (serverPlayer.isEuropean()) {
            StringTemplate nation = serverPlayer.getNationName();
            settlement = new ServerColony(game, serverPlayer, name, tile);
            for (Tile t : tile.getSurroundingTiles(settlement.getRadius())) {
                t.cacheUnseen();
            }
            serverPlayer.addSettlement(settlement);
            settlement.placeSettlement(false);
            cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.exploreForSettlement(settlement));
            cs.addHistory(serverPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.FOUND_COLONY, serverPlayer).addName("%colony%", settlement.getName()));
            settlement.equipForRole(unit, spec.getDefaultRole(), 0);
            for (ServerPlayer sp : this.getOtherLivePlayers(serverPlayer)) {
                if (!sp.hasAbility("model.ability.seeAllColonies")) continue;
                cs.add(ChangeSet.See.only(sp), sp.exploreForSettlement(settlement));
                sp.invalidateCanSeeTiles();
                cs.addMessage(ChangeSet.See.only(sp), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "buildColony.others", settlement).addStringTemplate("%nation%", nation).addStringTemplate("%colony%", settlement.getLocationLabelFor(sp)).addName("%region%", tile.getRegion().getName()));
            }
        } else {
            IndianNationType nationType = (IndianNationType)serverPlayer.getNationType();
            UnitType skill = (UnitType)RandomChoice.getWeightedRandom(logger, "Choose skill", nationType.generateSkillsForTile(tile), this.random);
            if (skill == null) {
                List<UnitType> scouts = spec.getUnitTypesWithAbility("model.ability.expertScout");
                skill = RandomUtils.getRandomMember(logger, "Choose scout", scouts, this.random);
            }
            settlement = new ServerIndianSettlement(game, serverPlayer, name, tile, false, skill, null);
            for (Tile t : tile.getSurroundingTiles(settlement.getRadius())) {
                t.cacheUnseen();
            }
            serverPlayer.addSettlement(settlement);
            settlement.placeSettlement(true);
            for (Player p : this.getGame().getLivePlayers(serverPlayer)) {
                if (p == serverPlayer) continue;
                ((IndianSettlement)settlement).setAlarm(p, p.isIndian() ? new Tension(Tension.Level.CONTENT.getLimit()) : serverPlayer.getTension(p));
            }
        }
        unit.setLocation(settlement);
        unit.setMovesLeft(0);
        cs.add(ChangeSet.See.perhaps(), settlement.getOwnedTiles());
        serverPlayer.invalidateCanSeeTiles();
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element joinColony(ServerPlayer serverPlayer, Unit unit, Colony colony) {
        Specification spec = this.getGame().getSpecification();
        ChangeSet cs = new ChangeSet();
        Set<Tile> ownedTiles = colony.getOwnedTiles();
        Tile tile = colony.getTile();
        tile.cacheUnseen();
        unit.setLocation(colony);
        unit.setMovesLeft(0);
        colony.equipForRole(unit, spec.getDefaultRole(), 0);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        for (Tile t : tile.getSurroundingTiles(colony.getRadius())) {
            if (t.getOwningSettlement() != colony || ownedTiles.contains(t)) continue;
            cs.add(ChangeSet.See.perhaps(), t);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element abandonSettlement(ServerPlayer serverPlayer, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        if (settlement instanceof Colony) {
            serverPlayer.csLoseLocation(settlement, cs);
            cs.addHistory(serverPlayer, new HistoryEvent(this.getGame().getTurn(), HistoryEvent.EventType.ABANDON_COLONY, serverPlayer).addName("%colony%", settlement.getName()));
        }
        serverPlayer.csDisposeSettlement(settlement, cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element claimLand(ServerPlayer serverPlayer, Tile tile, Settlement settlement, int price) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csClaimLand(tile, settlement, price, cs);
        if (settlement != null && serverPlayer.isEuropean()) {
            for (ServerPlayer sp : this.getOtherLivePlayers(serverPlayer)) {
                if (!sp.isEuropean() || !sp.hasAbility("model.ability.seeAllColonies")) continue;
                sp.exploreTile(tile);
                cs.add(ChangeSet.See.only(sp), tile);
                sp.invalidateCanSeeTiles();
            }
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    private boolean csAcceptTrade(DiplomaticTrade agreement, DiplomacySession session, ChangeSet cs) {
        ServerPlayer dest;
        ServerPlayer source;
        ServerPlayer srcPlayer = (ServerPlayer)agreement.getSender();
        ServerPlayer dstPlayer = (ServerPlayer)agreement.getRecipient();
        Unit unit = session.getUnit();
        Settlement settlement = session.getSettlement();
        boolean visibilityChange = false;
        boolean fail = false;
        for (TradeItem tradeItem : agreement.getTradeItems()) {
            Object u;
            source = (ServerPlayer)tradeItem.getSource();
            dest = (ServerPlayer)tradeItem.getDestination();
            if (!tradeItem.isValid()) {
                logger.warning("Trade with invalid tradeItem: " + tradeItem);
                fail = true;
                continue;
            }
            if (source != srcPlayer && source != dstPlayer) {
                logger.warning("Trade with invalid source: " + (source == null ? "null" : source.getId()));
                fail = true;
                continue;
            }
            if (dest != srcPlayer && dest != dstPlayer) {
                logger.warning("Trade with invalid destination: " + (dest == null ? "null" : dest.getId()));
                fail = true;
                continue;
            }
            Colony colony = tradeItem.getColony(this.getGame());
            if (colony != null && !source.owns(colony)) {
                logger.warning("Trade with invalid source owner: " + colony);
                fail = true;
                continue;
            }
            int gold = tradeItem.getGold();
            if (gold > 0 && !source.checkGold(gold)) {
                logger.warning("Trade with invalid gold: " + gold);
                fail = true;
                continue;
            }
            Goods goods = tradeItem.getGoods();
            if (goods != null) {
                Location loc = goods.getLocation();
                if (loc instanceof Ownable && !source.owns((Ownable)((Object)loc))) {
                    logger.warning("Trade with invalid source owner: " + loc);
                    fail = true;
                } else if (!(loc instanceof GoodsLocation) || !loc.contains(goods)) {
                    logger.warning("Trade of unavailable goods " + goods + " at " + loc);
                    fail = true;
                } else if (dest.owns(unit) && !unit.couldCarry(goods)) {
                    logger.warning("Trade unit can not carry traded goods: " + goods);
                    fail = true;
                }
            }
            if ((u = tradeItem.getUnit()) == null) continue;
            if (!source.owns((Ownable)u)) {
                logger.warning("Trade with invalid source owner: " + u);
                fail = true;
                continue;
            }
            if (!dest.owns(unit) || unit.couldCarry((Unit)u)) continue;
            logger.warning("Trade unit can not carry traded unit: " + u);
            fail = true;
        }
        if (fail) {
            return false;
        }
        for (TradeItem tradeItem : agreement.getTradeItems()) {
            UnitLocation newLoc;
            ServerUnit newUnit;
            ServerPlayer victim;
            Goods goods;
            int gold;
            Colony colony;
            source = (ServerPlayer)tradeItem.getSource();
            dest = (ServerPlayer)tradeItem.getDestination();
            Player.Stance stance = tradeItem.getStance();
            if (stance != null && !source.csChangeStance(stance, dest, true, cs)) {
                logger.warning("Stance trade failure: " + (Object)((Object)stance));
            }
            if ((colony = tradeItem.getColony(this.getGame())) != null) {
                ServerPlayer former = (ServerPlayer)colony.getOwner();
                for (Tile t : colony.getOwnedTiles()) {
                    t.cacheUnseen(dest);
                }
                ((ServerColony)colony).csChangeOwner(dest, cs);
                cs.add(ChangeSet.See.only(dest), dest.exploreForSettlement(colony));
                cs.add(ChangeSet.See.perhaps().always(former), colony.getOwnedTiles());
                visibilityChange = true;
            }
            if ((gold = tradeItem.getGold()) > 0) {
                source.modifyGold(-gold);
                dest.modifyGold(gold);
                cs.addPartial(ChangeSet.See.only(source), source, "gold", "score");
                cs.addPartial(ChangeSet.See.only(dest), dest, "gold", "score");
            }
            if ((goods = tradeItem.getGoods()) != null && settlement != null) {
                if (dest.owns(settlement)) {
                    goods.setLocation(unit);
                    this.moveGoods(unit, goods.getType(), goods.getAmount(), settlement);
                    cs.add(ChangeSet.See.only(source), unit);
                    cs.add(ChangeSet.See.only(dest), settlement.getGoodsContainer());
                } else {
                    goods.setLocation(settlement);
                    this.moveGoods(settlement, goods.getType(), goods.getAmount(), unit);
                    cs.add(ChangeSet.See.only(dest), unit);
                    cs.add(ChangeSet.See.only(source), settlement.getGoodsContainer());
                }
            }
            if ((victim = (ServerPlayer)tradeItem.getVictim()) != null && !source.csChangeStance(Player.Stance.WAR, victim, true, cs)) {
                logger.warning("Incite trade failure: " + victim);
            }
            if ((newUnit = (ServerUnit)tradeItem.getUnit()) == null || settlement == null) continue;
            ServerPlayer former = (ServerPlayer)newUnit.getOwner();
            Tile oldTile = newUnit.getTile();
            if (unit.isOnCarrier()) {
                Unit carrier = unit.getCarrier();
                if (!carrier.couldCarry(newUnit)) {
                    logger.warning("Can not add " + newUnit + " to " + carrier);
                    continue;
                }
                newLoc = carrier;
            } else {
                newLoc = dest == unit.getOwner() ? unit.getTile() : settlement.getTile();
            }
            if (source.csChangeOwner(newUnit, dest, UnitTypeChange.ChangeType.CAPTURE, newLoc, cs)) {
                newUnit.setMovesLeft(0);
                cs.add(ChangeSet.See.perhaps().always(former), oldTile);
            }
            visibilityChange = true;
        }
        if (visibilityChange) {
            srcPlayer.invalidateCanSeeTiles();
            dstPlayer.invalidateCanSeeTiles();
        }
        return true;
    }

    public Element nativeFirstContact(ServerPlayer serverPlayer, ServerPlayer other, Tile tile, boolean result) {
        ChangeSet cs = new ChangeSet();
        if (result) {
            if (tile != null) {
                Settlement s;
                Unit u = tile.getFirstUnit();
                DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, u, s = tile.getOwningSettlement());
                if (session == null) {
                    return DOMMessage.clientError("No diplomacy in effect for: " + tile.getId());
                }
                tile.cacheUnseen();
                tile.changeOwnership(serverPlayer, null);
                cs.add(ChangeSet.See.perhaps(), tile);
            }
        } else {
            other.csModifyTension(serverPlayer, 300, cs);
            other.addMissionBan(serverPlayer);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    private boolean csDiplomacySession(ServerPlayer serverPlayer, ServerPlayer otherPlayer, DiplomaticTrade agreement, DiplomacySession session, DiplomacyMessage message, ChangeSet cs) {
        DiplomaticTrade.TradeStatus status = agreement.getStatus();
        switch (status) {
            case PROPOSE_TRADE: {
                session.setAgreement(agreement);
                break;
            }
            case ACCEPT_TRADE: {
                agreement = session.getAgreement();
                agreement.setStatus(DiplomaticTrade.TradeStatus.ACCEPT_TRADE);
                if (this.csAcceptTrade(agreement, session, cs)) {
                    session.complete(cs);
                    this.sendToOthers(serverPlayer, cs);
                    return false;
                }
            }
            default: {
                agreement = session.getAgreement();
                agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                session.complete(cs);
                this.sendToOthers(serverPlayer, cs);
                return false;
            }
        }
        DOMMessage reply = this.askTimeout(otherPlayer, message);
        if (reply instanceof DiplomacyMessage) {
            agreement = ((DiplomacyMessage)reply).getAgreement();
            status = agreement.getStatus();
        } else {
            status = DiplomaticTrade.TradeStatus.REJECT_TRADE;
            agreement.setStatus(status);
        }
        agreement.incrementVersion();
        switch (status) {
            case PROPOSE_TRADE: {
                session.setAgreement(agreement);
                break;
            }
            case ACCEPT_TRADE: {
                agreement = session.getAgreement();
                agreement.setStatus(DiplomaticTrade.TradeStatus.ACCEPT_TRADE);
                if (this.csAcceptTrade(agreement, session, cs)) {
                    session.complete(cs);
                    this.sendToOthers(serverPlayer, cs);
                    break;
                }
            }
            default: {
                agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                session.setAgreement(agreement);
                session.complete(cs);
                this.sendToOthers(serverPlayer, cs);
            }
        }
        return true;
    }

    public Element europeanFirstContact(ServerPlayer serverPlayer, Unit ourUnit, Unit otherUnit, DiplomaticTrade agreement) {
        ServerPlayer otherPlayer;
        ChangeSet cs = new ChangeSet();
        DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, ourUnit, otherUnit);
        if (session == null) {
            session = TransactionSession.lookup(DiplomacySession.class, otherUnit, ourUnit);
        }
        if (session == null) {
            if (agreement.getStatus() != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
                return DOMMessage.clientError("Missing session for " + ourUnit.getId() + "," + otherUnit.getId());
            }
            session = new DiplomacySession(ourUnit, otherUnit);
            ourUnit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), ourUnit, "movesLeft");
        }
        if (this.csDiplomacySession(serverPlayer, otherPlayer = (ServerPlayer)otherUnit.getOwner(), agreement, session, new DiplomacyMessage(otherUnit, ourUnit, agreement), cs)) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new DiplomacyMessage(ourUnit, otherUnit, session.getAgreement()));
        }
        return cs.build(serverPlayer);
    }

    public Element europeanFirstContact(ServerPlayer serverPlayer, Unit ourUnit, Colony otherColony, DiplomaticTrade agreement) {
        ServerPlayer otherPlayer;
        ChangeSet cs = new ChangeSet();
        DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, ourUnit, otherColony);
        if (session == null) {
            if (agreement.getStatus() != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
                return DOMMessage.clientError("Missing diplomacy session for " + ourUnit.getId() + "," + otherColony.getId());
            }
            session = new DiplomacySession(ourUnit, otherColony);
            ourUnit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), ourUnit, "movesLeft");
        }
        if (this.csDiplomacySession(serverPlayer, otherPlayer = (ServerPlayer)otherColony.getOwner(), agreement, session, new DiplomacyMessage(otherColony, ourUnit, agreement), cs)) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new DiplomacyMessage(ourUnit, otherColony, session.getAgreement()));
        }
        return cs.build(serverPlayer);
    }

    public Element europeanFirstContact(ServerPlayer serverPlayer, Colony ourColony, Unit otherUnit, DiplomaticTrade agreement) {
        ChangeSet cs = new ChangeSet();
        DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, otherUnit, ourColony);
        if (session == null) {
            return DOMMessage.clientError("Missing diplomacy session for " + ourColony.getId() + "," + otherUnit.getId());
        }
        ServerPlayer otherPlayer = (ServerPlayer)otherUnit.getOwner();
        if (this.csDiplomacySession(serverPlayer, otherPlayer, agreement, session, new DiplomacyMessage(otherUnit, ourColony, agreement), cs)) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new DiplomacyMessage(ourColony, otherUnit, session.getAgreement()));
        }
        return cs.build(serverPlayer);
    }

    public Element diplomacy(ServerPlayer serverPlayer, Unit ourUnit, Colony otherColony, DiplomaticTrade agreement) {
        ServerPlayer otherPlayer;
        ChangeSet cs = new ChangeSet();
        DiplomaticTrade.TradeStatus status = agreement.getStatus();
        DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, ourUnit, otherColony);
        if (session == null) {
            if (status != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
                return DOMMessage.clientError("Mission session for " + ourUnit.getId() + "/" + otherColony.getId());
            }
            session = new DiplomacySession(ourUnit, otherColony);
        }
        if (this.csDiplomacySession(serverPlayer, otherPlayer = (ServerPlayer)otherColony.getOwner(), agreement, session, new DiplomacyMessage(otherColony, ourUnit, agreement), cs)) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new DiplomacyMessage(ourUnit, otherColony, session.getAgreement()));
        }
        return cs.build(serverPlayer);
    }

    public Element diplomacy(ServerPlayer serverPlayer, Colony ourColony, Unit otherUnit, DiplomaticTrade agreement) {
        ChangeSet cs = new ChangeSet();
        DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, otherUnit, ourColony);
        if (session == null) {
            return DOMMessage.clientError("Mission session for " + otherUnit.getId() + "/" + ourColony.getId());
        }
        ServerPlayer otherPlayer = (ServerPlayer)otherUnit.getOwner();
        if (this.csDiplomacySession(serverPlayer, otherPlayer, agreement, session, new DiplomacyMessage(otherUnit, ourColony, agreement), cs)) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new DiplomacyMessage(ourColony, otherUnit, session.getAgreement()));
        }
        return cs.build(serverPlayer);
    }

    public Element spySettlement(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        cs.addSpy(ChangeSet.See.only(serverPlayer), settlement);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        return cs.build(serverPlayer);
    }

    public Element work(ServerPlayer serverPlayer, Unit unit, WorkLocation workLocation) {
        Tile tile;
        Specification spec = this.getGame().getSpecification();
        Colony colony = workLocation.getColony();
        colony.getGoodsContainer().saveState();
        ChangeSet cs = new ChangeSet();
        if (workLocation instanceof ColonyTile && (tile = ((ColonyTile)workLocation).getWorkTile()).getOwningSettlement() != colony) {
            serverPlayer.csClaimLand(tile, colony, 0, cs);
        }
        colony.equipForRole(unit, spec.getDefaultRole(), 0);
        UnitType newType = unit.getTypeChange(UnitTypeChange.ChangeType.ENTER_COLONY, unit.getOwner());
        if (newType != null) {
            unit.changeType(newType);
        }
        if (!unit.isInColony()) {
            unit.getColony().getTile().cacheUnseen();
        }
        unit.setLocation(workLocation);
        cs.add(ChangeSet.See.perhaps(), colony.getTile());
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element lootCargo(ServerPlayer serverPlayer, Unit winner, String loserId, List<Goods> loot) {
        LootSession session = TransactionSession.lookup(LootSession.class, winner.getId(), loserId);
        if (session == null) {
            return DOMMessage.clientError("Bogus looting!");
        }
        if (!winner.hasSpaceLeft()) {
            return DOMMessage.clientError("No space to loot to: " + winner.getId());
        }
        ChangeSet cs = new ChangeSet();
        List<Goods> available = session.getCapture();
        if (loot == null) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new LootCargoMessage(winner, loserId, available));
        } else {
            for (Goods g : loot) {
                if (!available.contains(g)) {
                    return DOMMessage.clientError("Invalid loot: " + g);
                }
                available.remove(g);
                if (!winner.canAdd(g)) {
                    return DOMMessage.clientError("Loot failed: " + g);
                }
                winner.add(g);
            }
            session.complete(cs);
            cs.add(ChangeSet.See.perhaps(), winner);
            this.sendToOthers(serverPlayer, cs);
        }
        return cs.build(serverPlayer);
    }

    public Element payArrears(ServerPlayer serverPlayer, GoodsType type) {
        int arrears = serverPlayer.getArrears(type);
        if (arrears <= 0) {
            return DOMMessage.clientError("No arrears for pay for: " + type.getId());
        }
        if (!serverPlayer.checkGold(arrears)) {
            return DOMMessage.clientError("Not enough gold to pay arrears for: " + type.getId());
        }
        ChangeSet cs = new ChangeSet();
        Market market = serverPlayer.getMarket();
        serverPlayer.modifyGold(-arrears);
        market.setArrears(type, 0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), market.getMarketData(type));
        return cs.build(serverPlayer);
    }

    public Element equipForRole(ServerPlayer serverPlayer, Unit unit, Role role, int roleCount) {
        Unit carrier;
        ChangeSet cs = new ChangeSet();
        boolean ret = false;
        if (unit.isInEurope()) {
            ServerEurope serverEurope = (ServerEurope)serverPlayer.getEurope();
            ret = serverEurope.csEquipForRole(unit, role, roleCount, this.random, cs);
        } else if (unit.getColony() != null) {
            ServerColony serverColony = (ServerColony)unit.getColony();
            ret = serverColony.csEquipForRole(unit, role, roleCount, this.random, cs);
        } else if (unit.getIndianSettlement() != null) {
            ServerIndianSettlement sis = (ServerIndianSettlement)unit.getIndianSettlement();
            ret = sis.csEquipForRole(unit, role, roleCount, this.random, cs);
        } else {
            return DOMMessage.clientError("Unsuitable equip location for: " + unit.getId());
        }
        if (!ret) {
            return null;
        }
        if (unit.getInitialMovesLeft() != unit.getMovesLeft()) {
            unit.setMovesLeft(0);
        }
        if ((carrier = unit.getCarrier()) != null && carrier.getInitialMovesLeft() != carrier.getMovesLeft() && carrier.getMovesLeft() != 0) {
            carrier.setMovesLeft(0);
        }
        return cs.build(serverPlayer);
    }

    public Element payForBuilding(ServerPlayer serverPlayer, Colony colony) {
        if (!this.getGame().getSpecification().getBoolean("model.option.payForBuilding")) {
            return DOMMessage.clientError("Pay for building is disabled");
        }
        BuildableType build = colony.getCurrentlyBuilding();
        if (build == null) {
            return DOMMessage.clientError("Colony " + colony.getId() + " is not building anything!");
        }
        List<AbstractGoods> required = colony.getRequiredGoods(build);
        int price = colony.priceGoodsForBuilding(required);
        if (!serverPlayer.checkGold(price)) {
            return DOMMessage.clientError("Insufficient funds to pay for build.");
        }
        int savedGold = serverPlayer.modifyGold(-price);
        serverPlayer.modifyGold(price);
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = colony.getGoodsContainer();
        container.saveState();
        for (AbstractGoods ag : required) {
            GoodsType type = ag.getType();
            int amount = ag.getAmount();
            if (type.isStorable()) {
                if ((amount = serverPlayer.buy(container, type, amount)) < 0) {
                    return DOMMessage.clientError("Can not buy " + amount + " " + type + " for " + build);
                }
                serverPlayer.propagateToEuropeanMarkets(type, -amount, this.random);
                serverPlayer.csFlushMarket(type, cs);
                continue;
            }
            container.addGoods(type, amount);
        }
        colony.invalidateCache();
        serverPlayer.setGold(savedGold);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), container);
        return cs.build(serverPlayer);
    }

    public Element indianDemand(ServerPlayer serverPlayer, Unit unit, Colony colony, GoodsType type, int amount) {
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        ServerPlayer victim = (ServerPlayer)colony.getOwner();
        int difficulty = spec.getInteger("model.option.nativeDemands");
        ChangeSet cs = new ChangeSet();
        DOMMessage reply = this.askTimeout(victim, new IndianDemandMessage(unit, colony, type, amount));
        boolean result = reply instanceof IndianDemandMessage ? ((IndianDemandMessage)reply).getResult() : false;
        logger.info(serverPlayer.getName() + " unit " + unit + " demands " + amount + " " + (type == null ? "gold" : type) + " from " + colony.getName() + " accepted: " + result);
        IndianDemandMessage message = new IndianDemandMessage(unit, colony, type, amount);
        message.setResult(result);
        cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_NORMAL, message);
        if (result) {
            if (type == null) {
                victim.modifyGold(-amount);
                serverPlayer.modifyGold(amount);
                cs.addPartial(ChangeSet.See.only(victim), victim, "gold");
            } else {
                GoodsContainer colonyContainer = colony.getGoodsContainer();
                colonyContainer.saveState();
                GoodsContainer unitContainer = unit.getGoodsContainer();
                unitContainer.saveState();
                this.moveGoods(colony, type, amount, unit);
                cs.add(ChangeSet.See.only(victim), colonyContainer);
            }
            int tension = -(5 - difficulty) * 50;
            ServerIndianSettlement is = (ServerIndianSettlement)unit.getHomeIndianSettlement();
            if (is == null) {
                serverPlayer.csModifyTension(victim, tension, cs);
            } else {
                is.csModifyAlarm(victim, tension, true, cs);
            }
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element trainUnitInEurope(ServerPlayer serverPlayer, UnitType type) {
        Europe europe = serverPlayer.getEurope();
        if (europe == null) {
            return DOMMessage.clientError("No Europe to train in.");
        }
        int price = europe.getUnitPrice(type);
        if (price <= 0) {
            return DOMMessage.clientError("Bogus price: " + price);
        }
        if (!serverPlayer.checkGold(price)) {
            return DOMMessage.clientError("Not enough gold (" + serverPlayer.getGold() + " < " + price + ") to train " + type);
        }
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        Role role = spec.getBoolean("model.option.equipEuropeanRecruits") ? type.getDefaultRole() : spec.getDefaultRole();
        ServerUnit unit = new ServerUnit(game, europe, serverPlayer, type, role);
        unit.setName(serverPlayer.getNameForUnit(type, this.random));
        serverPlayer.modifyGold(-price);
        ((ServerEurope)europe).increasePrice(type, price);
        ChangeSet cs = new ChangeSet();
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), europe);
        return cs.build(serverPlayer);
    }

    public Element setBuildQueue(ServerPlayer serverPlayer, Colony colony, List<BuildableType> queue) {
        BuildableType current = colony.getCurrentlyBuilding();
        colony.setBuildQueue(queue);
        if (this.getGame().getSpecification().getBoolean("model.option.clearHammersOnConstructionSwitch") && current != colony.getCurrentlyBuilding()) {
            for (AbstractGoods ag : current.getRequiredGoods()) {
                if (ag.getType().isStorable()) continue;
                colony.removeGoods(ag.getType());
            }
        }
        colony.invalidateCache();
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), colony);
        return cs.build(serverPlayer);
    }

    public Element setGoodsLevels(ServerPlayer serverPlayer, Colony colony, ExportData exportData) {
        colony.setExportData(exportData);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), colony).build(serverPlayer);
    }

    public Element putOutsideColony(ServerPlayer serverPlayer, Unit unit) {
        Tile tile = unit.getTile();
        Colony colony = unit.getColony();
        if (unit.isInColony()) {
            tile.cacheUnseen();
        }
        unit.setLocation(tile);
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.add(ChangeSet.See.perhaps().except(serverPlayer), colony);
        return cs.build(serverPlayer);
    }

    public Element changeWorkType(ServerPlayer serverPlayer, Unit unit, GoodsType type) {
        if (unit.getWorkType() != type) {
            unit.setExperience(0);
            unit.changeWorkType(type);
        }
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit.getColony()).build(serverPlayer);
    }

    public Element changeWorkImprovementType(ServerPlayer serverPlayer, Unit unit, TileImprovementType type) {
        Tile tile = unit.getTile();
        TileImprovement improvement = tile.getTileImprovement(type);
        if (improvement == null) {
            improvement = new TileImprovement((Game)this.getGame(), tile, type);
            tile.add(improvement);
        }
        unit.setWorkImprovement(improvement);
        unit.setState(Unit.UnitState.IMPROVING);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), tile).build(serverPlayer);
    }

    public Element changeState(ServerPlayer serverPlayer, Unit unit, Unit.UnitState state) {
        boolean tileDirty;
        ChangeSet cs = new ChangeSet();
        Tile tile = unit.getTile();
        boolean bl = tileDirty = tile != null && tile.getIndianSettlement() != null;
        if (state == Unit.UnitState.FORTIFYING && tile != null) {
            Player owner;
            ServerColony colony = tile.getOwningSettlement() instanceof Colony ? (ServerColony)tile.getOwningSettlement() : null;
            Player player = owner = colony == null ? null : colony.getOwner();
            if (owner != null && owner != unit.getOwner() && serverPlayer.getStance(owner) != Player.Stance.ALLIANCE && serverPlayer.getStance(owner) != Player.Stance.PEACE) {
                if (colony.isTileInUse(tile)) {
                    colony.csEvictUsers(unit, cs);
                }
                if (serverPlayer.getStance(owner) == Player.Stance.WAR) {
                    tile.changeOwnership(null, null);
                    tileDirty = true;
                }
            }
        }
        unit.setState(state);
        if (tileDirty) {
            cs.add(ChangeSet.See.perhaps(), tile);
        } else {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)unit.getLocation()));
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element assignTeacher(ServerPlayer serverPlayer, Unit student, Unit teacher) {
        Unit oldStudent = teacher.getStudent();
        Unit oldTeacher = student.getTeacher();
        ChangeSet cs = new ChangeSet();
        if (oldTeacher != null) {
            oldTeacher.setStudent(null);
            cs.add(ChangeSet.See.only(serverPlayer), oldTeacher);
        }
        if (oldStudent != null) {
            oldStudent.setTeacher(null);
            cs.add(ChangeSet.See.only(serverPlayer), oldStudent);
        }
        teacher.setStudent(student);
        teacher.changeWorkType(null);
        student.setTeacher(teacher);
        cs.add(ChangeSet.See.only(serverPlayer), student, teacher);
        return cs.build(serverPlayer);
    }

    public Element assignTradeRoute(ServerPlayer serverPlayer, Unit unit, TradeRoute tradeRoute) {
        TradeRouteStop stop;
        unit.setDestination(tradeRoute == null && unit.isAtSea() && (stop = unit.getStop()) != null ? stop.getLocation() : null);
        unit.setTradeRoute(tradeRoute);
        if (tradeRoute != null) {
            List<TradeRouteStop> stops = tradeRoute.getStops();
            int found = -1;
            for (int i = 0; i < stops.size(); ++i) {
                if (unit.getLocation() != stops.get(i).getLocation()) continue;
                found = i;
                break;
            }
            if (found < 0) {
                found = 0;
            }
            unit.setCurrentStop(found);
        }
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element setTradeRoutes(ServerPlayer serverPlayer, List<TradeRoute> routes) {
        serverPlayer.setTradeRoutes(routes);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), serverPlayer).build(serverPlayer);
    }

    public Element getNewTradeRoute(ServerPlayer serverPlayer) {
        List<TradeRoute> routes = serverPlayer.getTradeRoutes();
        TradeRoute route = new TradeRoute(this.getGame(), serverPlayer.getNewTradeRouteName(), serverPlayer);
        routes.add(route);
        return new ChangeSet().addTradeRoute(serverPlayer, route).build(serverPlayer);
    }

    public Element getREFUnits(ServerPlayer serverPlayer) {
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        List<Object> units = new ArrayList();
        UnitType defaultType = spec.getDefaultUnitType();
        if (serverPlayer.getPlayerType() == Player.PlayerType.COLONIAL) {
            units = serverPlayer.getMonarch().getExpeditionaryForce().getUnits();
        } else {
            ServerPlayer REFPlayer = (ServerPlayer)serverPlayer.getREFPlayer();
            HashMap unitHash = new HashMap();
            for (Unit unit : REFPlayer.getUnits()) {
                Integer count;
                String roleId;
                HashMap<String, Integer> roleMap;
                if (!unit.isOffensiveUnit()) continue;
                UnitType unitType = defaultType;
                if (unit.getType().getOffence() > 0.0f || unit.hasAbility("model.ability.expertSoldier")) {
                    unitType = unit.getType();
                }
                if ((roleMap = (HashMap<String, Integer>)unitHash.get(unitType)) == null) {
                    roleMap = new HashMap<String, Integer>();
                }
                roleMap.put(roleId, (count = (Integer)roleMap.get(roleId = unit.getRole().getId())) == null ? 1 : count + 1);
                unitHash.put(unitType, roleMap);
            }
            for (Map.Entry entry : unitHash.entrySet()) {
                for (Map.Entry roleEntry : ((HashMap)entry.getValue()).entrySet()) {
                    units.add(new AbstractUnit((UnitType)entry.getKey(), (String)roleEntry.getKey(), (int)((Integer)roleEntry.getValue())));
                }
            }
        }
        ChangeSet cs = new ChangeSet();
        cs.addTrivial(ChangeSet.See.only(serverPlayer), "getREFUnits", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]);
        Element reply = cs.build(serverPlayer);
        for (AbstractUnit abstractUnit : units) {
            reply.appendChild(abstractUnit.toXMLElement(reply.getOwnerDocument()));
        }
        return reply;
    }

    public Element getHighScores(ServerPlayer serverPlayer) {
        List<HighScore> scores = HighScore.loadHighScores();
        ChangeSet cs = new ChangeSet();
        cs.addTrivial(ChangeSet.See.only(serverPlayer), "getHighScores", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]);
        Element reply = cs.build(serverPlayer);
        if (scores != null) {
            for (HighScore score : scores) {
                reply.appendChild(score.toXMLElement(reply.getOwnerDocument()));
            }
        }
        return reply;
    }

    public Element chat(ServerPlayer serverPlayer, String message, boolean pri) {
        this.sendToOthers(serverPlayer, new ChatMessage(serverPlayer, message, false).toXMLElement());
        return null;
    }

    public Element getStatistics(ServerPlayer serverPlayer) {
        java.util.Map<String, String> stats = this.getGame().getStatistics();
        stats.putAll(this.getFreeColServer().getAIMain().getAIStatistics());
        ArrayList<String> all = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>(stats.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            all.add(k);
            all.add(stats.get(k));
        }
        ChangeSet cs = new ChangeSet();
        cs.addTrivial(ChangeSet.See.only(serverPlayer), "statistics", ChangeSet.ChangePriority.CHANGE_NORMAL, all.toArray(new String[0]));
        return cs.build(serverPlayer);
    }

    public Element enterRevengeMode(ServerPlayer serverPlayer) {
        if (!this.getFreeColServer().isSinglePlayer()) {
            return DOMMessage.clientError("Can not enter revenge mode, as this is not a single player game.");
        }
        ServerGame game = this.getGame();
        List<UnitType> undeads = game.getSpecification().getUnitTypesWithAbility("model.ability.undead");
        ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
        ArrayList<UnitType> landUnits = new ArrayList<UnitType>();
        for (UnitType undead : undeads) {
            if (undead.hasAbility("model.ability.navalUnit")) {
                navalUnits.add(undead);
                continue;
            }
            if (!undead.hasAbility("model.ability.multipleAttacks")) continue;
            landUnits.add(undead);
        }
        if (navalUnits.isEmpty() || landUnits.isEmpty()) {
            return DOMMessage.clientError("Can not enter revenge mode, because we can not find the undead units.");
        }
        ChangeSet cs = new ChangeSet();
        UnitType navalType = (UnitType)RandomUtils.getRandomMember(logger, "Choose undead navy", navalUnits, this.random);
        Tile start = ((Tile)serverPlayer.getEntryLocation()).getSafeTile(serverPlayer, this.random);
        ServerUnit theFlyingDutchman = new ServerUnit(game, start, serverPlayer, navalType);
        UnitType landType = (UnitType)RandomUtils.getRandomMember(logger, "Choose undead army", landUnits, this.random);
        new ServerUnit(game, theFlyingDutchman, serverPlayer, landType);
        serverPlayer.setDead(false);
        serverPlayer.changePlayerType(Player.PlayerType.UNDEAD);
        serverPlayer.invalidateCanSeeTiles();
        for (Player p : game.getLivePlayers(serverPlayer)) {
            if (!serverPlayer.hasContacted(p)) continue;
            serverPlayer.csChangeStance(Player.Stance.WAR, (ServerPlayer)p, true, cs);
        }
        game.setCurrentPlayer(serverPlayer);
        cs.addTrivial(ChangeSet.See.all(), "setCurrentPlayer", ChangeSet.ChangePriority.CHANGE_LATE, "player", serverPlayer.getId());
        cs.add(ChangeSet.See.all(), serverPlayer);
        cs.add(ChangeSet.See.perhaps(), start);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element rearrangeColony(ServerPlayer serverPlayer, Colony colony, List<RearrangeColonyMessage.UnitChange> unitChanges) {
        Role defaultRole = this.getGame().getSpecification().getDefaultRole();
        Tile tile = colony.getTile();
        tile.cacheUnseen();
        for (RearrangeColonyMessage.UnitChange uc : unitChanges) {
            uc.unit.setLocation(tile);
            if (uc.unit.hasDefaultRole()) continue;
            colony.equipForRole(uc.unit, defaultRole, 0);
        }
        ArrayList<RearrangeColonyMessage.UnitChange> todo = new ArrayList<RearrangeColonyMessage.UnitChange>(unitChanges);
        block6: while (!todo.isEmpty()) {
            RearrangeColonyMessage.UnitChange uc;
            uc = (RearrangeColonyMessage.UnitChange)todo.remove(0);
            if (uc.loc == tile) continue;
            WorkLocation wl = (WorkLocation)uc.loc;
            switch (wl.getNoAddReason(uc.unit)) {
                case NONE: {
                    uc.unit.setLocation(wl);
                }
                case ALREADY_PRESENT: {
                    if (uc.unit.getWorkType() == uc.work) continue block6;
                    uc.unit.changeWorkType(uc.work);
                    continue block6;
                }
                case CAPACITY_EXCEEDED: {
                    todo.add(todo.size(), uc);
                    continue block6;
                }
            }
            logger.warning("Bad move for " + uc.unit + " to " + wl);
        }
        Iterator<RearrangeColonyMessage.UnitChange> uci = unitChanges.iterator();
        while (uci.hasNext()) {
            RearrangeColonyMessage.UnitChange uc = uci.next();
            if (uc.unit.getRole() != uc.role) continue;
            uci.remove();
        }
        if (!unitChanges.isEmpty()) {
            Collections.sort(unitChanges, RearrangeColonyMessage.roleComparator);
            Collections.reverse(unitChanges);
            for (RearrangeColonyMessage.UnitChange uc : unitChanges) {
                if (uc.role == defaultRole || colony.equipForRole(uc.unit, uc.role, uc.roleCount)) continue;
                return DOMMessage.clientError("Failed to equip " + uc.unit.getId() + " for role " + uc.role + " at " + colony);
            }
        }
        return new ChangeSet().add(ChangeSet.See.perhaps(), tile).build(serverPlayer);
    }

    private static class DOMMessageCallable
    implements Callable<DOMMessage> {
        private final Connection connection;
        private final Game game;
        private final DOMMessage message;
        private final DOMMessageHandler handler;

        public DOMMessageCallable(Connection connection, Game game, DOMMessage message, DOMMessageHandler handler) {
            this.connection = connection;
            this.game = game;
            this.message = message;
            this.handler = handler;
        }

        @Override
        public DOMMessage call() {
            Element reply;
            try {
                reply = this.connection.ask(this.message.toXMLElement());
            }
            catch (IOException e) {
                return null;
            }
            DOMMessage replyMessage = DOMMessage.createMessage(this.game, reply);
            return replyMessage == null ? null : this.handler.handle(replyMessage);
        }
    }

    private static interface DOMMessageHandler {
        public DOMMessage handle(DOMMessage var1);
    }
}

