/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class UnitSeekAndDestroyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitSeekAndDestroyMission.class.getName());
    private static final String tag = "AI seek+destroyer";
    private Location target;
    private Location transportTarget;
    private static final String TARGET_TAG = "target";

    public UnitSeekAndDestroyMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit, target);
    }

    public UnitSeekAndDestroyMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        Unit u;
        Tile t;
        Location loc;
        Location location = loc = path == null ? null : path.getLastNode().getLocation();
        return loc == null || aiUnit == null || aiUnit.getUnit() == null ? null : (UnitSeekAndDestroyMission.invalidReason(aiUnit, loc.getSettlement()) == null ? loc.getSettlement() : ((t = loc.getTile()) != null && UnitSeekAndDestroyMission.invalidReason(aiUnit, u = t.getDefendingUnit(aiUnit.getUnit())) == null ? u : null));
    }

    private static int scoreSettlementPath(AIUnit aiUnit, PathNode path, Settlement settlement) {
        IndianSettlement is;
        Tension tension;
        if (UnitSeekAndDestroyMission.invalidSettlementReason(aiUnit, settlement) != null) {
            return Integer.MIN_VALUE;
        }
        Unit unit = aiUnit.getUnit();
        CombatModel combatModel = unit.getGame().getCombatModel();
        int value = 1020;
        value -= path.getTotalTurns() * 100;
        float off = combatModel.getOffencePower(unit, settlement);
        value = (int)((float)value + off * 50.0f);
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            value += 50 * colony.getUnitCount();
            if (colony.hasStockade()) {
                value -= 200 * colony.getStockade().getLevel();
            }
        } else if (settlement instanceof IndianSettlement && (tension = (is = (IndianSettlement)settlement).getAlarm(unit.getOwner())) != null) {
            value += tension.getValue() / 2;
        }
        return aiUnit.getAIOwner().adjustMission(aiUnit, path, UnitSeekAndDestroyMission.class, value);
    }

    private static int scoreUnitPath(AIUnit aiUnit, PathNode path, Unit defender) {
        if (UnitSeekAndDestroyMission.invalidUnitReason(aiUnit, defender) != null) {
            return Integer.MIN_VALUE;
        }
        Unit unit = aiUnit.getUnit();
        Tile tile = path.getLastNode().getTile();
        int turns = path.getTotalTurns();
        CombatModel combatModel = unit.getGame().getCombatModel();
        float off = combatModel.getOffencePower(unit, defender);
        float def = combatModel.getDefencePower(unit, defender);
        if (tile == null || off <= 0.0f) {
            return Integer.MIN_VALUE;
        }
        int value = 1020 - turns * 100;
        value = (int)((float)value + 100.0f * (off - def));
        for (Unit u : tile.getUnitList()) {
            if (!u.canCarryTreasure() || u.getTreasureAmount() <= 0) continue;
            value += 1000;
            break;
        }
        if (defender.isNaval()) {
            if (tile.isLand()) {
                value += 500;
            }
        } else if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
            value += 100;
        }
        return aiUnit.getAIOwner().adjustMission(aiUnit, path, UnitSeekAndDestroyMission.class, value);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
        return loc instanceof Settlement ? UnitSeekAndDestroyMission.scoreSettlementPath(aiUnit, path, (Settlement)loc) : (loc instanceof Unit ? UnitSeekAndDestroyMission.scoreUnitPath(aiUnit, path, (Unit)loc) : Integer.MIN_VALUE);
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value = UnitSeekAndDestroyMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (UnitSeekAndDestroyMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        return unit.search(start, UnitSeekAndDestroyMission.getGoalDecider(aiUnit, false), CostDeciders.avoidIllegal(), range, unit.getCarrier());
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = UnitSeekAndDestroyMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? UnitSeekAndDestroyMission.extractTarget(aiUnit, path) : null;
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = UnitSeekAndDestroyMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isOffensiveUnit() ? "unit-not-offensive" : (aiUnit.getUnit().hasAbility("model.ability.speakWithChief") ? "scouts-should-not-seek-and-destroy" : null));
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        String reason = UnitSeekAndDestroyMission.invalidTargetReason(settlement);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return unit.isNaval() ? "unit-is-naval" : (settlement.getOwner() == unit.getOwner() ? "target-ownership" : UnitSeekAndDestroyMission.invalidAttackReason(aiUnit, settlement.getOwner()));
    }

    private static String invalidUnitReason(AIUnit aiUnit, Unit unit) {
        String reason = UnitSeekAndDestroyMission.invalidTargetReason(unit);
        if (reason != null) {
            return reason;
        }
        Tile tile = unit.getTile();
        return tile == null ? "target-not-on-map" : (aiUnit.getUnit().getOwner() == unit.getOwner() ? "target-ownership" : (tile.hasSettlement() ? "target-in-settlement" : (!aiUnit.getUnit().isTileAccessible(tile) ? "target-incompatible" : UnitSeekAndDestroyMission.invalidAttackReason(aiUnit, unit.getOwner()))));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return UnitSeekAndDestroyMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = UnitSeekAndDestroyMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Settlement ? UnitSeekAndDestroyMission.invalidSettlementReason(aiUnit, (Settlement)loc) : (loc instanceof Unit ? UnitSeekAndDestroyMission.invalidUnitReason(aiUnit, (Unit)loc) : "target-invalid"));
    }

    @Override
    public int getBaseTransportPriority() {
        return 95;
    }

    @Override
    public Location getTransportDestination() {
        if (!this.isValid()) {
            return null;
        }
        Location loc = this.transportTarget != null ? this.transportTarget : this.target;
        return this.getUnit().shouldTakeTransportTo(loc) ? loc : null;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Unit || target instanceof Settlement) {
            Settlement settlement;
            this.target = target;
            Unit unit = this.getUnit();
            this.transportTarget = null;
            if (unit.shouldTakeTransportTo(target) && target instanceof Settlement && (settlement = (Settlement)target).isConnectedPort()) {
                this.transportTarget = settlement.getTile().getBestDisembarkTile(unit.getOwner());
                logger.finest("AI seek+destroyer chose dropoff " + this.transportTarget + " for attack on " + (settlement.canBombardEnemyShip() ? "hazardous" : "normal") + " settlement " + settlement.getName() + ": " + this);
            }
        }
    }

    @Override
    public Location findTarget() {
        return UnitSeekAndDestroyMission.findTarget(this.getAIUnit(), 4, false);
    }

    @Override
    public String invalidReason() {
        return UnitSeekAndDestroyMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        Location nearbyTarget;
        lb.add(tag);
        AIUnit aiUnit = this.getAIUnit();
        String reason = this.invalidReason();
        if (UnitSeekAndDestroyMission.isTargetReason(reason)) {
            Mission m;
            Colony colony;
            if ("target-ownership".equals(reason) && this.getTarget() instanceof Colony && (colony = (Colony)this.getTarget()) != null && this.getPlayer().owns(colony) && (m = this.getAIPlayer().getDefendSettlementMission(aiUnit, colony)) != null) {
                return this.lbDone(lb, true, " capturing colony ", colony.getName());
            }
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        Location location = nearbyTarget = unit.isOnCarrier() ? null : UnitSeekAndDestroyMission.findTarget(aiUnit, 1, false);
        if (nearbyTarget != null) {
            if (this.getTarget() == null) {
                this.setTarget(nearbyTarget);
                return this.lbRetarget(lb);
            }
            if (nearbyTarget == this.getTarget()) {
                nearbyTarget = null;
            } else {
                Tile now = unit.getTile();
                Tile nearbyTile = nearbyTarget.getTile();
                Tile targetTile = this.getTarget().getTile();
                if (now != null && nearbyTile != null && targetTile != null && now.getDistanceTo(nearbyTile) >= now.getDistanceTo(targetTile)) {
                    nearbyTarget = null;
                } else {
                    lb.add(", found target of opportunity ", nearbyTarget);
                }
            }
        }
        Location currentTarget = nearbyTarget != null ? nearbyTarget : this.getTarget();
        Unit.MoveType mt = this.travelToTarget(currentTarget, CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            case ATTACK_UNIT: 
            case ATTACK_SETTLEMENT: {
                Tile unitTile = unit.getTile();
                Settlement settlement = unitTile.getSettlement();
                if (settlement != null && settlement.getUnitCount() < 2) {
                    Mission m = this.getAIPlayer().getDefendSettlementMission(aiUnit, settlement);
                    return this.lbDone(lb, m != null, " desperate defence of ", settlement);
                }
                Map.Direction d = unitTile.getDirection(currentTarget.getTile());
                assert (d != null);
                AIMessage.askAttack(aiUnit, d);
                return this.lbAttack(lb, currentTarget);
            }
        }
        return this.lbMove(lb, mt);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return UnitSeekAndDestroyMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unitSeekAndDestroyMission";
    }
}

