/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.mission.Mission;

public class PioneeringMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PioneeringMission.class.getName());
    private static final String tag = "AI pioneer";
    private static final int DEFAULT_THREAT_TURNS = 3;
    private TileImprovementPlan tileImprovementPlan;
    private Location target;
    private static final String TARGET_TAG = "target";
    private static final String TILE_IMPROVEMENT_PLAN_TAG = "tileImprovementPlan";

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit, target);
    }

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private TileImprovementPlan getBestPlan(Tile tile) {
        return this.getEuropeanAIPlayer().getBestPlan(tile);
    }

    private static TileImprovementPlan getBestPlan(AIUnit aiUnit, Tile tile) {
        return ((EuropeanAIPlayer)aiUnit.getAIOwner()).getBestPlan(tile);
    }

    public TileImprovementPlan getTileImprovementPlan() {
        return this.tileImprovementPlan;
    }

    public void setTileImprovementPlan(TileImprovementPlan tip) {
        TileImprovementPlan old = this.tileImprovementPlan;
        this.tileImprovementPlan = tip;
        AIUnit aiUnit = this.getAIUnit();
        if (old != this.tileImprovementPlan) {
            if (old != null && old.getPioneer() == aiUnit) {
                old.setPioneer(null);
            }
            if (this.tileImprovementPlan != null) {
                this.tileImprovementPlan.setPioneer(aiUnit);
            }
        }
    }

    private void abandonTileImprovementPlan() {
        if (this.tileImprovementPlan != null) {
            if (this.tileImprovementPlan.getPioneer() == this.getAIUnit()) {
                this.tileImprovementPlan.setPioneer(null);
            }
            this.setTileImprovementPlan(null);
        }
    }

    @Override
    public void dispose() {
        this.abandonTileImprovementPlan();
        super.dispose();
    }

    private static boolean hasTools(AIUnit aiUnit) {
        return aiUnit.getUnit().hasAbility("model.ability.improveTerrain");
    }

    private boolean hasTools() {
        return PioneeringMission.hasTools(this.getAIUnit());
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        return loc == null ? null : (PioneeringMission.hasTools(aiUnit) ? (PioneeringMission.invalidReason(aiUnit, loc.getTile()) != null ? null : loc.getTile()) : (PioneeringMission.invalidReason(aiUnit, loc.getColony()) != null ? null : loc.getColony()));
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = PioneeringMission.extractTarget(aiUnit, path);
        if (PioneeringMission.hasTools(aiUnit)) {
            TileImprovementPlan tip;
            if (loc instanceof Tile && (tip = PioneeringMission.getBestPlan(aiUnit, (Tile)loc)) != null) {
                return 1000 * tip.getValue() / (path.getTotalTurns() + 1);
            }
        } else if (loc instanceof Colony) {
            return 1000 / (path.getTotalTurns() + 1);
        }
        return Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value = PioneeringMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(false, gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (PioneeringMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        Unit carrier = unit.getCarrier();
        GoalDecider gd = PioneeringMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        return unit.search(start, gd, standardCd, range, carrier);
    }

    private static Colony getBestPioneeringColony(AIUnit aiUnit) {
        EuropeanAIPlayer aiPlayer = (EuropeanAIPlayer)aiUnit.getAIOwner();
        AIColony bestColony = null;
        int bestValue = -1;
        for (AIColony aic : aiPlayer.getAIColonies()) {
            int value = aic.getTileImprovementPlans().size();
            if (value <= bestValue) continue;
            bestValue = value;
            bestColony = aic;
        }
        if (bestColony == null) {
            return null;
        }
        Colony colony = bestColony.getColony();
        if (colony.isConnectedPort()) {
            return colony;
        }
        PathNode path = aiUnit.getUnit().findOurNearestPort();
        return path == null ? colony : path.getLastNode().getLocation().getColony();
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = PioneeringMission.findTargetPath(aiUnit, range, false);
        if (path != null) {
            return PioneeringMission.extractTarget(aiUnit, path);
        }
        if (deferOK) {
            return PioneeringMission.getBestPioneeringColony(aiUnit);
        }
        Location loc = PioneeringMission.findCircleTarget(aiUnit, PioneeringMission.getGoalDecider(aiUnit, false), range * 3, false);
        return PioneeringMission.hasTools(aiUnit) ? loc : PioneeringMission.upLoc(loc);
    }

    public static String prepare(AIUnit aiUnit) {
        String reason = PioneeringMission.invalidReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        if (!PioneeringMission.hasTools(aiUnit) && !aiUnit.equipForRole(unit.getSpecification().getPioneerRole())) {
            return "unit-could-not-equip";
        }
        return PioneeringMission.hasTools(aiUnit) || unit.hasAbility("model.ability.expertPioneer") ? null : "unit-missing-tools";
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = PioneeringMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isPerson() ? "unit-not-a-person" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = PioneeringMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
        Role role = aiUnit.getUnit().getSpecification().getRole("model.role.pioneer");
        return reason != null ? reason : (!PioneeringMission.hasTools(aiUnit) && !colony.canProvideGoods(role.getRequiredGoods()) ? "colony-can-not-provide-equipment" : null);
    }

    private static TileImprovementPlan getPlan(AIUnit aiUnit, Tile tile) {
        PioneeringMission pm = aiUnit.getMission(PioneeringMission.class);
        return pm != null && pm.getTileImprovementPlan() != null && pm.getTileImprovementPlan().getTarget() == tile ? pm.getTileImprovementPlan() : null;
    }

    private static String invalidTileReason(AIUnit aiUnit, Tile tile) {
        return tile == null ? "target-invalid" : (!PioneeringMission.hasTools(aiUnit) ? "unit-needs-tools" : (PioneeringMission.getPlan(aiUnit, tile) == null && PioneeringMission.getBestPlan(aiUnit, tile) == null ? "tile-has-no-plan" : (tile.getOwningSettlement() != null ? PioneeringMission.invalidTargetReason(tile.getOwningSettlement(), aiUnit.getUnit().getOwner()) : null)));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return PioneeringMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = PioneeringMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Tile ? PioneeringMission.invalidTileReason(aiUnit, (Tile)loc) : (loc instanceof Colony ? (aiUnit.getUnit().getLocation() instanceof Tile ? PioneeringMission.invalidColonyReason(aiUnit, (Colony)loc) : PioneeringMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner())) : "target-invalid"));
    }

    @Override
    public int getBaseTransportPriority() {
        return 100;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Colony || target instanceof Tile) {
            this.target = target;
            this.setTileImprovementPlan(target instanceof Tile ? this.getBestPlan((Tile)target) : null);
        }
    }

    @Override
    public Location findTarget() {
        return PioneeringMission.findTarget(this.getAIUnit(), 10, true);
    }

    @Override
    public String invalidReason() {
        if (this.tileImprovementPlan != null) {
            if (this.tileImprovementPlan.isDisposed()) {
                return "target-plan-disposed";
            }
            if (this.tileImprovementPlan.isComplete()) {
                return null;
            }
        }
        return PioneeringMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    protected Mission lbFail(LogBuilder lb, boolean cont, Object ... reasons) {
        if (this.hasTools() && this.getUnit().getColony() != null) {
            this.getAIUnit().equipForRole(this.getSpecification().getDefaultRole());
        }
        return super.lbFail(lb, false, reasons);
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        String reason;
        lb.add(tag);
        AIUnit aiUnit = this.getAIUnit();
        if (this.tileImprovementPlan != null) {
            if (this.tileImprovementPlan.isComplete()) {
                this.lbDone(lb, true, this.tileImprovementPlan.getType(), " at ", this.getTarget());
                this.setTarget(null);
            } else if (!this.tileImprovementPlan.validate()) {
                this.lbFail(lb, true, "abandoned invalid plan at ", this.getTarget(), "/", this.tileImprovementPlan);
                this.setTarget(null);
            }
        }
        if (PioneeringMission.isTargetReason(reason = this.invalidReason())) {
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        EuropeanAIPlayer aiPlayer = this.getEuropeanAIPlayer();
        CostDecider costDecider = CostDeciders.avoidSettlementsAndBlockingUnits();
        if (!this.hasTools()) {
            Location newTarget;
            Unit.MoveType mt = this.travelToTarget(this.getTarget(), costDecider, lb);
            switch (mt) {
                case MOVE: {
                    break;
                }
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_MOVES: 
                case MOVE_NO_REPAIR: 
                case MOVE_ILLEGAL: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_ACCESS_EMBARK: 
                case MOVE_NO_TILE: {
                    return this;
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            this.lbAt(lb);
            if (aiUnit.equipForRole(this.getSpecification().getPioneerRole()) && this.hasTools()) {
                lb.add(", equips");
                newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
                if (newTarget == null) {
                    return this.lbFail(lb, false, "no pioneering target");
                }
            } else {
                lb.add(", fails to equip");
                newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
                if (newTarget == null || Map.isSameLocation(newTarget, this.getTarget())) {
                    return this.lbFail(lb, false, "no tools target");
                }
            }
            this.setTarget(newTarget);
            return this.lbRetarget(lb);
        }
        if (this.getTarget() instanceof Colony && PioneeringMission.invalidTargetReason(this.getTarget(), player) == null) {
            Unit.MoveType mt = this.travelToTarget(this.getTarget(), costDecider, lb);
            switch (mt) {
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_REPAIR: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_MOVES: 
                case MOVE_ILLEGAL: 
                case MOVE_NO_TILE: {
                    return this;
                }
                case MOVE: {
                    break;
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            this.lbAt(lb);
            Location newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
            if (newTarget == null) {
                return this.lbFail(lb, false, "found no pioneering target");
            }
            this.setTarget(newTarget);
            return this.lbRetarget(lb);
        }
        Tile tile = this.getTarget().getTile();
        block16: while (true) {
            Unit.MoveType mt = this.travelToTarget(this.getTarget(), costDecider, lb);
            switch (mt) {
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_REPAIR: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_MOVES: 
                case MOVE_ILLEGAL: 
                case MOVE_NO_TILE: {
                    return this;
                }
                case MOVE: {
                    break block16;
                }
                case MOVE_NO_ATTACK_CIVILIAN: {
                    Map.Direction d = unit.getTile().getDirection(tile);
                    if (d == null) continue block16;
                    this.moveRandomly(tag, d);
                    continue block16;
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            break;
        }
        this.lbAt(lb);
        if (!player.owns(tile)) {
            boolean fail = false;
            int price = player.getLandPrice(tile);
            if (price < 0) {
                fail = true;
            } else {
                if (price > 0 && !player.checkGold(price)) {
                    price = -1;
                }
                boolean bl = fail = !AIMessage.askClaimLand(tile, aiUnit, price) || !player.owns(tile);
            }
            if (fail) {
                aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
                this.tileImprovementPlan.dispose();
                lb.add(", land claim failed at ", tile);
                Location newTarget = PioneeringMission.findTarget(aiUnit, 10, false);
                if (newTarget == null) {
                    return this.lbFail(lb, false, "no alternate target");
                }
                this.setTarget(newTarget);
                return this.lbRetarget(lb);
            }
        }
        if (unit.getState() == Unit.UnitState.IMPROVING) {
            return this.lbWait(lb, ", improving ", this.tileImprovementPlan);
        }
        if (unit.checkSetState(Unit.UnitState.IMPROVING)) {
            aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
            if (AIMessage.askChangeWorkImprovementType(aiUnit, this.tileImprovementPlan.getType())) {
                return this.lbWait(lb, ", began ", this.tileImprovementPlan);
            }
            this.tileImprovementPlan.dispose();
            return this.lbFail(lb, false, "to change work type at ", tile);
        }
        return this.lbWait(lb, ", waiting to improve at ", tile);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
            if (this.tileImprovementPlan != null) {
                xw.writeAttribute(TILE_IMPROVEMENT_PLAN_TAG, this.tileImprovementPlan);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
        this.tileImprovementPlan = xr.hasAttribute(TILE_IMPROVEMENT_PLAN_TAG) ? xr.makeAIObject(aiMain, TILE_IMPROVEMENT_PLAN_TAG, TileImprovementPlan.class, null, true) : null;
    }

    @Override
    public String getXMLTagName() {
        return PioneeringMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "pioneeringMission";
    }
}

