/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;

public class CashInTreasureTrainMission
extends Mission {
    private static final Logger logger = Logger.getLogger(CashInTreasureTrainMission.class.getName());
    private static final String tag = "AI treasureTrain";
    private Location target;
    private static final String TARGET_TAG = "target";

    public CashInTreasureTrainMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit, target);
    }

    public CashInTreasureTrainMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private AIUnit assignCarrier(LogBuilder lb) {
        TransportMission tm;
        AIUnit aiCarrier;
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        Europe europe = player.getEurope();
        List<Unit> carriers = player.getCarriersForUnit(unit);
        if (carriers.isEmpty()) {
            return null;
        }
        Location here = unit.getLocation();
        int turns = Integer.MAX_VALUE;
        Unit closest = null;
        for (Unit c : carriers) {
            int t = c.getTurnsToReach(here);
            if (turns <= t) continue;
            turns = t;
            closest = c;
        }
        AIMain aiMain = this.getAIMain();
        if (closest != null && (aiCarrier = aiMain.getAIUnit(closest)) != null && (tm = aiCarrier.getMission(TransportMission.class)) != null) {
            this.setTarget(europe);
            aiUnit.changeTransport(aiCarrier);
            if (tm.queueTransportable(aiUnit, false, lb)) {
                lb.add(" to ", aiCarrier.getUnit());
            }
            return aiCarrier;
        }
        return null;
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Colony colony = loc.getColony();
        return loc instanceof Europe && CashInTreasureTrainMission.invalidReason(aiUnit, loc) == null ? loc : (colony != null && CashInTreasureTrainMission.invalidReason(aiUnit, colony) == null ? colony : null);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc;
        if (path == null || (loc = CashInTreasureTrainMission.extractTarget(aiUnit, path)) == null || loc instanceof Colony && CashInTreasureTrainMission.invalidFullColonyReason(aiUnit, loc.getColony()) != null) {
            return Integer.MIN_VALUE;
        }
        return aiUnit.getUnit().getTreasureAmount() / (path.getTotalTurns() + 1);
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value;
                Location loc = CashInTreasureTrainMission.extractTarget(aiUnit, path);
                if ((loc instanceof Colony && CashInTreasureTrainMission.invalidFullColonyReason(aiUnit, (Colony)loc) == null || loc instanceof Europe) && this.bestValue < (value = CashInTreasureTrainMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(false, gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    private static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (CashInTreasureTrainMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        Player player = unit.getOwner();
        Europe europe = player.getEurope();
        Unit carrier = unit.getCarrier();
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        if (player.getNumberOfSettlements() <= 0 || start == null) {
            return europe == null ? null : unit.findPath(unit.getLocation(), europe, carrier, standardCd);
        }
        return unit.search(start, CashInTreasureTrainMission.getGoalDecider(aiUnit, deferOK), standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = CashInTreasureTrainMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? CashInTreasureTrainMission.extractTarget(aiUnit, path) : CashInTreasureTrainMission.upLoc(CashInTreasureTrainMission.findCircleTarget(aiUnit, CashInTreasureTrainMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = CashInTreasureTrainMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return !unit.canCarryTreasure() ? "unit-cannot-carry-treasure" : (unit.getTreasureAmount() <= 0 ? "unit-treasure-nonpositive" : null);
    }

    private static String invalidFullColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = CashInTreasureTrainMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
        return reason != null ? reason : (!aiUnit.getUnit().canCashInTreasureTrain(colony.getTile()) ? "cashin-impossible-at-location" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return CashInTreasureTrainMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidEuropeReason(AIUnit aiUnit, Europe europe) {
        return CashInTreasureTrainMission.invalidTargetReason(europe, aiUnit.getUnit().getOwner());
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = CashInTreasureTrainMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? CashInTreasureTrainMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof Europe ? CashInTreasureTrainMission.invalidEuropeReason(aiUnit, (Europe)loc) : "target-invalid"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return CashInTreasureTrainMission.invalidMissionReason(aiUnit);
    }

    @Override
    public int getBaseTransportPriority() {
        return this.getUnit().getTreasureAmount();
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Europe || target instanceof Colony) {
            this.target = target;
        }
    }

    @Override
    public Location findTarget() {
        return CashInTreasureTrainMission.findTarget(this.getAIUnit(), 20, true);
    }

    @Override
    public String invalidReason() {
        return CashInTreasureTrainMission.invalidReason(this.getAIUnit(), this.target);
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (CashInTreasureTrainMission.isTargetReason(reason)) {
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        AIUnit aiUnit = this.getAIUnit();
        Europe europe = this.getUnit().getOwner().getEurope();
        if (unit.canCashInTreasureTrain()) {
            boolean cashin;
            Object aiCarrier = null;
            boolean bl = cashin = unit.isInEurope() || europe == null || unit.getTransportFee() == 0;
            if (!cashin && aiUnit.getTransport() == null) {
                boolean bl2 = cashin = this.assignCarrier(lb) == null;
            }
            if (cashin) {
                return AIMessage.askCashInTreasureTrain(aiUnit) ? this.lbDone(lb, false, "cashed in") : this.lbFail(lb, false, "cashin");
            }
        }
        return this.retargetMission("transport expected", lb);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return CashInTreasureTrainMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "cashInTreasureTrainMission";
    }
}

