/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.model.ServerPlayer;

public class REFAIPlayer
extends EuropeanAIPlayer {
    private static final Logger logger = Logger.getLogger(REFAIPlayer.class.getName());
    private static final int UNIT_USAD_THRESHOLD = 5;
    private static final int seekAndDestroyRange = 12;
    private final Map<Location, Integer> targetMap = new HashMap<Location, Integer>();

    public REFAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
        this.uninitialized = this.getPlayer() == null;
    }

    public REFAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.getPlayer() == null;
    }

    private List<TargetTuple> findColonyTargets(AIUnit aiu, boolean port, AIUnit aiCarrier) {
        Player player = this.getPlayer();
        Unit unit = aiu.getUnit();
        Unit carrier = aiCarrier.getUnit();
        ArrayList<TargetTuple> targets = new ArrayList<TargetTuple>();
        for (Player p : player.getRebels()) {
            for (Colony colony : p.getColonies()) {
                PathNode path;
                if (port && !colony.isConnectedPort() || (path = unit.findPath(carrier, colony, carrier, null)) == null) continue;
                int score = UnitSeekAndDestroyMission.scorePath(aiu, path);
                targets.add(new TargetTuple(colony, path, score));
            }
        }
        int percentTwiddle = 20;
        int[] twiddle = RandomUtils.randomInts(logger, "REF target twiddle", this.getAIRandom(), 41, targets.size());
        int twidx = 0;
        for (TargetTuple t : targets) {
            t.score *= 0.01 * (double)(101 - Math.min(100, t.colony.getSoL()));
            for (Building b : t.colony.getBuildings()) {
                if (b.getLevel() <= 1) continue;
                if (b.hasAbility("model.ability.repairUnits")) {
                    t.score *= 1.5;
                }
                for (AbstractGoods ag : b.getOutputs()) {
                    if (ag.getType().isMilitaryGoods()) {
                        t.score *= 2.0;
                        continue;
                    }
                    if (!ag.getType().isBuildingMaterial() || !ag.getType().isRefined()) continue;
                    t.score *= 1.5;
                }
            }
            int stockade = !t.colony.hasStockade() ? 0 : t.colony.getStockade().getLevel();
            t.score *= (double)(6 - stockade) / 6.0;
            t.score *= 1.0 + 0.01 * (double)(twiddle[twidx++] - 20);
        }
        Collections.sort(targets);
        LogBuilder logBuilder = new LogBuilder(64);
        logBuilder.add("REF found colony targets:");
        for (TargetTuple t : targets) {
            logBuilder.add(" ", t.colony, "(", t.score, ")");
        }
        logBuilder.log(logger, Level.FINE);
        return targets;
    }

    public boolean initialize(boolean teleport) {
        Mission m;
        PathNode path;
        TargetTuple t;
        int i;
        AIMain aiMain = this.getAIMain();
        Random aiRandom = this.getAIRandom();
        AIUnit aiUnit = null;
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.getUnit().isNaval() || !aiu.getUnit().isOffensiveUnit()) continue;
            aiUnit = aiu;
            break;
        }
        if (aiUnit == null) {
            logger.warning("REF has no army?!?");
            return false;
        }
        Unit unit = aiUnit.getUnit();
        Unit carrier = unit.getCarrier();
        if (carrier == null) {
            logger.warning("REF land unit not on a carrier: " + unit);
            return false;
        }
        AIUnit aiCarrier = aiMain.getAIUnit(carrier);
        if (aiCarrier == null) {
            logger.warning("REF naval unit missing: " + carrier);
            return false;
        }
        List<TargetTuple> targets = this.findColonyTargets(aiUnit, true, aiCarrier);
        if (targets.isEmpty()) {
            logger.warning("REF found no targets.");
            return false;
        }
        final Player rebel = targets.get((int)0).colony.getOwner();
        double ratio = this.getStrengthRatio(rebel);
        int n = targets.size();
        LogBuilder lb = new LogBuilder(64);
        lb.add("REF attacking ", rebel.getName(), " ratio=", ratio);
        int fail = 0;
        for (i = 0; i < n; ++i) {
            t = targets.get(i);
            GoalDecider gd = GoalDeciders.getDisembarkGoalDecider(t.colony.getTile());
            path = unit.search(t.entry, gd, null, 10, carrier);
            if (path == null) {
                t.disembarkTile = null;
                ++fail;
                continue;
            }
            t.disembarkTile = path.getTransportDropNode().previous.getTile();
        }
        if (fail > 0) {
            if (fail < n) {
                lb.add(" (");
                i = 0;
                while (i < targets.size()) {
                    t = targets.get(i);
                    if (t.disembarkTile == null) {
                        lb.add(" ", t.colony);
                        targets.remove(i);
                        --n;
                        continue;
                    }
                    ++i;
                }
                lb.add(")");
            } else {
                for (i = 0; i < n; ++i) {
                    t = targets.get(i);
                    t.disembarkTile = t.path.getTransportDropNode().previous.getTile();
                }
            }
        }
        n = ratio < 1.0 ? 1 : (ratio < 2.0 ? Math.min(2, targets.size()) : Math.min(3, targets.size()));
        lb.add(" => #targets=", n);
        if (!teleport) {
            GoalDecider stealthGD = GoalDeciders.getComposedGoalDecider(true, GoalDeciders.getHighSeasGoalDecider(), GoalDeciders.getStealthyGoalDecider(rebel));
            for (int i2 = 0; i2 < n; ++i2) {
                TargetTuple t2 = targets.get(i2);
                if (!rebel.canSee(t2.entry) || (path = carrier.search(t2.disembarkTile, stealthGD, CostDeciders.avoidSettlementsAndBlockingUnits(), t2.path.getTotalTurns() + 1, null)) == null) continue;
                t2.entry = path.getLastNode().getTile();
                t2.score *= 1.5;
            }
            Collections.sort(targets);
        }
        ArrayList<AIUnit> navy = new ArrayList<AIUnit>();
        Iterator<AIUnit> auIterator = this.getAIUnits().iterator();
        int land = this.getPlayer().getNumberOfKingLandUnits();
        block5: for (int i3 = 0; i3 < n && auIterator.hasNext(); ++i3) {
            TargetTuple t3 = targets.get(i3);
            lb.add("\n  Attack ", t3.colony, " from ", t3.entry, " via ", t3.disembarkTile, " with ");
            while (auIterator.hasNext()) {
                AIUnit aiu = auIterator.next();
                if (!aiu.getUnit().isNaval()) continue;
                Unit ship = aiu.getUnit();
                if (ship.isEmpty()) {
                    navy.add(aiu);
                    continue;
                }
                if (teleport) {
                    ship.setEntryLocation(t3.disembarkTile);
                } else {
                    ship.setEntryLocation(t3.entry);
                }
                lb.add("[", ship);
                lb.mark();
                int used = 0;
                for (Unit u : aiu.getUnit().getUnitList()) {
                    AIUnit laiu = aiMain.getAIUnit(u);
                    m = this.getSeekAndDestroyMission(laiu, t3.colony);
                    if (m != null) {
                        lb.add(" ", m);
                    }
                    ++used;
                }
                m = this.getTransportMission(aiu);
                lb.grew(" ", m);
                lb.add(" ]");
                if (i3 >= n - 1 || used < (int)Math.floor((double)land * 0.66)) continue;
                land -= used;
                continue block5;
            }
        }
        final ArrayList rebelNavy = new ArrayList();
        GoalDecider navyGD = new GoalDecider(){

            @Override
            public PathNode getGoal() {
                return null;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit unit, PathNode pathNode) {
                Tile tile = pathNode.getTile();
                if (tile != null && !tile.isEmpty() && !tile.isLand() && rebel.owns(tile.getFirstUnit())) {
                    for (Unit u : tile.getUnitList()) {
                        if (!u.isOffensiveUnit() || !u.isNaval() || rebelNavy.contains(u)) continue;
                        rebelNavy.add(u);
                    }
                }
                return false;
            }
        };
        for (int i4 = 0; i4 < n; ++i4) {
            carrier.search(targets.get((int)i4).entry, navyGD, null, carrier.getInitialMovesLeft() * 2, null);
        }
        Comparator<Unit> militaryStrength = Unit.getMilitaryStrengthComparator(this.getGame().getCombatModel());
        Collections.sort(rebelNavy, militaryStrength);
        Iterator ui = rebelNavy.iterator();
        ArrayList<Tile> entries = new ArrayList<Tile>();
        entries.add(rebel.getEntryLocation().getTile());
        while (!navy.isEmpty()) {
            Tile start;
            Unit enemy;
            AIUnit aiu = (AIUnit)navy.remove(0);
            Unit u = aiu.getUnit();
            Unit unit2 = enemy = ui.hasNext() ? (Unit)ui.next() : null;
            if (enemy == null) {
                m = this.getWanderHostileMission(aiu);
                if (m == null) continue;
                start = (Tile)RandomUtils.getRandomMember(logger, "REF patrol entry", entries, aiRandom);
                u.setEntryLocation(start);
                lb.add("\n  Patrol from ", start, " with ", m);
                continue;
            }
            m = this.getSeekAndDestroyMission(aiu, enemy);
            if (m == null) continue;
            start = u.getBestEntryTile(enemy.getTile());
            u.setEntryLocation(start);
            entries.add(start);
            lb.add("\n  Suppress ", enemy, " from ", start, " with ", m);
        }
        lb.log(logger, Level.FINE);
        return true;
    }

    private List<AIUnit> requireTransports(int nt, List<AIUnit> transports, List<AIUnit> privateers, LogBuilder lb) {
        Mission m;
        ArrayList<AIUnit> naval = new ArrayList<AIUnit>();
        ArrayList<AIUnit> result = new ArrayList<AIUnit>();
        if (transports.size() < nt) {
            for (AIUnit aiu : privateers) {
                Location target = aiu.getMission().getTarget();
                if (target instanceof Unit && aiu.getUnit().hasTile()) {
                    naval.add(aiu);
                    continue;
                }
                m = this.getTransportMission(aiu);
                if (m == null) continue;
                lb.add(" notarget ", m);
                result.add(aiu);
            }
        }
        if (transports.size() < nt) {
            Collections.sort(naval, new Comparator<AIUnit>(){

                @Override
                public int compare(AIUnit a1, AIUnit a2) {
                    int d1 = a1.getMission(PrivateerMission.class).getDistanceToTarget();
                    int d2 = a2.getMission(PrivateerMission.class).getDistanceToTarget();
                    return d1 - d2;
                }
            });
            while (!naval.isEmpty()) {
                AIUnit aiu = (AIUnit)naval.remove(0);
                int distance = aiu.getMission(PrivateerMission.class).getDistanceToTarget();
                m = this.getTransportMission(aiu);
                if (m == null) continue;
                lb.add(" REQUIRED ", distance, " ", m);
                result.add(aiu);
                if (result.size() + transports.size() < nt) continue;
                break;
            }
        }
        privateers.removeAll(result);
        transports.addAll(result);
        return result;
    }

    @Override
    protected Player.Stance determineStance(Player other) {
        Player player = this.getPlayer();
        return other.getREFPlayer() == player ? (other.isRebel() ? Player.Stance.WAR : Player.Stance.PEACE) : (other.atWarWith(player) ? Player.Stance.WAR : (!player.getRebels().isEmpty() ? Player.Stance.PEACE : super.determineStance(other)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void giveNormalMissions(LogBuilder lb) {
        Mission m;
        Colony colony;
        Player player = this.getPlayer();
        final HashMap idlers = new HashMap();
        ArrayList<AIUnit> privateers = new ArrayList<AIUnit>();
        ArrayList<AIUnit> transports = new ArrayList<AIUnit>();
        ArrayList<AIUnit> todo = new ArrayList<AIUnit>();
        ArrayList<AIUnit> land = new ArrayList<AIUnit>();
        lb.add("\n  REF mission changes:");
        this.targetMap.clear();
        for (AIUnit aIUnit : this.getAIUnits()) {
            Unit u = aIUnit.getUnit();
            if (u.isDisposed() || !u.hasAbility("model.ability.refUnit")) continue;
            Mission mission = aIUnit.getMission();
            if (u.isNaval()) {
                if (mission == null || !mission.isValid()) {
                    todo.add(aIUnit);
                    continue;
                }
                if (mission instanceof TransportMission) {
                    transports.add(aIUnit);
                    continue;
                }
                if (mission instanceof PrivateerMission) {
                    privateers.add(aIUnit);
                    Location loc = mission.getTarget();
                    if (loc == null) continue;
                    CollectionUtils.incrementMapCount(this.targetMap, loc);
                    continue;
                }
                todo.add(aIUnit);
                continue;
            }
            if (mission == null) {
                land.add(aIUnit);
                continue;
            }
            if (mission instanceof DefendSettlementMission) {
                if (mission.isValid()) {
                    colony = (Colony)mission.getTarget();
                    if (u.isAtLocation(colony) && !colony.isBadlyDefended() && RandomUtils.randomInt(logger, "REF defend " + colony.getName(), this.getAIRandom(), 3) == 0) {
                        land.add(aIUnit);
                        continue;
                    }
                    CollectionUtils.incrementMapCount(this.targetMap, mission.getTarget());
                    continue;
                }
                land.add(aIUnit);
                continue;
            }
            if (mission instanceof UnitSeekAndDestroyMission) {
                if (mission.isValid()) {
                    CollectionUtils.incrementMapCount(this.targetMap, mission.getTarget());
                    continue;
                }
                land.add(aIUnit);
                continue;
            }
            land.add(aIUnit);
        }
        for (AIUnit aIUnit : todo) {
            m = this.getTransportMission(aIUnit);
            if (m == null) continue;
            lb.add(" ", m);
            transports.add(aIUnit);
        }
        todo.clear();
        int nt = Math.max(3, privateers.size() / 10);
        this.requireTransports(nt, transports, privateers, lb);
        for (Object aiu : land) {
            Location target = UnitSeekAndDestroyMission.findTarget((AIUnit)aiu, 12, false);
            if (target != null) {
                int count;
                int n = count = this.targetMap.containsKey(target) ? this.targetMap.get(target) : 0;
                if (target instanceof Unit && count < 5 && (m = this.getSeekAndDestroyMission((AIUnit)aiu, target)) != null) {
                    lb.add(" NEW-SEEK-", count, " ", m);
                    CollectionUtils.incrementMapCount(this.targetMap, target);
                    continue;
                }
                if (target instanceof Settlement && (m = this.getSeekAndDestroyMission((AIUnit)aiu, target)) != null) {
                    lb.add(" NEW-SEEK ", m);
                    CollectionUtils.incrementMapCount(this.targetMap, target);
                    continue;
                }
                throw new RuntimeException("Bogus target: " + target);
            }
            Unit u = ((AIUnit)aiu).getUnit();
            if (u.isInEurope()) {
                CollectionUtils.appendToMapList(idlers, player.getEurope(), aiu);
                continue;
            }
            colony = u.getColony();
            if (colony != null && colony.isConnectedPort()) {
                CollectionUtils.appendToMapList(idlers, colony, aiu);
                continue;
            }
            int bestValue = Integer.MAX_VALUE;
            Colony best = null;
            for (AIColony aIColony : this.getBadlyDefended()) {
                Colony c = aIColony.getColony();
                int value = u.getTurnsToReach(c);
                if (value < 0 || value >= bestValue) continue;
                bestValue = value;
                best = c;
            }
            if (best != null && (m = this.getDefendSettlementMission((AIUnit)aiu, best)) != null) {
                lb.add(" GO-DEFEND-", best.getName(), " ", m);
                CollectionUtils.incrementMapCount(this.targetMap, best);
                continue;
            }
            PathNode path = u.findOurNearestPort();
            Colony colony2 = colony = path == null ? null : path.getLastNode().getTile().getColony();
            if (colony != null && (m = this.getDefendSettlementMission((AIUnit)aiu, colony)) != null) {
                lb.add(" GOTO-", colony.getName(), " ", m);
                CollectionUtils.incrementMapCount(this.targetMap, colony);
                continue;
            }
            m = this.getIdleAtSettlementMission((AIUnit)aiu);
            lb.add(" ", m);
        }
        if (!idlers.isEmpty()) {
            this.requireTransports(0, transports, privateers, lb);
            todo.clear();
            HashMap hashMap = new HashMap();
            for (AIUnit aiu : transports) {
                UnitLocation key;
                TransportMission tm = aiu.getMission(TransportMission.class);
                if (!tm.isEmpty()) continue;
                Unit u = aiu.getUnit();
                if (u.isInEurope() && idlers.containsKey(key = player.getEurope())) {
                    CollectionUtils.appendToMapList(hashMap, key, aiu);
                    continue;
                }
                key = u.getColony();
                if (key != null && idlers.containsKey(key)) {
                    CollectionUtils.appendToMapList(hashMap, key, aiu);
                    continue;
                }
                todo.add(aiu);
            }
            ArrayList<Location> idlePorts = new ArrayList<Location>();
            ArrayList<AIUnit> aiCarriers = new ArrayList<AIUnit>();
            int space = 0;
            for (Map.Entry e : idlers.entrySet()) {
                void var18_35;
                Object carrier;
                if (e.getValue() == null) continue;
                aiCarriers.clear();
                Location key = (Location)e.getKey();
                if (!hashMap.containsKey(key) || ((List)hashMap.get(key)).isEmpty()) continue;
                block6: for (AIUnit aiu : (List)e.getValue()) {
                    for (AIUnit aiCarrier : (List)hashMap.get(key)) {
                        carrier = aiCarrier.getUnit();
                        if (!((UnitLocation)carrier).canAdd(aiu.getUnit()) || !aiu.joinTransport((Unit)carrier, null)) continue;
                        if (aiCarriers.contains(aiCarrier)) continue block6;
                        aiCarriers.add(aiCarrier);
                        continue block6;
                    }
                }
                if (aiCarriers.isEmpty()) continue;
                Object var18_34 = null;
                Colony target = null;
                for (AIUnit aiCarrier : aiCarriers) {
                    AIUnit aIUnit;
                    Unit u;
                    carrier = aiCarrier.getUnit().getUnitList().iterator();
                    while (carrier.hasNext() && (!(u = (Unit)carrier.next()).hasAbility("model.ability.refUnit") || (aIUnit = this.getAIUnit(u)) == null)) {
                    }
                    if (var18_35 == null || (m = var18_35.getMission()) == null || !m.isValid() || !(m instanceof UnitSeekAndDestroyMission) || !(m.getTarget() instanceof Colony)) continue;
                    target = (Colony)m.getTarget();
                    break;
                }
                if (target == null) {
                    AIUnit aiCarrier = this.getAIUnit(var18_35.getUnit().getCarrier());
                    List<TargetTuple> ct = this.findColonyTargets((AIUnit)var18_35, true, aiCarrier);
                    if (ct.isEmpty()) {
                        ct = this.findColonyTargets((AIUnit)var18_35, false, aiCarrier);
                    }
                    if (!ct.isEmpty()) {
                        target = ct.get((int)0).colony;
                    }
                }
                if (target == null) continue;
                for (AIUnit aiCarrier : aiCarriers) {
                    TransportMission tm = aiCarrier.getMission(TransportMission.class);
                    for (Unit u : aiCarrier.getUnit().getUnitList()) {
                        AIUnit aiu;
                        if (!u.hasAbility("model.ability.refUnit") || (aiu = this.getAIUnit(u)) == null || (m = this.getSeekAndDestroyMission(aiu, target)) == null) continue;
                        lb.add(" IDLER->", target, " ", m);
                        tm.queueTransportable(aiu, false, lb);
                        ((List)e.getValue()).remove(aiu);
                    }
                }
                if (((List)e.getValue()).isEmpty()) continue;
                idlePorts.add(key);
                for (AIUnit aiu : (List)e.getValue()) {
                    space += aiu.getUnit().getSpaceTaken();
                }
            }
            if (!idlePorts.isEmpty()) {
                for (AIUnit aiu : todo) {
                    space -= aiu.getUnit().getCargoCapacity() - aiu.getUnit().getCargoSpaceTaken();
                }
                nt = todo.size();
                if (space < 0) {
                    this.requireTransports(nt += -space / 5 + 1, todo, privateers, lb);
                }
                Collections.sort(idlePorts, new Comparator<Location>(){

                    @Override
                    public int compare(Location l1, Location l2) {
                        return ((List)idlers.get(l1)).size() - ((List)idlers.get(l2)).size();
                    }
                });
                boolean bad = false;
                while (!bad && !todo.isEmpty()) {
                    for (Location l : idlePorts) {
                        int n = Integer.MAX_VALUE;
                        AIUnit best = null;
                        for (AIUnit aiu : todo) {
                            int value = aiu.getUnit().getTurnsToReach(l);
                            if (value < 0 || value >= n) continue;
                            n = value;
                            best = aiu;
                        }
                        if (best == null) {
                            bad = true;
                            continue;
                        }
                        todo.remove(best);
                        best.getMission().setTarget(l);
                        lb.add(" retarget ", best, " to ", l, "(", ((List)idlers.get(l)).size(), ")");
                    }
                }
            }
        }
        super.giveNormalMissions(lb);
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        if (!player.isWorkForREF()) {
            logger.warning("No work for REF: " + player);
            return;
        }
        super.startWorking();
        ArrayList<TransportMission> transport = new ArrayList<TransportMission>();
        ArrayList<TransportableAIObject> land = new ArrayList<TransportableAIObject>();
        for (AIUnit aiu : this.getAIUnits()) {
            Unit u = aiu.getUnit();
            if (u.isNaval()) {
                if (!aiu.hasMission(TransportMission.class)) continue;
                transport.add(aiu.getMission(TransportMission.class));
                continue;
            }
            if (!u.isInEurope()) continue;
            land.add(aiu);
        }
        if (!land.isEmpty() && !transport.isEmpty()) {
            LogBuilder lb = new LogBuilder(256);
            this.allocateTransportables(land, transport, lb);
            lb.log(logger, Level.FINE);
        }
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (value > 0) {
            if (type == DefendSettlementMission.class) {
                Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
                if (loc instanceof Colony && !((Colony)loc).isBadlyDefended()) {
                    return Integer.MIN_VALUE;
                }
            } else if (type == UnitSeekAndDestroyMission.class) {
                Location target = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
                if (target instanceof Settlement) {
                    if (((Settlement)target).isConnectedPort()) {
                        value += 500;
                    } else if (this.getPlayer().getNumberOfSettlements() <= 0) {
                        return Integer.MIN_VALUE;
                    }
                } else if (target instanceof Unit) {
                    if (this.getPlayer().getNumberOfSettlements() <= 0) {
                        return Integer.MIN_VALUE;
                    }
                    for (AIUnit au : this.getAIUnits()) {
                        Location loc;
                        UnitSeekAndDestroyMission m = au.getMission(UnitSeekAndDestroyMission.class);
                        if (m == null || (loc = ((Mission)m).getTarget()) == null || !(loc instanceof Unit) || loc != target) continue;
                        return Integer.MIN_VALUE;
                    }
                    value /= 2;
                }
            }
        }
        return value;
    }

    private static class TargetTuple
    implements Comparable<TargetTuple> {
        public final Colony colony;
        public final PathNode path;
        public double score;
        public Tile disembarkTile;
        public Tile entry;

        public TargetTuple(Colony colony, PathNode path, double score) {
            this.colony = colony;
            this.path = path;
            this.score = score;
            this.disembarkTile = null;
            this.entry = null;
            if (path != null) {
                PathNode p = path;
                while (p != null) {
                    Tile t = p.getTile();
                    if (t != null) {
                        this.entry = t;
                        break;
                    }
                    p = p.next;
                }
            }
        }

        @Override
        public int compareTo(TargetTuple other) {
            double cmp = other.score - this.score;
            return cmp < 0.0 ? -1 : (cmp > 0.0 ? 1 : 0);
        }

        public boolean equals(Object other) {
            if (other instanceof TargetTuple) {
                return this.compareTo((TargetTuple)other) == 0;
            }
            return super.equals(other);
        }

        public int hashCode() {
            int hash = super.hashCode();
            hash = 37 * hash + Utils.hashCode(this.colony);
            hash = 37 * hash + Utils.hashCode(this.path);
            hash = 37 * hash + Utils.hashCode(this.score);
            hash = 37 * hash + Utils.hashCode(this.disembarkTile);
            return 37 * hash + Utils.hashCode(this.entry);
        }
    }
}

