/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.model.ServerPlayer;

public class NativeAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(NativeAIPlayer.class.getName());
    public static final int MAX_DISTANCE_TO_BRING_GIFTS = 5;
    public static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    public static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    public static final int MAX_NUMBER_OF_DEMANDS = 1;
    private final HashMap<String, Integer> sessionRegister = new HashMap();
    private final Map<Unit, String> reasons = new HashMap<Unit, String>();

    public NativeAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
        this.uninitialized = this.getPlayer() == null;
    }

    public NativeAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.getPlayer() == null;
    }

    private void initializeMissions(LogBuilder lb) {
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        lb.add("\n  Initialize");
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (IndianSettlement is : player.getIndianSettlements()) {
            units.clear();
            units.addAll(is.getTile().getUnitList());
            units.addAll(is.getUnitList());
            while (units.size() > is.getRequiredDefenders()) {
                Unit u = (Unit)units.remove(0);
                AIUnit aiu = this.getAIUnit(u);
                Mission m = this.getWanderHostileMission(aiu);
                if (m == null) continue;
                lb.add(" ", m);
            }
            for (Unit u : units) {
                AIUnit aiu = this.getAIUnit(u);
                Mission m = this.getDefendSettlementMission(aiu, is);
                if (m == null) continue;
                lb.add(" ", m);
            }
        }
    }

    private void determineStances(LogBuilder lb) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getPlayer();
        lb.mark();
        for (Player p : this.getGame().getLivePlayers(serverPlayer)) {
            Player.Stance newStance = this.determineStance(p);
            if (newStance == serverPlayer.getStance(p)) continue;
            this.getAIMain().getFreeColServer().getInGameController().changeStance(serverPlayer, newStance, (ServerPlayer)p, true);
            lb.add(new Object[]{" ", p.getDebugName(), "->", newStance, ", "});
        }
        if (lb.grew("\n  Stance changes:")) {
            lb.shrink(", ");
        }
    }

    private void secureSettlements(int[] randoms, LogBuilder lb) {
        int randomIdx = 0;
        List<IndianSettlement> settlements = this.getPlayer().getIndianSettlements();
        for (IndianSettlement is : settlements) {
            int n;
            IndianSettlement settlement;
            if ((settlement = settlements.get(n = randoms[randomIdx++])) == is) continue;
            is.tradeGoodsWithSettlement(settlement);
        }
        for (IndianSettlement is : settlements) {
            lb.mark();
            this.equipBraves(is, lb);
            this.secureIndianSettlement(is, lb);
            if (!lb.grew("\n  At ", is.getName())) continue;
            lb.shrink(", ");
        }
    }

    public void equipBraves(IndianSettlement is, LogBuilder lb) {
        Specification spec = this.getSpecification();
        List<Unit> units = is.getUnitList();
        units.addAll(is.getTile().getUnitList());
        Collections.sort(units, Unit.getMilitaryStrengthComparator(this.getGame().getCombatModel()));
        boolean moreHorses = true;
        boolean moreMuskets = true;
        for (Unit u : units) {
            Role r = is.canImproveUnitMilitaryRole(u);
            if (r == null) continue;
            Role old = u.getRole();
            if (!this.getAIUnit(u).equipForRole(r) || u.getRole() == old) continue;
            lb.add(u, " upgraded from ", old.getSuffix(), ", ");
        }
    }

    public void secureIndianSettlement(final IndianSettlement is, LogBuilder lb) {
        DefendSettlementMission dm;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        CombatModel cm = this.getGame().getCombatModel();
        int minimumDefence = is.getType().getMinimumSize() - 1;
        ArrayList<Unit> units = new ArrayList<Unit>();
        ArrayList<Unit> defenders = new ArrayList<Unit>();
        units.addAll(is.getUnitList());
        units.addAll(is.getTile().getUnitList());
        for (Unit u : is.getOwnedUnits()) {
            if (units.contains(u)) continue;
            units.add(u);
        }
        for (Unit u : new ArrayList(units)) {
            AIUnit aiu = aiMain.getAIUnit(u);
            if (aiu == null) {
                units.remove(u);
                continue;
            }
            dm = aiu.getMission(DefendSettlementMission.class);
            if (dm != null && dm.getTarget() == is) {
                defenders.add(u);
                units.remove(u);
                continue;
            }
            if (Mission.invalidNewMissionReason(aiu) == null) continue;
            units.remove(u);
        }
        final HashMap<Tile, Float> threats = new HashMap<Tile, Float>();
        for (Tile t : is.getTile().getSurroundingTiles(is.getRadius() + 1)) {
            float bonus;
            float threshold;
            if (!t.isLand() || t.getUnitCount() == 0) continue;
            Player enemy = t.getFirstUnit().getOwner();
            if (enemy == player) {
                for (Unit u : t.getUnitList()) {
                    AIUnit aiu;
                    if (defenders.contains(u) || units.contains(u) || (aiu = aiMain.getAIUnit(u)) == null) continue;
                    dm = aiu.getMission(DefendSettlementMission.class);
                    if (dm != null && dm.getTarget() == is) {
                        defenders.add(u);
                        continue;
                    }
                    if (Mission.invalidNewMissionReason(aiu) != null) continue;
                    units.add(u);
                }
                continue;
            }
            Tension tension = is.getAlarm(enemy);
            if (tension == null || tension.getLevel().compareTo(Tension.Level.CONTENT) <= 0) continue;
            float value = 0.0f;
            if (tension.getLevel().compareTo(Tension.Level.DISPLEASED) <= 0) {
                threshold = 1.0f;
                bonus = 0.0f;
            } else {
                threshold = 0.0f;
                bonus = (float)tension.getLevel().ordinal() - (float)Tension.Level.CONTENT.ordinal();
            }
            for (Unit u : t.getUnitList()) {
                float offence = cm.getOffencePower(u, is);
                if (!(offence > threshold)) continue;
                value += offence + bonus;
            }
            if (!(value > 0.0f)) continue;
            threats.put(t, new Float(value));
        }
        int homeBonus = 3;
        final Tile isTile = is.getTile();
        Comparator<Unit> isComparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                Tile t1 = u1.getTile();
                int s1 = t1.getDistanceTo(isTile);
                Tile t2 = u2.getTile();
                int s2 = t2.getDistanceTo(isTile);
                if (u1.getHomeIndianSettlement() == is) {
                    s1 -= 3;
                }
                if (u2.getHomeIndianSettlement() == is) {
                    s2 -= 3;
                }
                return s1 - s2;
            }
        };
        int needed = minimumDefence + threats.size();
        if (defenders.size() < needed) {
            Collections.sort(units, isComparator);
            while (!units.isEmpty()) {
                Unit u = (Unit)units.remove(0);
                AIUnit aiu = aiMain.getAIUnit(u);
                Mission m = this.getDefendSettlementMission(aiu, is);
                if (m == null) continue;
                lb.add(m, ", ");
                defenders.add(u);
                if (defenders.size() < needed) continue;
                break;
            }
        } else if (defenders.size() > needed) {
            Collections.sort(defenders, isComparator);
            Collections.reverse(defenders);
            while (defenders.size() > needed) {
                units.add((Unit)defenders.remove(0));
            }
        }
        ArrayList threatTiles = new ArrayList(threats.keySet());
        Collections.sort(threatTiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile t1, Tile t2) {
                return Float.compare(((Float)threats.get(t2)).floatValue(), ((Float)threats.get(t1)).floatValue());
            }
        });
        if (!defenders.isEmpty()) {
            lb.add(" defend with:");
            for (Unit u : defenders) {
                lb.add(" ", u);
            }
            lb.add(" minimum=", minimumDefence, " threats=", threats.size(), ", ");
        }
        while (!threatTiles.isEmpty() && !units.isEmpty()) {
            Unit target;
            Tile tile = (Tile)threatTiles.remove(0);
            int bestDistance = Integer.MAX_VALUE;
            Unit unit = null;
            for (Unit u : units) {
                int distance;
                AIUnit aiu = aiMain.getAIUnit(u);
                if (UnitSeekAndDestroyMission.invalidReason(aiu, tile.getDefendingUnit(u)) != null || bestDistance <= (distance = u.getTile().getDistanceTo(tile))) continue;
                bestDistance = distance;
                unit = u;
            }
            if (unit == null) continue;
            units.remove(unit);
            AIUnit aiUnit = aiMain.getAIUnit(unit);
            Mission m = this.getSeekAndDestroyMission(aiUnit, target = tile.getDefendingUnit(unit));
            if (m == null) continue;
            lb.add(m, ", ");
        }
    }

    private void giveNormalMissions(LogBuilder lb) {
        Unit unit;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        Specification spec = this.getSpecification();
        int turnNumber = this.getGame().getTurn().getNumber();
        List<AIUnit> aiUnits = this.getAIUnits();
        lb.mark();
        ArrayList<AIUnit> done = new ArrayList<AIUnit>();
        this.reasons.clear();
        for (AIUnit aiUnit : aiUnits) {
            unit = aiUnit.getUnit();
            Mission m = aiUnit.getMission();
            Object reason = null;
            if (unit.isUninitialized() || unit.isDisposed()) {
                this.reasons.put(unit, "Invalid");
            } else {
                if (m == null || !m.isValid() || m.isOneTime()) continue;
                this.reasons.put(unit, "Valid");
            }
            done.add(aiUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        for (AIUnit aiUnit : aiUnits) {
            unit = aiUnit.getUnit();
            Settlement settlement = unit.getSettlement();
            IndianSettlement is = unit.getHomeIndianSettlement();
            Mission m = aiUnit.getMission();
            if (settlement != null && settlement.getUnitCount() + settlement.getTile().getUnitCount() <= 1) {
                if (!(m instanceof DefendSettlementMission) || m.getTarget() != settlement) {
                    m = this.getDefendSettlementMission(aiUnit, settlement);
                    if (m == null) continue;
                    lb.add(m, ", ");
                }
                this.reasons.put(unit, "Defend-" + settlement.getName());
            } else if (is != null && is.canImproveUnitMilitaryRole(unit) != null) {
                if (!(m instanceof DefendSettlementMission) || m.getTarget() != is) {
                    m = this.getDefendSettlementMission(aiUnit, is);
                    if (m == null) continue;
                    lb.add(m, ", ");
                }
                this.reasons.put(unit, "Equip-" + is.getName());
            } else {
                if (!(m instanceof UnitWanderHostileMission)) {
                    m = this.getWanderHostileMission(aiUnit);
                    if (m == null) continue;
                    lb.add(m, ", ");
                }
                this.reasons.put(unit, "Patrol");
            }
            done.add(aiUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        if (lb.grew("\n  Mission changes: ")) {
            lb.shrink(", ");
        }
        if (!aiUnits.isEmpty()) {
            lb.add("\n  Free Land Units:");
            for (AIUnit aiu : aiUnits) {
                lb.add(" ", aiu.getUnit());
            }
        }
        lb.add("\n  Missions(settlements=", player.getNumberOfSettlements(), ")");
        this.logMissions(this.reasons, lb);
    }

    private void bringGifts(int[] randoms, LogBuilder lb) {
        Player player = this.getPlayer();
        CostDecider cd = CostDeciders.numberOfLegalTiles();
        int giftProbability = this.getSpecification().getInteger("model.option.giftProbability");
        int randomIdx = 0;
        lb.mark();
        for (IndianSettlement is : player.getIndianSettlements()) {
            Goods gift;
            if (randoms[randomIdx++] >= giftProbability || (gift = is.getRandomGift(this.getAIRandom())) == null) continue;
            ArrayList<Unit> availableUnits = new ArrayList<Unit>();
            int alreadyAssignedUnits = 0;
            for (Unit ou : is.getOwnedUnits()) {
                AIUnit aiu = this.getAIUnit(ou);
                if (aiu == null) continue;
                if (aiu.hasMission(IndianBringGiftMission.class)) {
                    ++alreadyAssignedUnits;
                    continue;
                }
                if (Mission.invalidNewMissionReason(aiu) != null) continue;
                availableUnits.add(ou);
            }
            if (alreadyAssignedUnits > 1) {
                lb.add(is.getName(), " has ", alreadyAssignedUnits, " already, ");
                continue;
            }
            if (availableUnits.isEmpty()) {
                lb.add(is.getName(), " has no gift units, ");
                continue;
            }
            Unit unit = null;
            AIUnit aiUnit = null;
            Tile home = is.getTile();
            while (unit == null && !availableUnits.isEmpty()) {
                Unit u = (Unit)availableUnits.get(RandomUtils.randomInt(logger, "Gift unit", this.getAIRandom(), availableUnits.size()));
                availableUnits.remove(u);
                aiUnit = this.getAIUnit(u);
                if (IndianBringGiftMission.invalidReason(aiUnit) != null || u.findPath(u.getTile(), home, null, cd) == null) continue;
                unit = u;
            }
            if (unit == null) {
                lb.add(is.getName(), " found no gift unit, ");
                continue;
            }
            ArrayList nearbyColonies = new ArrayList();
            for (Tile t : home.getSurroundingTiles(5)) {
                PathNode path;
                Colony c = t.getColony();
                if (c == null || !is.hasContacted(c.getOwner()) || IndianBringGiftMission.invalidReason(aiUnit, c) != null || (path = unit.findPath(home, c.getTile(), null, cd)) == null) continue;
                int alarm = Math.max(1, is.getAlarm(c.getOwner()).getValue());
                nearbyColonies.add(new RandomChoice<Colony>(c, 1000000 / alarm / path.getTotalTurns()));
            }
            if (nearbyColonies.isEmpty()) {
                lb.add(is.getName(), " found no gift colonies, ");
                continue;
            }
            Colony target = (Colony)RandomChoice.getWeightedRandom(logger, "Choose gift colony", nearbyColonies, this.getAIRandom());
            if (target == null) {
                throw new IllegalStateException("No gift target!?!");
            }
            IndianBringGiftMission m = new IndianBringGiftMission(this.getAIMain(), aiUnit, target);
            lb.add(m, " gift from ", is.getName(), " to ", target.getName(), ", ");
        }
        if (lb.grew("\n  Gifts: ")) {
            lb.shrink(", ");
        }
    }

    private void demandTribute(int[] randoms, LogBuilder lb) {
        Player player = this.getPlayer();
        CostDecider cd = CostDeciders.numberOfLegalTiles();
        int demandProbability = this.getSpecification().getInteger("model.option.demandProbability");
        int randomIdx = 0;
        lb.mark();
        for (IndianSettlement is : player.getIndianSettlements()) {
            if (randoms[randomIdx++] >= demandProbability) continue;
            ArrayList<Unit> availableUnits = new ArrayList<Unit>();
            int alreadyAssignedUnits = 0;
            for (Unit ou : is.getOwnedUnits()) {
                AIUnit aiu = this.getAIUnit(ou);
                if (Mission.invalidNewMissionReason(aiu) != null) continue;
                if (aiu.hasMission(IndianDemandMission.class)) {
                    ++alreadyAssignedUnits;
                    continue;
                }
                availableUnits.add(ou);
            }
            if (alreadyAssignedUnits > 1) {
                lb.add(is.getName(), " has ", alreadyAssignedUnits, " already, ");
                continue;
            }
            if (availableUnits.isEmpty()) {
                lb.add(is.getName(), " has no demand units, ");
                continue;
            }
            Tile home = is.getTile();
            Unit unit = null;
            AIUnit aiUnit = null;
            while (unit == null && !availableUnits.isEmpty()) {
                Unit u = (Unit)availableUnits.get(RandomUtils.randomInt(logger, "Demand unit", this.getAIRandom(), availableUnits.size()));
                availableUnits.remove(u);
                aiUnit = this.getAIUnit(u);
                if (IndianDemandMission.invalidReason(aiUnit) != null || u.findPath(u.getTile(), home, null, cd) == null) continue;
                unit = u;
            }
            if (unit == null) {
                lb.add(is.getName(), " found no demand unit, ");
                continue;
            }
            ArrayList nearbyColonies = new ArrayList();
            for (Tile t : home.getSurroundingTiles(5)) {
                PathNode path;
                Colony c = t.getColony();
                if (c == null || !is.hasContacted(c.getOwner()) || IndianDemandMission.invalidReason(aiUnit, c) != null || (path = unit.findPath(home, c.getTile(), null, cd)) == null) continue;
                int alarm = is.getAlarm(c.getOwner()).getValue();
                int defence = c.getUnitCount() + (c.getStockade() == null ? 1 : c.getStockade().getLevel() * 10);
                int weight = 1 + alarm * (1000000 / defence / path.getTotalTurns());
                nearbyColonies.add(new RandomChoice<Colony>(c, weight));
            }
            if (nearbyColonies.isEmpty()) {
                lb.add(is.getName(), " found no demand colonies, ");
                continue;
            }
            Colony target = (Colony)RandomChoice.getWeightedRandom(logger, "Choose demand colony", nearbyColonies, this.getAIRandom());
            if (target == null) {
                lb.add(is.getName(), " found no demand target, ");
                continue;
            }
            IndianDemandMission m = new IndianDemandMission(this.getAIMain(), aiUnit, target);
            lb.add("At ", is.getName(), " ", m, " will demand of ", target, ", ");
        }
        if (lb.grew("\n  Tribute: ")) {
            lb.shrink(", ");
        }
    }

    private Set<Modifier> getShipTradePenalties(boolean sense) {
        Specification spec = this.getSpecification();
        int penalty = spec.getInteger("model.option.shipTradePenalty");
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (Modifier m : spec.getModifiers("model.modifier.shipTradePenalty")) {
            Modifier n = new Modifier(m);
            n.setValue(sense ? (float)penalty : (float)(-penalty));
            result.add(n);
        }
        return result;
    }

    public void abortInvalidMissions() {
        for (AIUnit au : this.getAIUnits()) {
            Mission mission = au.getMission();
            String reason = mission == null ? null : mission.invalidReason();
            if (reason == null) continue;
            au.setMission(null);
        }
    }

    @Override
    public void startWorking() {
        List<AIUnit> more;
        Player player = this.getPlayer();
        Turn turn = this.getGame().getTurn();
        int nSettlements = player.getNumberOfSettlements();
        Random air = this.getAIRandom();
        LogBuilder lb = new LogBuilder(1024);
        lb.add(player.getDebugName(), " in ", turn, "/", turn.getNumber());
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.determineStances(lb);
        if (turn.isFirstTurn()) {
            this.initializeMissions(lb);
            more = this.getAIUnits();
        } else {
            this.abortInvalidMissions();
            int[] randoms = RandomUtils.randomInts(logger, "Trades", air, nSettlements, nSettlements);
            this.secureSettlements(randoms, lb);
            randoms = RandomUtils.randomInts(logger, "Gifts", air, 100, nSettlements);
            this.bringGifts(randoms, lb);
            randoms = RandomUtils.randomInts(logger, "Tribute", air, 100, nSettlements);
            this.demandTribute(randoms, lb);
            this.giveNormalMissions(lb);
            more = this.doMissions(this.getAIUnits(), lb);
        }
        if (!more.isEmpty()) {
            this.abortInvalidMissions();
            this.giveNormalMissions(lb);
            this.doMissions(more, lb);
        }
        this.clearAIUnits();
        lb.log(logger, Level.FINEST);
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (type == DefendSettlementMission.class) {
            Settlement settlement = (Settlement)DefendSettlementMission.extractTarget(aiUnit, path);
            value -= 75 * this.getSettlementDefenders(settlement);
        } else if (type == UnitSeekAndDestroyMission.class) {
            Location target = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
            Player targetPlayer = target instanceof Ownable ? ((Ownable)((Object)target)).getOwner() : null;
            IndianSettlement is = aiUnit.getUnit().getHomeIndianSettlement();
            if (targetPlayer != null && is != null && is.getAlarm(targetPlayer) != null) {
                value += is.getAlarm(targetPlayer).getValue() - Tension.Level.DISPLEASED.getLimit();
            }
        }
        return value;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        Specification spec = this.getSpecification();
        IndianSettlement is = (IndianSettlement)settlement;
        Player buyer = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = is.getPriceToSell(goods);
            switch (is.getAlarm(buyer).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    break;
                }
                case DISPLEASED: {
                    price *= 2;
                    break;
                }
                default: {
                    return -3;
                }
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            if (is.hasMissionary(buyer) && spec.getBoolean("model.option.enhancedMissionaries")) {
                Unit u = is.getMissionary();
                modifiers.addAll(u.getMissionaryTradeModifiers(false));
            }
            if (unit.isNaval()) {
                modifiers.addAll(this.getShipTradePenalties(false));
            }
            price = (int)FeatureContainer.applyModifiers(price, this.getGame().getTurn(), modifiers);
            this.sessionRegister.put(goldKey, price);
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending offer too low");
            this.sessionRegister.put(goldKey, -1);
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (RandomUtils.randomInt(logger, "Haggle-buy", this.getAIRandom(), 3 + haggling) >= 3) {
            this.sessionRegister.put(goldKey, -1);
            return -2;
        }
        this.sessionRegister.put(goldKey, gold);
        this.sessionRegister.put(hagglingKey, haggling + 1);
        return gold;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        int price;
        logger.finest("Entering method sellProposition");
        Specification spec = this.getSpecification();
        IndianSettlement is = (IndianSettlement)settlement;
        Player seller = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        if (this.sessionRegister.containsKey(goldKey)) {
            price = this.sessionRegister.get(goldKey);
        } else {
            price = is.getPriceToBuy(goods);
            switch (is.getAlarm(seller).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    break;
                }
                case DISPLEASED: {
                    price /= 2;
                    break;
                }
                case ANGRY: {
                    if (!goods.getType().isMilitaryGoods()) {
                        return -3;
                    }
                    price /= 2;
                    break;
                }
                default: {
                    return -3;
                }
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            if (is.hasMissionary(seller) && spec.getBoolean("model.option.enhancedMissionaries")) {
                Unit u = is.getMissionary();
                modifiers.addAll(u.getMissionaryTradeModifiers(true));
            }
            if (unit.isNaval()) {
                modifiers.addAll(this.getShipTradePenalties(true));
            }
            if ((price = (int)FeatureContainer.applyModifiers(price, this.getGame().getTurn(), modifiers)) <= 0) {
                return 0;
            }
            this.sessionRegister.put(goldKey, price);
        }
        if (gold < 0 || price == gold) {
            return price;
        }
        if (gold > price * 11 / 10) {
            logger.warning("Cheating attempt: haggling request too high");
            this.sessionRegister.put(goldKey, -1);
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (RandomUtils.randomInt(logger, "Haggle-sell", this.getAIRandom(), 3 + haggling) >= 3) {
            this.sessionRegister.put(goldKey, -1);
            return -2;
        }
        this.sessionRegister.put(goldKey, gold);
        this.sessionRegister.put(hagglingKey, haggling + 1);
        return gold;
    }

    @Override
    public String getXMLTagName() {
        return NativeAIPlayer.getXMLElementTagName();
    }
}

