/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.InciteTradeItem;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Cargo;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;

public class EuropeanAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(EuropeanAIPlayer.class.getName());
    private static final int buildingRange = 5;
    private static final int cashInRange = 20;
    private static final int missionaryRange = 20;
    private static final int pioneeringRange = 10;
    private static final int privateerRange = 1;
    private static final int scoutingRange = 20;
    private static final Comparator<AIUnit> builderComparator = new Comparator<AIUnit>(){

        private int score(AIUnit a) {
            int base;
            Unit unit;
            if (a == null || (unit = a.getUnit()) == null || BuildColonyMission.invalidReason(a) != null) {
                return -1000;
            }
            int n = !unit.hasDefaultRole() ? 0 : (base = unit.getSkillLevel() > 0 ? 100 : 500 + 100 * unit.getSkillLevel());
            if (unit.hasTile()) {
                base += 50;
            }
            return base;
        }

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            return this.score(a2) - this.score(a1);
        }
    };
    public static final Comparator<AIUnit> pioneerComparator = new Comparator<AIUnit>(){

        private int score(AIUnit a) {
            Unit unit;
            return a == null || (unit = a.getUnit()) == null ? -1000 : unit.getPioneerScore();
        }

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            return this.score(a2) - this.score(a1);
        }
    };
    public static final Comparator<AIUnit> scoutComparator = new Comparator<AIUnit>(){

        private int score(AIUnit a) {
            Unit unit;
            return a == null || (unit = a.getUnit()) == null ? -1000 : unit.getScoutScore();
        }

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            return this.score(a2) - this.score(a1);
        }
    };
    private static int liftBoycottCheatPercent;
    private static int equipScoutCheatPercent;
    private static int equipPioneerCheatPercent;
    private static int landUnitCheatPercent;
    private static int offensiveLandUnitCheatPercent;
    private static int offensiveNavalUnitCheatPercent;
    private static int transportNavalUnitCheatPercent;
    private static Role pioneerRole;
    private static Role scoutRole;
    private final java.util.Map<String, Integer> sessionRegister = new HashMap<String, Integer>();
    private final java.util.Map<Player, NationSummary> nationMap = new HashMap<Player, NationSummary>();
    private final java.util.Map<Tile, TileImprovementPlan> tipMap = new HashMap<Tile, TileImprovementPlan>();
    private final java.util.Map<Location, List<Wish>> transportDemand = new HashMap<Location, List<Wish>>();
    private final List<TransportableAIObject> transportSupply = new ArrayList<TransportableAIObject>();
    private final java.util.Map<GoodsType, List<GoodsWish>> goodsWishes = new HashMap<GoodsType, List<GoodsWish>>();
    private final java.util.Map<UnitType, List<WorkerWish>> workerWishes = new HashMap<UnitType, List<WorkerWish>>();
    private final java.util.Map<Integer, Integer> wagonsNeeded = new HashMap<Integer, Integer>();
    private final List<AIColony> badlyDefended = new ArrayList<AIColony>();
    private int nBuilders = 0;
    private int nPioneers = 0;
    private int nScouts = 0;
    private int nNavalCarrier = 0;

    public EuropeanAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
        this.uninitialized = this.getPlayer() == null;
    }

    public EuropeanAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.getPlayer() == null;
    }

    public static synchronized void initializeFromSpecification(Specification spec) {
        if (pioneerRole != null) {
            return;
        }
        pioneerRole = spec.getRoleWithAbility("model.ability.improveTerrain", null);
        scoutRole = spec.getRoleWithAbility("model.ability.speakWithChief", null);
        liftBoycottCheatPercent = spec.getInteger("model.option.liftBoycottCheat");
        equipScoutCheatPercent = spec.getInteger("model.option.equipScoutCheat");
        equipPioneerCheatPercent = spec.getInteger("model.option.equipPioneerCheat");
        landUnitCheatPercent = spec.getInteger("model.option.landUnitCheat");
        offensiveLandUnitCheatPercent = spec.getInteger("model.option.offensiveLandUnitCheat");
        offensiveNavalUnitCheatPercent = spec.getInteger("model.option.offensiveNavalUnitCheat");
        transportNavalUnitCheatPercent = spec.getInteger("model.option.transportNavalUnitCheat");
    }

    protected List<AIColony> getBadlyDefended() {
        return this.badlyDefended;
    }

    public void cacheNations() {
        this.nationMap.clear();
        for (Player p : this.getGame().getLiveEuropeanPlayers(null)) {
            NationSummary ns = AIMessage.askGetNationSummary(this, p);
            this.nationMap.put(p, ns);
        }
    }

    private void initializeMissions(LogBuilder lb) {
        Mission m;
        AIMain aiMain = this.getAIMain();
        List<AIUnit> aiUnits = this.getAIUnits();
        lb.add("\n  Initialize ");
        Map map = this.getGame().getMap();
        int maxRange = map.getWidth() + map.getHeight();
        for (AIUnit aiCarrier : aiUnits) {
            AIUnit aiu;
            Unit carrier;
            if (aiCarrier.hasMission() || !(carrier = aiCarrier.getUnit()).isNaval()) continue;
            Location target = null;
            for (Unit u : carrier.getUnitList()) {
                aiu = aiMain.getAIUnit(u);
                for (int range = 5; range < maxRange && (target = BuildColonyMission.findTarget(aiu, range, false)) == null; range += 5) {
                }
                if (target == null) {
                    throw new RuntimeException("Initial colony fail!");
                }
                m = this.getBuildColonyMission(aiu, target);
                if (m == null) continue;
                lb.add(m, ", ");
            }
            TransportMission tm = (TransportMission)this.getTransportMission(aiCarrier);
            if (tm == null) continue;
            lb.add(tm);
            for (Unit u : carrier.getUnitList()) {
                aiu = this.getAIMain().getAIUnit(u);
                if (aiu == null) continue;
                tm.queueTransportable(aiu, false, lb);
            }
        }
        lb.mark();
        for (AIUnit aiu : aiUnits) {
            if (aiu.hasMission() || (m = this.getSimpleMission(aiu)) == null) continue;
            lb.add(m, ", ");
        }
        if (lb.grew("\n  Backup: ")) {
            lb.shrink(", ");
        }
    }

    public void cheatGold(int amount, LogBuilder lb) {
        Player player = this.getPlayer();
        int gold = player.getGold();
        if (gold < amount) {
            player.modifyGold(amount -= gold);
            lb.add("added ", amount, " gold");
        }
        player.logCheat(amount + " gold");
    }

    private void cheat(LogBuilder lb) {
        int nCarrier;
        AIMain aiMain = this.getAIMain();
        if (!aiMain.getFreeColServer().isSinglePlayer()) {
            return;
        }
        Player player = this.getPlayer();
        if (player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return;
        }
        lb.mark();
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        Market market = player.getMarket();
        Europe europe = player.getEurope();
        Random air = this.getAIRandom();
        ArrayList<GoodsType> arrears = new ArrayList<GoodsType>();
        if (market != null) {
            for (GoodsType gt : spec.getGoodsTypeList()) {
                if (market.getArrears(gt) <= 0) continue;
                arrears.add(gt);
            }
        }
        int nCheats = arrears.size() + 6;
        int[] randoms = RandomUtils.randomInts(logger, "cheats", air, 100, nCheats);
        int cheatIndex = 0;
        block1: for (GoodsType goodsType : arrears) {
            if (randoms[cheatIndex++] >= liftBoycottCheatPercent) continue;
            market.setArrears(goodsType, 0);
            for (Colony c : player.getColonies()) {
                for (Modifier m : c.getModifiers()) {
                    if (Specification.COLONY_GOODS_PARTY_SOURCE != m.getSource()) continue;
                    c.removeModifier(m);
                    lb.add("lift-boycott at ", c, ", ");
                    player.logCheat("lift boycott at " + c.getName());
                    continue block1;
                }
            }
        }
        if (!europe.isEmpty() && this.scoutsNeeded() > 0 && randoms[cheatIndex++] < equipScoutCheatPercent) {
            for (Unit u : europe.getUnitList()) {
                if (!u.hasDefaultRole() || !u.hasAbility("model.ability.canBeEquipped")) continue;
                this.cheatGold(europe.priceGoods(u.getGoodsDifference(scoutRole, 1)), lb);
                if (!this.getAIUnit(u).equipForRole(spec.getRoleWithAbility("model.ability.speakWithChief", null))) break;
                lb.add(" to equip scout ", u, ", ");
                player.logCheat("Equip scout " + u.toShortString());
                break;
            }
        }
        if (!europe.isEmpty() && this.pioneersNeeded() > 0 && randoms[cheatIndex++] < equipPioneerCheatPercent) {
            for (Unit u : europe.getUnitList()) {
                if (!u.hasDefaultRole() || !u.hasAbility("model.ability.canBeEquipped")) continue;
                this.cheatGold(europe.priceGoods(u.getGoodsDifference(pioneerRole, 1)), lb);
                if (!this.getAIUnit(u).equipForRole(spec.getRoleWithAbility("model.ability.improveTerrain", null))) break;
                lb.add(" to equip pioneer ", u, ", ");
                player.logCheat("Equip pioneer " + u.toShortString());
                break;
            }
        }
        if (randoms[cheatIndex++] < landUnitCheatPercent) {
            WorkerWish bestWish = null;
            int bestValue = Integer.MIN_VALUE;
            for (UnitType ut : this.workerWishes.keySet()) {
                WorkerWish ww;
                List<WorkerWish> wl = this.workerWishes.get(ut);
                if (wl == null || wl.isEmpty() || ut == null || !ut.isAvailableTo(player) || europe.getUnitPrice(ut) == Integer.MIN_VALUE || bestValue >= (ww = wl.get(0)).getValue()) continue;
                bestValue = ww.getValue();
                bestWish = ww;
            }
            int cost = bestWish != null ? europe.getUnitPrice(bestWish.getUnitType()) : (player.getImmigration() < player.getImmigrationRequired() / 2 ? player.getRecruitPrice() : Integer.MAX_VALUE);
            if (cost != Integer.MAX_VALUE) {
                Object aiu;
                this.cheatGold(cost, lb);
                if (bestWish == null) {
                    aiu = this.recruitAIUnitInEurope(-1);
                    if (aiu != null) {
                        lb.add(" to recruit ", ((AIUnit)aiu).getUnit(), ", ");
                    }
                } else {
                    aiu = this.trainAIUnitInEurope(bestWish.getUnitType());
                    if (aiu != null) {
                        Mission m = this.getWishRealizationMission((AIUnit)aiu, bestWish);
                        if (m != null) {
                            lb.add(" to train for ", m, ", ");
                        } else {
                            lb.add(" to train ", ((AIUnit)aiu).getUnit(), ", ");
                        }
                    }
                }
                if (aiu != null) {
                    player.logCheat("Make " + ((AIUnit)aiu).getUnit());
                }
            }
        }
        if (game.getTurn().getAge() >= 2 && player.isAtWar() && randoms[cheatIndex++] < offensiveLandUnitCheatPercent) {
            List<Colony> colonies;
            Settlement target = null;
            ArrayList<Player> enemies = new ArrayList<Player>();
            ArrayList<Player> preferred = new ArrayList<Player>();
            for (Player p : game.getLivePlayers(player)) {
                if (!player.atWarWith(p)) continue;
                enemies.add(p);
                double strength = this.getStrengthRatio(p);
                if (!(strength < 1.5) || !(strength > 0.6666666666666666)) continue;
                preferred.add(p);
            }
            if (!preferred.isEmpty()) {
                enemies.clear();
                enemies.addAll(preferred);
            }
            if ((colonies = player.getColonies()).size() < 3) {
                ArrayList<Colony> targets = new ArrayList<Colony>();
                for (Player p : enemies) {
                    if (!p.isEuropean()) continue;
                    targets.addAll(p.getColonies());
                }
                double targetScore = -1.0;
                for (Colony c : targets) {
                    if (!c.isConnectedPort()) continue;
                    double score = 100000.0 / (double)c.getUnitCount();
                    Building stockade = c.getStockade();
                    double d = stockade == null ? 1.0 : (double)stockade.getLevel() + 1.5;
                    if (!(targetScore < (score /= d))) continue;
                    targetScore = score;
                    target = c;
                }
            }
            if (target == null && !colonies.isEmpty()) {
                ArrayList<AIColony> bad = new ArrayList<AIColony>(this.getBadlyDefended());
                if (bad.isEmpty()) {
                    bad.addAll(this.getAIColonies());
                }
                AIColony defend = RandomUtils.getRandomMember(logger, "AIColony to defend", bad, air);
                Tile center = defend.getColony().getTile();
                Tile t = game.getMap().searchCircle(center, GoalDeciders.getEnemySettlementGoalDecider(enemies), 30);
                if (t != null) {
                    target = t.getSettlement();
                }
            }
            if (target != null) {
                List<Unit> mercs = ((ServerPlayer)player).createUnits(player.getMonarch().getMercenaries(air), europe);
                Iterator defend = mercs.iterator();
                while (defend.hasNext()) {
                    Unit u = (Unit)defend.next();
                    AIUnit aiu = this.getAIUnit(u);
                    if (aiu == null) continue;
                    player.logCheat("Enlist " + aiu.getUnit());
                    Mission m = this.getSeekAndDestroyMission(aiu, target);
                    if (m != null) {
                        lb.add("enlisted ", m, ", ");
                        continue;
                    }
                    lb.add("enlisted ", aiu.getUnit(), ", ");
                }
            }
        }
        double naval = this.getNavalStrengthRatio();
        int nNaval = player.getUnitCount(true) == 0 ? 100 : (0.0 < naval && naval < 0.5 ? (int)(naval * (double)offensiveNavalUnitCheatPercent) : -1);
        ArrayList<RandomChoice<UnitType>> rc = new ArrayList<RandomChoice<UnitType>>();
        if (randoms[cheatIndex++] < nNaval) {
            rc.clear();
            for (UnitType unitType : spec.getUnitTypeList()) {
                if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(player) || !unitType.hasPrice() || !unitType.isOffensive()) continue;
                int weight = 100000 / europe.getUnitPrice(unitType);
                rc.add(new RandomChoice<UnitType>(unitType, weight));
            }
            this.cheatUnit(rc, "offensive-naval", lb);
        }
        int n = nCarrier = this.nNavalCarrier > 0 ? transportNavalUnitCheatPercent : -1;
        if (randoms[cheatIndex++] < nCarrier) {
            rc.clear();
            for (UnitType unitType : spec.getUnitTypeList()) {
                if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(player) || !unitType.hasPrice() || unitType.getSpace() <= 0) continue;
                int weight = 100000 / europe.getUnitPrice(unitType);
                rc.add(new RandomChoice<UnitType>(unitType, weight));
            }
            this.cheatUnit(rc, "transport-naval", lb);
        }
        if (lb.grew("\n  Cheats: ")) {
            lb.shrink(", ");
        }
    }

    private AIUnit cheatUnit(List<RandomChoice<UnitType>> rc, String what, LogBuilder lb) {
        UnitType unitToPurchase = (UnitType)RandomChoice.getWeightedRandom(logger, "Cheat which unit", rc, this.getAIRandom());
        return unitToPurchase == null ? null : this.cheatUnit(unitToPurchase, what, lb);
    }

    private AIUnit cheatUnit(UnitType unitType, String what, LogBuilder lb) {
        Player player = this.getPlayer();
        Europe europe = player.getEurope();
        int cost = europe.getUnitPrice(unitType);
        this.cheatGold(cost, lb);
        AIUnit result = this.trainAIUnitInEurope(unitType);
        lb.add(" to build ", what, " ", unitType.getSuffix(), result != null ? "" : "(failed)", ", ");
        if (result == null) {
            return null;
        }
        player.logCheat("Build " + result.getUnit());
        return result;
    }

    public void allocateTransportables(List<TransportableAIObject> transportables, List<TransportMission> missions, LogBuilder lb) {
        if (transportables.isEmpty()) {
            return;
        }
        if (missions.isEmpty()) {
            return;
        }
        lb.add("\n  Allocate Transport cargo=", transportables.size(), " carriers=", missions.size());
        LogBuilder lb2 = new LogBuilder(0);
        int i = 0;
        block0: while (i < transportables.size() && !missions.isEmpty()) {
            TransportableAIObject t = transportables.get(i);
            lb.add(" for ", t);
            Mission best = null;
            float bestValue = 0.0f;
            boolean present = false;
            for (TransportMission tm : missions) {
                float value;
                if (!tm.spaceAvailable(t)) continue;
                Cargo cargo = tm.makeCargo(t, lb2);
                if (cargo == null) {
                    transportables.remove(i);
                    continue block0;
                }
                int turns = cargo.getTurns();
                if (turns == 0) {
                    value = tm.destinationCapacity();
                    if (!present) {
                        bestValue = 0.0f;
                    }
                    present = true;
                } else {
                    float f = value = present ? -1.0f : (float)t.getTransportPriority() / (float)turns;
                }
                if (!(bestValue < value)) continue;
                bestValue = value;
                best = tm;
            }
            if (best == null) {
                lb.add(" nothing found");
            } else {
                lb.add(" ", best.getUnit(), " chosen");
                if (((TransportMission)best).queueTransportable(t, false, lb)) {
                    this.claimTransportable(t);
                    if (((TransportMission)best).destinationCapacity() <= 0) {
                        missions.remove(best);
                    }
                } else {
                    missions.remove(best);
                }
            }
            ++i;
        }
    }

    private void bringGifts(LogBuilder lb) {
    }

    private void demandTribute(LogBuilder lb) {
    }

    public void buildTipMap(LogBuilder lb) {
        this.tipMap.clear();
        for (AIColony aic : this.getAIColonies()) {
            for (TileImprovementPlan tip : aic.getTileImprovementPlans()) {
                if (tip == null || tip.isComplete()) {
                    aic.removeTileImprovementPlan(tip);
                    continue;
                }
                if (tip.getPioneer() != null) continue;
                if (!tip.validate()) {
                    aic.removeTileImprovementPlan(tip);
                    tip.dispose();
                    continue;
                }
                if (tip.getTarget() == null) {
                    logger.warning("No target for tip: " + tip);
                    continue;
                }
                TileImprovementPlan other = this.tipMap.get(tip.getTarget());
                if (other != null && other.getValue() >= tip.getValue()) continue;
                this.tipMap.put(tip.getTarget(), tip);
            }
        }
        if (!this.tipMap.isEmpty()) {
            lb.add("\n  Improvements:");
            for (Tile t : this.tipMap.keySet()) {
                TileImprovementPlan tip = this.tipMap.get(t);
                AIUnit pioneer = tip.getPioneer();
                lb.add(" ", t, "=", tip.getType().getSuffix());
                if (pioneer == null) continue;
                lb.add("/", pioneer.getUnit());
            }
        }
    }

    private void updateTipMap(AIColony aic) {
        for (TileImprovementPlan tip : aic.getTileImprovementPlans()) {
            this.tipMap.put(tip.getTarget(), tip);
        }
    }

    public TileImprovementPlan getBestPlan(Tile tile) {
        return this.tipMap == null ? null : this.tipMap.get(tile);
    }

    public Tile getBestPlanTile(Colony colony) {
        TileImprovementPlan best = null;
        int bestValue = Integer.MIN_VALUE;
        for (Tile t : colony.getOwnedTiles()) {
            TileImprovementPlan tip = this.tipMap.get(t);
            if (tip == null || tip.getValue() <= bestValue) continue;
            bestValue = tip.getValue();
            best = tip;
        }
        return best == null ? null : best.getTarget();
    }

    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        for (AIColony aic : this.getAIColonies()) {
            if (aic.removeTileImprovementPlan(plan)) break;
        }
    }

    public void updateTransport(AIUnit aiu, Location oldTarget, LogBuilder lb) {
        TransportMission tm;
        Location newTarget;
        AIUnit aiCarrier = aiu.getTransport();
        Mission newMission = aiu.getMission();
        Location location = newTarget = newMission == null ? null : newMission.getTarget();
        if (aiCarrier != null && (tm = aiCarrier.getMission(TransportMission.class)) != null && !Map.isSameLocation(oldTarget, newTarget)) {
            if (aiu.getUnit().getLocation() != aiCarrier.getUnit()) {
                lb.add(", drop transport ", aiCarrier.getUnit());
                aiu.dropTransport();
            } else if (newTarget == null) {
                tm.dumpTransportable(aiu, lb);
            } else {
                tm.requeueTransportable(aiu, lb);
            }
        }
    }

    private boolean requestsTransport(TransportableAIObject t) {
        return t.getTransport() == null && t.getTransportDestination() != null && t.getTransportSource() != null && !(t.getLocation() instanceof Unit);
    }

    private boolean checkTransport(TransportableAIObject t) {
        AIUnit aiCarrier = t.getTransport();
        if (aiCarrier == null) {
            return false;
        }
        TransportMission tm = aiCarrier.getMission(TransportMission.class);
        if (tm != null && tm.isTransporting(t)) {
            return true;
        }
        t.changeTransport(null);
        return false;
    }

    public int getNeededWagons(Tile tile) {
        Integer i;
        int contig;
        if (tile != null && (contig = tile.getContiguity()) > 0 && (i = this.wagonsNeeded.get(contig)) != null) {
            return i;
        }
        return 0;
    }

    private void changeNeedWagon(Tile tile, int amount) {
        if (tile == null) {
            return;
        }
        int contig = tile.getContiguity();
        if (contig > 0) {
            Integer i = this.wagonsNeeded.get(contig);
            if (i == null) {
                if (amount == 0) {
                    this.wagonsNeeded.put(contig, 0);
                }
            } else {
                this.wagonsNeeded.put(contig, i + amount);
            }
        }
    }

    private void buildTransportMaps(LogBuilder lb) {
        Colony colony;
        this.transportDemand.clear();
        this.transportSupply.clear();
        this.wagonsNeeded.clear();
        this.nNavalCarrier = 0;
        for (AIColony aic : this.getAIColonies()) {
            colony = aic.getColony();
            if (!colony.isConnectedPort()) continue;
            this.changeNeedWagon(colony.getTile(), 0);
        }
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.hasMission() && !aiu.getMission().isValid()) continue;
            Unit u = aiu.getUnit();
            if (u.isCarrier()) {
                if (u.isNaval()) {
                    --this.nNavalCarrier;
                    continue;
                }
                this.changeNeedWagon(u.getTile(), -1);
                continue;
            }
            this.checkTransport(aiu);
            if (!this.requestsTransport(aiu)) continue;
            this.transportSupply.add(aiu);
            aiu.incrementTransportPriority();
            ++this.nNavalCarrier;
        }
        for (AIColony aic : this.getAIColonies()) {
            for (AIGoods aig : aic.getAIGoods()) {
                Location dst;
                this.checkTransport(aig);
                if (!this.requestsTransport(aig)) continue;
                this.transportSupply.add(aig);
                aig.incrementTransportPriority();
                Location src = aig.getTransportSource();
                if (Map.isSameContiguity(src, dst = aig.getTransportDestination())) continue;
                ++this.nNavalCarrier;
            }
            colony = aic.getColony();
            if (colony.isConnectedPort()) continue;
            this.changeNeedWagon(colony.getTile(), 1);
        }
        for (Wish w : this.getWishes()) {
            TransportableAIObject t = w.getTransportable();
            if (t == null || t.getTransport() != null || t.getTransportDestination() == null) continue;
            Location loc = EuropeanAIPlayer.upLoc(t.getTransportDestination());
            CollectionUtils.appendToMapList(this.transportDemand, loc, w);
        }
        if (!this.transportSupply.isEmpty()) {
            lb.add("\n  Transport Supply:");
            for (TransportableAIObject t : this.transportSupply) {
                lb.add(" ", t.getTransportPriority(), "+", t);
            }
        }
        if (!this.transportDemand.isEmpty()) {
            lb.add("\n  Transport Demand:");
            for (Location ld : this.transportDemand.keySet()) {
                lb.add("\n    ", ld, "[");
                for (Wish w : this.transportDemand.get(ld)) {
                    lb.add(" ", w);
                }
                lb.add(" ]");
            }
        }
    }

    public List<TransportableAIObject> getUrgentTransportables() {
        ArrayList<TransportableAIObject> urgent = new ArrayList<TransportableAIObject>(this.transportSupply);
        Collections.sort(urgent);
        int urge = urgent.size();
        urge = Math.max(2, (urge + 5) / 10);
        while (urgent.size() > urge) {
            urgent.remove(urge);
        }
        return urgent;
    }

    public boolean claimTransportable(TransportableAIObject t) {
        return this.transportSupply.remove(t);
    }

    private Collection<AIUnit> rearrangeColonies(LogBuilder lb) {
        HashSet<AIUnit> workers = new HashSet<AIUnit>();
        for (AIColony aic : this.getAIColonies()) {
            workers.addAll(aic.rearrangeWorkers(lb));
        }
        return workers;
    }

    public List<WorkerWish> getWorkerWishesAt(Location loc, UnitType type) {
        List<Wish> demand = this.transportDemand.get(EuropeanAIPlayer.upLoc(loc));
        if (demand == null) {
            return Collections.emptyList();
        }
        ArrayList<WorkerWish> result = new ArrayList<WorkerWish>();
        for (Wish w : demand) {
            if (!(w instanceof WorkerWish) || ((WorkerWish)w).getUnitType() != type) continue;
            result.add((WorkerWish)w);
        }
        return result;
    }

    public List<GoodsWish> getGoodsWishesAt(Location loc, GoodsType type) {
        List<Wish> demand = this.transportDemand.get(EuropeanAIPlayer.upLoc(loc));
        if (demand == null) {
            return Collections.emptyList();
        }
        ArrayList<GoodsWish> result = new ArrayList<GoodsWish>();
        for (Wish w : demand) {
            if (!(w instanceof GoodsWish) || ((GoodsWish)w).getGoodsType() != type) continue;
            result.add((GoodsWish)w);
        }
        return result;
    }

    public WorkerWish getBestWorkerWish(AIUnit aiUnit, UnitType unitType) {
        List<WorkerWish> wishes = this.workerWishes.get(unitType);
        if (wishes == null) {
            return null;
        }
        Unit carrier = aiUnit.getUnit();
        WorkerWish nonTransported = null;
        WorkerWish transported = null;
        float bestNonTransportedValue = -1.0f;
        float bestTransportedValue = -1.0f;
        for (WorkerWish w : wishes) {
            int turns;
            try {
                turns = carrier.getTurnsToReach(w.getDestination());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Bogus wish destination for " + aiUnit + ": " + w.getDestination() + " for wish: " + w, e);
                continue;
            }
            if (turns == Integer.MAX_VALUE) {
                if (!(bestTransportedValue < (float)w.getValue())) continue;
                bestTransportedValue = w.getValue();
                transported = w;
                continue;
            }
            if (!(bestNonTransportedValue < (float)w.getValue() / (float)turns)) continue;
            bestNonTransportedValue = (float)w.getValue() / (float)turns;
            nonTransported = w;
        }
        return nonTransported != null ? nonTransported : (transported != null ? transported : null);
    }

    public GoodsWish getBestGoodsWish(AIUnit aiUnit, GoodsType goodsType) {
        List<GoodsWish> wishes = this.goodsWishes.get(goodsType);
        if (wishes == null) {
            return null;
        }
        Unit carrier = aiUnit.getUnit();
        float bestValue = 0.0f;
        GoodsWish best = null;
        for (GoodsWish w : wishes) {
            float value;
            int turns = carrier.getTurnsToReach(carrier.getLocation(), w.getDestination());
            if (turns == Integer.MAX_VALUE || !(bestValue > (value = (float)w.getValue() / (float)turns))) continue;
            bestValue = value;
            best = w;
        }
        return best;
    }

    private void buildWishMaps(LogBuilder lb) {
        List<GoodsWish> gl;
        List<WorkerWish> wl;
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            wl = this.workerWishes.get(unitType);
            if (wl == null) {
                this.workerWishes.put(unitType, new ArrayList());
                continue;
            }
            wl.clear();
        }
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            gl = this.goodsWishes.get(goodsType);
            if (gl == null) {
                this.goodsWishes.put(goodsType, new ArrayList());
                continue;
            }
            gl.clear();
        }
        for (Wish w : this.getWishes()) {
            GoodsWish gw;
            if (w instanceof WorkerWish) {
                WorkerWish ww = (WorkerWish)w;
                if (ww.getTransportable() != null) continue;
                CollectionUtils.appendToMapList(this.workerWishes, ww.getUnitType(), ww);
                continue;
            }
            if (!(w instanceof GoodsWish) || !((gw = (GoodsWish)w).getDestination() instanceof Colony)) continue;
            CollectionUtils.appendToMapList(this.goodsWishes, gw.getGoodsType(), gw);
        }
        if (!this.workerWishes.isEmpty()) {
            lb.add("\n  Wishes (workers):");
            for (UnitType ut : this.workerWishes.keySet()) {
                wl = this.workerWishes.get(ut);
                if (wl.isEmpty()) continue;
                lb.add("\n    ", ut.getSuffix(), ":");
                for (WorkerWish ww : wl) {
                    lb.add(" ", ww.getDestination(), "(", ww.getValue(), ")");
                }
            }
        }
        if (!this.goodsWishes.isEmpty()) {
            lb.add("\n  Wishes (goods):");
            for (GoodsType gt : this.goodsWishes.keySet()) {
                gl = this.goodsWishes.get(gt);
                if (gl.isEmpty()) continue;
                lb.add("\n    ", gt.getSuffix(), ":");
                for (GoodsWish gw : gl) {
                    lb.add(" ", gw.getDestination(), "(", gw.getValue(), ")");
                }
            }
        }
    }

    public void completeWish(Wish w) {
        if (w instanceof WorkerWish) {
            WorkerWish ww = (WorkerWish)w;
            List<WorkerWish> wl = this.workerWishes.get(ww.getUnitType());
            if (wl != null) {
                wl.remove(ww);
            }
        } else if (w instanceof GoodsWish) {
            GoodsWish gw = (GoodsWish)w;
            List<GoodsWish> gl = this.goodsWishes.get(gw.getGoodsType());
            if (gl != null) {
                gl.remove(gw);
            }
        } else {
            throw new IllegalStateException("Bogus wish: " + w);
        }
    }

    public void consumeWorkerWish(AIUnit aiUnit, WorkerWish ww) {
        Unit unit = aiUnit.getUnit();
        List<WorkerWish> wwL = this.workerWishes.get(unit.getType());
        wwL.remove(ww);
        List<Wish> wl = this.transportDemand.get(ww.getDestination());
        if (wl != null) {
            wl.remove(ww);
        }
        ww.setTransportable(aiUnit);
    }

    public void consumeGoodsWish(AIGoods aig, GoodsWish gw) {
        Goods goods = aig.getGoods();
        List<GoodsWish> gwL = this.goodsWishes.get(goods.getType());
        gwL.remove(gw);
        List<Wish> wl = this.transportDemand.get(gw.getDestination());
        if (wl != null) {
            wl.remove(gw);
        }
        gw.setTransportable(aig);
    }

    public int buildersNeeded() {
        Player player = this.getPlayer();
        if (!player.canBuildColonies()) {
            return 0;
        }
        int nColonies = 0;
        int nPorts = 0;
        int nWorkers = 0;
        int nEuropean = 0;
        for (Settlement settlement : player.getSettlements()) {
            ++nColonies;
            if (settlement.isConnectedPort()) {
                ++nPorts;
            }
            for (Unit u : settlement.getUnitList()) {
                if (!u.isPerson()) continue;
                ++nWorkers;
            }
            for (Unit u : settlement.getTile().getUnitList()) {
                if (!u.isPerson()) continue;
                ++nWorkers;
            }
        }
        Europe europe = player.getEurope();
        if (europe != null) {
            for (Unit u : europe.getUnitList()) {
                if (!u.isPerson()) continue;
                ++nEuropean;
            }
        }
        return nColonies == 0 || nPorts == 0 ? 2 : (nPorts <= 1 && nWorkers + nEuropean >= 3 ? 1 : ((double)(nWorkers + nEuropean) / (double)nColonies > Math.E ? 1 : 0));
    }

    public int pioneersNeeded() {
        return (this.tipMap.size() + 1) / 2;
    }

    public int scoutsNeeded() {
        return this.getGame().getTurn().getAge() <= 1 ? 3 : 1;
    }

    public AIUnit recruitAIUnitInEurope(int slot) {
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        if (europe == null) {
            return null;
        }
        int n = europe.getUnitCount();
        String selectAbility = "model.ability.selectRecruit";
        if (!Europe.MigrationType.validMigrantSlot(slot)) {
            int n2 = slot = this.getPlayer().hasAbility("model.ability.selectRecruit") ? Europe.MigrationType.getDefaultSlot() : Europe.MigrationType.getUnspecificSlot();
        }
        if (AIMessage.askEmigrate(this, slot) && europe.getUnitCount() == n + 1 && (aiUnit = this.getAIUnit(europe.getUnitList().get(n))) != null) {
            this.addAIUnit(aiUnit);
        }
        return aiUnit;
    }

    public AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Invalid UnitType.");
        }
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        if (europe == null) {
            return null;
        }
        int n = europe.getUnitCount();
        if (AIMessage.askTrainUnitInEurope(this, unitType) && europe.getUnitCount() == n + 1 && (aiUnit = this.getAIUnit(europe.getUnitList().get(n))) != null) {
            this.addAIUnit(aiUnit);
        }
        return aiUnit;
    }

    public List<Wish> getWishes() {
        ArrayList<Wish> wishes = new ArrayList<Wish>();
        for (AIColony aic : this.getAIColonies()) {
            wishes.addAll(aic.getWishes());
        }
        Collections.sort(wishes);
        return wishes;
    }

    private void determineStances(LogBuilder lb) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getPlayer();
        lb.mark();
        for (Player p : this.getGame().getLivePlayers(serverPlayer)) {
            Player.Stance newStance = this.determineStance(p);
            if (newStance == serverPlayer.getStance(p) || newStance == Player.Stance.WAR && this.peaceHolds(p)) continue;
            this.getAIMain().getFreeColServer().getInGameController().changeStance(serverPlayer, newStance, (ServerPlayer)p, true);
            lb.add(new Object[]{" ", p.getDebugName(), "->", newStance, ", "});
        }
        if (lb.grew("\n  Stance changes:")) {
            lb.shrink(", ");
        }
    }

    private boolean peaceHolds(Player p) {
        Player player = this.getPlayer();
        Turn turn = this.getGame().getTurn();
        double peaceProb = (double)this.getSpecification().getInteger("model.option.peaceProbability") / 100.0;
        int peaceTurn = -1;
        for (HistoryEvent h : player.getHistory()) {
            if (!p.getId().equals(h.getPlayerId()) || h.getTurn().getNumber() <= peaceTurn) continue;
            switch (h.getEventType()) {
                case MAKE_PEACE: 
                case FORM_ALLIANCE: {
                    peaceTurn = h.getTurn().getNumber();
                    break;
                }
                case DECLARE_WAR: {
                    peaceTurn = -1;
                    break;
                }
            }
        }
        if (peaceTurn < 0) {
            return false;
        }
        int n = turn.getNumber() - peaceTurn;
        float prob = (float)Math.pow(peaceProb, n);
        return (prob = p.applyModifiers(prob, turn, "model.modifier.peaceTreaty")) > 0.0f && RandomUtils.randomInt(logger, "Peace holds?", this.getAIRandom(), 100) < (int)(100.0f * prob);
    }

    protected double getStrengthRatio(Player other) {
        NationSummary ns = this.nationMap.get(other);
        int strength = this.getPlayer().calculateStrength(false);
        return ns == null ? -1.0 : (double)strength / (double)(strength + ns.getMilitaryStrength());
    }

    protected double getNavalStrengthRatio() {
        Player player = this.getPlayer();
        double navalAverage = 0.0;
        double navalStrength = 0.0;
        int nPlayers = 0;
        for (Map.Entry<Player, NationSummary> e : this.nationMap.entrySet()) {
            Player p = e.getKey();
            if (p.isREF()) continue;
            if (p == player) {
                navalStrength = e.getValue().getNavalStrength();
                continue;
            }
            int ns = e.getValue().getNavalStrength();
            if (ns >= 0) {
                navalAverage += (double)ns;
            }
            ++nPlayers;
        }
        if (nPlayers <= 0 || navalStrength < 0.0) {
            return -1.0;
        }
        return (navalAverage /= (double)nPlayers) == 0.0 ? -1.0 : navalStrength / navalAverage;
    }

    private int evaluateColony(Colony colony) {
        if (colony == null) {
            return 0;
        }
        Player player = this.getPlayer();
        int result = 0;
        if (player.owns(colony)) {
            for (WorkLocation wl : colony.getAvailableWorkLocations()) {
                for (Unit u : wl.getUnitList()) {
                    result += this.evaluateUnit(u);
                }
                if (wl instanceof Building) {
                    for (AbstractGoods ag : ((Building)wl).getType().getRequiredGoods()) {
                        result += this.evaluateGoods(ag);
                    }
                    continue;
                }
                if (!(wl instanceof ColonyTile)) continue;
                for (AbstractGoods ag : wl.getProductionInfo().getProduction()) {
                    result += this.evaluateGoods(ag);
                }
            }
            for (Unit u : colony.getTile().getUnitList()) {
                result += this.evaluateUnit(u);
            }
            for (Goods g : colony.getCompactGoods()) {
                result += this.evaluateGoods(g);
            }
        } else {
            result += colony.getDisplayUnitCount() * 1000;
            result += 500;
            for (Tile t : colony.getTile().getSurroundingTiles(1)) {
                if (t.getOwningSettlement() != colony) continue;
                result += 200;
            }
            Building stockade = colony.getStockade();
            if (stockade != null) {
                result *= stockade.getLevel();
            }
        }
        return result;
    }

    private int evaluateUnit(Unit unit) {
        Europe europe = this.getPlayer().getEurope();
        return europe == null ? 0 : europe.getUnitPrice(unit.getType());
    }

    private int evaluateGoods(AbstractGoods ag) {
        Market market = this.getPlayer().getMarket();
        return market == null ? 0 : market.getSalePrice(ag.getType(), ag.getAmount());
    }

    private DiplomaticTrade.TradeStatus rejectAgreement(TradeItem stance, DiplomaticTrade agreement) {
        if (stance == null) {
            return DiplomaticTrade.TradeStatus.REJECT_TRADE;
        }
        agreement.clear();
        agreement.add(stance);
        return DiplomaticTrade.TradeStatus.PROPOSE_TRADE;
    }

    protected void giveNormalMissions(LogBuilder lb) {
        Location oldTarget;
        Mission m;
        Unit unit;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        HashMap<Unit, String> reasons = new HashMap<Unit, String>();
        BuildColonyMission bcm = null;
        this.nBuilders = this.buildersNeeded();
        this.nPioneers = this.pioneersNeeded();
        this.nScouts = this.scoutsNeeded();
        List<AIUnit> aiUnits = this.getAIUnits();
        ArrayList<AIUnit> navalUnits = new ArrayList<AIUnit>();
        ArrayList<AIUnit> done = new ArrayList<AIUnit>();
        ArrayList<TransportMission> transportMissions = new ArrayList<TransportMission>();
        lb.mark();
        for (AIUnit aIUnit : aiUnits) {
            Location oldTarget3;
            unit = aIUnit.getUnit();
            Colony colony = unit.getColony();
            m = aIUnit.getMission();
            Location location = oldTarget3 = m == null ? null : m.getTarget();
            if (unit.isUninitialized() || unit.isDisposed()) {
                reasons.put(unit, "Invalid");
            } else if (unit.isDamaged()) {
                if (!(m instanceof IdleAtSettlementMission) && (m = this.getIdleAtSettlementMission(aIUnit)) != null) {
                    lb.add(", ", m);
                }
                reasons.put(unit, "Damaged");
            } else if (unit.getState() == Unit.UnitState.IN_COLONY && colony.getUnitCount() <= 1) {
                if (!(m instanceof WorkInsideColonyMission) && (m = this.getWorkInsideColonyMission(aIUnit, aiMain.getAIColony(colony))) != null) {
                    logger.warning(aIUnit + " should WorkInsideColony at " + colony.getName());
                    lb.add(", ", m);
                    this.updateTransport(aIUnit, oldTarget3, lb);
                }
                reasons.put(unit, "Vital");
            } else if (unit.isInMission()) {
                reasons.put(unit, "Mission");
            } else if (m != null && m.isValid() && !m.isOneTime()) {
                if (m instanceof BuildColonyMission) {
                    bcm = (BuildColonyMission)m;
                    --this.nBuilders;
                } else if (m instanceof PioneeringMission) {
                    --this.nPioneers;
                } else if (m instanceof ScoutingMission) {
                    --this.nScouts;
                } else if (m instanceof TransportMission) {
                    TransportMission tm = (TransportMission)m;
                    if (tm.isEmpty() && unit.isNaval() && unit.isOffensiveUnit()) {
                        navalUnits.add(aIUnit);
                        done.add(aIUnit);
                        continue;
                    }
                    if (tm.destinationCapacity() > 0) {
                        transportMissions.add(tm);
                    }
                } else if (m instanceof PrivateerMission && !(m.getTarget() instanceof Unit)) {
                    navalUnits.add(aIUnit);
                    done.add(aIUnit);
                    continue;
                }
                reasons.put(unit, "Valid");
            } else if (unit.isNaval()) {
                navalUnits.add(aIUnit);
            } else {
                if (!unit.isAtSea()) continue;
                reasons.put(unit, "At-Sea");
            }
            done.add(aIUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        if (player.getNumberOfSettlements() <= 0 && bcm != null) {
            Iterator<AIUnit> bcmTarget = bcm.getTarget();
            Collections.sort(aiUnits, builderComparator);
            for (AIUnit aiUnit : aiUnits) {
                m = aiUnit.getMission();
                Location location = m == null ? null : m.getTarget();
                m = this.getBuildColonyMission(aiUnit, (Location)((Object)bcmTarget));
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aiUnit, location, lb);
                done.add(aiUnit);
                if (this.requestsTransport(aiUnit)) {
                    this.transportSupply.add(aiUnit);
                }
                reasons.put(aiUnit.getUnit(), "0Builder");
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        if (this.nBuilders > 0) {
            Collections.sort(aiUnits, builderComparator);
            for (AIUnit aIUnit : aiUnits) {
                m = aIUnit.getMission();
                oldTarget = m == null ? null : m.getTarget();
                m = this.getBuildColonyMission(aIUnit, null);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, oldTarget, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(aIUnit.getUnit(), "Builder" + this.nBuilders);
                if (--this.nBuilders > 0) continue;
                break;
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        if (this.nScouts > 0) {
            Collections.sort(aiUnits, scoutComparator);
            for (AIUnit aIUnit : aiUnits) {
                m = aIUnit.getMission();
                oldTarget = m == null ? null : m.getTarget();
                Unit unit2 = aIUnit.getUnit();
                m = this.getScoutingMission(aIUnit);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, oldTarget, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(unit2, "Scout" + this.nScouts);
                if (--this.nScouts > 0) continue;
                break;
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        if (this.nPioneers > 0) {
            Collections.sort(aiUnits, pioneerComparator);
            for (AIUnit aIUnit : aiUnits) {
                unit = aIUnit.getUnit();
                m = aIUnit.getMission();
                Location location = m == null ? null : m.getTarget();
                m = this.getPioneeringMission(aIUnit, null);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, location, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(unit, "Pioneer" + this.nPioneers);
                if (--this.nPioneers > 0) continue;
                break;
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        for (AIUnit aIUnit : aiUnits) {
            unit = aIUnit.getUnit();
            m = aIUnit.getMission();
            Location location = m == null ? null : m.getTarget();
            m = this.getSimpleMission(aIUnit);
            if (m == null) continue;
            lb.add(", ", m);
            this.updateTransport(aIUnit, location, lb);
            reasons.put(unit, "New-Land");
            done.add(aIUnit);
            if (!this.requestsTransport(aIUnit)) continue;
            this.transportSupply.add(aIUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        for (AIUnit aIUnit : navalUnits) {
            unit = aIUnit.getUnit();
            m = aIUnit.getMission();
            Mission mission = m != null && m.isValid() ? m : null;
            m = this.getSimpleMission(aIUnit);
            if (m == null) continue;
            lb.add(", ", m, m == mission ? " (preserved)" : " (new)");
            reasons.put(unit, "New-Naval");
            done.add(aIUnit);
            if (!(m instanceof TransportMission)) continue;
            TransportMission tm = (TransportMission)m;
            if (tm.destinationCapacity() > 0) {
                transportMissions.add(tm);
            }
            for (Unit u : aIUnit.getUnit().getUnitList()) {
                AIUnit aiu = this.getAIUnit(u);
                Mission um = aiu.getMission();
                if (um == null || !um.isValid() || !aiUnits.contains(aiu)) continue;
                aiUnits.remove(aiu);
                reasons.put(aiu.getUnit(), "TNew");
            }
        }
        navalUnits.removeAll(done);
        done.clear();
        aiUnits.addAll(navalUnits);
        List<Colony> ports = null;
        int n = player.getNumberOfPorts();
        for (AIUnit aIUnit : aiUnits) {
            Location oldTarget4;
            Unit unit3 = aIUnit.getUnit();
            m = aIUnit.getMission();
            Location location = oldTarget4 = m == null ? null : m.getTarget();
            if (m != null && m.isValid() && !m.isOneTime()) {
                logger.warning("Trying fallback mission for unit " + unit3 + " with valid mission " + m + " reason " + (String)reasons.get(unit3));
                continue;
            }
            if (unit3.isInEurope() && unit3.isPerson() && n > 0) {
                Colony c;
                AIColony aic;
                if (ports == null) {
                    ports = player.getPorts();
                }
                if ((m = this.getWorkInsideColonyMission(aIUnit, aic = aiMain.getAIColony(c = ports.remove(0)))) == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, oldTarget4, lb);
                reasons.put(unit3, "To-work");
                ports.add(c);
                continue;
            }
            if (m instanceof IdleAtSettlementMission) {
                reasons.put(unit3, "Idle");
                continue;
            }
            m = this.getIdleAtSettlementMission(aIUnit);
            if (m == null) continue;
            lb.add(", ", m);
            this.updateTransport(aIUnit, oldTarget4, lb);
            reasons.put(unit3, "Idle");
        }
        lb.grew("\n  Mission changes");
        this.allocateTransportables(this.getUrgentTransportables(), transportMissions, lb);
        if (!aiUnits.isEmpty()) {
            lb.add("\n  Free Land Units:");
            for (AIUnit aIUnit : aiUnits) {
                lb.add(" ", aIUnit.getUnit());
            }
        }
        if (!navalUnits.isEmpty()) {
            lb.add("\n  Free Naval Units:");
            for (AIUnit aIUnit : navalUnits) {
                lb.add(" ", aIUnit.getUnit());
            }
        }
        lb.add("\n  Missions(colonies=", player.getNumberOfSettlements(), " builders=", this.nBuilders, " pioneers=", this.nPioneers, " scouts=", this.nScouts, " naval-carriers=", this.nNavalCarrier, ")");
        this.logMissions(reasons, lb);
    }

    public Mission getSimpleMission(AIUnit aiUnit) {
        Mission old;
        Unit unit = aiUnit.getUnit();
        Mission m = aiUnit.getMission();
        Mission mission = old = m != null && m.isValid() ? m : null;
        Mission ret = unit.isNaval() ? (old instanceof PrivateerMission ? old : ((m = this.getPrivateerMission(aiUnit, null)) != null ? m : (old instanceof TransportMission ? old : ((m = this.getTransportMission(aiUnit)) != null ? m : (old instanceof UnitSeekAndDestroyMission ? old : ((m = this.getSeekAndDestroyMission(aiUnit, 8)) != null ? m : (old instanceof UnitWanderHostileMission ? old : this.getWanderHostileMission(aiUnit)))))))) : (unit.isCarrier() ? this.getTransportMission(aiUnit) : (old instanceof CashInTreasureTrainMission ? old : ((m = this.getCashInTreasureTrainMission(aiUnit)) != null ? m : (unit.isInColony() && old instanceof WorkInsideColonyMission ? old : (unit.isInColony() && (m = this.getWorkInsideColonyMission(aiUnit, null)) != null ? m : (old instanceof DefendSettlementMission ? old : ((m = this.getDefendCurrentSettlementMission(aiUnit)) != null ? m : (unit.hasAbility("model.ability.refUnit") ? (old instanceof UnitSeekAndDestroyMission ? old : ((m = this.getSeekAndDestroyMission(aiUnit, 12)) != null ? m : (m = this.getWanderHostileMission(aiUnit)))) : (unit.isColonist() && unit.getSkillLevel() > 0 && old instanceof WishRealizationMission ? old : (unit.isColonist() && unit.getSkillLevel() > 0 && (m = this.getWishRealizationMission(aiUnit, null)) != null ? m : ((m = this.getDefendSettlementMission(aiUnit, false)) != null ? m : (old instanceof UnitSeekAndDestroyMission ? old : ((m = this.getSeekAndDestroyMission(aiUnit, 8)) != null ? m : (old instanceof MissionaryMission ? old : ((m = this.getMissionaryMission(aiUnit)) != null ? m : (old instanceof WishRealizationMission ? old : ((m = this.getWishRealizationMission(aiUnit, null)) != null ? m : ((m = this.getDefendSettlementMission(aiUnit, true)) != null ? m : ((m = this.getSeekAndDestroyMission(aiUnit, 16)) != null ? m : (old instanceof UnitWanderHostileMission ? old : ((m = this.getWanderHostileMission(aiUnit)) != null ? m : null)))))))))))))))))))));
        return ret;
    }

    public Mission getBuildColonyMission(AIUnit aiUnit, Location target) {
        String reason = BuildColonyMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        if (target == null) {
            target = BuildColonyMission.findTarget(aiUnit, 5, unit.isInEurope());
        }
        return target == null ? null : new BuildColonyMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getCashInTreasureTrainMission(AIUnit aiUnit) {
        String reason = CashInTreasureTrainMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = CashInTreasureTrainMission.findTarget(aiUnit, 20, unit.isInEurope());
        return loc == null ? null : new CashInTreasureTrainMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getDefendSettlementMission(AIUnit aiUnit, boolean relaxed) {
        if (DefendSettlementMission.invalidReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = unit.getLocation();
        double worstValue = 1000000.0;
        Colony worstColony = null;
        for (AIColony aic : this.getAIColonies()) {
            double value;
            Colony colony = aic.getColony();
            if (!aic.isBadlyDefended()) continue;
            if (unit.isAtLocation(colony.getTile())) {
                worstColony = colony;
                break;
            }
            int ttr = 1 + unit.getTurnsToReach(loc, colony.getTile(), unit.getCarrier(), relaxed ? CostDeciders.numberOfTiles() : null);
            if (ttr < 0 || !(worstValue > (value = (double)colony.getDefenceRatio() * 100.0 / (double)ttr))) continue;
            worstValue = value;
            worstColony = colony;
        }
        return worstColony == null ? null : this.getDefendSettlementMission(aiUnit, worstColony);
    }

    public Mission getMissionaryMission(AIUnit aiUnit) {
        if (MissionaryMission.prepare(aiUnit) != null) {
            return null;
        }
        Location loc = MissionaryMission.findTarget(aiUnit, 20, true);
        if (loc == null) {
            aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            return null;
        }
        return new MissionaryMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getPioneeringMission(AIUnit aiUnit, Location target) {
        if (PioneeringMission.prepare(aiUnit) != null) {
            return null;
        }
        if (target == null) {
            target = PioneeringMission.findTarget(aiUnit, 10, true);
        }
        if (target == null) {
            Unit unit = aiUnit.getUnit();
            if (unit.isInEurope() || unit.getSettlement() != null) {
                aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            }
            return null;
        }
        return new PioneeringMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getPrivateerMission(AIUnit aiUnit, Location target) {
        if (PrivateerMission.invalidReason(aiUnit) != null) {
            return null;
        }
        if (target == null) {
            target = PrivateerMission.findTarget(aiUnit, 1, true);
        }
        return target == null ? null : new PrivateerMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getScoutingMission(AIUnit aiUnit) {
        if (ScoutingMission.prepare(aiUnit) != null) {
            return null;
        }
        Location loc = ScoutingMission.findTarget(aiUnit, 20, true);
        if (loc == null) {
            Unit unit = aiUnit.getUnit();
            if (unit.isInEurope() || unit.getSettlement() != null) {
                aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            }
            return null;
        }
        return new ScoutingMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getTransportMission(AIUnit aiUnit) {
        if (TransportMission.invalidReason(aiUnit) != null) {
            return null;
        }
        return new TransportMission(this.getAIMain(), aiUnit);
    }

    public Mission getWishRealizationMission(AIUnit aiUnit, WorkerWish wish) {
        if (WishRealizationMission.invalidReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        if (wish == null) {
            wish = this.getBestWorkerWish(aiUnit, unit.getType());
        }
        if (wish == null) {
            return null;
        }
        this.consumeWorkerWish(aiUnit, wish);
        return new WishRealizationMission(this.getAIMain(), aiUnit, wish);
    }

    public Mission getWorkInsideColonyMission(AIUnit aiUnit, AIColony aiColony) {
        if (WorkInsideColonyMission.invalidReason(aiUnit) != null) {
            return null;
        }
        if (aiColony == null) {
            aiColony = this.getAIColony(aiUnit.getUnit().getColony());
        }
        return aiColony == null ? null : new WorkInsideColonyMission(this.getAIMain(), aiUnit, aiColony);
    }

    @Override
    protected Player.Stance determineStance(Player other) {
        Player player = this.getPlayer();
        return other.isREF() ? (player.getREFPlayer() == other ? (player.isRebel() ? Player.Stance.WAR : Player.Stance.PEACE) : (!other.getRebels().isEmpty() ? Player.Stance.PEACE : super.determineStance(other))) : super.determineStance(other);
    }

    @Override
    public void removeAIColony(AIColony aic) {
        Colony colony = aic.getColony();
        HashSet<TileImprovementPlan> tips = new HashSet<TileImprovementPlan>();
        for (Tile t : colony.getOwnedTiles()) {
            TileImprovementPlan tip = this.tipMap.remove(t);
            if (tip == null) continue;
            tips.add(tip);
        }
        for (AIGoods aig : aic.getAIGoods()) {
            if (!Map.isSameLocation(aig.getLocation(), colony)) continue;
            aig.changeTransport(null);
            aig.dispose();
        }
        this.transportDemand.remove(colony);
        HashSet<Wish> wishes = new HashSet<Wish>(aic.getWishes());
        for (AIUnit aiu : this.getAIUnits()) {
            PioneeringMission pm = aiu.getMission(PioneeringMission.class);
            if (pm != null) {
                if (!tips.contains(pm.getTileImprovementPlan())) continue;
                logger.info(pm + " collapses with loss of " + colony);
                aiu.changeMission(null);
                continue;
            }
            WishRealizationMission wm = aiu.getMission(WishRealizationMission.class);
            if (wm == null || !wishes.contains(wm.getWish())) continue;
            logger.info(wm + " collapses with loss of " + colony);
            aiu.changeMission(null);
        }
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        Turn turn = this.getGame().getTurn();
        Specification spec = this.getSpecification();
        EuropeanAIPlayer.initializeFromSpecification(spec);
        if (this.getAIMain().getAIPlayer(player) != this) {
            throw new RuntimeException("EuropeanAIPlayer integrity fail");
        }
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.cacheNations();
        this.badlyDefended.clear();
        LogBuilder lb = new LogBuilder(1024);
        int colonyCount = this.getAIColonies().size();
        lb.add(player.getDebugName(), " in ", turn, "/", turn.getNumber(), " units=", this.getAIUnits().size(), " colonies=", colonyCount, " declare=", player.checkDeclareIndependence() == null, " v-land-REF=", Float.valueOf(player.getRebelStrengthRatio(false)), " v-naval-REF=", Float.valueOf(player.getRebelStrengthRatio(true)));
        if (turn.isFirstTurn()) {
            this.initializeMissions(lb);
        }
        this.determineStances(lb);
        if (colonyCount > 0) {
            lb.add("\n  Badly defended:");
            for (AIColony aic : this.getAIColonies()) {
                if (!aic.isBadlyDefended()) continue;
                this.badlyDefended.add(aic);
                lb.add(" ", aic.getColony());
            }
            lb.add("\n  Update colonies:");
            for (AIColony aic : this.getAIColonies()) {
                aic.update(lb);
            }
            this.buildTipMap(lb);
            this.buildWishMaps(lb);
        }
        this.cheat(lb);
        this.buildTransportMaps(lb);
        List<AIUnit> aiUnits = this.getAIUnits();
        for (int i = 0; i < 3; ++i) {
            this.rearrangeColonies(lb);
            this.giveNormalMissions(lb);
            this.bringGifts(lb);
            this.demandTribute(lb);
            if (aiUnits.isEmpty()) break;
            aiUnits = this.doMissions(aiUnits, lb);
        }
        lb.log(logger, Level.FINE);
        this.clearAIUnits();
        this.tipMap.clear();
        this.transportDemand.clear();
        this.transportSupply.clear();
        this.wagonsNeeded.clear();
        this.goodsWishes.clear();
        this.workerWishes.clear();
    }

    @Override
    protected List<AIUnit> doMissions(List<AIUnit> aiUnits, LogBuilder lb) {
        lb.add("\n  Do missions:");
        ArrayList<AIUnit> result = new ArrayList<AIUnit>();
        for (AIUnit aiu : aiUnits) {
            Unit unit = aiu.getUnit();
            if (unit == null || unit.isDisposed()) continue;
            Mission oldMission = aiu.getMission();
            if (oldMission == null) {
                result.add(aiu);
                continue;
            }
            Location oldTarget = oldMission.getTarget();
            Location oldLocation = unit.getLocation();
            Colony oldColony = oldLocation.getColony();
            lb.add("\n  ", unit, " ");
            try {
                aiu.doMission(lb);
            }
            catch (Exception e) {
                lb.add(", EXCEPTION: ", e.getMessage());
                logger.log(Level.WARNING, "doMissions failed for: " + aiu, e);
            }
            if (unit.isDisposed()) {
                aiu.dropTransport();
                lb.add(", DIED.");
                continue;
            }
            this.updateTransport(aiu, oldTarget, lb);
            if (!(unit.getMovesLeft() <= 0 || unit.isOnCarrier() && unit.getCarrier().getMovesLeft() <= 0)) {
                lb.add("+");
                result.add(aiu);
            } else {
                lb.add(".");
            }
            Colony newColony = unit.getLocation().getColony();
            if (oldColony != null || newColony == null || !Map.isSameLocation(oldLocation, newColony)) continue;
            AIColony aiColony = this.getAIColony(newColony);
            aiColony.update(lb);
            this.updateTipMap(aiColony);
        }
        return result;
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (value > 0 && type == DefendSettlementMission.class) {
            Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
            if (!(loc instanceof Colony)) {
                throw new IllegalStateException("European players defend colonies: " + loc);
            }
            Colony colony = (Colony)loc;
            int defenders = this.getSettlementDefenders(colony);
            value -= 25 * defenders;
            if (colony.hasStockade()) {
                value = defenders > colony.getStockade().getLevel() + 1 ? (value -= 100 * colony.getStockade().getLevel()) : (value -= 20 * colony.getStockade().getLevel());
            }
        }
        return value;
    }

    @Override
    public boolean indianDemand(Unit unit, Colony colony, GoodsType goods, int gold) {
        return !"conquest".equals(this.getAIAdvantage());
    }

    @Override
    public DiplomaticTrade.TradeStatus acceptDiplomaticTrade(DiplomaticTrade agreement) {
        int value;
        Player player = this.getPlayer();
        Player other = agreement.getOtherPlayer(player);
        Market market = player.getMarket();
        boolean franklin = other.hasAbility("model.ability.alwaysOfferedPeace");
        final HashMap<TradeItem, Integer> scores = new HashMap<TradeItem, Integer>();
        TradeItem peace = null;
        TradeItem cash = null;
        LogBuilder lb = new LogBuilder(64);
        lb.add("Evaluate trade offer from ", other.getName(), ":");
        DiplomaticTrade.TradeStatus result = null;
        int unacceptable = 0;
        for (TradeItem item : agreement.getTradeItems()) {
            if (item instanceof GoldTradeItem) {
                cash = item;
                int gold = item.getGold();
                value = item.getSource() == player ? (player.checkGold(gold) ? -gold : Integer.MIN_VALUE) : gold;
            } else if (item instanceof ColonyTradeItem) {
                Colony colony = item.getColony(this.getGame());
                value = item.getSource() == player ? (!player.owns(colony) || player.getNumberOfSettlements() < 5 ? Integer.MIN_VALUE : -this.evaluateColony(colony)) : (player.owns(colony) ? Integer.MIN_VALUE : this.evaluateColony(colony));
            } else if (item instanceof GoodsTradeItem) {
                Goods goods = item.getGoods();
                value = item.getSource() == player ? -market.getBidPrice(goods.getType(), goods.getAmount()) : market.getSalePrice(goods.getType(), goods.getAmount());
            } else if (item instanceof InciteTradeItem) {
                Player victim = item.getVictim();
                switch (player.getStance(victim)) {
                    case ALLIANCE: {
                        value = Integer.MIN_VALUE;
                        break;
                    }
                    case WAR: {
                        value = 0;
                        break;
                    }
                    default: {
                        double ratio = this.getStrengthRatio(victim);
                        if (item.getSource() == player) {
                            value = -((int)Math.round(30.0 * ratio));
                            break;
                        }
                        value = (int)Math.round(30.0 * ratio);
                        break;
                    }
                }
            } else if (item instanceof StanceTradeItem) {
                double ratio = this.getStrengthRatio(other);
                Player.Stance stance = item.getStance();
                switch (stance) {
                    case WAR: {
                        if (ratio < 0.33) {
                            value = Integer.MIN_VALUE;
                            break;
                        }
                        if (ratio < 0.5) {
                            value = -((int)Math.round(100.0 * ratio));
                            break;
                        }
                        value = (int)Math.round(100.0 * ratio);
                        break;
                    }
                    case PEACE: {
                        if (agreement.getContext() == DiplomaticTrade.TradeContext.CONTACT) {
                            peace = item;
                            value = 0;
                            break;
                        }
                    }
                    case ALLIANCE: 
                    case CEASE_FIRE: {
                        if (franklin) {
                            peace = item;
                            value = 0;
                            break;
                        }
                        if (ratio > 0.66) {
                            value = Integer.MIN_VALUE;
                            break;
                        }
                        if (ratio > 0.5) {
                            value = -((int)Math.round(100.0 * ratio));
                            break;
                        }
                        if (ratio > 0.33) {
                            value = (int)Math.round(100.0 * ratio);
                            break;
                        }
                        value = 1000;
                        break;
                    }
                    default: {
                        value = Integer.MIN_VALUE;
                        break;
                    }
                }
            } else if (item instanceof UnitTradeItem) {
                Unit unit = item.getUnit();
                value = item.getSource() == player ? (!player.owns(unit) || player.getUnits().size() < 10 ? Integer.MIN_VALUE : -this.evaluateUnit(unit)) : (player.owns(unit) ? Integer.MIN_VALUE : this.evaluateUnit(unit));
            } else {
                throw new RuntimeException("Bogus item: " + item);
            }
            if (value == Integer.MIN_VALUE) {
                ++unacceptable;
            }
            scores.put(item, value);
            lb.add(" ", Messages.message(item.getLabel()), " = ", value);
        }
        double ratio = (double)unacceptable / (double)(unacceptable + agreement.getTradeItems().size());
        if (ratio > 0.5 - 0.5 * (double)agreement.getVersion()) {
            result = this.rejectAgreement(peace, agreement);
            lb.add(", Too many (", unacceptable, ") unacceptable");
        }
        value = 0;
        if (result == null) {
            for (Map.Entry entry : scores.entrySet()) {
                if ((Integer)entry.getValue() == Integer.MIN_VALUE) {
                    agreement.remove((TradeItem)entry.getKey());
                    continue;
                }
                value += ((Integer)entry.getValue()).intValue();
            }
            if (value >= 0) {
                result = agreement.getContext() == DiplomaticTrade.TradeContext.CONTACT && agreement.getVersion() == 0 ? DiplomaticTrade.TradeStatus.PROPOSE_TRADE : (unacceptable == 0 ? DiplomaticTrade.TradeStatus.ACCEPT_TRADE : (agreement.isEmpty() ? DiplomaticTrade.TradeStatus.REJECT_TRADE : DiplomaticTrade.TradeStatus.PROPOSE_TRADE));
                lb.add(", Value = ", value);
            }
        }
        if (result == null && RandomUtils.randomInt(logger, "Enough diplomacy?", this.getAIRandom(), 1 + agreement.getVersion()) > 5) {
            result = this.rejectAgreement(peace, agreement);
            lb.add(", Ran out of patience at ", agreement.getVersion());
        }
        if (result == null) {
            ArrayList<TradeItem> items = new ArrayList<TradeItem>(agreement.getTradeItems());
            Collections.sort(items, new Comparator<TradeItem>(){

                @Override
                public int compare(TradeItem t1, TradeItem t2) {
                    return (Integer)scores.get(t1) - (Integer)scores.get(t2);
                }
            });
            while (!items.isEmpty()) {
                TradeItem item = (TradeItem)items.remove(0);
                agreement.remove(item);
                if ((value += ((Integer)scores.get(item)).intValue()) <= 0) continue;
                break;
            }
            if (value > 0 && !items.isEmpty()) {
                result = DiplomaticTrade.TradeStatus.PROPOSE_TRADE;
                lb.add(", Pruned until acceptable at ", value);
            } else {
                result = this.rejectAgreement(peace, agreement);
                lb.add(", Agreement unsalvageable");
            }
        }
        lb.add(new Object[]{" => ", result});
        lb.log(logger, Level.INFO);
        return result;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        Specification spec = this.getSpecification();
        Player buyer = unit.getOwner();
        IndianSettlement is = (IndianSettlement)settlement;
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = is.getPriceToSell(goods) + this.getPlayer().getTension(buyer).getValue();
            if (is.hasMissionary(buyer) && spec.getBoolean("model.option.enhancedMissionaries")) {
                Unit u = is.getMissionary();
                price = (int)FeatureContainer.applyModifiers(price, this.getGame().getTurn(), u.getMissionaryTradeModifiers(false));
            }
            this.sessionRegister.put(goldKey, price);
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, -1);
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (RandomUtils.randomInt(logger, "Buy gold", this.getAIRandom(), 3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, gold);
            this.sessionRegister.put(hagglingKey, haggling + 1);
            return gold;
        }
        this.sessionRegister.put(goldKey, -1);
        return -2;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method sellProposition");
        Colony colony = (Colony)settlement;
        Player otherPlayer = unit.getOwner();
        int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
        amount = Math.min(amount, goods.getAmount());
        Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
        int percentage = (9 - tensionLevel.ordinal()) * 10;
        int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
        return netProfits * percentage / 100;
    }

    @Override
    public boolean acceptTax(int tax) {
        GoodsType goodsType;
        boolean ret = true;
        LogBuilder lb = new LogBuilder(64);
        lb.add("Tax demand to ", this.getPlayer().getId(), " of ", tax, "%: ");
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        GoodsType goodsType2 = goodsType = toBeDestroyed == null ? null : toBeDestroyed.getType();
        if (toBeDestroyed == null) {
            ret = false;
            lb.add("refused: no-goods-under-threat");
        } else if (goodsType.isFoodType()) {
            ret = false;
            lb.add("refused: food-type");
        } else if (goodsType.isBreedable()) {
            int n = 0;
            for (Settlement s : this.getPlayer().getSettlements()) {
                if (s.getGoodsCount(goodsType) <= 0) continue;
                ++n;
            }
            boolean bl = ret = n < 2;
            if (ret) {
                lb.add("accepted: breedable-type-", goodsType.getSuffix(), "-missing");
            } else {
                lb.add("refused: breedable-type-", goodsType.getSuffix(), "-present-in-", n, "-settlements");
            }
        } else if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            int age = this.getGame().getTurn().getAge();
            ret = age < 3;
            lb.add(ret ? "accepted" : "rejected", ": special-goods-in-age-", age);
        } else {
            int averageIncome = 0;
            int numberOfGoods = 0;
            List<GoodsType> goodsTypes = this.getSpecification().getGoodsTypeList();
            for (GoodsType type : goodsTypes) {
                if (!type.isStorable()) continue;
                averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
                ++numberOfGoods;
            }
            int income = this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType());
            ret = income < (averageIncome /= numberOfGoods);
            lb.add(ret ? "accepted" : "rejected", ": standard-goods-with-income-", income, ret ? "-less-than-" : "-greater-than-", averageIncome);
        }
        lb.log(logger, Level.INFO);
        return ret;
    }

    @Override
    public boolean acceptMercenaries() {
        return this.getPlayer().isAtWar() || "conquest".equals(this.getAIAdvantage());
    }

    @Override
    public FoundingFather selectFoundingFather(List<FoundingFather> ffs) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = Integer.MIN_VALUE;
        for (FoundingFather father : ffs) {
            if (father == null) continue;
            if (father.hasAbility("model.ability.buildCustomHouse")) {
                bestFather = father;
                break;
            }
            int weight = father.getWeight(age);
            if (weight <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    @Override
    public String getXMLTagName() {
        return EuropeanAIPlayer.getXMLElementTagName();
    }

    static {
        pioneerRole = null;
        scoutRole = null;
    }
}

