/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.WorkLocationPlan;

public class ColonyPlan {
    private static final Logger logger = Logger.getLogger(ColonyPlan.class.getName());
    private static final int LOW_PRODUCTION_THRESHOLD = 1;
    private static final int PRODUCTION_TURNOVER_TURNS = 5;
    private ProfileType profileType;
    private final AIMain aiMain;
    private final Colony colony;
    private final List<BuildPlan> buildPlans = new ArrayList<BuildPlan>();
    private static final Comparator<BuildPlan> buildPlanComparator = new Comparator<BuildPlan>(){

        @Override
        public int compare(BuildPlan b1, BuildPlan b2) {
            double d = b1.getValue() - b2.getValue();
            return d > 0.0 ? -1 : (d < 0.0 ? 1 : 0);
        }
    };
    private final List<WorkLocationPlan> workPlans = new ArrayList<WorkLocationPlan>();
    private final List<GoodsType> produce = new ArrayList<GoodsType>();
    private final List<GoodsType> foodGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> libertyGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> immigrationGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> militaryGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> rawBuildingGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> buildingGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> rawLuxuryGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> luxuryGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> otherRawGoodsTypes = new ArrayList<GoodsType>();
    private static final double BREEDING_WEIGHT = 0.1;
    private static final double BUILDING_WEIGHT = 0.9;
    private static final double DEFENCE_WEIGHT = 0.1;
    private static final double EXPORT_WEIGHT = 0.6;
    private static final double FISH_WEIGHT = 0.25;
    private static final double FORTIFY_WEIGHT = 0.3;
    private static final double IMMIGRATION_WEIGHT = 0.05;
    private static final double LIBERTY_WEIGHT = 0.75;
    private static final double MILITARY_WEIGHT = 0.4;
    private static final double PRODUCTION_WEIGHT = 0.25;
    private static final double REPAIR_WEIGHT = 0.1;
    private static final double STORAGE_WEIGHT = 0.85;
    private static final double TEACH_WEIGHT = 0.2;
    private static final double TRANSPORT_WEIGHT = 0.15;

    public ColonyPlan(AIMain aiMain, Colony colony) {
        if (aiMain == null) {
            throw new IllegalArgumentException("Null AIMain");
        }
        if (colony == null) {
            throw new IllegalArgumentException("Null colony");
        }
        this.aiMain = aiMain;
        this.colony = colony;
        this.profileType = ProfileType.getProfileTypeFromSize(colony.getUnitCount());
    }

    private AIMain getAIMain() {
        return this.aiMain;
    }

    private Specification spec() {
        return this.aiMain.getGame().getSpecification();
    }

    public List<GoodsType> getPreferredProduction() {
        return new ArrayList<GoodsType>(this.produce);
    }

    public List<BuildableType> getBuildableTypes() {
        ArrayList<BuildableType> build = new ArrayList<BuildableType>();
        for (BuildPlan b : this.buildPlans) {
            build.add(b.type);
        }
        return build;
    }

    public BuildableType getBestBuildableType() {
        for (BuildPlan b : this.buildPlans) {
            if (!this.colony.canBuild(b.type)) continue;
            return b.type;
        }
        return null;
    }

    public String getBuildableReport() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("Buildables:\n");
        for (BuildPlan b : this.buildPlans) {
            lb.add(b, "\n");
        }
        return lb.toString();
    }

    public List<WorkLocationPlan> getFoodPlans() {
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>();
        for (WorkLocationPlan wlp : this.workPlans) {
            if (!wlp.isFoodPlan() || wlp.getWorkLocation().canAutoProduce()) continue;
            plans.add(wlp);
        }
        return plans;
    }

    public List<WorkLocationPlan> getWorkPlans() {
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>();
        for (WorkLocationPlan wlp : this.workPlans) {
            if (wlp.isFoodPlan() || wlp.getWorkLocation().canAutoProduce()) continue;
            plans.add(wlp);
        }
        return plans;
    }

    public void refine(BuildableType build, LogBuilder lb) {
        ArrayList<GoodsType> required = new ArrayList<GoodsType>();
        for (AbstractGoods ag : this.colony.getFullRequiredGoods(build)) {
            required.add(ag.getType());
        }
        HashMap<GoodsType, ArrayList<WorkLocationPlan>> suppressed = new HashMap<GoodsType, ArrayList<WorkLocationPlan>>();
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>(this.workPlans);
        int offset = 0;
        for (int i = 0; i < plans.size(); ++i) {
            List wls;
            WorkLocationPlan wlp = (WorkLocationPlan)plans.get(i);
            GoodsType g = wlp.getGoodsType();
            if (this.rawBuildingGoodsTypes.contains(g) && !required.contains(g.getOutputType()) || this.buildingGoodsTypes.contains(g) && !required.contains(g)) {
                this.workPlans.remove(i - offset);
                ++offset;
                wls = (ArrayList<WorkLocationPlan>)suppressed.get(g);
                if (wls == null) {
                    wls = new ArrayList<WorkLocationPlan>();
                }
                wls.add(0, wlp);
                suppressed.put(g, (ArrayList<WorkLocationPlan>)wls);
                this.produce.remove(g);
                lb.add(", suppress production of ", g);
                continue;
            }
            if (!g.isRefined() || !this.rawBuildingGoodsTypes.contains(g.getInputType()) && !this.buildingGoodsTypes.contains(g.getInputType())) continue;
            int n = 0;
            int idx = this.produce.indexOf(g);
            for (GoodsType type = g.getInputType(); type != null && (wls = (List)suppressed.get(type)) != null && this.colony.getGoodsCount(type) < 50; type = type.getInputType()) {
                n += wls.size();
                while (!wls.isEmpty()) {
                    this.workPlans.add(i - offset, (WorkLocationPlan)wls.remove(0));
                }
                this.produce.add(idx, type);
                lb.add(", restore production of ", type);
            }
            offset -= n;
        }
    }

    public void update() {
        this.profileType = ProfileType.getProfileTypeFromSize(this.colony.getUnitCount());
        Map<GoodsType, Map<WorkLocation, Integer>> production = this.createProductionMap();
        this.updateGoodsTypeLists(production);
        this.updateRawMaterials(production);
        this.updateBuildableTypes();
        this.updatePlans(production);
    }

    private Map<GoodsType, Map<WorkLocation, Integer>> createProductionMap() {
        HashMap<GoodsType, Map<WorkLocation, Integer>> production = new HashMap<GoodsType, Map<WorkLocation, Integer>>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            for (GoodsType g : this.spec().getGoodsTypeList()) {
                int p = wl.getGenericPotential(g);
                if (p <= 0) continue;
                HashMap<WorkLocation, Integer> m = (HashMap<WorkLocation, Integer>)production.get(g);
                if (m == null) {
                    m = new HashMap<WorkLocation, Integer>();
                    production.put(g, m);
                }
                m.put(wl, p);
            }
        }
        return production;
    }

    private void updateGoodsTypeLists(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        this.foodGoodsTypes.clear();
        this.libertyGoodsTypes.clear();
        this.immigrationGoodsTypes.clear();
        this.militaryGoodsTypes.clear();
        this.rawBuildingGoodsTypes.clear();
        this.buildingGoodsTypes.clear();
        this.rawLuxuryGoodsTypes.clear();
        this.luxuryGoodsTypes.clear();
        this.otherRawGoodsTypes.clear();
        for (GoodsType g : new ArrayList<GoodsType>(production.keySet())) {
            if (g.isFoodType()) {
                this.foodGoodsTypes.add(g);
                continue;
            }
            if (g.isLibertyType()) {
                this.libertyGoodsTypes.add(g);
                continue;
            }
            if (g.isImmigrationType()) {
                this.immigrationGoodsTypes.add(g);
                continue;
            }
            if (g.isMilitaryGoods()) {
                this.militaryGoodsTypes.add(g);
                continue;
            }
            if (g.isRawBuildingMaterial()) {
                this.rawBuildingGoodsTypes.add(g);
                continue;
            }
            if (g.isBuildingMaterial() && g.getInputType().isRawBuildingMaterial()) {
                this.buildingGoodsTypes.add(g);
                continue;
            }
            if (g.isNewWorldGoodsType()) {
                this.rawLuxuryGoodsTypes.add(g);
                continue;
            }
            if (g.isRefined() && g.getInputType().isNewWorldGoodsType()) {
                this.luxuryGoodsTypes.add(g);
                continue;
            }
            if (g.isFarmed()) {
                this.otherRawGoodsTypes.add(g);
                continue;
            }
            logger.warning("Ignoring goods type " + g + " at " + this.colony.getName());
            production.remove(g);
        }
    }

    private void updateRawMaterials(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        Player player = this.colony.getOwner();
        Market market = player.getMarket();
        NationType nationType = player.getNationType();
        GoodsType primaryRawMaterial = null;
        GoodsType secondaryRawMaterial = null;
        int primaryValue = -1;
        int secondaryValue = -1;
        this.produce.clear();
        ArrayList<GoodsType> rawMaterials = new ArrayList<GoodsType>(this.rawLuxuryGoodsTypes);
        rawMaterials.addAll(this.otherRawGoodsTypes);
        for (GoodsType g : rawMaterials) {
            int value = 0;
            for (Map.Entry<WorkLocation, Integer> e : production.get(g).entrySet()) {
                value += e.getValue().intValue();
            }
            if (value <= 1) {
                production.remove(g);
                continue;
            }
            if (market != null) {
                if (g.getOutputType() == null) {
                    value *= market.getSalePrice(g, 1);
                } else if (production.containsKey(g.getOutputType())) {
                    value *= (market.getSalePrice(g, 1) + market.getSalePrice(g.getOutputType(), 1)) / 2;
                }
            }
            if (nationType.hasModifier(g.getId())) {
                value = value * 12 / 10;
            }
            if (value > secondaryValue && secondaryRawMaterial != null) {
                production.remove(secondaryRawMaterial);
                production.remove(secondaryRawMaterial.getOutputType());
                if (this.rawLuxuryGoodsTypes.contains(secondaryRawMaterial)) {
                    this.rawLuxuryGoodsTypes.remove(secondaryRawMaterial);
                    this.luxuryGoodsTypes.remove(secondaryRawMaterial.getOutputType());
                } else if (this.otherRawGoodsTypes.contains(secondaryRawMaterial)) {
                    this.otherRawGoodsTypes.remove(secondaryRawMaterial);
                }
            }
            if (value > primaryValue) {
                secondaryRawMaterial = primaryRawMaterial;
                secondaryValue = primaryValue;
                primaryRawMaterial = g;
                primaryValue = value;
                continue;
            }
            if (value <= secondaryValue) continue;
            secondaryRawMaterial = g;
            secondaryValue = value;
        }
        if (primaryRawMaterial != null) {
            this.produce.add(primaryRawMaterial);
            if (primaryRawMaterial.getOutputType() != null) {
                this.produce.add(primaryRawMaterial.getOutputType());
            }
            if (secondaryRawMaterial != null) {
                this.produce.add(secondaryRawMaterial);
                if (secondaryRawMaterial.getOutputType() != null) {
                    this.produce.add(secondaryRawMaterial.getOutputType());
                }
            }
        }
    }

    private BuildPlan findBuildPlan(BuildableType type) {
        for (BuildPlan bp : this.buildPlans) {
            if (bp.type != type) continue;
            return bp;
        }
        return null;
    }

    private boolean prioritize(BuildableType type, double weight, double support) {
        BuildPlan bp = this.findBuildPlan(type);
        if (bp == null) {
            this.buildPlans.add(new BuildPlan(type, weight, support));
            return true;
        }
        if (bp.weight * bp.support < weight * support) {
            bp.weight = weight;
            bp.support = support;
            return true;
        }
        return false;
    }

    private boolean prioritizeProduction(BuildableType type, GoodsType goodsType) {
        Player player = this.colony.getOwner();
        NationType nationType = player.getNationType();
        String advantage = this.getAIMain().getAIPlayer(player).getAIAdvantage();
        boolean ret = false;
        double factor = 1.0;
        if (nationType.hasModifier(goodsType.getId())) {
            factor *= 1.2;
        }
        if (goodsType.isMilitaryGoods()) {
            if ("conquest".equals(advantage)) {
                factor = 1.2;
            }
            ret = this.prioritize(type, 0.4 * factor, 1.0);
        } else if (goodsType.isBuildingMaterial()) {
            ret = this.prioritize(type, 0.9 * factor, 1.0);
        } else if (goodsType.isLibertyType()) {
            if (player.isREF()) {
                return false;
            }
            ret = this.prioritize(type, 0.75, this.colony.getSoL() >= 100 ? 0.01 : 1.0);
        } else if (goodsType.isImmigrationType()) {
            if ("immigration".equals(advantage)) {
                factor = 1.2;
            }
            ret = this.prioritize(type, 0.05 * factor, 1.0);
        } else if (this.produce.contains(goodsType)) {
            if ("trade".equals(advantage)) {
                factor = 1.2;
            }
            double f = 0.1 * (double)this.colony.getTotalProductionOf(goodsType.getInputType());
            ret = this.prioritize(type, 0.25, f);
        }
        return ret;
    }

    private void updateBuildableTypes() {
        int maxLevel;
        EuropeanAIPlayer euaip = (EuropeanAIPlayer)this.getAIMain().getAIPlayer(this.colony.getOwner());
        String advantage = euaip.getAIAdvantage();
        this.buildPlans.clear();
        switch (this.profileType) {
            case OUTPOST: 
            case SMALL: {
                maxLevel = 1;
                break;
            }
            case MEDIUM: {
                maxLevel = 2;
                break;
            }
            case LARGE: {
                maxLevel = 3;
                break;
            }
            case CAPITAL: {
                maxLevel = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Bogus profile type: " + (Object)((Object)this.profileType));
            }
        }
        Player player = this.colony.getOwner();
        for (BuildingType type : this.spec().getBuildingTypeList()) {
            GoodsType output;
            double factor;
            boolean expectFail = false;
            if (!this.colony.canBuild(type)) continue;
            if (type.hasModifier("model.modifier.defence")) {
                factor = 1.0;
                if ("conquest".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.3 * factor, 1.0);
            }
            if (type.hasAbility("model.ability.export")) {
                factor = 1.0;
                if ("trade".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.6 * factor, 1.0);
            }
            if (type.getLevel() > maxLevel) continue;
            if (type.hasAbility("model.ability.produceInWater")) {
                factor = 0.0;
                if (!this.colony.hasAbility("model.ability.produceInWater") && this.colony.getTile().isShore()) {
                    int landFood = 0;
                    int seaFood = 0;
                    for (Tile t : this.colony.getTile().getSurroundingTiles(1)) {
                        if (t.getOwningSettlement() != this.colony && !player.canClaimForSettlement(t)) continue;
                        for (AbstractGoods ag : t.getSortedPotential()) {
                            if (!ag.getType().isFoodType()) continue;
                            if (t.isLand()) {
                                landFood += ag.getAmount();
                                continue;
                            }
                            seaFood += ag.getAmount();
                        }
                    }
                    factor = seaFood + landFood == 0 ? 0.0 : (double)seaFood / (double)(seaFood + landFood);
                }
                this.prioritize(type, 0.25, factor);
            }
            if (type.hasAbility("model.ability.build")) {
                factor = 1.0;
                if ("building".equals(advantage)) {
                    factor = 1.1;
                }
                double support = 1.0;
                for (Ability a : type.getAbilities("model.ability.build")) {
                    List<Scope> scopes = a.getScopes();
                    if (scopes == null || scopes.isEmpty()) continue;
                    support = 0.1;
                }
                this.prioritize(type, 0.9 * factor, support);
            }
            if (type.hasAbility("model.ability.teach")) {
                this.prioritize(type, 0.2, 1.0);
            }
            if (type.hasAbility("model.ability.repairUnits")) {
                factor = 1.0;
                if ("naval".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.1 * factor, 1.0);
            }
            if ((output = type.getProducedGoodsType()) != null) {
                if (!this.prioritizeProduction(type, output)) {
                    expectFail = true;
                }
            } else {
                for (GoodsType g : this.spec().getGoodsTypeList()) {
                    if (!type.hasModifier(g.getId()) || this.prioritizeProduction(type, g)) continue;
                    expectFail = true;
                }
                if (type.hasModifier("model.modifier.warehouseStorage")) {
                    double factor2 = 1.0;
                    if ("trade".equals(advantage)) {
                        factor2 = 1.1;
                    }
                    this.prioritize(type, 0.85 * factor2, 1.0);
                }
                if (type.hasModifier("model.modifier.breedingDivisor")) {
                    this.prioritize(type, 0.1, 1.0);
                }
            }
            if (this.findBuildPlan(type) != null || expectFail) continue;
            logger.warning("No building priority found for: " + type);
        }
        double wagonNeed = 0.0;
        if (!this.colony.isConnectedPort()) {
            int wagons = euaip.getNeededWagons(this.colony.getTile());
            wagonNeed = wagons <= 0 ? 0.0 : (wagons > 3 ? 1.0 : (double)wagons / 3.0);
        }
        for (UnitType unitType : this.spec().getUnitTypeList()) {
            if (!this.colony.canBuild(unitType) || unitType.hasAbility("model.ability.navalUnit")) continue;
            if (unitType.isDefensive()) {
                if (!this.colony.isBadlyDefended()) continue;
                this.prioritize(unitType, 0.1, 1.0);
                continue;
            }
            if (!unitType.hasAbility("model.ability.carryGoods") || !(wagonNeed > 0.0)) continue;
            double factor = 1.0;
            if ("trade".equals(advantage)) {
                factor = 1.1;
            }
            this.prioritize(unitType, 0.15 * factor, wagonNeed);
        }
        for (BuildPlan bp : this.buildPlans) {
            double difficulty = 0.0;
            for (AbstractGoods ag : bp.type.getRequiredGoods()) {
                GoodsType g = ag.getType();
                int need = ag.getAmount() - this.colony.getGoodsCount(g);
                if (need <= 0) continue;
                double f = this.produce.contains(g.getInputType()) ? 1.0 : 5.0;
                difficulty += (double)need * f;
            }
            bp.difficulty = Math.max(1.0, Math.sqrt(difficulty));
        }
        Collections.sort(this.buildPlans, buildPlanComparator);
    }

    private void updatePlans(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        this.workPlans.clear();
        for (Map.Entry<GoodsType, Map<WorkLocation, Integer>> entry : production.entrySet()) {
            GoodsType g = entry.getKey();
            if (g.isStorable() && this.colony.getGoodsCount(g) >= this.colony.getWarehouseCapacity() && !g.limitIgnored()) continue;
            for (WorkLocation wl : entry.getValue().keySet()) {
                if (!wl.canBeWorked() && !wl.canAutoProduce()) continue;
                this.workPlans.add(new WorkLocationPlan(this.getAIMain(), wl, g));
            }
        }
        this.updateProductionList(production);
        ArrayList<WorkLocationPlan> oldPlans = new ArrayList<WorkLocationPlan>(this.workPlans);
        this.workPlans.clear();
        for (WorkLocationPlan wlp : oldPlans) {
            if (!wlp.getWorkLocation().canBeWorked()) continue;
            this.workPlans.add(wlp);
        }
        Collections.sort(this.workPlans, new Comparator<WorkLocationPlan>(){

            @Override
            public int compare(WorkLocationPlan w1, WorkLocationPlan w2) {
                int cmp;
                GoodsType g1 = w1.getGoodsType();
                GoodsType g2 = w2.getGoodsType();
                int i1 = ColonyPlan.this.produce.indexOf(g1);
                int i2 = ColonyPlan.this.produce.indexOf(g2);
                if (i1 < 0 && !g1.isFoodType()) {
                    i1 = 99999;
                }
                if (i2 < 0 && !g2.isFoodType()) {
                    i2 = 99999;
                }
                if ((cmp = i1 - i2) == 0) {
                    cmp = w2.getWorkLocation().getGenericPotential(g2) - w1.getWorkLocation().getGenericPotential(g1);
                }
                return cmp;
            }
        });
    }

    private void updateProductionList(final Map<GoodsType, Map<WorkLocation, Integer>> production) {
        GoodsType raw;
        Comparator<GoodsType> productionComparator = new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                int p1 = 0;
                for (Integer i : ((Map)production.get(g1)).values()) {
                    p1 += i.intValue();
                }
                int p2 = 0;
                for (Integer i : ((Map)production.get(g2)).values()) {
                    p2 += i.intValue();
                }
                return p2 - p1;
            }
        };
        ArrayList<GoodsType> toAdd = new ArrayList<GoodsType>();
        if (this.colony.getSoL() < 100) {
            for (GoodsType g : this.libertyGoodsTypes) {
                if (!production.containsKey(g)) continue;
                toAdd.add(g);
            }
            Collections.sort(toAdd, productionComparator);
            this.produce.addAll(0, toAdd);
            toAdd.clear();
        }
        Collections.sort(this.rawBuildingGoodsTypes, productionComparator);
        for (GoodsType g : this.buildingGoodsTypes) {
            if (!production.containsKey(g) || this.colony.getGoodsCount(raw = g.getInputType()) < 50 && !production.containsKey(raw)) continue;
            toAdd.add(g);
        }
        Collections.sort(toAdd, new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                int i1 = ColonyPlan.this.rawBuildingGoodsTypes.indexOf(g1.getInputType());
                int i2 = ColonyPlan.this.rawBuildingGoodsTypes.indexOf(g2.getInputType());
                return i1 - i2;
            }
        });
        for (int i = toAdd.size() - 1; i >= 0; --i) {
            GoodsType make = (GoodsType)toAdd.get(i);
            raw = make.getInputType();
            if (production.containsKey(raw)) {
                if (this.colony.getGoodsCount(raw) >= 50) {
                    this.produce.add(raw);
                    this.produce.add(0, make);
                    continue;
                }
                this.produce.add(0, make);
                this.produce.add(0, raw);
                continue;
            }
            this.produce.add(0, make);
        }
        toAdd.clear();
        for (GoodsType g : this.militaryGoodsTypes) {
            if (!production.containsKey(g)) continue;
            toAdd.add(g);
        }
        Collections.sort(toAdd, productionComparator);
        this.produce.addAll(toAdd);
        toAdd.clear();
        if (this.colony.getOwner().getEurope() != null) {
            for (GoodsType g : this.immigrationGoodsTypes) {
                if (!production.containsKey(g)) continue;
                toAdd.add(g);
            }
            Collections.sort(toAdd, productionComparator);
            this.produce.addAll(toAdd);
            toAdd.clear();
        }
    }

    private Unit trySwapExpert(Unit expert, List<Unit> others, Colony colony) {
        Role oldRole = expert.getRole();
        int oldRoleCount = expert.getRoleCount();
        GoodsType work = expert.getType().getExpertProduction();
        GoodsType oldWork = expert.getWorkType();
        for (Unit other : others) {
            if (!other.isPerson() || other.getWorkType() != work || other.getType().getExpertProduction() == work) continue;
            Location l1 = expert.getLocation();
            Location l2 = other.getLocation();
            other.setLocation(colony.getTile());
            expert.setLocation(l2);
            expert.changeWorkType(work);
            other.setLocation(l1);
            if (oldWork != null) {
                other.changeWorkType(oldWork);
            }
            Role tmpRole = other.getRole();
            int tmpRoleCount = other.getRoleCount();
            other.changeRole(oldRole, oldRoleCount);
            expert.changeRole(tmpRole, tmpRoleCount);
            return other;
        }
        return null;
    }

    private WorkLocationPlan findPlan(GoodsType goodsType, List<WorkLocationPlan> plans) {
        for (WorkLocationPlan wlp : plans) {
            if (wlp.getGoodsType() != goodsType) continue;
            return wlp;
        }
        return null;
    }

    public static Unit getBestWorker(WorkLocation wl, GoodsType goodsType, List<Unit> workers) {
        GoodsType outputType;
        if (workers == null || workers.isEmpty()) {
            return null;
        }
        Colony colony = wl.getColony();
        GoodsType goodsType2 = outputType = goodsType.isStoredAs() ? goodsType.getStoredAs() : goodsType;
        if (workers.size() == 1) {
            Unit u = workers.get(0);
            if (!wl.canAdd(u)) {
                return null;
            }
            Location oldLoc = u.getLocation();
            GoodsType oldWork = u.getWorkType();
            u.setLocation(wl);
            u.changeWorkType(goodsType);
            int production = wl.getProductionOf(u, goodsType);
            u.setLocation(oldLoc);
            u.changeWorkType(oldWork);
            return production > 0 ? u : null;
        }
        ArrayList<Unit> todo = new ArrayList<Unit>(workers);
        ArrayList<Unit> best = new ArrayList<Unit>();
        int bestValue = colony.getAdjustedNetProductionOf(outputType);
        Unit special = null;
        best.clear();
        for (Unit u : todo) {
            if (!wl.canAdd(u)) continue;
            Location oldLoc = u.getLocation();
            GoodsType oldWork = u.getWorkType();
            u.setLocation(wl);
            u.changeWorkType(goodsType);
            int value = colony.getAdjustedNetProductionOf(outputType);
            if (value > bestValue) {
                bestValue = value;
                best.clear();
                best.add(u);
                if (u.getType().getExpertProduction() == goodsType) {
                    special = u;
                }
            } else if (value == bestValue && !best.isEmpty()) {
                best.add(u);
                if (u.getType().getExpertProduction() == goodsType) {
                    special = u;
                }
            }
            u.setLocation(oldLoc);
            u.changeWorkType(oldWork);
        }
        switch (best.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Unit)best.get(0);
            }
        }
        todo.clear();
        todo.addAll(best);
        if (special != null) {
            return special;
        }
        Specification spec = colony.getSpecification();
        UnitType expert = spec.getExpertForProducing(goodsType);
        best.clear();
        bestValue = Integer.MIN_VALUE;
        for (Unit u : todo) {
            int score;
            boolean relevant = u.getWorkType() == goodsType;
            int n = score = relevant ? u.getExperience() : -u.getExperience();
            if (expert != null && u.getType().canBeUpgraded(expert, UnitTypeChange.ChangeType.EXPERIENCE)) {
                score += 10000;
            } else if (expert != null && u.getType().canBeUpgraded(null, UnitTypeChange.ChangeType.EXPERIENCE)) {
                score -= 10000;
            }
            if (score > bestValue) {
                best.clear();
                best.add(u);
                bestValue = score;
                continue;
            }
            if (score != bestValue) continue;
            best.add(u);
        }
        switch (best.size()) {
            case 0: {
                break;
            }
            case 1: {
                return (Unit)best.get(0);
            }
            default: {
                todo.clear();
                todo.addAll(best);
            }
        }
        int worstSkill = Integer.MAX_VALUE;
        special = null;
        for (Unit u : todo) {
            if (u.getType().getSkill() >= worstSkill) continue;
            special = u;
            worstSkill = u.getType().getSkill();
        }
        return special;
    }

    private static boolean fullEquipUnit(Specification spec, Unit unit, Role role, Colony colony) {
        if (role.isOffensive()) {
            for (Role r : unit.getAvailableRoles(spec.getMilitaryRoles())) {
                if (!colony.equipForRole(unit, r, r.getMaximumCount())) continue;
                return true;
            }
            return false;
        }
        return colony.equipForRole(unit, role, role.getMaximumCount());
    }

    public Colony assignWorkers(List<Unit> workers, boolean preferScout, LogBuilder lb) {
        Comparator<Unit> comparator;
        Colony col;
        block46: {
            Iterator<Unit> goodsType;
            GoodsType foodType = this.spec().getPrimaryFoodType();
            final List<GoodsType> produce = this.getPreferredProduction();
            List<WorkLocationPlan> foodPlans = this.getFoodPlans();
            List<WorkLocationPlan> workPlans = this.getWorkPlans();
            col = this.colony.copyColony();
            Tile tile = col.getTile();
            ArrayList<Unit> otherWorkers = new ArrayList<Unit>(workers);
            workers.clear();
            for (Unit unit : otherWorkers) {
                workers.add(col.getCorresponding(unit));
            }
            for (Unit unit : workers) {
                unit.setLocation(tile);
                col.equipForRole(unit, this.spec().getDefaultRole(), 0);
            }
            Role[] outdoorRoles = new Role[]{this.spec().getRoleWithAbility("model.ability.improveTerrain", null), null, this.spec().getRoleWithAbility("model.ability.speakWithChief", null)};
            if (preferScout) {
                Role role = outdoorRoles[1];
                outdoorRoles[1] = outdoorRoles[2];
                outdoorRoles[2] = role;
            }
            block2: for (Role outdoorRole : outdoorRoles) {
                for (Unit u : new ArrayList<Unit>(workers)) {
                    if (workers.size() <= 1) continue block2;
                    Role role = outdoorRole;
                    if (role == null && (role = u.getMilitaryRole()) == null || u.getType() != role.getExpertUnit() || !ColonyPlan.fullEquipUnit(this.spec(), u, role, col)) continue;
                    workers.remove(u);
                    lb.add(u.getId(), "(", u.getType().getSuffix(), ") -> ", role.getSuffix(), "\n");
                }
            }
            comparator = new Comparator<Unit>(){

                @Override
                public int compare(Unit u1, Unit u2) {
                    int cmp = u1.getSkillLevel() - u2.getSkillLevel();
                    if (cmp == 0) {
                        GoodsType g1 = u1.getType().getExpertProduction();
                        GoodsType g2 = u2.getType().getExpertProduction();
                        cmp = (g2 == null ? 1 : 0) - (g1 == null ? 1 : 0);
                        if (cmp == 0 && g1 != null) {
                            int i = produce.indexOf(g2);
                            cmp = i < 0 ? produce.size() : i;
                            i = produce.indexOf(g1);
                            cmp -= i < 0 ? produce.size() : i;
                        }
                    }
                    if (cmp == 0) {
                        cmp = u1.getExperience() - u2.getExperience();
                    }
                    return cmp;
                }
            };
            Collections.sort(workers, comparator);
            for (Unit u : new ArrayList<Unit>(workers)) {
                if (workers.size() <= 1 || !col.isBadlyDefended()) break;
                Role role = u.getMilitaryRole();
                if (role == null || !ColonyPlan.fullEquipUnit(this.spec(), u, role, col)) continue;
                workers.remove(u);
                lb.add(u.getId(), "(", u.getType().getSuffix(), ") -> ", u.getRoleSuffix(), "\n");
            }
            ArrayList<AbstractGoods> buildGoods = new ArrayList<AbstractGoods>();
            BuildableType build = col.getCurrentlyBuilding();
            if (build != null) {
                buildGoods.addAll(build.getRequiredGoods());
            }
            boolean done = false;
            block5: while (!workers.isEmpty() && !done) {
                GoodsType raw;
                List<WorkLocationPlan> wlps = null;
                WorkLocationPlan wlp = null;
                if (col.getAdjustedNetProductionOf(foodType) > 0) {
                    wlps = workPlans;
                    while (!produce.isEmpty() && (wlp = this.findPlan(produce.get(0), workPlans)) == null) {
                        produce.remove(0);
                    }
                }
                while (true) {
                    if (wlp == null) {
                        if (foodPlans.isEmpty()) {
                            lb.add("    Food plans exhausted\n");
                            done = true;
                            continue block5;
                        }
                        wlps = foodPlans;
                        wlp = wlps.get(0);
                    }
                    String err = null;
                    goodsType = wlp.getGoodsType();
                    WorkLocation wl = col.getCorresponding(wlp.getWorkLocation());
                    Object best = null;
                    lb.add("    ", LogBuilder.wide(2, col.getUnitCount()), ": ", LogBuilder.wide(-15, ((FreeColObject)((Object)goodsType)).getSuffix()), "@", LogBuilder.wide(25, this.locationDescription(wl)), " => ");
                    if (!wl.canBeWorked()) {
                        err = "can not be worked";
                    } else if (wl.isFull()) {
                        err = "full";
                    } else {
                        best = ColonyPlan.getBestWorker(wl, goodsType, workers);
                        if (best == null) {
                            err = "no worker found";
                        }
                    }
                    if (err != null) {
                        wlps.remove(wlp);
                        lb.add(err, "\n");
                        continue block5;
                    }
                    ((Unit)best).setLocation(wl);
                    if (col.getProductionBonus() < 0) {
                        ((Unit)best).setLocation(tile);
                        done = true;
                        lb.add("    broke production bonus\n");
                        continue block5;
                    }
                    if (col.getAdjustedNetProductionOf(foodType) < 0) {
                        int net = col.getAdjustedNetProductionOf(foodType);
                        int count = col.getGoodsCount(foodType);
                        if (count / -net < 5) {
                            ((Unit)best).setLocation(tile);
                            wlp = null;
                            if (((GoodsType)((Object)goodsType)).isFoodType()) {
                                lb.add("    starvation (", count, "/", net, ")\n");
                                done = true;
                                continue block5;
                            }
                            lb.add("    would starve (", count, "/", net, ")\n");
                            continue;
                        }
                    }
                    raw = ((GoodsType)((Object)goodsType)).getInputType();
                    int rawNeeded = 0;
                    for (AbstractGoods ag : buildGoods) {
                        if (raw != ag.getType()) continue;
                        rawNeeded += ag.getAmount();
                    }
                    if (raw == null || col.getAdjustedNetProductionOf(raw) >= 0 || (col.getGoodsCount(raw) - rawNeeded) / -col.getAdjustedNetProductionOf(raw) >= 5) {
                        ((Unit)best).changeWorkType((GoodsType)((Object)goodsType));
                        workers.remove(best);
                        lb.add("    ", ((FreeColObject)best).getId(), "(", ((Unit)best).getType().getSuffix(), ")\n");
                        if (((GoodsType)((Object)goodsType)).isFoodType() || !produce.remove(goodsType)) continue block5;
                        produce.add((GoodsType)((Object)goodsType));
                        continue block5;
                    }
                    ((Unit)best).setLocation(tile);
                    WorkLocationPlan rawWlp = this.findPlan(raw, workPlans);
                    if (rawWlp == null) break;
                    if (produce.remove(raw)) {
                        produce.add(0, raw);
                    }
                    wlp = rawWlp;
                    lb.add("    retry with ", raw.getSuffix(), "\n");
                }
                wlps.remove(wlp);
                produce.remove(goodsType);
                lb.add("    needs more ", raw.getSuffix(), "\n");
            }
            for (Unit u : workers) {
                if (u.getLocation() == tile) continue;
                u.setLocation(tile);
            }
            if (col.getUnitCount() == 0) {
                if (this.getFoodPlans().isEmpty()) {
                    for (WorkLocation wl : col.getAvailableWorkLocations()) {
                        for (Unit u : new ArrayList<Unit>(workers)) {
                            for (GoodsType type : this.libertyGoodsTypes) {
                                if (!wl.canAdd(u) || wl.getPotentialProduction(type, u.getType()) <= 0) continue;
                                u.setLocation(wl);
                                u.changeWorkType(type);
                                workers.remove(u);
                                break block46;
                            }
                        }
                    }
                } else {
                    for (WorkLocationPlan w : this.getFoodPlans()) {
                        goodsType = w.getGoodsType();
                        WorkLocation wl = col.getCorresponding(w.getWorkLocation());
                        for (Unit u : new ArrayList<Unit>(workers)) {
                            GoodsType oldWork = u.getWorkType();
                            u.setLocation(wl);
                            u.changeWorkType((GoodsType)((Object)goodsType));
                            if (col.getAdjustedNetProductionOf(foodType) >= 0) {
                                lb.add("    Subsist with ", u, "\n");
                                workers.remove(u);
                                break block46;
                            }
                            u.setLocation(tile);
                            u.changeWorkType(oldWork);
                        }
                    }
                }
            }
        }
        ArrayList<Unit> experts = new ArrayList<Unit>();
        ArrayList<Unit> nonExperts = new ArrayList<Unit>();
        for (Unit u : col.getUnitList()) {
            if (u.getType().getExpertProduction() != null) {
                if (u.getType().getExpertProduction() == u.getWorkType()) continue;
                experts.add(u);
                continue;
            }
            nonExperts.add(u);
        }
        int expert = 0;
        while (expert < experts.size()) {
            Unit u1 = (Unit)experts.get(expert);
            Unit other = this.trySwapExpert(u1, experts, col);
            if (other != null) {
                lb.add("    Swapped ", u1.getId(), "(", u1.getType().getSuffix(), ") for ", other, "\n");
                experts.remove(u1);
                continue;
            }
            other = this.trySwapExpert(u1, nonExperts, col);
            if (other != null) {
                lb.add("    Swapped ", u1.getId(), "(", u1.getType().getSuffix(), ") for ", other, "\n");
                experts.remove(u1);
                continue;
            }
            ++expert;
        }
        for (Unit u : new ArrayList<Unit>(workers)) {
            Unit other;
            GoodsType work = u.getType().getExpertProduction();
            if (work == null || (other = this.trySwapExpert(u, col.getUnitList(), col)) == null) continue;
            lb.add("    Swapped ", u.getId(), "(", u.getType().getSuffix(), ") for ", other, "\n");
            workers.remove(u);
            workers.add(other);
        }
        Collections.sort(workers, comparator);
        for (Unit u : new ArrayList<Unit>(workers)) {
            Role role = u.getMilitaryRole();
            if (role == null) continue;
            if (!ColonyPlan.fullEquipUnit(this.spec(), u, role, col)) break;
            lb.add("    ", u.getId(), "(", u.getType().getSuffix(), ") -> ", u.getRoleSuffix(), "\n");
            workers.remove(u);
        }
        for (Unit u : col.getUnitList()) {
            if (u.hasDefaultRole()) continue;
            logger.warning("assignWorkers bogus role for " + u);
            u.changeRole(this.spec().getDefaultRole(), 0);
        }
        for (Unit u : workers) {
            lb.add("    ", u.getId(), "(", u.getType().getSuffix(), ") -> UNUSED\n");
        }
        if (col.getUnitCount() <= 0) {
            col = null;
        }
        return col;
    }

    private String locationDescription(Location loc) {
        String name = this.colony.getName() + "-";
        String desc = loc.toShortString();
        if (desc.startsWith(name)) {
            desc = desc.substring(name.length(), desc.length());
        }
        return desc;
    }

    public String toString() {
        WorkLocation wl;
        Tile tile = this.colony.getTile();
        LogBuilder lb = new LogBuilder(256);
        lb.add(new Object[]{"ColonyPlan: ", this.colony, " ", this.colony.getTile(), "\nProfile: ", this.profileType, "\nPreferred production:\n"});
        for (GoodsType goodsType : this.getPreferredProduction()) {
            lb.add(goodsType.getSuffix(), "\n");
        }
        lb.add(this.getBuildableReport(), "Food Plans:\n");
        for (WorkLocationPlan wlp : this.getFoodPlans()) {
            wl = wlp.getWorkLocation();
            lb.add(this.locationDescription(wl), ": ", wl.getGenericPotential(wlp.getGoodsType()), " ", wlp.getGoodsType().getSuffix(), "\n");
        }
        lb.add("Work Plans:\n");
        for (WorkLocationPlan wlp : this.getWorkPlans()) {
            wl = wlp.getWorkLocation();
            lb.add(this.locationDescription(wl), ": ", wl.getGenericPotential(wlp.getGoodsType()), " ", wlp.getGoodsType().getSuffix(), "\n");
        }
        return lb.toString();
    }

    private static class BuildPlan {
        public final BuildableType type;
        public double weight;
        public double support;
        public double difficulty;

        public BuildPlan(BuildableType type, double weight, double support) {
            this.type = type;
            this.weight = weight;
            this.support = support;
            this.difficulty = 1.0;
        }

        public double getValue() {
            return this.weight * this.support / this.difficulty;
        }

        public String toString() {
            return String.format("%s (%1.3f * %1.3f / %1.3f = %1.3f)", this.type.getSuffix(), this.weight, this.support, this.difficulty, this.getValue());
        }
    }

    private static enum ProfileType {
        OUTPOST,
        SMALL,
        MEDIUM,
        LARGE,
        CAPITAL;


        public static ProfileType getProfileTypeFromSize(int size) {
            return size <= 1 ? OUTPOST : (size <= 2 ? SMALL : (size <= 4 ? MEDIUM : (size <= 8 ? LARGE : CAPITAL)));
        }
    }
}

