/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;

public abstract class AIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    private static final Comparator<AIUnit> aiUnitLocationComparator = new Comparator<AIUnit>(){

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            Location l1;
            Location location = a1 == null ? null : (l1 = a1.getUnit() == null ? null : a1.getUnit().getLocation());
            Location l2 = a2 == null ? null : (a2.getUnit() == null ? null : a2.getUnit().getLocation());
            FreeColObject f1 = l1 instanceof WorkLocation ? l1.getColony() : (FreeColObject)((Object)l1);
            FreeColObject f2 = l2 instanceof WorkLocation ? l2.getColony() : (FreeColObject)((Object)l2);
            return FreeColObject.compareIds(f1, f2);
        }
    };
    private ServerPlayer player;
    private Random aiRandom;
    private Connection debuggingConnection;
    private final List<AIUnit> aiUnits = new ArrayList<AIUnit>();
    private static final String RANDOM_STATE_TAG = "randomState";

    public AIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.player = player;
        this.aiRandom = new Random(aiMain.getRandomSeed("Seed for " + this.getId()));
        this.uninitialized = false;
    }

    public AIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.player == null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Random getAIRandom() {
        return this.aiRandom;
    }

    protected void clearAIUnits() {
        this.aiUnits.clear();
    }

    public void addAIUnit(AIUnit aiUnit) {
        this.aiUnits.add(aiUnit);
    }

    public void removeAIUnit(AIUnit aiUnit) {
        aiUnit.dropTransport();
        aiUnit.changeMission(null);
        this.aiUnits.remove(aiUnit);
    }

    private void createAIUnits() {
        this.clearAIUnits();
        for (Unit u : this.getPlayer().getUnits()) {
            if (u.isDisposed()) {
                logger.warning("createAIUnits ignoring: " + u.getId());
                continue;
            }
            AIUnit a = this.getAIUnit(u);
            if (a != null) {
                if (a.getUnit() != u) {
                    throw new IllegalStateException("createAIUnits fail: " + u + "/" + a);
                }
                this.aiUnits.add(a);
                continue;
            }
            logger.warning("Could not find the AIUnit for: " + u + " (" + u.getId() + ")");
        }
    }

    protected String getAIAdvantage() {
        String prefix = "model.nationType.";
        String id = this.player == null || this.player.getNationType() == null ? "" : this.player.getNationType().getId();
        return id.startsWith("model.nationType.") ? id.substring("model.nationType.".length()) : "";
    }

    public Connection getConnection() {
        return this.debuggingConnection != null ? this.debuggingConnection : ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public void setDebuggingConnection(Connection debuggingConnection) {
        this.debuggingConnection = debuggingConnection;
    }

    public AIColony getAIColony(Colony colony) {
        return this.getAIMain().getAIColony(colony);
    }

    public List<AIColony> getAIColonies() {
        ArrayList<AIColony> ac = new ArrayList<AIColony>();
        for (Colony colony : this.getPlayer().getColonies()) {
            AIColony a = this.getAIColony(colony);
            if (a != null) {
                ac.add(a);
                continue;
            }
            logger.warning("Could not find the AIColony for: " + colony);
        }
        return ac;
    }

    public void removeAIColony(AIColony aic) {
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected List<AIUnit> getAIUnits() {
        if (this.aiUnits.isEmpty()) {
            this.createAIUnits();
        }
        return new ArrayList<AIUnit>(this.aiUnits);
    }

    protected Iterator<AIUnit> getAIUnitIterator() {
        if (this.aiUnits.isEmpty()) {
            this.createAIUnits();
        }
        return this.aiUnits.iterator();
    }

    protected Player.Stance determineStance(Player other) {
        return this.player.getStance(other).getStanceFromTension(this.player.getTension(other));
    }

    public int getSettlementDefenders(Settlement settlement) {
        int defenders = 0;
        for (AIUnit au : this.getAIUnits()) {
            DefendSettlementMission dm = au.getMission(DefendSettlementMission.class);
            if (dm == null || ((Mission)dm).getTarget() != settlement || au.getUnit().getSettlement() != settlement) continue;
            ++defenders;
        }
        return defenders;
    }

    public boolean isTargetValidForSeekAndDestroy(Unit attacker, Tile tile) {
        Player defenderPlayer;
        if (attacker == null) {
            return false;
        }
        Player attackerPlayer = attacker.getOwner();
        Settlement settlement = tile.getSettlement();
        Unit defender = tile.getDefendingUnit(attacker);
        Player player = settlement != null ? settlement.getOwner() : (defenderPlayer = defender != null ? defender.getOwner() : null);
        if (defenderPlayer == null) {
            return false;
        }
        if (attackerPlayer == defenderPlayer) {
            return false;
        }
        boolean atWar = attackerPlayer.atWarWith(defenderPlayer);
        if (attackerPlayer.isEuropean() ? !atWar : attackerPlayer.isIndian() && !atWar && attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) <= 0) {
            return false;
        }
        return attacker.canAttack(defender);
    }

    protected void logMissions(Map<Unit, String> reasons, LogBuilder lb) {
        List<AIUnit> units = this.getAIUnits();
        Collections.sort(units, aiUnitLocationComparator);
        for (AIUnit aiu : units) {
            Unit u = aiu.getUnit();
            String reason = reasons.get(u);
            if (reason == null) {
                reason = "OMITTED";
            }
            String ms = "NONE";
            Location target = null;
            if (aiu.hasMission()) {
                Mission m = aiu.getMission();
                ms = StringUtils.lastPart(m.getClass().toString(), ".");
                ms = ms.substring(0, ms.length() - "Mission".length());
                target = m.getTarget();
            }
            lb.add("\n  @", String.format("%-30s%-10s%-40s%-16s", StringUtils.chop(u.getLocation().toShortString(), 30), StringUtils.chop(reason, 10), StringUtils.chop(u.toShortString(), 40), StringUtils.chop(ms, 16)));
            if (target == null) continue;
            lb.add("->", target);
        }
    }

    public Mission getDefendCurrentSettlementMission(AIUnit aiUnit) {
        if (DefendSettlementMission.invalidReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = unit.getLocation();
        Settlement settlement = loc == null ? null : loc.getSettlement();
        return settlement != null && settlement.isBadlyDefended() ? this.getDefendSettlementMission(aiUnit, settlement) : null;
    }

    public Mission getDefendSettlementMission(AIUnit aiUnit, Settlement target) {
        return DefendSettlementMission.invalidReason(aiUnit) != null ? null : new DefendSettlementMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getIdleAtSettlementMission(AIUnit aiUnit) {
        return IdleAtSettlementMission.invalidReason(aiUnit) != null ? null : new IdleAtSettlementMission(this.getAIMain(), aiUnit);
    }

    public Mission getSeekAndDestroyMission(AIUnit aiUnit, int range) {
        Location loc = null;
        if (UnitSeekAndDestroyMission.invalidReason(aiUnit) == null) {
            loc = UnitSeekAndDestroyMission.findTarget(aiUnit, range, false);
        }
        return loc == null ? null : this.getSeekAndDestroyMission(aiUnit, loc);
    }

    public Mission getSeekAndDestroyMission(AIUnit aiUnit, Location loc) {
        return UnitSeekAndDestroyMission.invalidReason(aiUnit) != null || loc == null ? null : new UnitSeekAndDestroyMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getWanderHostileMission(AIUnit aiUnit) {
        return UnitWanderHostileMission.invalidReason(aiUnit) != null ? null : new UnitWanderHostileMission(this.getAIMain(), aiUnit);
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.player == null || this.player.isDisposed() || !this.player.isAI()) {
            result = -1;
        }
        return result;
    }

    public abstract void startWorking();

    protected List<AIUnit> doMissions(List<AIUnit> aiUnits, LogBuilder lb) {
        lb.add("\n  Do Missions:");
        ArrayList<AIUnit> result = new ArrayList<AIUnit>();
        for (AIUnit aiu : aiUnits) {
            Unit unit = aiu.getUnit();
            if (unit == null || unit.isDisposed()) continue;
            lb.add("\n  ", unit, " ");
            try {
                aiu.doMission(lb);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "doMissions failed for: " + aiu, e);
            }
            if (unit.isDisposed() || unit.getMovesLeft() <= 0) continue;
            result.add(aiu);
        }
        return result;
    }

    public abstract int adjustMission(AIUnit var1, PathNode var2, Class var3, int var4);

    public boolean indianDemand(Unit unit, Colony colony, GoodsType type, int amount) {
        return false;
    }

    public DiplomaticTrade.TradeStatus acceptDiplomaticTrade(DiplomaticTrade agreement) {
        return DiplomaticTrade.TradeStatus.REJECT_TRADE;
    }

    public abstract void registerSellGoods(Goods var1);

    public abstract int buyProposition(Unit var1, Settlement var2, Goods var3, int var4);

    public abstract int sellProposition(Unit var1, Settlement var2, Goods var3, int var4);

    public boolean acceptTax(int tax) {
        return false;
    }

    public boolean acceptMercenaries() {
        return false;
    }

    public FoundingFather selectFoundingFather(List<FoundingFather> ffs) {
        return null;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(RANDOM_STATE_TAG, Utils.getRandomState(this.aiRandom));
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.player = xr.findFreeColGameObject(aiMain.getGame(), "id", ServerPlayer.class, null, true);
        Random rnd = Utils.restoreRandomState(xr.getAttribute(RANDOM_STATE_TAG, null));
        this.aiRandom = rnd != null ? rnd : new Random(aiMain.getRandomSeed("Seed for " + this.getId()));
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        if (this.getPlayer() != null) {
            this.uninitialized = false;
        }
    }

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }
}

