/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.ValuedAIObject;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class AIColony
extends AIObject
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AIColony.class.getName());
    private static final String LIST_ELEMENT = "ListElement";
    private static final int FOREST_MINIMUM = 1;
    private static final int EXPORT_MINIMUM = 10;
    private Colony colony = null;
    private ColonyPlan colonyPlan = null;
    private final List<AIGoods> exportGoods = new ArrayList<AIGoods>();
    private final List<Wish> wishes = new ArrayList<Wish>();
    private final List<TileImprovementPlan> tileImprovementPlans = new ArrayList<TileImprovementPlan>();
    private Turn rearrangeTurn = new Turn(0);
    private static final Set<GoodsType> fullExport = new HashSet<GoodsType>();
    private static final Set<GoodsType> partExport = new HashSet<GoodsType>();
    private static final Comparator<Unit> pioneerComparator = new Comparator<Unit>(){

        private int score(Unit unit) {
            return unit == null ? -1000 : unit.getPioneerScore();
        }

        @Override
        public int compare(Unit u1, Unit u2) {
            return this.score(u2) - this.score(u1);
        }
    };
    private static final Comparator<Unit> scoutComparator = new Comparator<Unit>(){

        private int score(Unit unit) {
            return unit == null ? -1000 : unit.getScoutScore();
        }

        @Override
        public int compare(Unit u1, Unit u2) {
            return this.score(u2) - this.score(u1);
        }
    };
    private static final String AI_GOODS_LIST_TAG = AIGoods.getXMLElementTagName() + "ListElement";
    private static final String GOODS_WISH_LIST_TAG = GoodsWish.getXMLElementTagName() + "ListElement";
    private static final String TILE_IMPROVEMENT_PLAN_LIST_TAG = TileImprovementPlan.getXMLElementTagName() + "ListElement";
    private static final String WORKER_WISH_LIST_TAG = WorkerWish.getXMLElementTagName() + "ListElement";
    private static final String OLD_GOODS_WISH_TAG = GoodsWish.getXMLElementTagName() + "Wish" + "ListElement";
    private static final String OLD_TILE_IMPROVEMENT_PLAN_TAG = "tileimprovementplanListElement";
    private static final String OLD_WORKER_WISH_TAG = WorkerWish.getXMLElementTagName() + "Wish" + "ListElement";

    public AIColony(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public AIColony(AIMain aiMain, Colony colony) {
        this(aiMain, colony.getId());
        this.colony = colony;
        colony.addPropertyChangeListener("rearrangeWorkers", this);
        this.uninitialized = false;
    }

    public AIColony(AIMain aiMain, Element element) {
        this(aiMain, (String)null);
        this.readFromXMLElement(element);
        this.addAIObjectWithId();
        this.uninitialized = this.getColony() == null;
    }

    public AIColony(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        this(aiMain, (String)null);
        this.readFromXML(xr);
        this.addAIObjectWithId();
        this.uninitialized = this.getColony() == null;
    }

    public final Colony getColony() {
        return this.colony;
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.colony.getOwner());
    }

    public boolean isBadlyDefended() {
        return this.colony.isBadlyDefended();
    }

    public void update(LogBuilder lb) {
        lb.add("\n  ", this.colony.getName());
        this.resetExports();
        this.updateAIGoods(lb);
        this.updateTileImprovementPlans(lb);
        this.updateWishes(lb);
    }

    public Collection<AIUnit> rearrangeWorkers(LogBuilder lb) {
        AIMain aiMain = this.getAIMain();
        HashSet<AIUnit> result = new HashSet<AIUnit>();
        if (this.colony.getUnitCount() <= 0 && !this.avertAutoDestruction()) {
            return result;
        }
        int turn = this.getGame().getTurn().getNumber();
        if (this.rearrangeTurn.getNumber() > turn) {
            if (this.colony.getCurrentlyBuilding() == null && this.colonyPlan != null && this.colonyPlan.getBestBuildableType() != null) {
                logger.warning(this.colony.getName() + " could be building but" + " is asleep until turn: " + this.rearrangeTurn.getNumber() + "( > " + turn + ")");
            } else {
                return result;
            }
        }
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        Specification spec = this.getSpecification();
        lb.add("\n  ", this.colony.getName());
        int nextRearrange = 15;
        this.exploreLCRs();
        this.stealTiles(lb);
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (player.owns(t) || !player.canClaimForSettlement(t)) continue;
            AIMessage.askClaimLand(t, this, 0);
            if (!player.owns(t)) continue;
            lb.add(", claimed tile ", t);
        }
        if (this.colonyPlan == null) {
            this.colonyPlan = new ColonyPlan(aiMain, this.colony);
        }
        this.colonyPlan.update();
        BuildableType oldBuild = this.colony.getCurrentlyBuilding();
        BuildableType build = this.colonyPlan.getBestBuildableType();
        if (build != oldBuild) {
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            if (build != null) {
                queue.add(build);
            }
            AIMessage.askSetBuildQueue(this, queue);
            build = this.colony.getCurrentlyBuilding();
        }
        this.colonyPlan.refine(build, lb);
        List<Unit> workers = this.colony.getUnitList();
        ArrayList<UnitWas> was = new ArrayList<UnitWas>();
        for (Unit u : workers) {
            Location loc = u.getLocation();
            was.add(new UnitWas(u));
        }
        for (Unit u : tile.getUnitList()) {
            Mission m;
            if (!u.isPerson() || u.hasAbility("model.ability.refUnit") || this.getAIUnit(u) == null || (m = this.getAIUnit(u).getMission()) != null && (!(m instanceof BuildColonyMission) || !Map.isSameLocation(m.getTarget(), tile) && this.colony.getUnitCount() > 1) && !(m instanceof DefendSettlementMission) && !(m instanceof IdleAtSettlementMission) && !(m instanceof WorkInsideColonyMission)) continue;
            workers.add(u);
            was.add(new UnitWas(u));
        }
        EuropeanAIPlayer aiPlayer = (EuropeanAIPlayer)this.getAIOwner();
        LogBuilder aw = new LogBuilder(256);
        boolean preferScouts = aiPlayer.scoutsNeeded() > 0;
        Colony scratch = this.colonyPlan.assignWorkers(new ArrayList<Unit>(workers), preferScouts, aw);
        if (scratch == null) {
            lb.add(", failed to assign workers.");
            this.rearrangeTurn = new Turn(turn + 1);
            return result;
        }
        lb.add(", assigned ", workers.size(), " workers");
        AIMessage.askRearrangeColony(this, workers, scratch);
        if (this.colony.getUnitCount() <= 0) {
            lb.add(", autodestruct detected");
            String destruct = "Autodestruct at " + this.colony.getName() + " in " + turn + ":";
            for (UnitWas uw : was) {
                destruct = destruct + "\n" + uw;
            }
            logger.warning(destruct);
            if (!this.avertAutoDestruction()) {
                return result;
            }
        }
        if (build != null && !this.colony.canBuild(build)) {
            BuildableType newBuild = this.colonyPlan.getBestBuildableType();
            lb.add(new Object[]{", reneged building ", build.getSuffix(), " (", this.colony.getNoBuildReason(build, null), ")"});
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            if (newBuild != null) {
                queue.add(newBuild);
            }
            AIMessage.askSetBuildQueue(this, queue);
            nextRearrange = 1;
        }
        if (this.colony.getNetProductionOf(spec.getPrimaryFoodType()) < 0) {
            int net = this.colony.getNetProductionOf(spec.getPrimaryFoodType());
            int when = this.colony.getGoodsCount(spec.getPrimaryFoodType()) / -net;
            nextRearrange = Math.max(0, Math.min(nextRearrange, when - 1));
        }
        int warehouse = this.colony.getWarehouseCapacity();
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (!g.isStorable() || g.isFoodType()) continue;
            int have = this.colony.getGoodsCount(g);
            int net = this.colony.getAdjustedNetProductionOf(g);
            if (net >= 0 && (have >= warehouse || g.limitIgnored())) continue;
            int when = net < 0 ? have / -net - 1 : (net > 0 ? (warehouse - have) / net - 1 : Integer.MAX_VALUE);
            nextRearrange = Math.max(1, Math.min(nextRearrange, when));
        }
        for (Unit u : this.colony.getUnitList()) {
            AIUnit aiu = this.getAIUnit(u);
            WorkInsideColonyMission wic = aiu.getMission(WorkInsideColonyMission.class);
            if (wic != null) continue;
            if (aiPlayer.getWorkInsideColonyMission(aiu, this) == null) {
                result.add(aiu);
                continue;
            }
            lb.add(", ", aiu.getMission());
            aiu.dropTransport();
        }
        int tipSize = this.tileImprovementPlans.size();
        if (tipSize > 0) {
            ArrayList pioneers = new ArrayList();
            for (Unit u : tile.getUnitList()) {
                if (u.getPioneerScore() < 0) continue;
                pioneers.add(u);
            }
            Collections.sort(pioneers, pioneerComparator);
            Iterator<Unit> aiu = pioneers.iterator();
            while (aiu.hasNext()) {
                Location oldTarget;
                Unit u = aiu.next();
                AIUnit aiu2 = this.getAIUnit(u);
                Mission m = aiu2.getMission();
                Location location = oldTarget = m == null ? null : m.getTarget();
                m = aiPlayer.getPioneeringMission(aiu2, null);
                if (m == null) continue;
                lb.add(", ", aiu2.getMission());
                aiPlayer.updateTransport(aiu2, oldTarget, lb);
                if (--tipSize > 0) continue;
                break;
            }
        }
        for (Unit u : tile.getUnitList()) {
            Location oldTarget;
            AIUnit aiu = this.getAIUnit(u);
            Mission m = aiu.getMission();
            if (m instanceof BuildColonyMission || m instanceof DefendSettlementMission || m instanceof MissionaryMission || m instanceof PioneeringMission || m instanceof ScoutingMission || m instanceof UnitSeekAndDestroyMission) continue;
            Location location = oldTarget = m == null ? null : m.getTarget();
            if (u.hasAbility("model.ability.speakWithChief") && (m = aiPlayer.getScoutingMission(aiu)) != null) {
                lb.add(", ", m);
                aiPlayer.updateTransport(aiu, oldTarget, lb);
                continue;
            }
            if (u.isDefensiveUnit() && (m = aiPlayer.getDefendSettlementMission(aiu, this.colony)) != null) {
                lb.add(", ", m);
                aiPlayer.updateTransport(aiu, oldTarget, lb);
                continue;
            }
            if (u.hasAbility("model.ability.establishMission") && (m = aiPlayer.getMissionaryMission(aiu)) != null) {
                lb.add(", ", m);
                aiPlayer.updateTransport(aiu, oldTarget, lb);
                continue;
            }
            result.add(aiu);
        }
        build = this.colony.getCurrentlyBuilding();
        String buildStr = build != null ? build.toString() : ((build = this.colonyPlan.getBestBuildableType()) != null ? "unexpected-null(" + build + ")" : "expected-null");
        lb.add(", building ", buildStr, ", population ", this.colony.getUnitCount(), ", rearrange ", nextRearrange, ".\n");
        lb.add(aw.toString());
        lb.shrink("\n");
        for (UnitWas uw : was) {
            lb.add("\n  ", uw);
        }
        this.rearrangeTurn = new Turn(turn + nextRearrange);
        return result;
    }

    private void resetExports() {
        Specification spec = this.getSpecification();
        Player player = this.colony.getOwner();
        fullExport.clear();
        partExport.clear();
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (!g.isStorable() || g.isFoodType() || g.isBuildingMaterial() || g.isMilitaryGoods() || g.isTradeGoods()) continue;
            if (g.isRawMaterial()) {
                partExport.add(g);
                continue;
            }
            fullExport.add(g);
        }
        for (Role role : spec.getRoles()) {
            if (!role.isAvailableTo(player, spec.getDefaultUnitType())) continue;
            for (AbstractGoods ag : role.getRequiredGoods()) {
                if (!fullExport.contains(ag.getType())) continue;
                fullExport.remove(ag.getType());
                partExport.add(ag.getType());
            }
        }
        if (this.colony.getOwner().getMarket() == null) {
            for (GoodsType g : spec.getGoodsTypeList()) {
                this.colony.getExportData(g).setExported(false);
            }
        } else {
            int exportLevel = 4 * this.colony.getWarehouseCapacity() / 5;
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (fullExport.contains(g)) {
                    this.colony.getExportData(g).setExportLevel(0);
                    this.colony.getExportData(g).setExported(true);
                    continue;
                }
                if (partExport.contains(g)) {
                    this.colony.getExportData(g).setExportLevel(exportLevel);
                    this.colony.getExportData(g).setExported(true);
                    continue;
                }
                this.colony.getExportData(g).setExported(false);
            }
        }
    }

    private void exploreLCRs() {
        Tile tile = this.colony.getTile();
        ArrayList<Unit> explorers = new ArrayList<Unit>();
        for (Unit u : tile.getUnitList()) {
            if (!u.isPerson() || u.getType().getSkill() > 0 && !u.hasAbility("model.ability.expertScout")) continue;
            explorers.add(u);
        }
        Collections.sort(explorers, scoutComparator);
        for (Tile t : tile.getSurroundingTiles(1)) {
            Unit u;
            if (!t.hasLostCityRumour()) continue;
            Map.Direction direction = tile.getDirection(t);
            do {
                if (!explorers.isEmpty()) continue;
                return;
            } while (!(u = (Unit)explorers.remove(0)).getMoveType(t).isProgress() || !this.getAIUnit(u).move(direction) || t.hasLostCityRumour());
            u.setDestination(tile);
        }
    }

    private void stealTiles(LogBuilder lb) {
        Specification spec = this.getSpecification();
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        boolean hasDefender = false;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.isDefensiveUnit() || this.getAIUnit(unit).getMission(DefendSettlementMission.class) == null) continue;
            hasDefender = true;
            break;
        }
        if (!hasDefender) {
            return;
        }
        ArrayList<GoodsType> needed = new ArrayList<GoodsType>();
        for (GoodsType g : spec.getRawBuildingGoodsTypeList()) {
            if (this.colony.getTotalProductionOf(g) > 0) continue;
            needed.add(g);
        }
        UnitType unitType = spec.getDefaultUnitType();
        Tile steal = null;
        float score = 1.0f;
        for (Tile t : tile.getSurroundingTiles(1)) {
            Player owner = t.getOwner();
            if (owner == null || owner == player || owner.isEuropean() || !player.canClaimForSettlement(t)) continue;
            if (owner.atWarWith(player)) {
                if (!AIMessage.askClaimLand(t, this, -1) || !player.owns(t)) continue;
                lb.add(", stole tile ", t, " from hostile ", owner.getName());
                continue;
            }
            float s = 0.0f;
            for (GoodsType g : needed) {
                s += (float)t.getPotentialProduction(g, unitType);
            }
            for (GoodsType g : spec.getFoodGoodsTypeList()) {
                s = (float)((double)s + 0.1 * (double)t.getPotentialProduction(g, unitType));
            }
            if (!(s > score)) continue;
            score = s;
            steal = t;
        }
        if (steal != null) {
            Player owner = steal.getOwner();
            if (AIMessage.askClaimLand(steal, this, -1) && player.owns(steal)) {
                lb.add(", stole tile ", steal, " (score = ", Float.valueOf(score), ") from ", owner.getName());
            }
        }
    }

    private boolean avertAutoDestruction() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("Colony ", this.colony.getName(), " rearrangement leaves no units, ", this.colony.getTile().getUnitCount(), " available:");
        for (Unit u : this.colony.getTile().getUnitList()) {
            lb.add(" ", u);
        }
        List<GoodsType> libertyGoods = this.getSpecification().getLibertyGoodsTypeList();
        block1: for (Unit u : this.colony.getTile().getUnitList()) {
            if (!u.isPerson()) continue;
            for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
                if (!wl.canAdd(u)) continue;
                for (GoodsType type : libertyGoods) {
                    if (wl.getPotentialProduction(type, u.getType()) <= 0 || !AIMessage.askWork(this.getAIUnit(u), wl) || u.getLocation() != wl) continue;
                    AIMessage.askChangeWorkType(this.getAIUnit(u), type);
                    lb.add(", averts destruction with ", u);
                    break block1;
                }
            }
        }
        lb.log(logger, Level.WARNING);
        return this.colony.getUnitCount() > 0;
    }

    public void stopUsing(WorkLocation wl) {
        for (Unit u : wl.getUnitList()) {
            AIMessage.askPutOutsideColony(this.getAIUnit(u));
        }
        if (this.colony.getUnitCount() <= 0) {
            this.avertAutoDestruction();
        }
        this.rearrangeTurn = new Turn(this.getGame().getTurn().getNumber());
    }

    public List<AIGoods> getAIGoods() {
        return new ArrayList<AIGoods>(this.exportGoods);
    }

    public void removeAIGoods(AIGoods ag) {
        while (this.exportGoods.remove(ag)) {
        }
    }

    private void dropGoods(AIGoods ag) {
        TransportMission tm;
        if (ag.getTransport() != null && (tm = ag.getTransport().getMission(TransportMission.class)) != null) {
            tm.removeTransportable(ag);
        }
        this.removeAIGoods(ag);
        ag.dispose();
    }

    private void goodsLog(AIGoods ag, String action, LogBuilder lb) {
        Goods goods = ag == null ? null : ag.getGoods();
        int amount = goods == null ? -1 : goods.getAmount();
        String type = goods == null ? "(null)" : ag.getGoods().getType().getSuffix();
        lb.add(", ", action, " ", ag == null ? "(null)" : ag.getId(), " ", amount >= 100 ? "full " : Integer.toString(amount) + " ", type);
    }

    private void updateAIGoods(LogBuilder lb) {
        if (this.colony.hasAbility("model.ability.export")) {
            while (!this.exportGoods.isEmpty()) {
                AIGoods ag = this.exportGoods.remove(0);
                this.goodsLog(ag, "customizes", lb);
                this.dropGoods(ag);
            }
        } else {
            int i = 0;
            while (i < this.exportGoods.size()) {
                AIGoods ag = this.exportGoods.get(i);
                if (ag == null) {
                    this.exportGoods.remove(i);
                    continue;
                }
                if (ag.checkIntegrity(false) < 0) {
                    this.goodsLog(ag, "reaps", lb);
                    this.exportGoods.remove(i);
                    this.dropGoods(ag);
                    continue;
                }
                if (ag.getGoods().getLocation() != this.colony) {
                    this.goodsLog(ag, "sends", lb);
                    this.exportGoods.remove(i);
                    continue;
                }
                if (this.colony.getAdjustedNetProductionOf(ag.getGoods().getType()) < 0) {
                    this.goodsLog(ag, "needs", lb);
                    this.exportGoods.remove(i);
                    this.dropGoods(ag);
                    continue;
                }
                ++i;
            }
            Europe europe = this.colony.getOwner().getEurope();
            int capacity = this.colony.getWarehouseCapacity();
            ArrayList<AIGoods> newAIGoods = new ArrayList<AIGoods>();
            for (GoodsType g : this.getSpecification().getGoodsTypeList()) {
                Europe destination;
                int exportAmount;
                if (this.colony.getAdjustedNetProductionOf(g) < 0) continue;
                int count = this.colony.getGoodsCount(g);
                int n = fullExport.contains(g) ? count : (exportAmount = partExport.contains(g) ? count - this.colony.getExportData(g).getExportLevel() : -1);
                int priority = exportAmount >= capacity ? 110 : (exportAmount >= 100 ? 100 : 0);
                i = 0;
                while (i < this.exportGoods.size()) {
                    AIGoods ag = this.exportGoods.get(i);
                    Goods goods = ag.getGoods();
                    if (goods.getType() != g) {
                        ++i;
                        continue;
                    }
                    int amount = goods.getAmount();
                    if (amount <= exportAmount) {
                        if (amount < 100) {
                            amount = Math.min(exportAmount, 100);
                            goods.setAmount(amount);
                            ag.setTransportPriority(priority);
                        }
                        this.goodsLog(ag, "exports", lb);
                    } else if (exportAmount >= 10) {
                        goods.setAmount(exportAmount);
                        this.goodsLog(ag, "clamps", lb);
                    } else {
                        this.goodsLog(ag, "unexports", lb);
                        this.dropGoods(ag);
                        continue;
                    }
                    exportAmount -= amount;
                    ++i;
                }
                Europe europe2 = destination = this.colony.getOwner().canTrade(g) ? europe : null;
                while (exportAmount >= 10) {
                    int amount = Math.min(100, exportAmount);
                    AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, g, amount, destination);
                    newGoods.setTransportPriority(priority);
                    newAIGoods.add(newGoods);
                    this.goodsLog(newGoods, "makes", lb);
                    exportAmount -= amount;
                }
            }
            this.exportGoods.addAll(newAIGoods);
            Collections.sort(this.exportGoods);
        }
    }

    public void addWish(Wish wish) {
        this.wishes.add(wish);
    }

    public boolean completeWish(Wish wish, String reason, LogBuilder lb) {
        if (!this.wishes.remove(wish)) {
            lb.add(", ", reason, " not wished for at ", this.colony.getName());
            return false;
        }
        ((EuropeanAIPlayer)this.getAIOwner()).completeWish(wish);
        lb.add(", ", reason, " fulfills at ", this.colony.getName());
        wish.dispose();
        this.requestRearrange();
        return true;
    }

    public boolean completeWish(Goods goods, LogBuilder lb) {
        boolean ret = false;
        int i = 0;
        while (i < this.wishes.size()) {
            GoodsWish gw;
            if (this.wishes.get(i) instanceof GoodsWish && (gw = (GoodsWish)this.wishes.get(i)).satisfiedBy(goods) && this.completeWish(gw, goods.toString(), lb)) {
                ret = true;
                continue;
            }
            ++i;
        }
        return ret;
    }

    public boolean completeWish(Unit unit, LogBuilder lb) {
        boolean ret = false;
        int i = 0;
        while (i < this.wishes.size()) {
            WorkerWish ww;
            if (this.wishes.get(i) instanceof WorkerWish && (ww = (WorkerWish)this.wishes.get(i)).satisfiedBy(unit) && this.completeWish(ww, unit.toShortString(), lb)) {
                ret = true;
                continue;
            }
            ++i;
        }
        return ret;
    }

    public boolean completeWish(TransportableAIObject t, LogBuilder lb) {
        AIUnit aiUnit;
        WishRealizationMission wm;
        if (t instanceof AIGoods) {
            return this.completeWish((Goods)t.getTransportLocatable(), lb);
        }
        if (t instanceof AIUnit && (wm = (aiUnit = (AIUnit)t).getMission(WishRealizationMission.class)) != null && Map.isSameLocation(wm.getTarget(), this.colony)) {
            lb.add(", at wish-target");
            this.completeWish(aiUnit.getUnit(), lb);
            aiUnit.changeMission(null);
            return true;
        }
        return false;
    }

    public List<Wish> getWishes() {
        return new ArrayList<Wish>(this.wishes);
    }

    public List<GoodsWish> getGoodsWishes() {
        ArrayList<GoodsWish> result = new ArrayList<GoodsWish>();
        for (Wish wish : this.wishes) {
            if (!(wish instanceof GoodsWish)) continue;
            result.add((GoodsWish)wish);
        }
        return result;
    }

    public List<WorkerWish> getWorkerWishes() {
        ArrayList<WorkerWish> result = new ArrayList<WorkerWish>();
        for (Wish wish : this.wishes) {
            if (!(wish instanceof WorkerWish)) continue;
            result.add((WorkerWish)wish);
        }
        return result;
    }

    public void requireGoodsWish(GoodsType type, int amount, int value, LogBuilder lb) {
        ValuedAIObject gw = null;
        for (Wish w : this.wishes) {
            if (!(w instanceof GoodsWish) || ((GoodsWish)w).getGoodsType() != type) continue;
            gw = (GoodsWish)w;
            break;
        }
        if (gw != null) {
            ((GoodsWish)gw).update(type, amount, gw.getValue() + 1);
            lb.add(", update ", gw);
        } else {
            gw = new GoodsWish(this.getAIMain(), this.colony, value, amount, type);
            this.wishes.add((Wish)gw);
            lb.add(", add ", gw);
        }
    }

    public void requireWorkerWish(UnitType type, boolean expertNeeded, int value, LogBuilder lb) {
        ValuedAIObject ww = null;
        for (Wish w : this.wishes) {
            if (!(w instanceof WorkerWish) || ((WorkerWish)w).getUnitType() != type) continue;
            ww = (WorkerWish)w;
            break;
        }
        if (ww != null) {
            ((WorkerWish)ww).update(type, expertNeeded, ww.getValue() + 1);
            lb.add(", update ", ww);
        } else {
            ww = new WorkerWish(this.getAIMain(), this.colony, value, type, expertNeeded);
            this.wishes.add((Wish)ww);
            lb.add(", add ", ww);
        }
    }

    private void updateWishes(LogBuilder lb) {
        this.updateWorkerWishes(lb);
        this.updateGoodsWishes(lb);
        Collections.sort(this.wishes);
    }

    private void updateWorkerWishes(LogBuilder lb) {
        UnitType unitType;
        GoodsType goods;
        Specification spec = this.getSpecification();
        int baseValue = 25;
        int priorityMax = 50;
        int priorityDecay = 5;
        int multipleBonus = 5;
        int multipleMax = 5;
        ArrayList<GoodsType> producing = new ArrayList<GoodsType>();
        for (WorkLocation workLocation : this.colony.getAvailableWorkLocations()) {
            for (Unit u : workLocation.getUnitList()) {
                GoodsType work = u.getWorkType();
                if (work == null || producing.contains(work = work.getStoredAs())) continue;
                producing.add(work);
            }
        }
        Collections.sort(producing, new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                return AIColony.this.colony.getAdjustedNetProductionOf(g1) - AIColony.this.colony.getAdjustedNetProductionOf(g2);
            }
        });
        TypeCountMap<UnitType> experts = new TypeCountMap<UnitType>();
        for (Unit unit : this.colony.getUnitList()) {
            goods = unit.getWorkType();
            UnitType expert = goods == null || goods == unit.getType().getExpertProduction() ? null : spec.getExpertForProducing(goods);
            if (expert == null) continue;
            experts.incrementCount(expert, 1);
        }
        for (UnitType expert : experts.keySet()) {
            goods = expert.getExpertProduction();
            int value = 25 + Math.max(0, 50 - 5 * producing.indexOf(goods)) + Math.min(5, experts.getCount(expert) - 1) * 5;
            this.requireWorkerWish(expert, true, value, lb);
        }
        if (this.colonyPlan != null && experts.isEmpty() && this.colony.governmentChange(this.colony.getUnitCount() + 1) >= 0) {
            UnitType expert;
            boolean bl = this.colony.getFoodProduction() <= this.colony.getFoodConsumption() + this.colony.getOwner().getMaximumFoodConsumption();
            expert = spec.getDefaultUnitType();
            for (WorkLocationPlan plan : bl ? this.colonyPlan.getFoodPlans() : this.colonyPlan.getWorkPlans()) {
                WorkLocation location = plan.getWorkLocation();
                if (!location.canBeWorked()) continue;
                expert = spec.getExpertForProducing(plan.getGoodsType());
                break;
            }
            this.requireWorkerWish(expert, false, 50, lb);
        }
        if (this.isBadlyDefended() && (unitType = this.colony.getBestDefenderType()) != null) {
            this.requireWorkerWish(unitType, true, 100, lb);
        }
    }

    private void updateGoodsWishes(LogBuilder lb) {
        Specification spec = this.getSpecification();
        int goodsWishValue = 50;
        TypeCountMap<GoodsType> required = new TypeCountMap<GoodsType>();
        if (this.colony.getCurrentlyBuilding() != null) {
            for (AbstractGoods iterator : this.colony.getCurrentlyBuilding().getRequiredGoods()) {
                if (this.colony.getAdjustedNetProductionOf(iterator.getType()) > 0) continue;
                required.incrementCount(iterator.getType(), iterator.getAmount());
            }
        }
        for (TileImprovementPlan tileImprovementPlan : this.tileImprovementPlans) {
            Role role = tileImprovementPlan.getType().getRequiredRole();
            if (role == null) continue;
            for (AbstractGoods ag : role.getRequiredGoods()) {
                required.incrementCount(ag.getType(), ag.getAmount());
            }
        }
        for (WorkLocation workLocation : this.colony.getCurrentWorkLocations()) {
            Object info;
            Object building;
            List<AbstractGoods> inputs;
            if (!(workLocation instanceof Building) || (inputs = ((WorkLocation)(building = (Building)workLocation)).getInputs()).isEmpty() || ((ProductionInfo)(info = this.colony.getProductionInfo(building))).hasMaximumProduction()) continue;
            for (AbstractGoods goods : inputs) {
                required.incrementCount(goods.getType(), 100);
            }
        }
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            if (!goodsType.isBreedable() || this.colony.getGoodsCount(goodsType) >= goodsType.getBreedingNumber()) continue;
            required.incrementCount(goodsType, goodsType.getBreedingNumber());
        }
        if (this.isBadlyDefended()) {
            Role role = spec.getMilitaryRoles().get(0);
            Player player = this.colony.getOwner();
            for (Unit unit : this.colony.getTile().getUnitList()) {
                if (!unit.roleIsAvailable(role) || !unit.hasDefaultRole() && !Role.isCompatibleWith(role, unit.getRole())) continue;
                for (AbstractGoods ag : role.getRequiredGoods()) {
                    required.incrementCount(ag.getType(), ag.getAmount());
                }
            }
        }
        int i = 0;
        while (i < this.wishes.size()) {
            GoodsWish goodsWish;
            GoodsType t;
            if (this.wishes.get(i) instanceof GoodsWish && required.getCount(t = (goodsWish = (GoodsWish)this.wishes.get(i)).getGoodsType()) < this.colony.getGoodsCount(t)) {
                this.completeWish(goodsWish, "redundant", lb);
                continue;
            }
            ++i;
        }
        Iterator iterator = required.keySet().iterator();
        while (iterator.hasNext()) {
            int amount;
            GoodsType type;
            GoodsType requiredType;
            for (requiredType = type = (GoodsType)iterator.next(); requiredType != null && !requiredType.isStorable(); requiredType = requiredType.getInputType()) {
            }
            if (requiredType == null || (amount = Math.min(this.colony.getWarehouseCapacity(), required.getCount(type) - this.colony.getGoodsCount(requiredType))) <= 0) continue;
            int value = goodsWishValue;
            if (this.colony.canProduce(requiredType)) {
                value /= 10;
            }
            this.requireGoodsWish(requiredType, amount, value, lb);
        }
    }

    public List<TileImprovementPlan> getTileImprovementPlans() {
        return new ArrayList<TileImprovementPlan>(this.tileImprovementPlans);
    }

    public boolean removeTileImprovementPlan(TileImprovementPlan plan) {
        return this.tileImprovementPlans.remove(plan);
    }

    private TileImprovementPlan getPlanFor(Tile tile, List<TileImprovementPlan> plans) {
        for (TileImprovementPlan tip : plans) {
            if (tip.getTarget() != tile) continue;
            return tip;
        }
        return null;
    }

    public void updateTileImprovementPlans(LogBuilder lb) {
        ArrayList<TileImprovementPlan> newPlans = new ArrayList<TileImprovementPlan>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            ColonyTile colonyTile;
            Tile workTile;
            if (!(wl instanceof ColonyTile) || (workTile = (colonyTile = (ColonyTile)wl).getWorkTile()).getOwningSettlement() != this.colony || this.getPlanFor(workTile, newPlans) != null) continue;
            GoodsType goodsType = null;
            if (colonyTile.isColonyCenterTile()) {
                for (AbstractGoods ag : colonyTile.getProduction()) {
                    if (!ag.getType().isFoodType()) continue;
                    goodsType = ag.getType();
                    break;
                }
            } else {
                if (colonyTile.isEmpty()) continue;
                goodsType = colonyTile.getUnitList().get(0).getWorkType();
            }
            if (goodsType == null) continue;
            TileImprovementPlan plan = this.getPlanFor(workTile, this.tileImprovementPlans);
            if (plan == null) {
                TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(workTile, goodsType);
                if (type != null) {
                    plan = new TileImprovementPlan(this.getAIMain(), workTile, type, type.getImprovementValue(workTile, goodsType));
                }
            } else if (!plan.update(goodsType)) {
                plan = null;
            }
            if (plan == null) continue;
            TileType change = plan.getType().getChange(workTile.getType());
            if (change != null && !change.isForested()) {
                int forest = 0;
                for (WorkLocation f : this.colony.getAvailableWorkLocations()) {
                    if (!(f instanceof ColonyTile) || !((ColonyTile)f).getWorkTile().isForested()) continue;
                    ++forest;
                }
                if (forest <= 1) continue;
            }
            newPlans.add(plan);
        }
        this.tileImprovementPlans.clear();
        this.tileImprovementPlans.addAll(newPlans);
        Collections.sort(this.tileImprovementPlans);
        if (!this.tileImprovementPlans.isEmpty()) {
            lb.add(", improve:");
            for (TileImprovementPlan tip : this.tileImprovementPlans) {
                lb.add(" ", tip.getTarget(), "-", tip.getType().getSuffix());
            }
        }
    }

    public List<BuildableType> getPlannedBuildableTypes() {
        return this.colonyPlan == null ? Collections.emptyList() : this.colonyPlan.getBuildableTypes();
    }

    public String planToString() {
        if (this.colonyPlan == null) {
            return "No plan.";
        }
        LogBuilder lb = new LogBuilder(256);
        lb.add(this.colonyPlan, "\n\nTILE IMPROVEMENTS:\n");
        for (TileImprovementPlan tip : this.getTileImprovementPlans()) {
            lb.add(tip, "\n");
        }
        lb.add("\n\nWISHES:\n");
        for (Wish w : this.getWishes()) {
            lb.add(w, "\n");
        }
        lb.add("\n\nEXPORT GOODS:\n");
        for (AIGoods aig : this.getAIGoods()) {
            lb.add(aig, "\n");
        }
        return lb.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("Property change REARRANGE_WORKERS fired.");
        this.requestRearrange();
        if (event != null && event.getOldValue() instanceof GoodsType) {
            GoodsType goodsType = (GoodsType)event.getOldValue();
            int left = this.colony.getGoodsCount(goodsType);
            AIGoods export = null;
            for (int i = 0; i < this.exportGoods.size(); ++i) {
                export = this.exportGoods.get(i);
                if (export.isDisposed()) {
                    this.exportGoods.remove(i);
                    break;
                }
                if (export.getGoods() == null) {
                    this.exportGoods.remove(i);
                    export.changeTransport(null);
                    break;
                }
                if (export.getGoodsType() != goodsType) continue;
                if (left > 0) {
                    export.getGoods().setAmount(left);
                    break;
                }
                this.exportGoods.remove(i);
                export.changeTransport(null);
                break;
            }
        }
    }

    public void requestRearrange() {
        this.rearrangeTurn = new Turn(0);
    }

    @Override
    public void dispose() {
        ArrayList<ValuedAIObject> objects = new ArrayList<ValuedAIObject>();
        for (AIGoods aIGoods : this.exportGoods) {
            if (aIGoods.isDisposed() || aIGoods.getGoods() == null || aIGoods.getGoods().getLocation() != this.colony) continue;
            objects.add(aIGoods);
        }
        objects.addAll(this.wishes);
        this.wishes.clear();
        objects.addAll(this.tileImprovementPlans);
        this.tileImprovementPlans.clear();
        for (AIObject aIObject : objects) {
            aIObject.dispose();
        }
        this.colonyPlan = null;
        super.dispose();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.colony == null || this.colony.isDisposed()) {
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (AIGoods ag : this.exportGoods) {
            if (ag.checkIntegrity(true) < 0) continue;
            xw.writeStartElement(AI_GOODS_LIST_TAG);
            xw.writeAttribute("id", ag);
            xw.writeEndElement();
        }
        for (TileImprovementPlan tip : this.tileImprovementPlans) {
            if (tip.checkIntegrity(true) < 0) continue;
            xw.writeStartElement(TILE_IMPROVEMENT_PLAN_LIST_TAG);
            xw.writeAttribute("id", tip);
            xw.writeEndElement();
        }
        for (Wish w : this.wishes) {
            String tag;
            String string = w instanceof GoodsWish ? GOODS_WISH_LIST_TAG : (tag = w instanceof WorkerWish ? WORKER_WISH_LIST_TAG : null);
            if (w.checkIntegrity(true) < 0 || !w.shouldBeStored() || tag == null) continue;
            xw.writeStartElement(tag);
            xw.writeAttribute("id", w);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.colony = xr.getAttribute(aiMain.getGame(), "id", Colony.class, (Colony)null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.exportGoods.clear();
        this.tileImprovementPlans.clear();
        this.wishes.clear();
        super.readChildren(xr);
        if (this.getColony() != null) {
            this.uninitialized = false;
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        String tag = xr.getLocalName();
        if (AI_GOODS_LIST_TAG.equals(tag)) {
            this.exportGoods.add(xr.makeAIObject(aiMain, "id", AIGoods.class, null, true));
            xr.closeTag(AI_GOODS_LIST_TAG);
        } else if (GOODS_WISH_LIST_TAG.equals(tag) || OLD_GOODS_WISH_TAG.equals(tag)) {
            this.wishes.add(xr.makeAIObject(aiMain, "id", GoodsWish.class, null, true));
            xr.closeTag(tag);
        } else if (TILE_IMPROVEMENT_PLAN_LIST_TAG.equals(tag) || OLD_TILE_IMPROVEMENT_PLAN_TAG.equals(tag)) {
            this.tileImprovementPlans.add(xr.makeAIObject(aiMain, "id", TileImprovementPlan.class, null, true));
            xr.closeTag(tag);
        } else if (WORKER_WISH_LIST_TAG.equals(tag) || OLD_WORKER_WISH_TAG.equals(tag)) {
            this.wishes.add(xr.makeAIObject(aiMain, "id", WorkerWish.class, null, true));
            xr.closeTag(tag);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return AIColony.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "aiColony";
    }
}

