/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIInGameInputHandler;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.control.InGameInputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.control.PreGameInputHandler;
import net.sf.freecol.server.control.UserConnectionHandler;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.SimpleMapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TransactionSession;
import net.sf.freecol.server.networking.DummyConnection;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Element;

public final class FreeColServer {
    private static final Logger logger = Logger.getLogger(FreeColServer.class.getName());
    public static final String ACTIVE_UNIT_TAG = "activeUnit";
    public static final String DEBUG_TAG = "debug";
    public static final String RANDOM_STATE_TAG = "randomState";
    public static final String OWNER_TAG = "owner";
    public static final String PUBLIC_SERVER_TAG = "publicServer";
    public static final String SAVED_GAME_TAG = "savedGame";
    public static final String SERVER_OBJECTS_TAG = "serverObjects";
    public static final String SINGLE_PLAYER_TAG = "singleplayer";
    private static final int META_SERVER_UPDATE_INTERVAL = 60000;
    public static final int SAVEGAME_VERSION = 13;
    public static final int MINIMUM_SAVEGAME_VERSION = 11;
    public static final String DEFAULT_SPEC = "freecol";
    private boolean singlePlayer;
    private boolean publicServer = false;
    private String name;
    private GameState gameState = GameState.STARTING_GAME;
    private Server server;
    private final UserConnectionHandler userConnectionHandler;
    private final PreGameController preGameController;
    private final PreGameInputHandler preGameInputHandler;
    private final InGameInputHandler inGameInputHandler;
    private final InGameController inGameController;
    private AIMain aiMain;
    private ServerGame game;
    private MapGenerator mapGenerator = null;
    private Random random = null;
    private int integrity = 1;
    private Unit activeUnit = null;

    public FreeColServer(boolean publicServer, boolean singlePlayer, Specification specification, int port, String name) throws IOException, NoRouteToServerException {
        this.publicServer = publicServer;
        this.singlePlayer = singlePlayer;
        this.name = name;
        this.server = this.serverStart(port);
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.random = new Random(FreeColSeed.getFreeColSeed(true));
        this.game = new ServerGame(specification);
        this.game.setNationOptions(new NationOptions(specification));
        this.game.initializeCitiesOfCibola(this.random);
        this.inGameController = new InGameController(this, this.random);
        this.mapGenerator = new SimpleMapGenerator(this.game, this.random);
        if (publicServer) {
            this.updateMetaServer(true);
        }
    }

    public FreeColServer(FreeColSavegameFile savegame, Specification specification, int port, String name) throws FreeColException, IOException, NoRouteToServerException, XMLStreamException {
        this.name = name;
        this.server = this.serverStart(port);
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.game = this.loadGame(savegame, specification, this.server);
        TransactionSession.clearAll();
        long seed = FreeColSeed.getFreeColSeed(this.random == null);
        if (seed != 0L) {
            this.random = new Random(seed);
        }
        this.inGameController = new InGameController(this, this.random);
        this.mapGenerator = null;
        if (this.publicServer) {
            this.updateMetaServer(true);
        }
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public void setSinglePlayer(boolean singlePlayer) {
        this.singlePlayer = singlePlayer;
    }

    public void setPublicServer(boolean publicServer) {
        this.publicServer = publicServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.server == null ? null : this.server.getHost();
    }

    public int getPort() {
        return this.server == null ? -1 : this.server.getPort();
    }

    private Server serverStart(int firstPort) throws IOException {
        int tries;
        int port;
        String host;
        String string = host = this.publicServer ? "0.0.0.0" : InetAddress.getLoopbackAddress().getHostAddress();
        if (firstPort < 0) {
            port = FreeCol.getServerPort();
            tries = 10;
        } else {
            port = firstPort;
            tries = 1;
        }
        logger.finest("serverStart(" + firstPort + ") => " + port + " x " + tries);
        for (int i = tries; i > 0; --i) {
            block7: {
                try {
                    this.server = new Server(this, host, port);
                    this.server.start();
                    break;
                }
                catch (BindException be) {
                    if (i == 1) {
                        throw new IOException("Bind exception starting server", be);
                    }
                }
                catch (IOException ie) {
                    if (i != 1) break block7;
                    throw ie;
                }
            }
            ++port;
        }
        return this.server;
    }

    public Specification getSpecification() {
        return this.game.getSpecification();
    }

    public UserConnectionHandler getUserConnectionHandler() {
        return this.userConnectionHandler;
    }

    public Controller getController() {
        if (this.getGameState() == GameState.IN_GAME) {
            return this.inGameController;
        }
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public ServerGame getGame() {
        return this.game;
    }

    public void setGame(ServerGame game) {
        this.game = game;
    }

    public void setAIMain(AIMain aiMain) {
        this.aiMain = aiMain;
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState state) {
        this.gameState = state;
    }

    public Server getServer() {
        return this.server;
    }

    public int getIntegrity() {
        return this.integrity;
    }

    public MapGenerator getMapGenerator() {
        return this.mapGenerator;
    }

    public void setMapGenerator(MapGenerator mapGenerator) {
        this.mapGenerator = mapGenerator;
    }

    public Random getServerRandom() {
        return this.random;
    }

    public void setServerRandom(Random random) {
        this.random = random;
    }

    public Unit getActiveUnit() {
        return this.activeUnit;
    }

    public void setActiveUnit(Unit unit) {
        this.activeUnit = unit;
    }

    public void updateMetaServer() throws NoRouteToServerException {
        if (this.publicServer) {
            this.updateMetaServer(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetaServer(boolean firstTime) throws NoRouteToServerException {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not connect to meta-server.", e);
            return;
        }
        String tag = firstTime ? "register" : "update";
        int port = mc.getSocket().getPort();
        String addr = this.name != null ? this.name : mc.getSocket().getLocalAddress().getHostAddress() + ":" + port;
        int nPlayers = this.getNumberOfLivingHumanPlayers();
        boolean started = this.gameState != GameState.STARTING_GAME;
        try {
            Element reply = mc.ask(DOMMessage.createMessage(tag, "name", addr, "port", Integer.toString(port), "slotsAvailable", Integer.toString(this.getSlotsAvailable()), "currentlyPlaying", Integer.toString(nPlayers), "isGameStarted", Boolean.toString(started), "version", FreeCol.getVersion(), "gameState", Integer.toString(this.getGameState().ordinal())));
            if (reply != null && "noRouteToServer".equals(reply.getTagName())) {
                throw new NoRouteToServerException();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Network error with meta-server.", e);
            return;
        }
        finally {
            mc.close();
        }
        if (firstTime) {
            Timer t = new Timer(true);
            t.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        FreeColServer.this.updateMetaServer();
                    }
                    catch (NoRouteToServerException noRouteToServerException) {
                        // empty catch block
                    }
                }
            }, 60000L, 60000L);
        }
    }

    public void removeFromMetaServer() {
        if (!this.publicServer) {
            return;
        }
        try (Connection mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");){
            mc.send(DOMMessage.createMessage("remove", "port", Integer.toString(mc.getSocket().getPort())));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Network error with meta-server.", e);
        }
    }

    public int getSlotsAvailable() {
        int n = 0;
        for (Player player : this.game.getLiveEuropeanPlayers(null)) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.isREF() || !sp.isAI() || sp.isConnected()) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfLivingHumanPlayers() {
        int n = 0;
        for (Player player : this.game.getLivePlayers(null)) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.isAI() || !sp.isConnected()) continue;
            ++n;
        }
        return n;
    }

    public void saveGame(File file, OptionGroup options) throws IOException {
        this.saveGame(file, options, null);
    }

    public void saveMapEditorGame(File file, BufferedImage image) throws IOException {
        this.setAIMain(null);
        this.saveGame(file, null, image);
    }

    public void saveGame(File file, OptionGroup options, BufferedImage image) throws IOException {
        ServerGame game = this.getGame();
        try (JarOutputStream fos = new JarOutputStream(new FileOutputStream(file));){
            if (image != null) {
                fos.putNextEntry(new JarEntry("thumbnail.png"));
                ImageIO.write((RenderedImage)image, "png", fos);
                fos.closeEntry();
            }
            if (options != null) {
                fos.putNextEntry(new JarEntry("client-options.xml"));
                options.save(fos, FreeColXMLWriter.WriteScope.toSave(), false);
                fos.closeEntry();
            }
            Properties properties = new Properties();
            properties.put("map.width", Integer.toString(game.getMap().getWidth()));
            properties.put("map.height", Integer.toString(game.getMap().getHeight()));
            fos.putNextEntry(new JarEntry("savegame.properties"));
            properties.store(fos, null);
            fos.closeEntry();
            fos.putNextEntry(new JarEntry("savegame.xml"));
            try (FreeColXMLWriter xw = new FreeColXMLWriter(fos, FreeColXMLWriter.WriteScope.toSave(), false);){
                xw.writeStartDocument("UTF-8", "1.0");
                xw.writeComment("Game version: " + FreeCol.getRevision());
                xw.writeStartElement(SAVED_GAME_TAG);
                xw.writeAttribute(OWNER_TAG, FreeCol.getName());
                xw.writeAttribute(PUBLIC_SERVER_TAG, this.publicServer);
                xw.writeAttribute(SINGLE_PLAYER_TAG, this.singlePlayer);
                xw.writeAttribute("version", 13);
                xw.writeAttribute(RANDOM_STATE_TAG, Utils.getRandomState(this.random));
                xw.writeAttribute(DEBUG_TAG, FreeColDebugger.getDebugModes());
                if (this.getActiveUnit() != null) {
                    xw.writeAttribute(ACTIVE_UNIT_TAG, this.getActiveUnit());
                }
                xw.writeStartElement(SERVER_OBJECTS_TAG);
                for (ServerModelObject smo : game.getServerModelObjects()) {
                    xw.writeStartElement(smo.getServerXMLElementTagName());
                    xw.writeAttribute("id", smo.getId());
                    xw.writeEndElement();
                }
                xw.writeEndElement();
                game.toXML(xw);
                if (this.aiMain != null) {
                    this.aiMain.toXML(xw);
                }
                xw.writeEndElement();
                xw.writeEndDocument();
                xw.flush();
            }
            fos.closeEntry();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to save (XML)", e);
        }
        catch (Exception e) {
            throw new IOException("Failed to save", e);
        }
    }

    public ServerGame loadGame(FreeColSavegameFile fis) throws IOException, FreeColException, XMLStreamException {
        return this.loadGame(fis, null, this.getServer());
    }

    public static ServerGame readGame(File file, Specification spec, FreeColServer server) {
        ServerGame g = null;
        try {
            g = FreeColServer.readGame(new FreeColSavegameFile(file), spec, server);
            logger.info("Imported file " + file.getPath());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Import failed for " + file.getPath(), e);
        }
        File startGame = FreeColDirectories.getStartMapFile();
        if (startGame != null && startGame.getPath().equals(file.getPath())) {
            file.delete();
        }
        return g;
    }

    public static ServerGame readGame(FreeColSavegameFile fis, Specification specification, FreeColServer server) throws IOException, FreeColException, XMLStreamException {
        int savegameVersion = fis.getSavegameVersion();
        if (savegameVersion < 11) {
            throw new FreeColException("incompatibleVersions");
        }
        logger.info("Found savegame version " + savegameVersion);
        Game game = null;
        try (FreeColXMLReader xr = fis.getFreeColXMLReader();){
            xr.setReadScope(FreeColXMLReader.ReadScope.SERVER);
            String active = null;
            xr.nextTag();
            if (server != null) {
                server.setSinglePlayer(xr.getAttribute(SINGLE_PLAYER_TAG, true));
                server.setPublicServer(xr.getAttribute(PUBLIC_SERVER_TAG, false));
                String r = xr.getAttribute(RANDOM_STATE_TAG, null);
                server.setServerRandom(Utils.restoreRandomState(r));
                FreeColDebugger.setDebugModes(xr.getAttribute(DEBUG_TAG, null));
                active = xr.getAttribute(ACTIVE_UNIT_TAG, null);
            }
            while (xr.nextTag() != 2) {
                String tag = xr.getLocalName();
                if (SERVER_OBJECTS_TAG.equals(tag)) {
                    while (xr.nextTag() != 2) {
                        xr.nextTag();
                    }
                    continue;
                }
                if (Game.getXMLElementTagName().equals(tag)) {
                    game = new ServerGame(null, xr, specification);
                    game.setCurrentPlayer(null);
                    if (server == null) continue;
                    server.setGame((ServerGame)game);
                    continue;
                }
                if (AIMain.getXMLElementTagName().equals(tag)) {
                    if (server == null) break;
                    server.setAIMain(new AIMain(server, xr));
                    continue;
                }
                throw new XMLStreamException("Unknown tag reading server game: " + tag);
            }
            if (server != null && active != null && game != null) {
                Unit u = game.getFreeColGameObject(active, Unit.class);
                server.setActiveUnit(u);
            }
        }
        return game;
    }

    private ServerGame loadGame(FreeColSavegameFile fis, Specification specification, Server server) throws FreeColException, IOException, XMLStreamException {
        ServerGame game = FreeColServer.readGame(fis, specification, this);
        this.gameState = GameState.IN_GAME;
        this.integrity = game.checkIntegrity(true);
        if (this.integrity < 0) {
            logger.warning("Game integrity test failed.");
        } else {
            logger.info("Game integrity test " + (this.integrity > 0 ? "succeeded" : "failed, but fixed") + ".");
        }
        int savegameVersion = fis.getSavegameVersion();
        if (savegameVersion < 12) {
            for (Player p : game.getPlayers()) {
                if (p.isIndian()) {
                    for (IndianSettlement is : p.getIndianSettlements()) {
                        ((ServerIndianSettlement)is).updateMostHated();
                    }
                }
                if (p.isIndian() || p.getEurope() == null) continue;
                p.initializeHighSeas();
                for (Unit u : p.getEurope().getUnitList()) {
                    if (u.getState() == Unit.UnitState.TO_EUROPE) {
                        logger.info("Found unit on way to europe: " + u);
                        u.setLocation(p.getHighSeas());
                        u.setDestination(p.getEurope());
                        continue;
                    }
                    if (u.getState() != Unit.UnitState.TO_AMERICA) continue;
                    logger.info("Found unit on way to new world: " + u);
                    u.setLocation(p.getHighSeas());
                    u.setDestination(game.getMap());
                }
            }
            for (Tile tile : game.getMap().getAllTiles()) {
                TerrainGenerator.encodeStyle(tile);
            }
        }
        game.getMap().resetContiguity();
        Player unknown = game.getUnknownEnemy();
        if (unknown == null) {
            this.establishUnknownEnemy(game);
        } else {
            unknown.setName("model.nation.unknownEnemy");
        }
        specification = this.getSpecification();
        specification.disableEditing();
        AIMain aiMain = this.getAIMain();
        int aiIntegrity = aiMain.checkIntegrity(true);
        if (aiIntegrity < 0) {
            aiMain = new AIMain(this);
            aiMain.findNewObjects(true);
            logger.warning("AI integrity test failed, replaced AIMain.");
        } else {
            logger.info("AI integrity test " + (aiIntegrity > 0 ? "succeeded" : "failed, but fixed"));
        }
        game.setFreeColGameObjectListener(aiMain);
        Collections.sort(game.getPlayers(), Player.playerComparator);
        for (Player player : game.getLivePlayers(null)) {
            if (player.isAI()) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DummyConnection theConnection = new DummyConnection("Server-Server-" + player.getName(), this.getInGameInputHandler());
                DummyConnection aiConnection = new DummyConnection("Server-AI-" + player.getName(), new AIInGameInputHandler(this, serverPlayer, aiMain));
                aiConnection.setConnection(theConnection);
                theConnection.setConnection(aiConnection);
                server.addDummyConnection(theConnection);
                serverPlayer.setConnection(theConnection);
                serverPlayer.setConnected(true);
            }
            if (!player.isEuropean()) continue;
            player.canSee(game.getMap().getTile(0, 0));
        }
        return game;
    }

    private ServerPlayer establishUnknownEnemy(Game game) {
        Specification spec = game.getSpecification();
        ServerPlayer enemy = new ServerPlayer(game, false, spec.getNation("model.nation.unknownEnemy"), null, null);
        game.setUnknownEnemy(enemy);
        return enemy;
    }

    public Map createEmptyMap(Game game, int width, int height) {
        return this.getMapGenerator().createEmptyMap(width, height);
    }

    public Game buildGame() throws FreeColException {
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        AIMain aiMain = this.initializeAI(true);
        this.establishUnknownEnemy(game);
        game.setMap(this.getMapGenerator().createMap());
        spec.generateDynamicOptions();
        Random random = this.getServerRandom();
        for (Player player : game.getLivePlayers(null)) {
            ((ServerPlayer)player).randomizeGame(random);
            if (!player.isIndian()) continue;
            int alarm = (Tension.Level.HAPPY.getLimit() + Tension.Level.CONTENT.getLimit()) / 2;
            for (Player other : game.getLiveNativePlayers(player)) {
                player.setStance(other, Player.Stance.PEACE);
                for (IndianSettlement is : player.getIndianSettlements()) {
                    is.setAlarm(other, new Tension(alarm));
                }
            }
        }
        spec.getMapGeneratorOptions().setEditable(false);
        spec.getGameOptions().setEditable(false);
        spec.getOptionGroup("difficultyLevels").setEditable(false);
        aiMain.findNewObjects(true);
        return game;
    }

    public AIMain initializeAI(boolean allNations) {
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        AIMain aiMain = new AIMain(this);
        this.setAIMain(aiMain);
        if (allNations) {
            game.setFreeColGameObjectListener(aiMain);
            for (Map.Entry<Nation, NationOptions.NationState> entry : game.getNationOptions().getNations().entrySet()) {
                if (entry.getKey().isUnknownEnemy() || entry.getValue() == NationOptions.NationState.NOT_AVAILABLE || game.getPlayer(entry.getKey().getId()) != null) continue;
                this.addAIPlayer(entry.getKey());
            }
        } else {
            for (Nation nation : spec.getIndianNations()) {
                this.addAIPlayer(nation);
            }
        }
        Collections.sort(game.getPlayers(), Player.playerComparator);
        return aiMain;
    }

    public ServerPlayer addAIPlayer(Nation nation) {
        DummyConnection theConnection = new DummyConnection("Server connection - " + nation.getId(), this.getInGameInputHandler());
        ServerPlayer aiPlayer = new ServerPlayer(this.getGame(), false, nation, null, theConnection);
        aiPlayer.setAI(true);
        DummyConnection aiConnection = new DummyConnection("AI connection - " + nation.getId(), new AIInGameInputHandler(this, aiPlayer, this.getAIMain()));
        aiConnection.setConnection(theConnection);
        theConnection.setConnection(aiConnection);
        this.getServer().addDummyConnection(theConnection);
        this.getGame().addPlayer(aiPlayer);
        this.getAIMain().setFreeColGameObject(aiPlayer.getId(), aiPlayer);
        Element player = DOMMessage.createMessage("addPlayer", new String[0]);
        player.appendChild(aiPlayer.toXMLElement(player.getOwnerDocument()));
        this.getServer().sendToAll(player, theConnection);
        return aiPlayer;
    }

    public static void removeAutosaves(String prefix) {
        for (File autosaveFile : FreeColDirectories.getAutosaveDirectory().listFiles()) {
            if (!autosaveFile.getName().startsWith(prefix)) continue;
            autosaveFile.delete();
        }
    }

    public void exploreMapForAllPlayers(boolean reveal) {
        for (Player player : this.getGame().getLiveEuropeanPlayers(null)) {
            ((ServerPlayer)player).exploreMap(reveal);
        }
        BooleanOption fogOfWarSetting = this.game.getSpecification().getBooleanOption("model.option.fogOfWar");
        if (reveal) {
            FreeColDebugger.setNormalGameFogOfWar(fogOfWarSetting.getValue());
            fogOfWarSetting.setValue(Boolean.FALSE);
        } else {
            fogOfWarSetting.setValue(FreeColDebugger.getNormalGameFogOfWar());
        }
        for (Player player : this.getGame().getLiveEuropeanPlayers(null)) {
            try {
                ((ServerPlayer)player).getConnection().send(DOMMessage.createMessage("reconnect", new String[0]));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error sending reconnect.", e);
            }
        }
    }

    public ServerPlayer getPlayer(Connection connection) {
        for (Player p : this.game.getPlayers()) {
            ServerPlayer serverPlayer = (ServerPlayer)p;
            if (serverPlayer.getConnection() != connection) continue;
            return serverPlayer;
        }
        return null;
    }

    public AIPlayer getAIPlayer(Player player) {
        return this.getAIMain().getAIPlayer(player);
    }

    public void shutdown() {
        this.server.shutdown();
    }

    public static enum GameState {
        STARTING_GAME,
        IN_GAME,
        ENDING_GAME;

    }
}

