/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    public static <T> boolean equals(T one, T two) {
        return one == null ? two == null : one.equals(two);
    }

    public static int hashCode(Object object) {
        return object == null ? 31 : object.hashCode();
    }

    public static synchronized String getRandomState(Random random) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(random);
            oos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("IO exception in memory!?", e);
        }
        byte[] bytes = bos.toByteArray();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static synchronized Random restoreRandomState(String state) {
        if (state == null || state.isEmpty()) {
            return null;
        }
        byte[] bytes = new byte[state.length() / 2];
        int pos = 0;
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)HEX_DIGITS.indexOf(state.charAt(pos++));
            int n = i;
            bytes[n] = (byte)(bytes[n] << 4);
            int n2 = i++;
            bytes[n2] = (byte)(bytes[n2] | (byte)HEX_DIGITS.indexOf(state.charAt(pos++)));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Random)ois.readObject();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to restore random state.", e);
            return null;
        }
    }

    public static Writer getFileUTF8Writer(File file) {
        OutputStreamWriter osw;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "No FileOutputStream for " + file.getName(), e);
            return null;
        }
        try {
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "No OutputStreamWriter for " + file.getName(), e);
            try {
                fos.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to close", ioe);
            }
            return null;
        }
        return osw;
    }
}

