/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.Collection;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.util.RandomUtils;

public class RandomChoice<T> {
    private final int probability;
    private final T object;

    public RandomChoice(T object, int probability) {
        this.probability = probability;
        this.object = object;
    }

    public int getProbability() {
        return this.probability;
    }

    public T getObject() {
        return this.object;
    }

    private static <T> T select(Collection<RandomChoice<T>> input, int probability) {
        if (input.isEmpty()) {
            return null;
        }
        int total = 0;
        for (RandomChoice<T> choice : input) {
            if (probability >= (total += choice.getProbability())) continue;
            return choice.getObject();
        }
        return input.iterator().next().getObject();
    }

    public static <T> int getTotalProbability(Collection<RandomChoice<T>> input) {
        int total = 0;
        for (RandomChoice<T> choice : input) {
            total += choice.getProbability();
        }
        return total;
    }

    public static <T> T getWeightedRandom(Logger logger, String logMe, Collection<RandomChoice<T>> input, Random random) {
        int n;
        return input == null || input.isEmpty() || (n = RandomChoice.getTotalProbability(input)) <= 0 ? null : (input.size() == 1 ? (T)input.iterator().next().getObject() : (T)RandomChoice.select(input, RandomUtils.randomInt(logger, logMe, random, n)));
    }
}

