/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.VideoResource;

public class ResourceFactory {
    private static final Logger logger = Logger.getLogger(ResourceFactory.class.getName());
    private static final Map<URI, WeakReference<Resource>> resources = new WeakHashMap<URI, WeakReference<Resource>>();

    private static Resource getResource(URI uri) {
        Resource r;
        WeakReference<Resource> wr = resources.get(uri);
        if (wr != null && (r = (Resource)wr.get()) != null) {
            return r;
        }
        return null;
    }

    public static Resource createResource(URI uri) {
        Resource r = ResourceFactory.getResource(uri);
        if (r == null) {
            try {
                if ("urn".equals(uri.getScheme())) {
                    if (uri.getSchemeSpecificPart().startsWith("color:")) {
                        r = new ColorResource(uri);
                    } else if (uri.getSchemeSpecificPart().startsWith("font:")) {
                        r = new FontResource(uri);
                    }
                } else {
                    r = uri.getPath().endsWith(".faf") ? new FAFileResource(uri) : (uri.getPath().endsWith(".sza") ? new SZAResource(uri) : (uri.getPath().endsWith(".ttf") ? new FontResource(uri) : (uri.getPath().endsWith(".wav") ? new AudioResource(uri) : (uri.getPath().endsWith(".ogg") ? (uri.getPath().endsWith(".video.ogg") ? new VideoResource(uri) : new AudioResource(uri)) : new ImageResource(uri)))));
                }
                resources.put(uri, new WeakReference<Resource>(r));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create resource with URI: " + uri, e);
            }
        }
        return r;
    }
}

