/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FAFile {
    private final HashMap<Object, Object> letters = new HashMap();
    private int maxHeight = 0;

    public FAFile(InputStream is) throws IOException {
        this.load(new CREatingInputStream(is));
    }

    public Dimension getDimension(String text) {
        FAName fn = this.getFAName(text);
        if (fn != null) {
            return new Dimension(fn.width, fn.height);
        }
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            FALetter fl = this.getLetter(text.charAt(i));
            width += fl.advance;
        }
        int firstMinX = Integer.MAX_VALUE;
        FALetter letter = this.getLetter(text.charAt(0));
        for (int i = 0; i < letter.points.length; ++i) {
            Point p = letter.points[i];
            if (p.x >= firstMinX) continue;
            firstMinX = p.x;
        }
        width += firstMinX;
        int lastMaxX = 0;
        letter = this.getLetter(text.charAt(text.length() - 1));
        for (int i = 0; i < letter.points.length; ++i) {
            Point p = letter.points[i];
            if (p.x <= lastMaxX) continue;
            lastMaxX = p.x;
        }
        return new Dimension(width += lastMaxX, this.maxHeight);
    }

    public Point[] getPoints(String text) {
        FAName fn = this.getFAName(text);
        if (fn != null) {
            return fn.points;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        int x = 0;
        for (int i = 0; i < text.length(); ++i) {
            FALetter fl = this.getLetter(text.charAt(i));
            for (int j = 0; j < fl.points.length; ++j) {
                Point p = fl.points[j];
                points.add(new Point(p.x + x, p.y));
            }
            x += fl.advance;
        }
        return points.toArray(new Point[0]);
    }

    private void load(InputStream is) throws IOException {
        int i;
        this.letters.clear();
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = in.readLine();
        if (line == null || !line.startsWith("FontAnimationFile")) {
            throw new IllegalStateException("Not a FAF");
        }
        line = in.readLine();
        if (line == null) {
            throw new IllegalStateException("Max height expected");
        }
        StringTokenizer st = new StringTokenizer(line);
        this.maxHeight = Integer.parseInt(st.nextToken());
        line = in.readLine();
        while (line != null && !line.startsWith("[Chars]")) {
            String name = line;
            line = in.readLine();
            if (line == null) break;
            st = new StringTokenizer(line);
            int width = Integer.parseInt(st.nextToken());
            int height = Integer.parseInt(st.nextToken());
            int numberOfPoints = Integer.parseInt(st.nextToken());
            int[] xs = new int[numberOfPoints];
            int[] ys = new int[numberOfPoints];
            line = in.readLine();
            if (line == null) break;
            st = new StringTokenizer(line);
            for (i = 0; i < numberOfPoints; ++i) {
                xs[i] = Integer.parseInt(st.nextToken());
            }
            line = in.readLine();
            if (line == null) break;
            st = new StringTokenizer(line);
            for (i = 0; i < numberOfPoints; ++i) {
                ys[i] = Integer.parseInt(st.nextToken());
            }
            FAName newLetter = new FAName();
            newLetter.width = width;
            newLetter.height = height;
            newLetter.points = new Point[numberOfPoints];
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                newLetter.points[i2] = new Point(xs[i2], ys[i2]);
            }
            this.letters.put(name, newLetter);
            line = in.readLine();
        }
        line = in.readLine();
        while (line != null) {
            int i3;
            st = new StringTokenizer(line.substring(1));
            char letter = line.charAt(0);
            int advance = Integer.parseInt(st.nextToken());
            int numberOfPoints = Integer.parseInt(st.nextToken());
            int[] xs = new int[numberOfPoints];
            int[] ys = new int[numberOfPoints];
            line = in.readLine();
            st = new StringTokenizer(line);
            for (i3 = 0; i3 < numberOfPoints; ++i3) {
                xs[i3] = Integer.parseInt(st.nextToken());
            }
            line = in.readLine();
            if (line == null) break;
            st = new StringTokenizer(line);
            for (i3 = 0; i3 < numberOfPoints; ++i3) {
                ys[i3] = Integer.parseInt(st.nextToken());
            }
            FALetter newLetter = new FALetter();
            newLetter.advance = advance;
            newLetter.points = new Point[numberOfPoints];
            for (i = 0; i < numberOfPoints; ++i) {
                newLetter.points[i] = new Point(xs[i], ys[i]);
            }
            this.letters.put(new Character(letter), newLetter);
            line = in.readLine();
        }
    }

    private FALetter getLetter(char letter) {
        return (FALetter)this.letters.get(new Character(letter));
    }

    private FAName getFAName(String name) {
        return (FAName)this.letters.get(name);
    }

    private static class CREatingInputStream
    extends InputStream {
        private final InputStream in;

        CREatingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int c;
            while ((c = this.in.read()) == 13) {
            }
            return c;
        }
    }

    private static class FAName {
        public Point[] points;
        public int width;
        public int height;

        private FAName() {
        }
    }

    private static class FALetter {
        public Point[] points;
        public int advance;

        private FALetter() {
        }
    }
}

