/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.ModOption;

public abstract class ListOption<T>
extends AbstractOption<List<AbstractOption<T>>> {
    private static final Logger logger = Logger.getLogger(ListOption.class.getName());
    private AbstractOption<T> template;
    private int maximumNumber = Integer.MAX_VALUE;
    private final List<AbstractOption<T>> value = new ArrayList<AbstractOption<T>>();
    protected boolean allowDuplicates = true;
    private static final String MAXIMUM_NUMBER_TAG = "maximumNumber";
    private static final String OPTION_VALUE_TAG = "optionValue";
    private static final String TEMPLATE_TAG = "template";

    public ListOption(Specification specification) {
        super(specification);
    }

    public ListOption(String id, Specification specification) {
        super(id, specification);
    }

    public int getMaximumValue() {
        return this.maximumNumber;
    }

    public AbstractOption<T> getTemplate() {
        return this.template;
    }

    public List<T> getOptionValues() {
        ArrayList<T> result = new ArrayList<T>();
        for (AbstractOption<T> option : this.value) {
            if (option == null) continue;
            result.add(option.getValue());
        }
        return result;
    }

    private void addMember(AbstractOption<T> ao) {
        if (this.canAdd(ao)) {
            this.value.add(ao);
        }
    }

    public boolean allowsDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean canAdd(AbstractOption<T> ao) {
        if (!this.allowDuplicates) {
            for (AbstractOption<T> o : this.value) {
                if (!o.equals(ao)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<AbstractOption<T>> getValue() {
        return this.value;
    }

    @Override
    public void setValue(List<AbstractOption<T>> value) {
        if (value == null) {
            throw new IllegalArgumentException("Null ListOption");
        }
        ArrayList<AbstractOption<T>> oldValue = new ArrayList<AbstractOption<T>>(this.value);
        this.value.clear();
        for (AbstractOption<T> op : value) {
            this.addMember(op);
        }
        if (this.isDefined && !value.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(MAXIMUM_NUMBER_TAG, this.maximumNumber);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.template != null) {
            xw.writeStartElement(TEMPLATE_TAG);
            this.template.toXML(xw);
            xw.writeEndElement();
        }
        for (AbstractOption<T> option : this.value) {
            option.toXML(xw);
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.maximumNumber = xr.getAttribute(MAXIMUM_NUMBER_TAG, 1);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.value.clear();
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (OPTION_VALUE_TAG.equals(tag)) {
            FreeColModFile fcmf;
            String modId = xr.readId();
            logger.finest("Found old-style mod value: " + modId);
            if (modId != null && (fcmf = Mods.getModFile(modId)) != null) {
                ModOption modOption = new ModOption(this.getSpecification());
                modOption.setValue(fcmf);
                this.addMember(modOption);
            }
        } else if (TEMPLATE_TAG.equals(tag)) {
            xr.nextTag();
            this.template = this.readOption(xr);
            xr.closeTag(TEMPLATE_TAG);
        } else {
            AbstractOption op = null;
            try {
                op = this.readOption(xr);
            }
            catch (XMLStreamException xse) {
                logger.log(Level.WARNING, "Invalid option at: " + tag, xse);
                xr.closeTag(tag);
            }
            if (op != null) {
                this.addMember(op);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getId());
        if (this.value != null) {
            sb.append(" [");
            for (AbstractOption<T> ao : this.value) {
                sb.append(" ").append(ao);
            }
            sb.append(" ]");
        }
        sb.append("]");
        return sb.toString();
    }
}

