/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitTypeOption;

public class AbstractUnitOption
extends AbstractOption<AbstractUnit> {
    private static final Logger logger = Logger.getLogger(AbstractUnitOption.class.getName());
    private static final UnitTypeOption.TypeSelector DEFAULT_SELECTOR = UnitTypeOption.TypeSelector.UNITS;
    private AbstractUnit value = null;
    private UnitTypeOption unitType = null;
    private StringOption role = null;
    private IntegerOption number = null;
    private static final String NUMBER_TAG = "number";
    private static final String ROLE_TAG = "role";
    private static final String UNIT_TYPE_TAG = "unitType";

    public AbstractUnitOption(Specification specification) {
        super(specification);
    }

    public AbstractUnitOption(String id, Specification specification) {
        super(id, specification);
    }

    private void requireUnitType() {
        this.unitType = new UnitTypeOption(this.getId() + ".unitType", this.getSpecification());
    }

    private void requireRole() {
        this.role = new StringOption(this.getId() + ".role", this.getSpecification());
    }

    private void requireNumber() {
        this.number = new IntegerOption(this.getId() + ".number", this.getSpecification());
    }

    public final UnitTypeOption getUnitType() {
        return this.unitType;
    }

    public final StringOption getRole() {
        return this.role;
    }

    public final IntegerOption getNumber() {
        return this.number;
    }

    @Override
    public AbstractUnitOption clone() {
        Specification spec = this.getSpecification();
        AbstractUnitOption result = new AbstractUnitOption(this.getId(), spec);
        result.setValues(this);
        if (this.value != null) {
            AbstractUnit au = new AbstractUnit(this.value.getType(spec), this.value.getRoleId(), this.value.getNumber());
            result.setValue(au);
        }
        if (this.unitType != null) {
            result.unitType = this.unitType;
        }
        if (this.role != null) {
            result.role = this.role;
        }
        if (this.number != null) {
            result.number = this.number;
        }
        return result;
    }

    @Override
    public AbstractUnit getValue() {
        return this.value;
    }

    @Override
    public void setValue(AbstractUnit value) {
        Specification spec = this.getSpecification();
        AbstractUnit oldValue = this.value;
        this.value = value;
        if (value == null) {
            this.unitType = null;
            this.role = null;
            this.number = null;
        } else {
            this.requireUnitType();
            this.unitType.setValue(value.getType(spec));
            this.requireRole();
            this.role.setValue(value.getRoleId());
            this.requireNumber();
            this.number.setValue(value.getNumber());
        }
        if (this.isDefined && (value == null != (oldValue == null) || value != null && !value.equals(oldValue))) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    public void generateChoices() {
        this.unitType.generateChoices();
        ArrayList<String> roles = new ArrayList<String>();
        for (Role r : this.getSpecification().getRoles()) {
            roles.add(r.getId());
        }
        this.role.setChoices(roles);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.number.toXML(xw, NUMBER_TAG);
        this.role.toXML(xw, ROLE_TAG);
        this.unitType.toXML(xw, UNIT_TYPE_TAG);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        AbstractUnit au = null;
        if (this.unitType != null && this.role != null && this.number != null) {
            au = new AbstractUnit(this.unitType.getValue(), this.role.getValue(), (int)this.number.getValue());
        }
        this.setValue(au);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (NUMBER_TAG.equals(tag)) {
            this.requireNumber();
            this.number.readFromXML(xr);
        } else if (ROLE_TAG.equals(tag)) {
            this.requireRole();
            this.role.readFromXML(xr);
        } else if (UNIT_TYPE_TAG.equals(tag)) {
            this.requireUnitType();
            this.unitType.readFromXML(xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append(this.value).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return AbstractUnitOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unitOption";
    }
}

