/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SpySettlementMessage
extends DOMMessage {
    private final String unitId;
    private final String directionString;

    public SpySettlementMessage(Unit unit, Map.Direction direction) {
        super(SpySettlementMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public SpySettlementMessage(Game game, Element element) {
        super(SpySettlementMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Connection connection) {
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = serverPlayer.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.hasAbility("model.ability.spyOnColony")) {
            return DOMMessage.clientError("Unit lacks ability to spy on colony: " + this.unitId);
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Settlement settlement = tile.getSettlement();
        if (settlement == null) {
            return DOMMessage.clientError("There is no settlement at: " + tile.getId());
        }
        Unit.MoveType type = unit.getMoveType(settlement.getTile());
        if (type != Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT) {
            return DOMMessage.clientError("Unable to enter at: " + settlement.getName() + ": " + type.whyIllegal());
        }
        return server.getInGameController().spySettlement(serverPlayer, unit, settlement);
    }

    @Override
    public Element toXMLElement() {
        return SpySettlementMessage.createMessage(SpySettlementMessage.getXMLElementTagName(), "unit", this.unitId, "direction", this.directionString);
    }

    public static String getXMLElementTagName() {
        return "spySettlement";
    }
}

