/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NetworkReplyObject;
import org.xml.sax.SAXException;

final class ReceivingThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ReceivingThread.class.getName());
    private static final int MAXIMUM_RETRIES = 5;
    private final Map<Integer, NetworkReplyObject> waitingThreads = Collections.synchronizedMap(new HashMap());
    private final FreeColNetworkInputStream in;
    private final Connection connection;
    private boolean shouldRun;
    private int nextNetworkReplyId;

    ReceivingThread(Connection connection, InputStream in, String threadName) {
        super(threadName + "-ReceivingThread-" + connection);
        this.in = new FreeColNetworkInputStream(in);
        this.connection = connection;
        this.shouldRun = true;
        this.nextNetworkReplyId = 1;
    }

    public synchronized int getNextNetworkReplyId() {
        return this.nextNetworkReplyId++;
    }

    public NetworkReplyObject waitForNetworkReply(int networkReplyId) {
        NetworkReplyObject nro = new NetworkReplyObject(networkReplyId);
        this.waitingThreads.put(networkReplyId, nro);
        return nro;
    }

    private synchronized boolean shouldRun() {
        return this.shouldRun;
    }

    public synchronized void askToStop() {
        if (this.shouldRun) {
            this.shouldRun = false;
            for (NetworkReplyObject o : this.waitingThreads.values()) {
                o.interrupt();
            }
        }
    }

    private void disconnect(String reason) {
        this.askToStop();
        if (this.connection.getMessageHandler() != null) {
            try {
                this.connection.getMessageHandler().handle(this.connection, DOMMessage.createMessage("disconnect", "reason", reason));
            }
            catch (FreeColException e) {
                logger.log(Level.WARNING, "Rx disconnect", e);
            }
        }
    }

    private void listen() throws IOException, SAXException, XMLStreamException {
        String tag;
        this.in.enable();
        int LOOK_AHEAD = 8192;
        BufferedInputStream bis = new BufferedInputStream(this.in, 8192);
        bis.mark(8192);
        FreeColXMLReader xr = new FreeColXMLReader(bis);
        try {
            xr.nextTag();
            tag = xr.getLocalName();
        }
        catch (XMLStreamException xse) {
            tag = "disconnect";
        }
        if ("disconnect".equals(tag)) {
            this.askToStop();
        } else if ("reply".equals(tag)) {
            int id = xr.getAttribute("networkReplyId", -1);
            NetworkReplyObject nro = this.waitingThreads.remove(id);
            if (nro == null) {
                logger.warning("Could not find networkReplyId: " + id);
            } else {
                bis.reset();
                nro.setResponse(new DOMMessage(bis));
            }
        } else {
            try {
                bis.reset();
                this.connection.handleAndSendReply(bis);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "IO error", ioe);
            }
        }
        if (xr != null) {
            xr.close();
        }
    }

    @Override
    public void run() {
        int timesFailed = 0;
        try {
            while (this.shouldRun()) {
                try {
                    this.listen();
                    timesFailed = 0;
                }
                catch (XMLStreamException | SAXException e) {
                    if (!this.shouldRun()) {
                        break;
                    }
                    logger.log(Level.WARNING, "XML fail", e);
                    if (++timesFailed <= 5) continue;
                    this.disconnect("Too many failures (XML)");
                }
                catch (IOException e) {
                    if (!this.shouldRun()) {
                        break;
                    }
                    logger.log(Level.WARNING, "IO fail", e);
                    this.disconnect("Unexpected IO failure");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected exception.", e);
        }
        finally {
            this.askToStop();
        }
        this.connection.reallyClose();
        logger.info("Finished: " + this.getName());
    }

    private static class FreeColNetworkInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 16384;
        private static final char END_OF_STREAM = '\n';
        private final InputStream in;
        private final byte[] buffer = new byte[16384];
        private int bStart = 0;
        private int bEnd = 0;
        private boolean empty = true;
        private boolean wait = false;

        public FreeColNetworkInputStream(InputStream in) {
            this.in = in;
        }

        public void enable() {
            this.wait = false;
        }

        private boolean fill() throws IOException {
            int r;
            if (!this.empty) {
                throw new IllegalStateException("Not empty.");
            }
            if (this.bStart < this.bEnd) {
                r = this.in.read(this.buffer, this.bEnd, 16384 - this.bEnd);
            } else if (this.bStart == this.bEnd) {
                this.bEnd = 0;
                this.bStart = 0;
                r = this.in.read(this.buffer, this.bEnd, 16384 - this.bEnd);
            } else {
                r = this.in.read(this.buffer, this.bEnd, this.bStart - this.bEnd);
            }
            if (r <= 0) {
                return false;
            }
            this.empty = false;
            this.bEnd += r;
            if (this.bEnd >= 16384) {
                this.bEnd = 0;
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            if (this.wait) {
                return -1;
            }
            if (this.empty && !this.fill()) {
                this.wait = true;
                return -1;
            }
            int ret = this.buffer[this.bStart];
            ++this.bStart;
            if (this.bStart >= 16384) {
                this.bStart = 0;
            }
            if (this.bStart == this.bEnd) {
                this.empty = true;
            }
            if (ret == 10) {
                this.wait = true;
                ret = -1;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            if (this.wait) {
                return -1;
            }
            for (n = 0; n < len; ++n) {
                if (this.empty && !this.fill()) {
                    this.wait = true;
                    break;
                }
                byte value = this.buffer[this.bStart];
                ++this.bStart;
                if (this.bStart == 16384) {
                    this.bStart = 0;
                }
                if (this.bStart == this.bEnd) {
                    this.empty = true;
                }
                if (value == 10) {
                    this.wait = true;
                    break;
                }
                b[n + off] = value;
            }
            return n <= 0 && this.wait ? -1 : n;
        }
    }
}

