/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class NewRegionNameMessage
extends DOMMessage {
    private final String regionId;
    private final String tileId;
    private final String unitId;
    private final String newRegionName;

    public NewRegionNameMessage(Region region, Tile tile, Unit unit, String newRegionName) {
        super(NewRegionNameMessage.getXMLElementTagName());
        this.regionId = region.getId();
        this.tileId = tile.getId();
        this.unitId = unit.getId();
        this.newRegionName = newRegionName;
    }

    public NewRegionNameMessage(Game game, Element element) {
        super(NewRegionNameMessage.getXMLElementTagName());
        this.regionId = element.getAttribute("region");
        this.tileId = element.getAttribute("tile");
        this.unitId = element.getAttribute("unit");
        this.newRegionName = element.getAttribute("newRegionName");
    }

    public Region getRegion(Game game) {
        return game.getFreeColGameObject(this.regionId, Region.class);
    }

    public Tile getTile(Game game) {
        return game.getFreeColGameObject(this.tileId, Tile.class);
    }

    public Unit getUnit(Player player) {
        return player.getOurFreeColGameObject(this.unitId, Unit.class);
    }

    public String getNewRegionName() {
        return this.newRegionName;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerGame game;
        Tile tile;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (!serverPlayer.hasExplored(tile = this.getTile(game = server.getGame()))) {
            return DOMMessage.clientError("Can not claim discovery in unexplored tile: " + this.tileId);
        }
        try {
            unit = this.getUnit(player);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Region region = tile.getDiscoverableRegion();
        if (region == null) {
            return DOMMessage.clientError("No discoverable region in: " + this.tileId);
        }
        if (!region.getId().equals(this.regionId)) {
            return DOMMessage.clientError("Region mismatch, " + region.getId() + " != " + this.regionId);
        }
        if (!Utils.equals(region.getDiscoverer(), unit.getId())) {
            return DOMMessage.clientError("Discoverer mismatch, " + region.getDiscoverer() + " expected, " + unit.getId() + " provided.");
        }
        return server.getInGameController().setNewRegionName(serverPlayer, unit, region, this.newRegionName);
    }

    @Override
    public Element toXMLElement() {
        return NewRegionNameMessage.createMessage(NewRegionNameMessage.getXMLElementTagName(), "region", this.regionId, "tile", this.tileId, "unit", this.unitId, "newRegionName", this.newRegionName);
    }

    public static String getXMLElementTagName() {
        return "newRegionName";
    }
}

