/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DeclineMoundsMessage
extends DOMMessage {
    private final String unitId;
    private final String directionString;

    public DeclineMoundsMessage(Unit unit, Map.Direction direction) {
        super(DeclineMoundsMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public DeclineMoundsMessage(Game game, Element element) {
        super(DeclineMoundsMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        LostCityRumour rumour = tile.getLostCityRumour();
        if (rumour == null || rumour.getType() != LostCityRumour.RumourType.MOUNDS) {
            return DOMMessage.clientError("No mounds rumour on tile: " + tile.getId());
        }
        return server.getInGameController().declineMounds(serverPlayer, tile);
    }

    @Override
    public Element toXMLElement() {
        return DeclineMoundsMessage.createMessage(DeclineMoundsMessage.getXMLElementTagName(), "unit", this.unitId, "direction", this.directionString);
    }

    public static String getXMLElementTagName() {
        return "declineMounds";
    }
}

