/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class BuyMessage
extends DOMMessage {
    private final String unitId;
    private final String settlementId;
    private final Goods goods;
    private final String goldString;

    public BuyMessage(Unit unit, Settlement settlement, Goods goods, int gold) {
        super(BuyMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.goods = goods;
        this.goldString = Integer.toString(gold);
    }

    public BuyMessage(Game game, Element element) {
        super(BuyMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.goods = new Goods(game, DOMMessage.getChildElement(element, Goods.getXMLElementTagName()));
        this.goldString = element.getAttribute("gold");
    }

    public int getGold() {
        try {
            return Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerIndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            settlement = (ServerIndianSettlement)unit.getAdjacentIndianSettlementSafely(this.settlementId);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.goods.getLocation() != settlement) {
            return DOMMessage.createError("server.trade.noGoods", "Goods " + this.goods.getId() + " is not at settlement " + this.settlementId);
        }
        int gold = this.getGold();
        if (gold < 0) {
            return DOMMessage.clientError("Bad gold: " + this.goldString);
        }
        return server.getInGameController().buyFromSettlement(serverPlayer, unit, settlement, this.goods, gold);
    }

    @Override
    public Element toXMLElement() {
        Element result = BuyMessage.createMessage(BuyMessage.getXMLElementTagName(), "unit", this.unitId, "settlement", this.settlementId, "gold", this.goldString);
        result.appendChild(this.goods.toXMLElement(result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "buy";
    }
}

