/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AskSkillMessage
extends DOMMessage {
    private final String unitId;
    private final String directionString;

    public AskSkillMessage(Unit unit, Map.Direction direction) {
        super(AskSkillMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public AskSkillMessage(Game game, Element element) {
        super(AskSkillMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unitId");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = serverPlayer.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return DOMMessage.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit.MoveType type = unit.getMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST) {
            return DOMMessage.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return server.getInGameController().askLearnSkill(serverPlayer, unit, is);
    }

    @Override
    public Element toXMLElement() {
        return AskSkillMessage.createMessage(AskSkillMessage.getXMLElementTagName(), "unitId", this.unitId, "direction", this.directionString);
    }

    public static String getXMLElementTagName() {
        return "askSkill";
    }
}

