/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.mission.AbstractMission;
import net.sf.freecol.common.model.mission.Mission;
import net.sf.freecol.common.model.mission.MissionManager;
import org.w3c.dom.Element;

public class CompoundMission
extends AbstractMission {
    private List<Mission> missions;
    private int index;
    private static final String INDEX_TAG = "index";

    public CompoundMission(Game game) {
        super(game);
    }

    public CompoundMission(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    public CompoundMission(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public CompoundMission(Game game, String id) {
        super(game, id);
    }

    public final List<Mission> getMissions() {
        return this.missions;
    }

    public final void setMissions(List<Mission> newMissions) {
        this.missions = newMissions;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int newIndex) {
        this.index = newIndex;
    }

    @Override
    public boolean isValid() {
        if (super.isValid() && !this.missions.isEmpty()) {
            for (Mission mission : this.missions) {
                if (mission.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Mission.MissionState doMission() {
        Mission.MissionState state = this.missions.get(this.index).doMission();
        if (state == Mission.MissionState.COMPLETED) {
            ++this.index;
            if (this.index == this.missions.size()) {
                this.setRepeatCount(this.getRepeatCount() - 1);
                if (this.getRepeatCount() > 0) {
                    this.index = 0;
                } else {
                    return Mission.MissionState.COMPLETED;
                }
            }
            if (this.getUnit().getMovesLeft() > 0) {
                return this.doMission();
            }
        }
        return state;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(INDEX_TAG, this.index);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Mission mission : this.missions) {
            mission.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.index = xr.getAttribute(INDEX_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.missions.clear();
        while (xr.nextTag() != 2) {
            Mission mission = MissionManager.getMission(this.getGame(), xr);
            if (mission == null) continue;
            this.missions.add(mission);
        }
    }

    @Override
    public String getXMLTagName() {
        return "TODO!";
    }
}

