/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

public abstract class WorkLocation
extends UnitLocation
implements Ownable {
    private static final Logger logger = Logger.getLogger(WorkLocation.class.getName());
    public static final List<AbstractGoods> EMPTY_LIST = Collections.emptyList();
    protected Colony colony;
    private ProductionType productionType;
    private static final String COLONY_TAG = "colony";

    protected WorkLocation(Game game) {
        super(game);
    }

    public WorkLocation(Game game, String id) {
        super(game, id);
    }

    public Settlement getOwningSettlement() {
        return this.colony;
    }

    public final ProductionType getProductionType() {
        return this.productionType;
    }

    public final void setProductionType(ProductionType newProductionType) {
        if (newProductionType != this.productionType) {
            this.productionType = newProductionType;
            this.colony.invalidateCache();
            logger.fine("Production type at " + this + " is now: " + newProductionType);
        }
    }

    public void updateProductionType() {
        Unit unit = this.getFirstUnit();
        GoodsType workType = unit == null ? null : unit.getWorkType();
        this.setProductionType(this.getBestProductionType(unit == null, workType));
    }

    public ProductionType getBestProductionType(boolean unattended, GoodsType workType) {
        ProductionType best = null;
        int amount = -1;
        for (ProductionType pt : this.getAvailableProductionTypes(unattended)) {
            for (AbstractGoods output : pt.getOutputs()) {
                if (workType != null && workType != output.getType() || amount >= output.getAmount()) continue;
                amount = output.getAmount();
                best = pt;
            }
        }
        return best;
    }

    public List<AbstractGoods> getInputs() {
        return this.productionType == null ? Collections.emptyList() : this.productionType.getInputs();
    }

    public List<AbstractGoods> getOutputs() {
        return this.productionType == null ? EMPTY_LIST : this.productionType.getOutputs();
    }

    public boolean produces(GoodsType goodsType) {
        return AbstractGoods.findByType(goodsType, this.getOutputs()) != null;
    }

    public boolean hasInputs() {
        return this.productionType != null && !this.productionType.getInputs().isEmpty();
    }

    public boolean hasOutputs() {
        return this.productionType != null && !this.productionType.getOutputs().isEmpty();
    }

    public boolean canBeWorked() {
        return this.getNoWorkReason() == UnitLocation.NoAddReason.NONE;
    }

    public boolean canTeach() {
        return this.hasAbility("model.ability.teach");
    }

    public ProductionInfo getProductionInfo() {
        return this.getColony().getProductionInfo(this);
    }

    public List<AbstractGoods> getProduction() {
        ProductionInfo info = this.getProductionInfo();
        return info == null ? Collections.emptyList() : info.getProduction();
    }

    public int getTotalProductionOf(GoodsType goodsType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("Null GoodsType.");
        }
        return AbstractGoods.getCount(goodsType, this.getProduction());
    }

    public int getMaximumProductionOf(GoodsType goodsType) {
        AbstractGoods ag;
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return 0;
        }
        List<AbstractGoods> production = info.getMaximumProduction();
        if (production != null && (ag = AbstractGoods.findByType(goodsType, production)) != null) {
            return ag.getAmount();
        }
        return this.getTotalProductionOf(goodsType);
    }

    public UnitType getExpertUnitType() {
        Specification spec = this.getSpecification();
        ProductionType pt = this.getBestProductionType(false, null);
        if (pt != null) {
            for (AbstractGoods goods : pt.getOutputs()) {
                UnitType expert = spec.getExpertForProducing(goods.getType());
                if (expert == null) continue;
                return expert;
            }
        }
        return null;
    }

    public int getGenericPotential(GoodsType goodsType) {
        return this.getPotentialProduction(goodsType, this.getSpecification().getDefaultUnitType());
    }

    public int getUnitProduction(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            return 0;
        }
        UnitType unitType = unit.getType();
        if (unit.getWorkType() != goodsType) {
            return 0;
        }
        Turn turn = this.getGame().getTurn();
        int bestAmount = 0;
        for (AbstractGoods output : this.getOutputs()) {
            if (output.getType() != goodsType) continue;
            int amount = this.getBaseProduction(this.getProductionType(), goodsType, unitType);
            if (bestAmount >= (amount = (int)WorkLocation.applyModifiers(amount, turn, this.getProductionModifiers(goodsType, unitType)))) continue;
            bestAmount = amount;
        }
        return bestAmount;
    }

    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit.");
        }
        UnitType unitType = unit.getType();
        AbstractGoods goods = AbstractGoods.findByType(goodsType, this.getOutputs());
        return goods == null ? 0 : Math.max(0, this.getPotentialProduction(goodsType, unitType));
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return 0;
        }
        if (unitType != null) {
            switch (this.getNoWorkReason()) {
                case NONE: 
                case ALREADY_PRESENT: 
                case CLAIM_REQUIRED: {
                    break;
                }
                case CAPACITY_EXCEEDED: {
                    if (this.getUnitCapacity() > 0) break;
                }
                default: {
                    return 0;
                }
            }
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)WorkLocation.applyModifiers(amount, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType))) < 0 ? 0 : amount;
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.getOwner() == player ? this.getLocationLabel() : this.getColony().getLocationLabelFor(player);
    }

    @Override
    public final Tile getTile() {
        return this.colony.getTile();
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        if (reason != UnitLocation.NoAddReason.NONE) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this + " because " + (Object)((Object)reason));
        }
        Unit unit = (Unit)locatable;
        if (this.contains(unit)) {
            return true;
        }
        if (!super.add(unit)) {
            return false;
        }
        unit.setState(Unit.UnitState.IN_COLONY);
        unit.setMovesLeft(0);
        this.getColony().setOccupationAt(unit, this, false);
        this.getColony().invalidateCache();
        return true;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (!super.remove(unit)) {
            return false;
        }
        unit.setState(Unit.UnitState.ACTIVE);
        unit.setMovesLeft(0);
        if (this.isEmpty()) {
            this.updateProductionType();
        }
        this.getColony().invalidateCache();
        return true;
    }

    @Override
    public final Settlement getSettlement() {
        return this.colony;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        return locatable instanceof Unit && ((Unit)locatable).isPerson() ? super.getNoAddReason(locatable) : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    public abstract StringTemplate getLabel();

    public abstract UnitLocation.NoAddReason getNoWorkReason();

    public abstract boolean canAutoProduce();

    public abstract boolean canProduce(GoodsType var1, UnitType var2);

    public abstract int getBaseProduction(ProductionType var1, GoodsType var2, UnitType var3);

    public abstract List<Modifier> getProductionModifiers(GoodsType var1, UnitType var2);

    public abstract List<ProductionType> getAvailableProductionTypes(boolean var1);

    public StringTemplate getClaimTemplate() {
        return StringTemplate.name("");
    }

    @Override
    public Player getOwner() {
        return this.colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLONY_TAG, this.colony);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.productionType != null) {
            this.productionType.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colony = xr.findFreeColGameObject(this.getGame(), COLONY_TAG, Colony.class, null, true);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        this.updateProductionType();
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (ProductionType.getXMLElementTagName().equals(tag)) {
            this.productionType = new ProductionType(xr, spec);
        } else {
            super.readChild(xr);
        }
    }
}

