/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

public class UnitTypeChange
extends FreeColObject {
    public static final Map<ChangeType, String> tags = new EnumMap<ChangeType, String>(ChangeType.class);
    private UnitType newUnitType = null;
    protected int turnsToLearn = 0;
    protected final Map<ChangeType, Integer> changeTypes = new EnumMap<ChangeType, Integer>(ChangeType.class);
    private List<Scope> scopes = null;
    private static final String TURNS_TO_LEARN_TAG = "turnsToLearn";
    private static final String UNIT_TAG = "unit";

    public UnitTypeChange() {
    }

    public UnitTypeChange(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(xr);
    }

    public final UnitType getNewUnitType() {
        return this.newUnitType;
    }

    public final void setNewUnitType(UnitType newUnitType) {
        this.newUnitType = newUnitType;
    }

    public final int getTurnsToLearn() {
        return this.turnsToLearn;
    }

    public final void setTurnsToLearn(int newTurnsToLearn) {
        this.turnsToLearn = newTurnsToLearn;
    }

    public Map<ChangeType, Integer> getChangeTypes() {
        return this.changeTypes;
    }

    public final int getProbability(ChangeType type) {
        Integer result = this.changeTypes.get((Object)type);
        return result == null ? 0 : result;
    }

    public boolean asResultOf(ChangeType type) {
        return this.changeTypes.containsKey((Object)type) && this.changeTypes.get((Object)type) > 0;
    }

    public boolean canBeTaught() {
        return this.asResultOf(ChangeType.EDUCATION) && this.turnsToLearn > 0;
    }

    public List<Scope> getScopes() {
        return this.scopes == null ? Collections.emptyList() : this.scopes;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    private void addScope(Scope scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public boolean appliesTo(Player player) {
        List<Scope> scopeList = this.getScopes();
        if (scopeList.isEmpty()) {
            return true;
        }
        for (Scope scope : scopeList) {
            if (!scope.appliesTo(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.newUnitType != null) {
            xw.writeAttribute(UNIT_TAG, this.newUnitType);
        }
        if (this.turnsToLearn != Integer.MIN_VALUE) {
            xw.writeAttribute(TURNS_TO_LEARN_TAG, this.turnsToLearn);
        }
        for (Map.Entry<ChangeType, Integer> entry : this.changeTypes.entrySet()) {
            xw.writeAttribute(tags.get((Object)entry.getKey()), entry.getValue().toString());
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Scope scope : this.getScopes()) {
            scope.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        if (xr.hasAttribute(UNIT_TAG)) {
            this.newUnitType = xr.getType(spec, UNIT_TAG, UnitType.class, null);
            this.turnsToLearn = xr.getAttribute(TURNS_TO_LEARN_TAG, Integer.MIN_VALUE);
            if (this.turnsToLearn > 0) {
                this.changeTypes.put(ChangeType.EDUCATION, 100);
            }
            for (ChangeType type : ChangeType.values()) {
                int value = xr.getAttribute(tags.get((Object)type), -1);
                if (value < 0) continue;
                this.changeTypes.put(type, Math.min(100, value));
            }
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.scopes = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (Scope.getXMLElementTagName().equals(tag)) {
            this.addScope(new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.newUnitType).append(" ").append(Integer.toString(this.turnsToLearn));
        for (Map.Entry<ChangeType, Integer> entry : this.changeTypes.entrySet()) {
            sb.append(" ").append(tags.get((Object)entry.getKey())).append("/").append(entry.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return UnitTypeChange.getXMLElementTagName();
    }

    public static final String getXMLElementTagName() {
        return "upgrade";
    }

    static {
        tags.put(ChangeType.EDUCATION, "learnInSchool");
        tags.put(ChangeType.NATIVES, "learnFromNatives");
        tags.put(ChangeType.EXPERIENCE, "learnFromExperience");
        tags.put(ChangeType.LOST_CITY, "learnInLostCity");
        tags.put(ChangeType.PROMOTION, "promotion");
        tags.put(ChangeType.CLEAR_SKILL, "clearSkill");
        tags.put(ChangeType.DEMOTION, "demotion");
        tags.put(ChangeType.CAPTURE, "capture");
        tags.put(ChangeType.CREATION, "creation");
        tags.put(ChangeType.ENTER_COLONY, "enterColony");
        tags.put(ChangeType.INDEPENDENCE, "independence");
        tags.put(ChangeType.CONVERSION, "conversion");
        tags.put(ChangeType.UNDEAD, "undead");
    }

    public static enum ChangeType {
        EDUCATION,
        NATIVES,
        EXPERIENCE,
        LOST_CITY,
        PROMOTION,
        CREATION,
        ENTER_COLONY,
        INDEPENDENCE,
        CLEAR_SKILL,
        DEMOTION,
        CAPTURE,
        CONVERSION,
        UNDEAD;

    }
}

