/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

public class TradeRoute
extends FreeColGameObject
implements Nameable,
Ownable {
    private static final Logger logger = Logger.getLogger(TradeRoute.class.getName());
    private String name;
    private Player owner;
    private final List<TradeRouteStop> stops = new ArrayList<TradeRouteStop>();
    private boolean silent = false;
    private static final String NAME_TAG = "name";
    private static final String OWNER_TAG = "owner";
    private static final String SILENT_TAG = "silent";

    public TradeRoute(Game game, String name, Player player) {
        super(game);
        this.name = name;
        this.owner = player;
        this.silent = false;
    }

    public TradeRoute(Game game, String id) {
        super(game, id);
    }

    public TradeRoute(Game game, Element e) {
        super(game, null);
        this.readFromXMLElement(e);
    }

    public synchronized void updateFrom(TradeRoute other) {
        this.setName(other.getName());
        this.stops.clear();
        for (TradeRouteStop otherStop : other.getStops()) {
            this.addStop(new TradeRouteStop(otherStop));
        }
        this.silent = other.silent;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String newName) {
        this.name = newName;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public final List<TradeRouteStop> getStops() {
        return this.stops;
    }

    public void addStop(TradeRouteStop stop) {
        this.stops.add(stop);
    }

    public void removeStop(TradeRouteStop stop) {
        this.stops.remove(stop);
    }

    public void clearStops() {
        this.stops.clear();
    }

    public List<Unit> getAssignedUnits() {
        ArrayList<Unit> list = new ArrayList<Unit>();
        for (Unit unit : this.owner.getUnits()) {
            if (unit.getTradeRoute() != this) continue;
            list.add(unit);
        }
        return list;
    }

    public static boolean isStopValid(Unit unit, TradeRouteStop stop) {
        return TradeRoute.isStopValid(unit.getOwner(), stop);
    }

    public static boolean isStopValid(Player player, TradeRouteStop stop) {
        return stop == null ? false : stop.isValid(player);
    }

    public StringTemplate verify() {
        if (this.owner == null) {
            return StringTemplate.template("tradeRoute.nullOwner");
        }
        for (TradeRoute route : this.owner.getTradeRoutes()) {
            if (route == this || !route.getName().equals(this.name)) continue;
            return StringTemplate.template("tradeRoute.duplicateName").addName("%name%", this.name);
        }
        if (this.stops.size() < 2) {
            return StringTemplate.template("tradeRoute.notEnoughStops");
        }
        HashSet<GoodsType> always = new HashSet<GoodsType>(this.stops.get(0).getCargo());
        boolean empty = true;
        for (TradeRouteStop stop : this.stops) {
            if (!TradeRoute.isStopValid(this.owner, stop)) {
                return StringTemplate.template("tradeRoute.invalidStop").addStringTemplate("%name%", stop.getLocation().getLocationLabelFor(this.owner));
            }
            if (!stop.getCargo().isEmpty()) {
                empty = false;
            }
            always.retainAll(stop.getCargo());
        }
        if (empty) {
            return StringTemplate.template("tradeRoute.allEmpty");
        }
        if (!always.isEmpty()) {
            return StringTemplate.template("tradeRoute.alwaysPresent").add("%goodsType%", ((GoodsType)always.iterator().next()).getNameKey());
        }
        return null;
    }

    @Override
    public final Player getOwner() {
        return this.owner;
    }

    @Override
    public final void setOwner(Player newOwner) {
        this.owner = newOwner;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NAME_TAG, this.getName());
        xw.writeAttribute(OWNER_TAG, this.getOwner());
        xw.writeAttribute(SILENT_TAG, this.isSilent());
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (TradeRouteStop stop : this.stops) {
            stop.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.name = xr.getAttribute(NAME_TAG, null);
        this.owner = xr.findFreeColGameObject(this.getGame(), OWNER_TAG, Player.class, null, true);
        this.silent = xr.getAttribute(SILENT_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.stops.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (TradeRouteStop.getXMLElementTagName().equals(tag)) {
            this.stops.add(new TradeRouteStop(this.getGame(), xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getXMLTagName()).append(" \"").append(this.getName()).append("\"").append(" owner=").append(this.owner.getId()).append(" silent=").append(Boolean.toString(this.silent));
        for (TradeRouteStop stop : this.getStops()) {
            sb.append(" ").append(stop);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TradeRoute.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tradeRoute";
    }
}

