/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

public class TileItemContainer
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(TileItemContainer.class.getName());
    private static final Comparator<TileItem> tileItemComparator = new Comparator<TileItem>(){

        @Override
        public int compare(TileItem tileItem1, TileItem tileItem2) {
            int cmp = tileItem1.getZIndex() - tileItem2.getZIndex();
            if (cmp == 0) {
                cmp = FreeColObject.compareIds(tileItem1, tileItem2);
            }
            return cmp;
        }
    };
    private Tile tile;
    private final List<TileItem> tileItems = new ArrayList<TileItem>();
    private static final String TILE_TAG = "tile";

    public TileItemContainer(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
    }

    public TileItemContainer(Game game, Tile tile, TileItemContainer template, Map.Layer layer) {
        this(game, tile);
        Specification spec = this.getSpecification();
        for (TileItem item : template.getTileItems()) {
            if (item instanceof Resource) {
                Resource resource = (Resource)item;
                if (layer.compareTo(Map.Layer.RESOURCES) < 0) continue;
                this.addTileItem(new Resource(game, tile, spec.getResourceType(resource.getId()), resource.getQuantity()));
                continue;
            }
            if (item instanceof LostCityRumour) {
                LostCityRumour rumour = (LostCityRumour)item;
                if (layer.compareTo(Map.Layer.NATIVES) < 0) continue;
                this.addTileItem(new LostCityRumour(game, tile, rumour.getType(), rumour.getName()));
                continue;
            }
            if (item instanceof TileImprovement) {
                TileImprovement improvement = (TileImprovement)item;
                if (layer.compareTo(Map.Layer.RIVERS) < 0 && !improvement.getType().isNatural()) continue;
                this.addTileItem(new TileImprovement(game, tile, improvement));
                continue;
            }
            logger.warning("Bogus tile item: " + item.getId());
        }
    }

    public TileItemContainer(Game game, String id) {
        super(game, id);
    }

    public final Tile getTile() {
        return this.tile;
    }

    public final List<TileItem> getTileItems() {
        return this.tileItems;
    }

    public final void setTileItems(List<TileItem> newTileItems) {
        this.tileItems.clear();
        if (newTileItems != null) {
            this.tileItems.addAll(newTileItems);
        }
        this.invalidateCache();
    }

    private void invalidateCache() {
        Colony colony = this.tile.getColony();
        if (colony != null && colony.isTileInUse(this.tile)) {
            colony.invalidateCache();
        }
    }

    public final LostCityRumour getLostCityRumour() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof LostCityRumour)) continue;
            return (LostCityRumour)item;
        }
        return null;
    }

    public final Resource getResource() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof Resource)) continue;
            return (Resource)item;
        }
        return null;
    }

    public boolean hasImprovement(TileImprovementType type) {
        TileImprovement improvement = this.getImprovement(type);
        return improvement != null && improvement.isComplete();
    }

    public TileImprovement getImprovement(TileImprovementType type) {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || ((TileImprovement)item).getType() != type) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public TileImprovement getRoad() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isRoad()) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public TileImprovement getRiver() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isRiver()) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public void removeIncompatibleImprovements() {
        TileType tileType = this.tile.getType();
        Iterator<TileItem> iterator = this.tileItems.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            TileItem item = iterator.next();
            if (item.isTileTypeAllowed(tileType)) continue;
            iterator.remove();
            item.dispose();
            removed = true;
        }
        if (removed) {
            this.invalidateCache();
        }
    }

    private List<TileImprovement> getImprovements(boolean completedOnly) {
        ArrayList<TileImprovement> improvements = new ArrayList<TileImprovement>();
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || completedOnly && !((TileImprovement)item).isComplete()) continue;
            improvements.add((TileImprovement)item);
        }
        return improvements;
    }

    public List<TileImprovement> getImprovements() {
        return this.getImprovements(false);
    }

    public List<TileImprovement> getCompletedImprovements() {
        return this.getImprovements(true);
    }

    public final TileItem addTileItem(TileItem item) {
        if (item == null) {
            return null;
        }
        for (int index = 0; index < this.tileItems.size(); ++index) {
            TileItem oldItem = this.tileItems.get(index);
            if (!(item instanceof TileImprovement) || !(oldItem instanceof TileImprovement)) continue;
            TileImprovement oldTip = (TileImprovement)oldItem;
            TileImprovement newTip = (TileImprovement)item;
            if (oldTip.getType().getId().equals(newTip.getType().getId())) {
                if (oldTip.getMagnitude() < newTip.getMagnitude()) {
                    this.tileItems.set(index, item);
                    oldItem.dispose();
                    this.invalidateCache();
                    return item;
                }
                return oldItem;
            }
            if (oldItem.getZIndex() > item.getZIndex()) break;
        }
        this.tileItems.add(item);
        this.invalidateCache();
        return item;
    }

    public final <T extends TileItem> T removeTileItem(T item) {
        boolean removed = this.tileItems.remove(item);
        if (removed) {
            item.setLocation(null);
            this.invalidateCache();
            return item;
        }
        return null;
    }

    public final <T extends TileItem> void removeAll(Class<T> c) {
        Iterator<TileItem> iterator = this.tileItems.iterator();
        while (iterator.hasNext()) {
            if (!c.isInstance(iterator.next())) continue;
            iterator.remove();
        }
    }

    public int getTotalBonusPotential(GoodsType goodsType, UnitType unitType, int potential, boolean onlyNatural) {
        int result = potential;
        for (TileItem item : this.tileItems) {
            if (!item.isNatural() && onlyNatural) continue;
            result = item.applyBonus(goodsType, unitType, result);
        }
        return result;
    }

    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (TileItem item : this.tileItems) {
            result.addAll(item.getProductionModifiers(goodsType, unitType));
        }
        return result;
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        for (TileItem ti : this.tileItems) {
            if (!ti.canProduce(goodsType, unitType)) continue;
            return true;
        }
        return false;
    }

    public int getMoveCost(Tile fromTile, Tile targetTile, int basicMoveCost) {
        int moveCost = basicMoveCost;
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isComplete()) continue;
            Map.Direction direction = targetTile.getDirection(fromTile);
            if (direction == null) {
                return Integer.MAX_VALUE;
            }
            moveCost = Math.min(moveCost, ((TileImprovement)item).getMoveCost(direction, moveCost));
        }
        return moveCost;
    }

    public void copyFrom(TileItemContainer tic) {
        this.copyFrom(tic, true, false);
    }

    public void copyFrom(TileItemContainer tic, boolean importResources) {
        this.copyFrom(tic, importResources, false);
    }

    public void copyFrom(TileItemContainer tic, boolean importResources, boolean copyOnlyNatural) {
        this.tileItems.clear();
        for (TileItem item : tic.getTileItems()) {
            TileItem r;
            TileItem ticR;
            if (item instanceof Resource) {
                if (!importResources) continue;
                ticR = (Resource)item;
                r = new Resource(this.getGame(), this.tile, ((Resource)ticR).getType(), ((Resource)ticR).getQuantity());
                this.tileItems.add(r);
                continue;
            }
            if (item instanceof LostCityRumour) {
                if (copyOnlyNatural) continue;
                ticR = (LostCityRumour)item;
                r = new LostCityRumour(this.getGame(), this.tile, ((LostCityRumour)ticR).getType(), ((LostCityRumour)ticR).getName());
                this.addTileItem(r);
                continue;
            }
            if (!(item instanceof TileImprovement) || copyOnlyNatural && !((TileImprovement)item).getType().isNatural()) continue;
            this.addTileItem(new TileImprovement(this.getGame(), this.tile, (TileImprovement)item));
        }
    }

    public boolean contains(TileItem t) {
        return this.tileItems.contains(t);
    }

    @Override
    public void disposeResources() {
        this.tileItems.clear();
        super.disposeResources();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        for (TileItem ti : new ArrayList<TileItem>(this.tileItems)) {
            int integ = ti.checkIntegrity(fix);
            if (fix) {
                if (ti.getTile() != this.tile) {
                    logger.warning("Fixing improvement tile at: " + this.tile + " / " + ti.getId());
                    ti.setLocation(this.tile);
                    integ = Math.min(integ, 0);
                }
                if (integ < 0) {
                    logger.warning("Removing broken improvement at: " + this.tile + " / " + ti.getId());
                    this.tileItems.remove(ti);
                    integ = 0;
                }
            }
            result = Math.min(result, integ);
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.tile);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (TileItem item : this.tileItems) {
            item.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.tile = xr.findFreeColGameObject(this.getGame(), TILE_TAG, Tile.class, null, true);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.tileItems.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (LostCityRumour.getXMLElementTagName().equals(tag)) {
            LostCityRumour lcr = xr.readFreeColGameObject(game, LostCityRumour.class);
            if (lcr != null) {
                this.tileItems.add(lcr);
                lcr.setTile(this.tile);
            }
        } else if (Resource.getXMLElementTagName().equals(tag)) {
            this.tileItems.add(xr.readFreeColGameObject(game, Resource.class));
        } else if (TileImprovement.getXMLElementTagName().equals(tag)) {
            this.tileItems.add(xr.readFreeColGameObject(game, TileImprovement.class));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getId());
        for (TileItem item : this.tileItems) {
            sb.append(" ").append(item);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TileItemContainer.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tileitemcontainer";
    }
}

