/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

public abstract class TileItem
extends FreeColGameObject
implements Locatable {
    public static final int RESOURCE_ZINDEX = 400;
    public static final int RUMOUR_ZINDEX = 500;
    protected Tile tile;

    public TileItem(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new IllegalArgumentException("Parameter 'tile' must not be 'null'.");
        }
        this.tile = tile;
    }

    public TileItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, null);
    }

    public TileItem(Game game, String id) {
        super(game, id);
    }

    public abstract int getZIndex();

    public abstract boolean isTileTypeAllowed(TileType var1);

    public abstract int applyBonus(GoodsType var1, UnitType var2, int var3);

    public abstract boolean canProduce(GoodsType var1, UnitType var2);

    public abstract List<Modifier> getProductionModifiers(GoodsType var1, UnitType var2);

    public abstract boolean isNatural();

    @Override
    public Location getLocation() {
        return this.tile;
    }

    @Override
    public boolean setLocation(Location newLocation) {
        if (newLocation == null || newLocation instanceof Tile) {
            this.tile = (Tile)newLocation;
            return true;
        }
        throw new IllegalArgumentException("newLocation is not a Tile");
    }

    @Override
    public boolean isInEurope() {
        return false;
    }

    @Override
    public Tile getTile() {
        return this.tile;
    }

    @Override
    public int getSpaceTaken() {
        return 0;
    }
}

