/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

public class Resource
extends TileItem {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    private static final int UNLIMITED = -1;
    private ResourceType type;
    private int quantity;
    private static final String QUANTITY_TAG = "quantity";
    private static final String TILE_TAG = "tile";
    private static final String TYPE_TAG = "type";

    public Resource(Game game, Tile tile, ResourceType type, int quantity) {
        super(game, tile);
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        this.type = type;
        this.quantity = quantity;
    }

    public Resource(Game game, Tile tile, ResourceType type) {
        this(game, tile, type, type.getMaxValue());
    }

    public Resource(Game game, String id) {
        super(game, id);
    }

    public String getNameKey() {
        return this.getType().getNameKey();
    }

    public ResourceType getType() {
        return this.type;
    }

    public boolean isUnlimited() {
        return this.quantity == -1;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int newQuantity) {
        this.quantity = newQuantity;
    }

    public GoodsType getBestGoodsType() {
        return this.type.getBestGoodsType();
    }

    public int useQuantity(GoodsType goodsType, UnitType unitType, int potential) {
        return this.useQuantity(this.applyBonus(goodsType, unitType, potential) - potential);
    }

    public int useQuantity(int usedQuantity) {
        if (this.quantity != -1) {
            if (this.quantity >= usedQuantity) {
                this.quantity -= usedQuantity;
            } else {
                logger.severe("Insufficient quantity in " + this);
                this.quantity = 0;
            }
        }
        return this.quantity;
    }

    @Override
    public final int getZIndex() {
        return 400;
    }

    @Override
    public boolean isTileTypeAllowed(TileType tileType) {
        return tileType.canHaveResourceType(this.getType());
    }

    @Override
    public int applyBonus(GoodsType goodsType, UnitType unitType, int potential) {
        Set<Modifier> bonus = this.type.getModifiers(goodsType.getId(), unitType);
        int amount = (int)Resource.applyModifiers(potential, null, bonus) - potential;
        return potential + (this.quantity == -1 || this.quantity > amount ? amount : this.quantity);
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return false;
        }
        return (int)Resource.applyModifiers(0.0f, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType)) > 0;
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        return goodsType == null ? Collections.emptyList() : new ArrayList<Modifier>(this.getType().getModifiers(goodsType.getId(), unitType));
    }

    @Override
    public boolean isNatural() {
        return true;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        return this.type == null ? -1 : 1;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.getTile());
        xw.writeAttribute(TYPE_TAG, this.getType());
        xw.writeAttribute(QUANTITY_TAG, this.quantity);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(xr);
        this.tile = xr.findFreeColGameObject(this.getGame(), TILE_TAG, Tile.class, null, true);
        this.type = xr.getType(spec, TYPE_TAG, ResourceType.class, null);
        this.quantity = xr.getAttribute(QUANTITY_TAG, 0);
    }

    @Override
    public String toString() {
        return this.quantity == -1 ? this.getType().getId() : Integer.toString(this.quantity) + " " + this.getType().getId();
    }

    @Override
    public String getXMLTagName() {
        return Resource.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "resource";
    }
}

