/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;

public class Region
extends FreeColGameObject
implements Nameable {
    private static final Logger logger = Logger.getLogger(Region.class.getName());
    public static final String PACIFIC_NAME_KEY = "model.region.pacific";
    protected String name;
    protected RegionType type;
    protected String nameKey;
    protected Region parent;
    protected boolean claimable = false;
    protected boolean discoverable = false;
    protected Turn discoveredIn;
    protected Player discoveredBy;
    protected String discoverer;
    protected boolean prediscovered = false;
    protected int scoreValue = 0;
    protected List<Region> children = null;
    private static final String CHILD_TAG = "child";
    private static final String CLAIMABLE_TAG = "claimable";
    private static final String DISCOVERABLE_TAG = "discoverable";
    private static final String DISCOVERED_BY_TAG = "discoveredBy";
    private static final String DISCOVERED_IN_TAG = "discoveredIn";
    private static final String NAME_TAG = "name";
    private static final String NAME_KEY_TAG = "nameKey";
    private static final String PARENT_TAG = "parent";
    private static final String PREDISCOVERED_TAG = "prediscovered";
    private static final String SCORE_VALUE_TAG = "scoreValue";
    private static final String TYPE_TAG = "type";

    public Region(Game game) {
        super(game);
    }

    public Region(Game game, String id) {
        super(game, id);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String newName) {
        this.name = newName;
    }

    public final String getNameKey() {
        return this.nameKey;
    }

    public final void setNameKey(String newNameKey) {
        this.nameKey = newNameKey;
    }

    public boolean isPacific() {
        if (PACIFIC_NAME_KEY.equals(this.nameKey)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isPacific();
        }
        return false;
    }

    public StringTemplate getLabel() {
        return this.prediscovered || this.isPacific() ? StringTemplate.key(this.nameKey) : (this.name == null ? StringTemplate.key(this.type.getUnknownKey()) : StringTemplate.name(this.name));
    }

    public final RegionType getType() {
        return this.type;
    }

    public final void setType(RegionType newType) {
        this.type = newType;
    }

    public final Region getParent() {
        return this.parent;
    }

    public final void setParent(Region newParent) {
        this.parent = newParent;
    }

    public final List<Region> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public final void setChildren(List<Region> newChildren) {
        this.children = newChildren;
    }

    public void addChild(Region child) {
        if (this.children == null) {
            this.children = new ArrayList<Region>();
        }
        this.children.add(child);
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public final boolean isClaimable() {
        return this.claimable;
    }

    public final void setClaimable(boolean newClaimable) {
        this.claimable = newClaimable;
    }

    public final boolean isDiscoverable() {
        return this.discoverable;
    }

    public final void setDiscoverable(boolean newDiscoverable) {
        this.discoverable = newDiscoverable;
        if (this.discoverable) {
            this.prediscovered = false;
        }
    }

    public String getDiscoverer() {
        return this.discoverer;
    }

    public void setDiscoverer(String discoverer) {
        this.discoverer = discoverer;
    }

    public Region getDiscoverableRegion() {
        if (this.isDiscoverable()) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getDiscoverableRegion();
        }
        return null;
    }

    public final Turn getDiscoveredIn() {
        return this.discoveredIn;
    }

    public final void setDiscoveredIn(Turn newDiscoveredIn) {
        this.discoveredIn = newDiscoveredIn;
    }

    public final Player getDiscoveredBy() {
        return this.discoveredBy;
    }

    public final void setDiscoveredBy(Player newDiscoveredBy) {
        this.discoveredBy = newDiscoveredBy;
    }

    public final boolean isPrediscovered() {
        return this.prediscovered;
    }

    public final void setPrediscovered(boolean newPrediscovered) {
        this.prediscovered = newPrediscovered;
    }

    public HistoryEvent discover(Unit unit, Turn turn, String newName) {
        Player player;
        if (!this.isPacific()) {
            this.name = newName;
        }
        this.discoveredBy = player = unit.getOwner();
        this.discoveredIn = turn;
        this.discoverable = false;
        for (Region r : this.getChildren()) {
            r.setDiscoverable(false);
        }
        int score = this.isDiscoverable() && this.getSpecification().getBoolean("model.option.explorationPoints") ? this.getScoreValue() : 0;
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.EventType.DISCOVER_REGION, player).addStringTemplate("%nation%", player.getNationName()).addName("%region%", newName);
        h.setScore(this.getScoreValue());
        return h;
    }

    public final int getScoreValue() {
        return this.scoreValue;
    }

    public final void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.name != null) {
            xw.writeAttribute(NAME_TAG, this.name);
        }
        xw.writeAttribute(NAME_KEY_TAG, this.nameKey);
        xw.writeAttribute(TYPE_TAG, this.type);
        xw.writeAttribute(PREDISCOVERED_TAG, this.prediscovered);
        xw.writeAttribute(CLAIMABLE_TAG, this.claimable);
        xw.writeAttribute(DISCOVERABLE_TAG, this.discoverable);
        if (this.parent != null) {
            xw.writeAttribute(PARENT_TAG, this.parent);
        }
        if (this.discoveredIn != null) {
            xw.writeAttribute(DISCOVERED_IN_TAG, this.discoveredIn.getNumber());
        }
        if (this.discoveredBy != null) {
            xw.writeAttribute(DISCOVERED_BY_TAG, this.discoveredBy);
        }
        if (this.scoreValue > 0) {
            xw.writeAttribute(SCORE_VALUE_TAG, this.scoreValue);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Region child : this.getChildren()) {
            xw.writeStartElement(CHILD_TAG);
            xw.writeAttribute("id", child);
            xw.writeEndElement();
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.name = xr.getAttribute(NAME_TAG, null);
        this.nameKey = xr.getAttribute(NAME_KEY_TAG, null);
        this.type = xr.getAttribute(TYPE_TAG, RegionType.class, null);
        this.claimable = xr.getAttribute(CLAIMABLE_TAG, false);
        this.discoverable = xr.getAttribute(DISCOVERABLE_TAG, false);
        this.prediscovered = xr.getAttribute(PREDISCOVERED_TAG, false);
        this.scoreValue = xr.getAttribute(SCORE_VALUE_TAG, 0);
        int turn = xr.getAttribute(DISCOVERED_IN_TAG, Integer.MIN_VALUE);
        this.discoveredIn = turn == Integer.MIN_VALUE ? null : new Turn(turn);
        this.discoveredBy = xr.findFreeColGameObject(this.getGame(), DISCOVERED_BY_TAG, Player.class, null, false);
        this.parent = xr.makeFreeColGameObject(this.getGame(), PARENT_TAG, Region.class, false);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.children = null;
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (CHILD_TAG.equals(tag)) {
            this.addChild(xr.makeFreeColGameObject(this.getGame(), "id", Region.class, true));
            xr.closeTag(CHILD_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" ").append(this.name == null ? "(null)" : this.name).append(" ").append(this.nameKey).append(" ").append(this.type).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Region.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "region";
    }

    public static enum RegionType implements Named
    {
        OCEAN,
        COAST,
        LAKE,
        RIVER,
        LAND,
        MOUNTAIN,
        DESERT;


        public String getNameIndexKey() {
            return "index." + this.toString().toLowerCase(Locale.US);
        }

        public String getUnknownKey() {
            return "model.region." + this.toString().toLowerCase(Locale.US) + ".unknown";
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model.region." + this.toString().toLowerCase(Locale.US));
        }
    }
}

