/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.util.RandomUtils;

public class RandomRange {
    private static final Logger logger = Logger.getLogger(RandomRange.class.getName());
    private int probability = 0;
    private int minimum = 0;
    private int maximum = 0;
    private int factor = 1;
    private List<Scope> scopes = null;
    private static final String FACTOR_TAG = "factor";
    private static final String MAXIMUM_TAG = "maximum";
    private static final String MINIMUM_TAG = "minimum";
    private static final String PROBABILITY_TAG = "probability";
    private static final String SCOPE_TAG = "scope";

    public RandomRange(int probability, int minimum, int maximum, int factor) {
        if (probability < 0) {
            throw new IllegalArgumentException("Negative probability " + probability);
        }
        if (minimum > maximum) {
            throw new IllegalArgumentException("Min " + minimum + " > Max " + maximum);
        }
        this.probability = probability;
        this.minimum = minimum;
        this.maximum = maximum;
        this.factor = factor;
    }

    public RandomRange(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final int getProbability() {
        return this.probability;
    }

    public final int getMinimum() {
        return this.minimum;
    }

    public final int getMaximum() {
        return this.maximum;
    }

    public final int getFactor() {
        return this.factor;
    }

    public List<Scope> getScopes() {
        return this.scopes == null ? Collections.emptyList() : this.scopes;
    }

    private void addScope(Scope scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public int getAmount(String prefix, Random random, boolean continuous) {
        if (this.probability >= 100 || this.probability > 0 && RandomUtils.randomInt(logger, prefix + " check-probability", random, 100) < this.probability) {
            int range = this.maximum - this.minimum + 1;
            if (continuous) {
                int r = RandomUtils.randomInt(logger, prefix + " random-range", random, range * this.factor);
                return r + this.minimum * this.factor;
            }
            int r = RandomUtils.randomInt(logger, prefix + " random-range", random, range);
            return (r + this.minimum) * this.factor;
        }
        return 0;
    }

    public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        xw.writeStartElement(tag);
        xw.writeAttribute(PROBABILITY_TAG, this.probability);
        xw.writeAttribute(MINIMUM_TAG, this.minimum);
        xw.writeAttribute(MAXIMUM_TAG, this.maximum);
        xw.writeAttribute(FACTOR_TAG, this.factor);
        for (Scope scope : this.getScopes()) {
            scope.toXML(xw);
        }
        xw.writeEndElement();
    }

    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        this.probability = xr.getAttribute(PROBABILITY_TAG, 0);
        this.minimum = xr.getAttribute(MINIMUM_TAG, 0);
        this.maximum = xr.getAttribute(MAXIMUM_TAG, 0);
        this.factor = xr.getAttribute(FACTOR_TAG, 0);
        if (this.scopes != null) {
            this.scopes.clear();
        }
        while (xr.nextTag() != 2) {
            String tag = xr.getLocalName();
            if (SCOPE_TAG.equals(tag)) {
                this.addScope(new Scope(xr));
                continue;
            }
            throw new XMLStreamException("Bogus RandomRange tag: " + tag);
        }
    }
}

