/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionMap;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;

public class ProductionCache {
    private final Colony colony;
    private final TypeCountMap<GoodsType> netProduction = new TypeCountMap();
    private final Map<Object, ProductionInfo> productionAndConsumption = new HashMap<Object, ProductionInfo>();
    private final Set<GoodsType> goodsUsed = new HashSet<GoodsType>();
    private boolean upToDate = false;

    public ProductionCache(Colony colony) {
        this.colony = colony;
    }

    private synchronized void update() {
        if (this.upToDate) {
            return;
        }
        Specification spec = this.colony.getSpecification();
        GoodsType bells = spec.getGoodsType("model.goods.bells");
        this.productionAndConsumption.clear();
        this.netProduction.clear();
        this.goodsUsed.clear();
        ProductionMap production = new ProductionMap();
        for (ColonyTile colonyTile : this.colony.getColonyTiles()) {
            ProductionInfo info = colonyTile.getBasicProductionInfo();
            production.add(info.getProduction());
            this.productionAndConsumption.put(colonyTile, info);
            for (AbstractGoods goods : info.getProduction()) {
                this.goodsUsed.add(goods.getType());
                this.netProduction.incrementCount(goods.getType().getStoredAs(), goods.getAmount());
            }
        }
        int unitsThatUseNoBells = spec.getInteger("model.option.unitsThatUseNoBells");
        int amount = Math.min(unitsThatUseNoBells, this.colony.getUnitCount());
        ProductionInfo bellsInfo = new ProductionInfo();
        bellsInfo.addProduction(new AbstractGoods(bells, amount));
        this.productionAndConsumption.put(this, bellsInfo);
        this.netProduction.incrementCount(bells, amount);
        ArrayList<AbstractGoods> goods = new ArrayList<AbstractGoods>();
        for (Consumer consumer : this.colony.getConsumers()) {
            Set<Modifier> modifiers = consumer.getModifiers("model.modifier.consumeOnlySurplusProduction");
            goods.clear();
            for (AbstractGoods g : consumer.getConsumedGoods()) {
                this.goodsUsed.add(g.getType());
                AbstractGoods surplus = new AbstractGoods(production.get(g.getType()));
                if (modifiers.isEmpty()) {
                    surplus.setAmount(surplus.getAmount() + this.getGoodsCount(g.getType()));
                } else {
                    surplus.setAmount((int)FeatureContainer.applyModifiers(surplus.getAmount(), null, modifiers));
                }
                goods.add(surplus);
            }
            ProductionInfo info = null;
            if (consumer instanceof Building) {
                Building building = (Building)consumer;
                ArrayList<AbstractGoods> outputs = new ArrayList<AbstractGoods>();
                for (AbstractGoods output : building.getOutputs()) {
                    GoodsType outputType = output.getType();
                    this.goodsUsed.add(outputType);
                    AbstractGoods newOutput = new AbstractGoods(production.get(outputType));
                    newOutput.setAmount(newOutput.getAmount() + this.getGoodsCount(outputType));
                    outputs.add(newOutput);
                }
                info = building.getAdjustedProductionInfo(goods, outputs);
            } else if (consumer instanceof Unit) {
                info = ((Unit)consumer).getProductionInfo(goods);
            } else if (consumer instanceof BuildQueue) {
                info = ((BuildQueue)consumer).getProductionInfo(goods);
            }
            if (info == null) continue;
            production.add(info.getProduction());
            production.remove(info.getConsumption());
            for (AbstractGoods g : info.getProduction()) {
                this.netProduction.incrementCount(g.getType().getStoredAs(), g.getAmount());
            }
            for (AbstractGoods g : info.getConsumption()) {
                this.netProduction.incrementCount(g.getType().getStoredAs(), -g.getAmount());
            }
            this.productionAndConsumption.put(consumer, info);
        }
        this.upToDate = true;
    }

    private int getGoodsCount(GoodsType type) {
        return this.colony.getGoodsCount(type);
    }

    public synchronized void invalidate() {
        this.upToDate = false;
    }

    public synchronized void invalidate(GoodsType goodsType) {
        if (this.goodsUsed.contains(goodsType)) {
            this.upToDate = false;
        }
    }

    public int getNetProductionOf(GoodsType type) {
        this.update();
        return this.netProduction.getCount(type);
    }

    public ProductionInfo getProductionInfo(Object object) {
        this.update();
        return this.productionAndConsumption.get(object);
    }

    public TypeCountMap<GoodsType> getProductionMap() {
        this.update();
        TypeCountMap<GoodsType> result = new TypeCountMap<GoodsType>();
        result.putAll(this.netProduction);
        return result;
    }
}

