/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class PlayerExploredTile
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(PlayerExploredTile.class.getName());
    private Player player;
    private Tile tile;
    private Player owner;
    private Settlement owningSettlement;
    private List<TileItem> tileItems = null;
    private int colonyUnitCount = 0;
    private Unit missionary = null;
    private Tension alarm = null;
    private Player mostHated = null;
    private static final String ALARM_TAG = "alarm";
    private static final String COLONY_UNIT_COUNT_TAG = "colonyUnitCount";
    private static final String LEARNABLE_SKILL_TAG = "learnableSkill";
    private static final String MISSIONARY_TAG = "missionary";
    private static final String MOST_HATED_TAG = "mostHated";
    private static final String OWNER_TAG = "owner";
    private static final String OWNING_SETTLEMENT_TAG = "owningSettlement";
    private static final String PLAYER_TAG = "player";
    private static final String TILE_TAG = "tile";
    private static final String WANTED_GOODS_TAG = "wantedGoods";

    public PlayerExploredTile(Game game, Player player, Tile tile) {
        super(game);
        this.player = player;
        this.tile = tile;
    }

    public PlayerExploredTile(Game game, String id) {
        super(game, id);
    }

    private List<TileItem> getTileItems() {
        return this.tileItems == null ? Collections.emptyList() : this.tileItems;
    }

    private void addTileItem(TileItem item) {
        if (this.tileItems == null) {
            this.tileItems = new ArrayList<TileItem>();
        }
        this.tileItems.add(item);
    }

    public void fixCache() {
        Settlement ts;
        List<TileItem> ti;
        if (!this.getSpecification().getBoolean("model.option.fogOfWar")) {
            this.tile.setCachedTile(this.player, this.tile);
            return;
        }
        Tile copied = this.tile.getTileToCache();
        boolean ok = true;
        if (this.tile.getOwner() != this.owner) {
            copied.setOwner(this.owner);
            ok = false;
        }
        if (this.tile.getOwningSettlement() != this.owningSettlement) {
            copied.setOwningSettlement(this.owningSettlement);
            ok = false;
        }
        if ((ti = copied.getTileItemContainer() == null ? null : copied.getTileItemContainer().getTileItems()) == null != (this.tileItems == null) || ti != null && ti.size() != this.tileItems.size()) {
            ok = false;
        }
        if ((ts = copied.getSettlement()) instanceof Colony) {
            Colony colony = (Colony)ts;
            if (this.colonyUnitCount != colony.getUnitCount()) {
                colony.setDisplayUnitCount(this.colonyUnitCount);
                ok = false;
            }
        } else if (ts instanceof IndianSettlement) {
            if (this.missionary == null && this.mostHated == null && this.alarm == null) {
                copied.setSettlement(null);
            } else {
                IndianSettlement is = (IndianSettlement)ts;
                if (this.missionary != is.getMissionary()) {
                    is.setMissionary(null);
                    ok = false;
                }
                if (this.mostHated != is.getMostHated()) {
                    is.setMostHated(this.mostHated);
                    ok = false;
                }
                if (this.alarm != is.getAlarm(this.player)) {
                    is.setAlarm(this.player, this.alarm);
                    ok = false;
                }
            }
        }
        this.tile.setCachedTile(this.player, ok ? this.tile : copied);
    }

    @Override
    public void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(PLAYER_TAG, this.player);
        xw.writeAttribute(TILE_TAG, this.tile);
        if (this.owner != null) {
            xw.writeAttribute(OWNER_TAG, this.owner);
        }
        if (this.owningSettlement != null) {
            xw.writeAttribute(OWNING_SETTLEMENT_TAG, this.owningSettlement);
        }
        if (this.colonyUnitCount > 0) {
            xw.writeAttribute(COLONY_UNIT_COUNT_TAG, this.colonyUnitCount);
        }
        if (this.alarm != null) {
            xw.writeAttribute(ALARM_TAG, this.alarm.getValue());
        }
        if (this.mostHated != null) {
            xw.writeAttribute(MOST_HATED_TAG, this.mostHated.getId());
        }
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.missionary != null && this.tile.getSettlement() != null && this.tile.getSettlement() instanceof IndianSettlement && ((IndianSettlement)this.tile.getSettlement()).getMissionary() == this.missionary) {
            xw.writeStartElement(MISSIONARY_TAG);
            this.missionary.toXML(xw);
            xw.writeEndElement();
        }
        for (TileItem ti : this.getTileItems()) {
            ti.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.player = xr.makeFreeColGameObject(game, PLAYER_TAG, Player.class, true);
        this.tile = xr.makeFreeColGameObject(game, TILE_TAG, Tile.class, true);
        this.owner = xr.makeFreeColGameObject(game, OWNER_TAG, Player.class, false);
        this.owningSettlement = xr.findFreeColGameObject(game, OWNING_SETTLEMENT_TAG, Settlement.class, null, false);
        this.colonyUnitCount = xr.getAttribute(COLONY_UNIT_COUNT_TAG, 0);
        this.alarm = new Tension(xr.getAttribute(ALARM_TAG, 0));
        this.mostHated = xr.makeFreeColGameObject(game, MOST_HATED_TAG, Player.class, false);
        IndianSettlement is = this.tile.getIndianSettlement();
        if (is != null) {
            UnitType skill = xr.getType(spec, LEARNABLE_SKILL_TAG, UnitType.class, null);
            boolean natives = skill != null;
            GoodsType[] wanted = new GoodsType[3];
            for (int i = 0; i < 3; ++i) {
                wanted[i] = xr.getType(spec, WANTED_GOODS_TAG + i, GoodsType.class, null);
                natives |= wanted[i] != null;
            }
            if (natives) {
                this.tile.setIndianSettlementInternals(this.player, skill, wanted);
            }
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.tileItems != null) {
            this.tileItems.clear();
        }
        this.missionary = null;
        super.readChildren(xr);
        if (this.tile.getIndianSettlement() == null && this.missionary != null) {
            logger.warning("Dropping ghost missionary " + this.missionary.getId() + " from " + this.getId());
            Player p = this.missionary.getOwner();
            if (p != null) {
                p.removeUnit(this.missionary);
            }
            this.missionary = null;
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (MISSIONARY_TAG.equals(tag)) {
            xr.nextTag();
            this.missionary = xr.readFreeColGameObject(game, Unit.class);
            xr.closeTag(MISSIONARY_TAG);
        } else if (LostCityRumour.getXMLElementTagName().equals(tag)) {
            this.addTileItem(xr.readFreeColGameObject(game, LostCityRumour.class));
        } else if (Resource.getXMLElementTagName().equals(tag)) {
            this.addTileItem(xr.readFreeColGameObject(game, Resource.class));
        } else if (TileImprovement.getXMLElementTagName().equals(tag)) {
            this.addTileItem(xr.readFreeColGameObject(game, TileImprovement.class));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return PlayerExploredTile.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "playerExploredTile";
    }
}

