/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

public class Player
extends FreeColGameObject
implements Nameable {
    private static final Logger logger = Logger.getLogger(Player.class.getName());
    private static final Comparator<Unit> xyComparator = new Comparator<Unit>(){

        @Override
        public int compare(Unit unit1, Unit unit2) {
            Tile tile1 = unit1.getTile();
            Tile tile2 = unit2.getTile();
            int cmp = (tile1 == null ? 0 : tile1.getY()) - (tile2 == null ? 0 : tile2.getY());
            return cmp != 0 || tile1 == null || tile2 == null ? cmp : tile1.getX() - tile2.getX();
        }
    };
    public static final Comparator<Player> playerComparator = new Comparator<Player>(){

        @Override
        public int compare(Player player1, Player player2) {
            int counter1 = 0;
            int counter2 = 0;
            if (player1.isAdmin()) {
                counter1 += 8;
            }
            if (!player1.isAI()) {
                counter1 += 4;
            }
            if (player1.isEuropean()) {
                counter1 += 2;
            }
            if (player2.isAdmin()) {
                counter2 += 8;
            }
            if (!player2.isAI()) {
                counter2 += 4;
            }
            if (player2.isEuropean()) {
                counter2 += 2;
            }
            return counter2 - counter1;
        }
    };
    public static final int GOLD_NOT_ACCOUNTED = Integer.MIN_VALUE;
    public static final String ASSIGN_SETTLEMENT_NAME = "";
    protected String name;
    protected String independentNationName;
    protected PlayerType playerType;
    protected NationType nationType;
    protected String nationId;
    protected String newLandName = null;
    protected boolean admin;
    protected boolean ai;
    protected boolean ready;
    protected boolean dead = false;
    protected boolean attackedByPrivateers = false;
    private boolean bankrupt;
    protected int score;
    protected int gold;
    protected int immigration;
    protected int immigrationRequired;
    protected int liberty;
    protected int oldSoL = 0;
    protected int interventionBells;
    protected int tax = 0;
    protected Location entryLocation;
    protected Market market;
    protected Europe europe;
    protected Monarch monarch;
    protected final Set<FoundingFather> foundingFathers = new HashSet<FoundingFather>();
    protected FoundingFather currentFather;
    protected final List<FoundingFather> offeredFathers = new ArrayList<FoundingFather>();
    protected final java.util.Map<Player, Tension> tension = new HashMap<Player, Tension>();
    protected Set<Player> bannedMissions = null;
    protected final java.util.Map<String, Stance> stance = new HashMap<String, Stance>();
    protected final List<TradeRoute> tradeRoutes = new ArrayList<TradeRoute>();
    protected final List<ModelMessage> modelMessages = new ArrayList<ModelMessage>();
    protected final List<HistoryEvent> history = new ArrayList<HistoryEvent>();
    protected HashMap<String, LastSale> lastSales = null;
    protected final HashMap<String, Integer> nameIndex = new HashMap();
    private final List<Unit> units = new ArrayList<Unit>();
    protected final List<Settlement> settlements = new ArrayList<Settlement>();
    private boolean[][] canSeeTiles = null;
    private boolean canSeeValid = false;
    private final Object canSeeLock = new Object();
    protected final FeatureContainer featureContainer = new FeatureContainer();
    private int maximumFoodConsumption = -1;
    private final UnitIterator nextActiveUnitIterator = new UnitIterator(this, new ActivePredicate());
    private final UnitIterator nextGoingToUnitIterator = new UnitIterator(this, new GoingToPredicate(this, false));
    private final UnitIterator nextTradeRouteUnitIterator = new UnitIterator(this, new GoingToPredicate(this, true));
    protected HighSeas highSeas = null;
    protected List<String> settlementNames = null;
    protected String capitalName = null;
    protected List<String> shipNames = null;
    protected String shipFallback = null;
    private static final String ADMIN_TAG = "admin";
    private static final String AI_TAG = "ai";
    private static final String ATTACKED_BY_PRIVATEERS_TAG = "attackedByPrivateers";
    private static final String BANKRUPT_TAG = "bankrupt";
    private static final String BAN_MISSIONS_TAG = "banMissions";
    private static final String CURRENT_FATHER_TAG = "currentFather";
    private static final String DEAD_TAG = "dead";
    private static final String ENTRY_LOCATION_TAG = "entryLocation";
    private static final String FOUNDING_FATHERS_TAG = "foundingFathers";
    private static final String GOLD_TAG = "gold";
    private static final String IMMIGRATION_TAG = "immigration";
    private static final String IMMIGRATION_REQUIRED_TAG = "immigrationRequired";
    private static final String LIBERTY_TAG = "liberty";
    private static final String INDEPENDENT_NATION_NAME_TAG = "independentNationName";
    private static final String INTERVENTION_BELLS_TAG = "interventionBells";
    private static final String NATION_ID_TAG = "nationId";
    private static final String NATION_TYPE_TAG = "nationType";
    private static final String NEW_LAND_NAME_TAG = "newLandName";
    private static final String NUMBER_OF_SETTLEMENTS_TAG = "numberOfSettlements";
    private static final String OFFERED_FATHERS_TAG = "offeredFathers";
    private static final String OLD_SOL_TAG = "oldSoL";
    private static final String PLAYER_TAG = "player";
    private static final String PLAYER_TYPE_TAG = "playerType";
    private static final String READY_TAG = "ready";
    private static final String SCORE_TAG = "score";
    private static final String STANCE_TAG = "stance";
    private static final String TAX_TAG = "tax";
    private static final String TENSION_TAG = "tension";
    private static final String USERNAME_TAG = "username";
    private static final String OLD_NATION_ID_TAG = "nationID";

    protected Player(Game game) {
        super(game);
    }

    public Player(Game game, Element e) {
        super(game, null);
        this.readFromXMLElement(e);
    }

    public Player(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isUnknownEnemy() {
        return "model.nation.unknownEnemy".equals(this.nationId);
    }

    public final String getIndependentNationName() {
        return this.independentNationName;
    }

    public final void setIndependentNationName(String newIndependentNationName) {
        this.independentNationName = newIndependentNationName;
    }

    public String getNewLandName() {
        return this.newLandName;
    }

    public boolean isNewLandNamed() {
        return this.newLandName != null;
    }

    public void setNewLandName(String newLandName) {
        this.newLandName = newLandName;
    }

    public String getEuropeNameKey() {
        return this.europe == null ? null : this.nationId + ".europe";
    }

    public String getNationNameKey() {
        return StringUtils.lastPart(this.nationId, ".").toUpperCase(Locale.US);
    }

    public StringTemplate getNationName() {
        return this.playerType == PlayerType.REBEL || this.playerType == PlayerType.INDEPENDENT ? StringTemplate.name(this.independentNationName) : StringTemplate.key(Messages.nameKey(this.nationId));
    }

    public String getDebugName() {
        return this.getNation().getSuffix();
    }

    public final String getRulerNameKey() {
        return Messages.rulerKey(this.nationId);
    }

    public String getMonarchKey() {
        return this.nationId + ".monarch.image";
    }

    public int getNameIndex(String key) {
        Integer val = this.nameIndex.get(key);
        return val == null ? 0 : val;
    }

    public void setNameIndex(String key, int value) {
        this.nameIndex.put(key, value);
    }

    public StringTemplate getMarketName() {
        return this.getEurope() == null ? StringTemplate.key("model.market.independent") : StringTemplate.key(this.getEuropeNameKey());
    }

    private void initializeSettlementNames(Random random) {
        if (this.settlementNames == null) {
            this.settlementNames = new ArrayList<String>();
            this.settlementNames.addAll(Messages.getSettlementNames(this));
            if (this.isIndian()) {
                this.capitalName = this.settlementNames.remove(0);
                if (random != null) {
                    RandomUtils.randomShuffle(logger, "Settlement names", this.settlementNames, random);
                }
            } else {
                this.capitalName = null;
            }
            logger.info("Installed " + this.settlementNames.size() + " settlement names for player " + this);
        }
    }

    public String getCapitalName(Random random) {
        if (this.isEuropean()) {
            return null;
        }
        if (this.capitalName == null) {
            this.initializeSettlementNames(random);
        }
        return this.capitalName;
    }

    public String getSettlementName(Random random) {
        String name;
        Game game = this.getGame();
        if (this.settlementNames == null) {
            this.initializeSettlementNames(random);
        }
        while (!this.settlementNames.isEmpty()) {
            String name2 = this.settlementNames.remove(0);
            if (game.getSettlement(name2) != null) continue;
            return name2;
        }
        String base = Messages.message(this.isEuropean() ? "Colony" : "Settlement") + "-";
        int i = this.settlements.size() + 1;
        while (game.getSettlement(name = base + Integer.toString(i)) != null) {
            ++i;
        }
        return name;
    }

    private void initializeShipNames(Random random) {
        if (this.shipNames == null) {
            String startingShip;
            this.shipNames = new ArrayList<String>();
            this.shipNames.addAll(Messages.getShipNames(this));
            this.shipFallback = this.shipNames.isEmpty() ? null : this.shipNames.remove(0);
            String string = startingShip = this.shipNames.isEmpty() ? null : this.shipNames.remove(0);
            if (random != null) {
                RandomUtils.randomShuffle(logger, "Ship names", this.shipNames, random);
            }
            if (startingShip != null) {
                this.shipNames.add(0, startingShip);
            }
            logger.info("Installed " + this.shipNames.size() + " ship names for player " + this);
        }
    }

    public String getNameForUnit(UnitType type, Random random) {
        String name;
        if (!type.isNaval()) {
            return null;
        }
        ArrayList<String> navalNames = new ArrayList<String>();
        for (Unit u : this.getUnits()) {
            if (!u.isNaval() || u.getName() == null) continue;
            navalNames.add(u.getName());
        }
        if (this.shipNames == null) {
            this.initializeShipNames(random);
        }
        while (!this.shipNames.isEmpty()) {
            name = this.shipNames.remove(0);
            if (navalNames.contains(name)) continue;
            return name;
        }
        if (this.shipFallback != null) {
            String base = this.shipFallback + "-";
            int i = 0;
            while (navalNames.contains(name = base + Integer.toString(i))) {
                ++i;
            }
            return name;
        }
        return null;
    }

    public PlayerType getPlayerType() {
        return this.playerType;
    }

    private void setPlayerType(PlayerType type) {
        this.playerType = type;
    }

    public void changePlayerType(PlayerType type) {
        if (this.playerType != PlayerType.REBEL && this.playerType != PlayerType.INDEPENDENT) {
            switch (type) {
                case REBEL: 
                case INDEPENDENT: {
                    this.addAbility(new Ability("model.ability.independenceDeclared", true));
                    this.addAbility(new Ability("model.ability.independentNation", true));
                    break;
                }
            }
        }
        this.setPlayerType(type);
    }

    public boolean isColonial() {
        return this.playerType == PlayerType.COLONIAL;
    }

    public boolean isEuropean() {
        return this.playerType == PlayerType.COLONIAL || this.playerType == PlayerType.REBEL || this.playerType == PlayerType.INDEPENDENT || this.playerType == PlayerType.ROYAL;
    }

    public boolean isIndian() {
        return this.playerType == PlayerType.NATIVE;
    }

    public boolean isRebel() {
        return this.playerType == PlayerType.REBEL;
    }

    public boolean isUndead() {
        return this.playerType == PlayerType.UNDEAD;
    }

    public boolean isREF() {
        return this.playerType == PlayerType.ROYAL;
    }

    public NationType getNationType() {
        return this.nationType;
    }

    public void setNationType(NationType newNationType) {
        this.nationType = newNationType;
    }

    public void changeNationType(NationType newNationType) {
        if (this.nationType != null) {
            this.removeFeatures(this.nationType);
        }
        this.setNationType(newNationType);
        if (newNationType != null) {
            this.addFeatures(newNationType);
        }
    }

    public boolean canBuildColonies() {
        return this.nationType.hasAbility("model.ability.foundsColonies");
    }

    public boolean canHaveFoundingFathers() {
        return this.nationType.hasAbility("model.ability.electFoundingFather");
    }

    public String getNationId() {
        return this.nationId;
    }

    public Nation getNation() {
        return this.getSpecification().getNation(this.nationId);
    }

    public void setNation(Nation newNation) {
        Nation oldNation = this.getNation();
        this.nationId = newNation.getId();
        java.util.Map<Nation, NationOptions.NationState> nations = this.getGame().getNationOptions().getNations();
        nations.put(oldNation, NationOptions.NationState.AVAILABLE);
        nations.put(newNation, NationOptions.NationState.NOT_AVAILABLE);
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isAI() {
        return this.ai;
    }

    public void setAI(boolean ai) {
        this.ai = ai;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean getDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public boolean getAttackedByPrivateers() {
        return this.attackedByPrivateers;
    }

    public void setAttackedByPrivateers(boolean attacked) {
        this.attackedByPrivateers = attacked;
    }

    public boolean isWorkForREF() {
        for (Unit u : this.getUnits()) {
            if (!u.hasTile()) continue;
            return true;
        }
        return !this.getRebels().isEmpty();
    }

    public List<Player> getRebels() {
        ArrayList<Player> rebels = new ArrayList<Player>();
        for (Player p : this.getGame().getLiveEuropeanPlayers(this)) {
            if (p.getREFPlayer() != this || !p.isRebel() && !p.isUndead()) continue;
            rebels.add(p);
        }
        return rebels;
    }

    public Player getREFPlayer() {
        Nation ref = this.getNation().getREFNation();
        return ref == null ? null : this.getGame().getPlayer(ref.getId());
    }

    public Color getNationColor() {
        Nation nation = this.getNation();
        Color color = nation.getColor();
        return color != null ? color : nation.forceDefaultColor();
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getSpanishSuccessionScore() {
        return this.getScore();
    }

    public int getGold() {
        return this.gold;
    }

    public void setGold(int newGold) {
        this.gold = newGold;
    }

    public boolean checkGold(int amount) {
        return this.gold == Integer.MIN_VALUE || this.gold >= amount;
    }

    public int modifyGold(int amount) {
        if (this.gold != Integer.MIN_VALUE) {
            if (this.gold + amount >= 0) {
                this.gold += amount;
            } else {
                logger.warning("Cannot add " + amount + " gold for " + this + ": would be negative!");
                this.gold = 0;
            }
        }
        return this.gold;
    }

    public final boolean getBankrupt() {
        return this.bankrupt;
    }

    public final void setBankrupt(boolean newBankrupt) {
        this.bankrupt = newBankrupt;
    }

    public int getImmigration() {
        return this.isColonial() ? this.immigration : 0;
    }

    public void setImmigration(int immigration) {
        if (!this.isColonial()) {
            return;
        }
        this.immigration = immigration;
    }

    public void reduceImmigration() {
        int cost;
        if (!this.isColonial()) {
            return;
        }
        int n = cost = this.getSpecification().getBoolean("model.option.saveProductionOverflow") ? this.immigrationRequired : this.immigration;
        this.immigration = cost > this.immigration ? 0 : (this.immigration -= cost);
    }

    public void modifyImmigration(int amount) {
        this.immigration = Math.max(0, this.immigration + amount);
    }

    public int getImmigrationRequired() {
        return this.immigrationRequired;
    }

    public void setImmigrationRequired(int immigrationRequired) {
        this.immigrationRequired = immigrationRequired;
    }

    public void updateImmigrationRequired() {
        if (!this.isColonial()) {
            return;
        }
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        int current = this.immigrationRequired;
        int base = spec.getInteger("model.option.crossesIncrement");
        int unreduced = Math.round((float)current / this.applyModifiers(1.0f, turn, "model.modifier.religiousUnrestBonus"));
        this.immigrationRequired = (int)this.applyModifiers(unreduced + base, turn, "model.modifier.religiousUnrestBonus");
        logger.finest("Immigration for " + this.getId() + " updated " + current + " -> " + this.immigrationRequired);
    }

    public boolean checkEmigrate() {
        return this.isColonial() ? this.getImmigrationRequired() <= this.immigration : false;
    }

    public int getTotalImmigrationProduction() {
        if (!this.isColonial()) {
            return 0;
        }
        List<GoodsType> immigrationGoodsTypes = this.getSpecification().getImmigrationGoodsTypeList();
        int production = 0;
        for (Colony colony : this.getColonies()) {
            for (GoodsType goodsType : immigrationGoodsTypes) {
                production += colony.getTotalProductionOf(goodsType);
            }
        }
        Europe europe = this.getEurope();
        if (europe != null) {
            production += europe.getImmigration(production);
        }
        return production;
    }

    public int getLiberty() {
        return this.canHaveFoundingFathers() ? this.liberty : 0;
    }

    public void setLiberty(int liberty) {
        if (!this.canHaveFoundingFathers()) {
            return;
        }
        this.liberty = liberty;
    }

    public void modifyLiberty(int amount) {
        this.setLiberty(Math.max(0, this.liberty + amount));
        if (this.isRebel()) {
            this.interventionBells += amount;
        }
    }

    protected boolean recalculateBellsBonus() {
        Set<Modifier> libertyBonus = this.getModifiers("model.goods.bells");
        boolean ret = false;
        for (Ability ability : this.getAbilities("model.ability.addTaxToBells")) {
            FreeColObject source = ability.getSource();
            if (source == null) continue;
            for (Modifier modifier : libertyBonus) {
                if (!source.equals(modifier.getSource())) continue;
                modifier.setValue(this.tax);
                ret = true;
            }
        }
        return ret;
    }

    public int getLibertyProductionNextTurn() {
        int nextTurn = 0;
        for (Colony colony : this.getColonies()) {
            for (GoodsType libertyGoods : this.getSpecification().getLibertyGoodsTypeList()) {
                nextTurn += colony.getTotalProductionOf(libertyGoods);
            }
        }
        return (int)this.applyModifiers(nextTurn, this.getGame().getTurn(), "model.modifier.liberty");
    }

    public int getSoL() {
        int sum = 0;
        int number = 0;
        for (Colony c : this.getColonies()) {
            sum += c.getSoL();
            ++number;
        }
        return number > 0 ? sum / number : 0;
    }

    public Set<FoundingFather> getFathers() {
        return this.foundingFathers;
    }

    public boolean hasFather(FoundingFather someFather) {
        return this.foundingFathers.contains(someFather);
    }

    public int getFatherCount() {
        return this.foundingFathers.size();
    }

    public void addFather(FoundingFather father) {
        this.foundingFathers.add(father);
        this.addFeatures(father);
        for (Colony colony : this.getColonies()) {
            colony.invalidateCache();
        }
    }

    public FoundingFather getCurrentFather() {
        return this.currentFather;
    }

    public void setCurrentFather(FoundingFather someFather) {
        this.currentFather = someFather;
    }

    public List<FoundingFather> getOfferedFathers() {
        return this.offeredFathers;
    }

    public void clearOfferedFathers() {
        this.offeredFathers.clear();
    }

    public void setOfferedFathers(List<FoundingFather> fathers) {
        this.clearOfferedFathers();
        this.offeredFathers.addAll(fathers);
    }

    public int getRemainingFoundingFatherCost() {
        return this.getTotalFoundingFatherCost() - this.getLiberty();
    }

    public int getTotalFoundingFatherCost() {
        Specification spec = this.getSpecification();
        int base = spec.getInteger("model.option.foundingFatherFactor");
        int count = this.getFatherCount();
        return count == 0 ? base : 2 * (count + 1) * base + 1;
    }

    public java.util.Map<String, Turn> getElectionTurns() {
        HashMap<String, Turn> result = new HashMap<String, Turn>();
        for (HistoryEvent e : this.getHistory()) {
            if (e.getEventType() != HistoryEvent.EventType.FOUNDING_FATHER) continue;
            result.put(e.getReplacement("%father%").getId(), e.getTurn());
        }
        return result;
    }

    public StringTemplate checkDeclareIndependence() {
        if (this.getPlayerType() != PlayerType.COLONIAL) {
            return StringTemplate.template("model.independence.colonial");
        }
        Event event = this.getSpecification().getEvent("model.event.declareIndependence");
        for (Limit limit : event.getLimits()) {
            if (limit.evaluate(this)) continue;
            return StringTemplate.template(limit.getDescriptionKey()).addAmount("%limit%", limit.getRightHandSide().getValue(this.getGame()));
        }
        return null;
    }

    public int calculateStrength(boolean naval) {
        CombatModel cm = this.getGame().getCombatModel();
        int s = 0;
        for (Unit unit : this.getUnits()) {
            if (unit.isNaval() != naval) continue;
            s = (int)((float)s + cm.getOffencePower(unit, null));
        }
        return s;
    }

    public float getRebelStrengthRatio(boolean naval) {
        if (this.getPlayerType() != PlayerType.COLONIAL) {
            return 0.0f;
        }
        float ref = this.getMonarch().getExpeditionaryForce().calculateStrength(naval);
        float pla = this.calculateStrength(naval);
        return pla / (ref + pla);
    }

    public int getTax() {
        return this.tax;
    }

    public void setTax(int amount) {
        this.tax = amount;
        if (this.recalculateBellsBonus()) {
            for (Colony colony : this.getColonies()) {
                colony.invalidateCache();
            }
        }
    }

    public Market getMarket() {
        return this.market;
    }

    public void reinitialiseMarket() {
        this.market = new Market(this.getGame(), this);
    }

    public LastSale getLastSale(Location where, GoodsType what) {
        return this.lastSales == null ? null : this.lastSales.get(LastSale.makeKey(where, what));
    }

    public void addLastSale(LastSale sale) {
        if (this.lastSales == null) {
            this.lastSales = new HashMap();
        }
        this.lastSales.put(sale.getId(), sale);
    }

    public String getLastSaleString(Location where, GoodsType what) {
        LastSale data = this.getLastSale(where, what);
        return data == null ? null : String.valueOf(data.getPrice());
    }

    public int getArrears(GoodsType type) {
        return this.getMarket().getArrears(type);
    }

    public boolean canTrade(GoodsType type) {
        return this.canTrade(type, Market.Access.EUROPE);
    }

    public boolean canTrade(GoodsType type, Market.Access access) {
        if (this.getMarket().getArrears(type) == 0) {
            return true;
        }
        if (access == Market.Access.CUSTOM_HOUSE) {
            if (this.getSpecification().getBoolean("model.option.customIgnoreBoycott")) {
                return true;
            }
            if (this.hasAbility("model.ability.customHouseTradesWithForeignCountries")) {
                for (Player other : this.getGame().getLiveEuropeanPlayers(this)) {
                    if (this.getStance(other) != Stance.PEACE && this.getStance(other) != Stance.ALLIANCE) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getSales(GoodsType goodsType) {
        return this.getMarket().getSales(goodsType);
    }

    public void modifySales(GoodsType goodsType, int amount) {
        this.getMarket().modifySales(goodsType, amount);
    }

    public boolean hasTraded(GoodsType goodsType) {
        return this.getMarket().hasBeenTraded(goodsType);
    }

    public Goods getMostValuableGoods() {
        if (!this.isEuropean()) {
            return null;
        }
        Goods goods = null;
        int highValue = 0;
        for (Colony colony : this.getColonies()) {
            for (Goods g : colony.getCompactGoods()) {
                if (this.getArrears(g.getType()) > 0 || !this.hasTraded(g.getType())) continue;
                int amount = Math.min(g.getAmount(), 100);
                int value = this.market.getSalePrice(g.getType(), amount);
                if (value <= highValue) continue;
                highValue = value;
                goods = g;
            }
        }
        return goods;
    }

    public int getIncomeBeforeTaxes(GoodsType goodsType) {
        return this.getMarket().getIncomeBeforeTaxes(goodsType);
    }

    public void modifyIncomeBeforeTaxes(GoodsType goodsType, int amount) {
        this.getMarket().modifyIncomeBeforeTaxes(goodsType, amount);
    }

    public int getIncomeAfterTaxes(GoodsType goodsType) {
        return this.getMarket().getIncomeAfterTaxes(goodsType);
    }

    public void modifyIncomeAfterTaxes(GoodsType goodsType, int amount) {
        this.getMarket().modifyIncomeAfterTaxes(goodsType, amount);
    }

    public Europe getEurope() {
        return this.europe;
    }

    public void setEurope(Europe europe) {
        this.europe = europe;
    }

    public boolean canMoveToEurope() {
        return this.getEurope() != null;
    }

    public int getRecruitPrice() {
        return this.getEurope().getRecruitPrice();
    }

    public int getPrice(AbstractUnit au) {
        Specification spec = this.getSpecification();
        UnitType unitType = au.getType(spec);
        Role role = au.getRole(spec);
        if (unitType.hasPrice()) {
            int price = this.getEurope().getUnitPrice(unitType);
            for (AbstractGoods goods : role.getRequiredGoods()) {
                int amount = goods.getAmount() * role.getMaximumCount();
                price += this.getMarket().getBidPrice(goods.getType(), amount);
            }
            return price * au.getNumber();
        }
        return Integer.MAX_VALUE;
    }

    public Monarch getMonarch() {
        return this.monarch;
    }

    public void setMonarch(Monarch monarch) {
        this.monarch = monarch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnit(Unit unit) {
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.contains(unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Unit> getUnits() {
        List<Unit> list = this.units;
        synchronized (list) {
            return new ArrayList<Unit>(this.units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Unit> getUnitIterator() {
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addUnit(Unit newUnit) {
        if (newUnit == null) {
            return false;
        }
        if (!this.owns(newUnit)) {
            throw new IllegalStateException("Adding another players unit:" + newUnit.getId() + " to " + this);
        }
        if (this.hasUnit(newUnit)) {
            return false;
        }
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.add(newUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnit(Unit oldUnit) {
        if (oldUnit == null) {
            return false;
        }
        this.nextActiveUnitIterator.remove(oldUnit);
        this.nextGoingToUnitIterator.remove(oldUnit);
        this.nextTradeRouteUnitIterator.remove(oldUnit);
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.remove(oldUnit);
        }
    }

    public List<Unit> getCarriersForUnit(Unit unit) {
        ArrayList<Unit> ul = new ArrayList<Unit>();
        for (Unit u : this.getUnits()) {
            if (!u.couldCarry(unit)) continue;
            ul.add(u);
        }
        return ul;
    }

    public int getUnitCount(boolean naval) {
        int ret = 0;
        for (Unit u : this.getUnits()) {
            if (u.isNaval() != naval) continue;
            ++ret;
        }
        return ret;
    }

    public int getNumberOfKingLandUnits() {
        int n = 0;
        for (Unit unit : this.getUnits()) {
            if (!unit.hasAbility("model.ability.refUnit") || unit.isNaval()) continue;
            ++n;
        }
        return n;
    }

    public boolean hasUnitType(String typeId) {
        for (Unit u : this.getUnits()) {
            if (!typeId.equals(u.getType().getId())) continue;
            return true;
        }
        return false;
    }

    public Unit getNextActiveUnit() {
        return this.nextActiveUnitIterator.next();
    }

    public boolean setNextActiveUnit(Unit unit) {
        return this.nextActiveUnitIterator.setNext(unit);
    }

    public boolean hasNextActiveUnit() {
        return this.nextActiveUnitIterator.hasNext();
    }

    public Unit getNextGoingToUnit() {
        return this.nextGoingToUnitIterator.next();
    }

    public boolean setNextGoingToUnit(Unit unit) {
        return this.nextGoingToUnitIterator.setNext(unit);
    }

    public boolean hasNextGoingToUnit() {
        return this.nextGoingToUnitIterator.hasNext();
    }

    public Unit getNextTradeRouteUnit() {
        return this.nextTradeRouteUnitIterator.next();
    }

    public boolean hasNextTradeRouteUnit() {
        return this.nextTradeRouteUnitIterator.hasNext();
    }

    public void resetIterators() {
        this.nextActiveUnitIterator.reset();
        this.nextGoingToUnitIterator.reset();
        this.nextTradeRouteUnitIterator.reset();
    }

    public final List<TradeRoute> getTradeRoutes() {
        return this.tradeRoutes;
    }

    public TradeRoute getTradeRoute(String name) {
        for (TradeRoute t : this.tradeRoutes) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public final void setTradeRoutes(List<TradeRoute> newTradeRoutes) {
        this.tradeRoutes.clear();
        this.tradeRoutes.addAll(newTradeRoutes);
    }

    public String getNewTradeRouteName() {
        String name;
        String base = Messages.message("tradeRoute.newRoute");
        if (this.getTradeRoute(base) == null) {
            return base;
        }
        int i = 1;
        while (this.getTradeRoute(name = base + Integer.toString(i)) != null) {
            ++i;
        }
        return name;
    }

    public boolean addOwnable(Ownable o) {
        return o instanceof Settlement ? this.addSettlement((Settlement)o) : (o instanceof Unit ? this.addUnit((Unit)o) : false);
    }

    public boolean removeOwnable(Ownable o) {
        return o instanceof Settlement ? this.removeSettlement((Settlement)o) : (o instanceof Unit ? this.removeUnit((Unit)o) : false);
    }

    public List<Settlement> getSettlements() {
        return this.settlements;
    }

    public int getNumberOfSettlements() {
        return this.settlements.size();
    }

    public int getNumberOfPorts() {
        if (!this.isEuropean()) {
            return 0;
        }
        int n = 0;
        for (Colony colony : this.getColonies()) {
            if (!colony.isConnectedPort()) continue;
            ++n;
        }
        return n;
    }

    public List<Colony> getPorts() {
        if (!this.isEuropean()) {
            return Collections.emptyList();
        }
        ArrayList<Colony> result = new ArrayList<Colony>();
        for (Colony colony : this.getColonies()) {
            if (!colony.isConnectedPort()) continue;
            result.add(colony);
        }
        return result;
    }

    public boolean hasSettlement(Settlement settlement) {
        return this.settlements.contains(settlement);
    }

    public boolean addSettlement(Settlement settlement) {
        if (settlement == null) {
            return false;
        }
        if (!this.owns(settlement)) {
            throw new IllegalStateException("Does not own: " + settlement);
        }
        if (this.hasSettlement(settlement)) {
            return false;
        }
        this.settlements.add(settlement);
        return true;
    }

    public boolean removeSettlement(Settlement settlement) {
        return this.settlements.remove(settlement);
    }

    public int getColoniesPopulation() {
        int i = 0;
        for (Colony c : this.getColonies()) {
            i += c.getUnitCount();
        }
        return i;
    }

    public Colony getColonyByName(String name) {
        for (Colony colony : this.getColonies()) {
            if (!colony.getName().equals(name)) continue;
            return colony;
        }
        return null;
    }

    public IndianSettlement getIndianSettlementByName(String name) {
        for (IndianSettlement settlement : this.getIndianSettlements()) {
            if (!settlement.getName().equals(name)) continue;
            return settlement;
        }
        return null;
    }

    public List<Colony> getColonies() {
        ArrayList<Colony> colonies = new ArrayList<Colony>();
        for (Settlement s : this.getSettlements()) {
            if (s instanceof Colony) {
                colonies.add((Colony)s);
                continue;
            }
            throw new RuntimeException("getColonies found: " + s);
        }
        return colonies;
    }

    public List<Colony> getSortedColonies(Comparator<Colony> c) {
        List<Colony> colonies = this.getColonies();
        Collections.sort(colonies, c);
        return colonies;
    }

    public List<IndianSettlement> getIndianSettlements() {
        ArrayList<IndianSettlement> indianSettlements = new ArrayList<IndianSettlement>();
        for (Settlement s : this.getSettlements()) {
            if (s instanceof IndianSettlement) {
                indianSettlements.add((IndianSettlement)s);
                continue;
            }
            throw new RuntimeException("getIndianSettlements found: " + s);
        }
        return indianSettlements;
    }

    public Settlement getSettlementByName(String name) {
        return this.isIndian() ? this.getIndianSettlementByName(name) : this.getColonyByName(name);
    }

    public Settlement getClosestPortForEurope() {
        int bestValue = Integer.MAX_VALUE;
        Settlement best = null;
        for (Settlement settlement : this.getSettlements()) {
            int value = settlement.getHighSeasCount();
            if (bestValue <= value) continue;
            bestValue = value;
            best = settlement;
        }
        return best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModelMessage> getModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            return new ArrayList<ModelMessage>(this.modelMessages);
        }
    }

    public List<ModelMessage> getNewModelMessages() {
        ArrayList<ModelMessage> out = new ArrayList<ModelMessage>();
        for (ModelMessage m : this.getModelMessages()) {
            if (m.hasBeenDisplayed()) continue;
            out.add(m);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelMessage(ModelMessage modelMessage) {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            this.modelMessages.add(modelMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refilterModelMessages(OptionGroup options) {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            Iterator<ModelMessage> messageIterator = this.modelMessages.iterator();
            while (messageIterator.hasNext()) {
                ModelMessage message = messageIterator.next();
                String id = message.getMessageType().getOptionName();
                if (options.getBoolean(id)) continue;
                messageIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisplayedModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            Iterator<ModelMessage> messageIterator = this.modelMessages.iterator();
            while (messageIterator.hasNext()) {
                ModelMessage message = messageIterator.next();
                if (!message.hasBeenDisplayed()) continue;
                messageIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            this.modelMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void divertModelMessages(FreeColGameObject source, FreeColGameObject newSource) {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            Iterator<ModelMessage> messageIterator = this.modelMessages.iterator();
            while (messageIterator.hasNext()) {
                ModelMessage message = messageIterator.next();
                if (!Utils.equals(message.getSourceId(), source.getId())) continue;
                if (newSource == null) {
                    messageIterator.remove();
                    continue;
                }
                message.divert(newSource);
            }
        }
    }

    public final List<HistoryEvent> getHistory() {
        return this.history;
    }

    public void addHistory(HistoryEvent event) {
        this.history.add(event);
    }

    public Location getEntryLocation() {
        return this.entryLocation;
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
    }

    public final HighSeas getHighSeas() {
        return this.highSeas;
    }

    public void initializeHighSeas() {
        Game game = this.getGame();
        this.highSeas = new HighSeas(game);
        if (this.europe != null) {
            this.highSeas.addDestination(this.europe);
        }
        if (game.getMap() != null) {
            this.highSeas.addDestination(game.getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSee(Tile tile) {
        if (tile == null) {
            return false;
        }
        do {
            Object object = this.canSeeLock;
            synchronized (object) {
                if (this.canSeeValid) {
                    return this.canSeeTiles[tile.getX()][tile.getY()];
                }
            }
        } while (this.resetCanSeeTiles());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCanSeeTiles() {
        Object object = this.canSeeLock;
        synchronized (object) {
            this.canSeeValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resetCanSeeTiles() {
        Map map = this.getGame().getMap();
        if (map == null) {
            return false;
        }
        boolean[][] cST = this.makeCanSeeTiles(map);
        Object object = this.canSeeLock;
        synchronized (object) {
            this.canSeeTiles = cST;
            this.canSeeValid = true;
        }
        return true;
    }

    public boolean hasExplored(Tile tile) {
        return tile.isExplored();
    }

    private boolean[][] makeCanSeeTiles(Map map) {
        Specification spec = this.getSpecification();
        if (!spec.getBoolean("model.option.fogOfWar")) {
            boolean[][] cST = this.canSeeTiles != null ? this.canSeeTiles : new boolean[map.getWidth()][map.getHeight()];
            for (Tile t : this.getGame().getMap().getAllTiles()) {
                if (t == null) continue;
                cST[t.getX()][t.getY()] = this.hasExplored(t);
            }
            return cST;
        }
        boolean[][] cST = new boolean[map.getWidth()][map.getHeight()];
        for (Unit unit : this.getUnits()) {
            if (!(unit.getLocation() instanceof Tile)) continue;
            for (Tile t : ((Tile)unit.getLocation()).getSurroundingTiles(0, unit.getLineOfSight())) {
                cST[t.getX()][t.getY()] = true;
                t.seeTile(this);
            }
        }
        for (Settlement settlement : this.getSettlements()) {
            for (Tile t : settlement.getTile().getSurroundingTiles(0, settlement.getLineOfSight())) {
                cST[t.getX()][t.getY()] = true;
                t.seeTile(this);
            }
        }
        if (this.isEuropean() && spec.getBoolean("model.option.enhancedMissionaries")) {
            for (Player other : this.getGame().getLiveNativePlayers(this)) {
                for (IndianSettlement is : other.getIndianSettlements()) {
                    if (!is.hasMissionary(this)) continue;
                    for (Tile t : is.getTile().getSurroundingTiles(0, is.getLineOfSight())) {
                        cST[t.getX()][t.getY()] = true;
                        t.seeTile(this);
                    }
                }
            }
        }
        if (this.isEuropean() && this.hasAbility("model.ability.seeAllColonies")) {
            for (Player other : this.getGame().getLiveEuropeanPlayers(this)) {
                for (Colony colony : other.getColonies()) {
                    for (Tile t : colony.getTile().getSurroundingTiles(0, colony.getLineOfSight())) {
                        cST[t.getX()][t.getY()] = true;
                        t.seeTile(this);
                    }
                }
            }
        }
        return cST;
    }

    public Tension getTension(Player player) {
        if (player == null) {
            throw new IllegalStateException("Null player.");
        }
        Tension newTension = this.tension.get(player);
        if (newTension == null) {
            newTension = new Tension(0);
            this.tension.put(player, newTension);
        }
        return newTension;
    }

    public void setTension(Player player, Tension newTension) {
        if (player == this || player == null) {
            return;
        }
        this.tension.put(player, newTension);
    }

    public void removeTension(Player player) {
        if (player != null) {
            this.tension.remove(player);
        }
    }

    public boolean missionsBanned(Player player) {
        return this.bannedMissions != null && this.bannedMissions.contains(player);
    }

    public void addMissionBan(Player player) {
        if (this.bannedMissions == null) {
            this.bannedMissions = new HashSet<Player>();
        }
        this.bannedMissions.add(player);
    }

    public void removeMissionBan(Player player) {
        if (this.bannedMissions != null) {
            this.bannedMissions.remove(player);
        }
    }

    public Stance getStance(Player player) {
        return player == null || this.stance.get(player.getId()) == null ? Stance.UNCONTACTED : this.stance.get(player.getId());
    }

    public boolean setStance(Player player, Stance newStance) {
        if (player == null) {
            throw new IllegalArgumentException("Player must not be 'null'.");
        }
        if (player == this) {
            throw new IllegalArgumentException("Cannot set the stance towards ourselves.");
        }
        if (newStance == null) {
            this.stance.remove(player.getId());
            return true;
        }
        Stance oldStance = this.stance.get(player.getId());
        if (newStance == oldStance) {
            return true;
        }
        boolean valid = true;
        if (newStance == Stance.CEASE_FIRE && oldStance != Stance.WAR || newStance == Stance.UNCONTACTED) {
            valid = false;
        }
        this.stance.put(player.getId(), newStance);
        return valid;
    }

    public boolean atWarWith(Player player) {
        return this.getStance(player) == Stance.WAR;
    }

    public boolean isAtWar() {
        for (Player player : this.getGame().getLivePlayers(null)) {
            if (!this.atWarWith(player)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContacted(Player player) {
        return this.getStance(player) != Stance.UNCONTACTED;
    }

    public boolean hasContactedEuropeans() {
        for (Player other : this.getGame().getLiveEuropeanPlayers(this)) {
            if (!this.hasContacted(other)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContactedIndians() {
        for (Player other : this.getGame().getLiveNativePlayers(this)) {
            if (!this.hasContacted(other)) continue;
            return true;
        }
        return false;
    }

    public static void makeContact(Player player1, Player player2) {
        player1.stance.put(player2.getId(), Stance.PEACE);
        player2.stance.put(player1.getId(), Stance.PEACE);
        player1.setTension(player2, new Tension(0));
        player2.setTension(player1, new Tension(0));
    }

    public int getLandPrice(Tile tile) {
        Specification spec = this.getSpecification();
        Player nationOwner = tile.getOwner();
        int price = 0;
        if (nationOwner == null || nationOwner == this) {
            return 0;
        }
        if (tile.hasSettlement()) {
            return -1;
        }
        if (nationOwner.isEuropean()) {
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement().getOwner() == nationOwner) {
                return -1;
            }
            return 0;
        }
        for (GoodsType type : spec.getGoodsTypeList()) {
            if (type == spec.getPrimaryFoodType()) continue;
            price += tile.getPotentialProduction(type, null);
        }
        price *= spec.getInteger("model.option.landPriceFactor");
        return (int)this.applyModifiers(price += 100, this.getGame().getTurn(), "model.modifier.landPaymentModifier");
    }

    public boolean canOwnTile(Tile tile) {
        return this.canOwnTileReason(tile) == NoClaimReason.NONE;
    }

    private NoClaimReason canOwnTileReason(Tile tile) {
        Unit u;
        Player owner;
        Iterator<Unit> iterator = tile.getUnitList().iterator();
        while (iterator.hasNext() && (owner = (u = iterator.next()).getOwner()) != this && owner.atWarWith(this)) {
            if (!u.isOffensiveUnit()) continue;
            return NoClaimReason.OCCUPIED;
        }
        return this.isEuropean() ? (tile.hasLostCityRumour() ? NoClaimReason.RUMOUR : NoClaimReason.NONE) : (tile.isLand() ? NoClaimReason.NONE : NoClaimReason.WATER);
    }

    public boolean canClaimForSettlement(Tile tile) {
        return this.canClaimForSettlementReason(tile) == NoClaimReason.NONE;
    }

    public NoClaimReason canClaimForSettlementReason(Tile tile) {
        int price;
        NoClaimReason reason = this.canOwnTileReason(tile);
        NoClaimReason noClaimReason = reason != NoClaimReason.NONE ? reason : (tile.hasSettlement() ? NoClaimReason.SETTLEMENT : (tile.getOwner() == null ? NoClaimReason.NONE : (tile.getOwner() == this ? (tile.isInUse() ? NoClaimReason.WORKED : NoClaimReason.NONE) : ((price = this.getLandPrice(tile)) < 0 ? NoClaimReason.EUROPEANS : (price > 0 ? NoClaimReason.NATIVES : NoClaimReason.NONE)))));
        return noClaimReason;
    }

    public boolean canClaimToFoundSettlement(Tile tile) {
        return this.canClaimToFoundSettlementReason(tile) == NoClaimReason.NONE;
    }

    public NoClaimReason canClaimToFoundSettlementReason(Tile tile) {
        NoClaimReason reason;
        return !tile.getType().canSettle() ? NoClaimReason.TERRAIN : ((reason = this.canClaimForSettlementReason(tile)) != NoClaimReason.NATIVES ? reason : (!tile.getAdjacentColonies().isEmpty() ? NoClaimReason.SETTLEMENT : (this.canClaimFreeCenterTile(tile) ? NoClaimReason.NONE : NoClaimReason.NATIVES)));
    }

    private boolean canClaimFreeCenterTile(Tile tile) {
        Specification spec = this.getGame().getSpecification();
        String build = spec.getString("model.option.buildOnNativeLand");
        return this.isEuropean() && tile.getOwner() != null && tile.getOwner().isIndian() && ("model.option.buildOnNativeLand.always".equals(build) || "model.option.buildOnNativeLand.first".equals(build) && this.hasZeroSettlements() || "model.option.buildOnNativeLand.firstAndUncontacted".equals(build) && this.hasZeroSettlements() && (tile.getOwner() == null || tile.getOwner().getStance(this) == Stance.UNCONTACTED));
    }

    private boolean hasZeroSettlements() {
        List<Settlement> settlements = this.getSettlements();
        return settlements.isEmpty() || settlements.size() == 1 && settlements.get(0).getTile().getSettlement() == null;
    }

    public boolean canClaimForImprovement(Tile tile) {
        Player owner = tile.getOwner();
        return owner == null || owner == this || this.getLandPrice(tile) == 0;
    }

    public boolean canAcquireForImprovement(Tile tile) {
        return this.canClaimForImprovement(tile) || this.getLandPrice(tile) > 0;
    }

    public List<Tile> getClaimableTiles(Tile centerTile, int radius) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        ArrayList<Tile> layer = new ArrayList<Tile>();
        if (this.canClaimToFoundSettlement(centerTile)) {
            layer.add(centerTile);
            for (int r = 1; r <= radius; ++r) {
                ArrayList lastLayer = new ArrayList(layer);
                tiles.addAll(layer);
                layer.clear();
                for (Tile have : lastLayer) {
                    for (Tile next : have.getSurroundingTiles(1)) {
                        if (tiles.contains(next) || !this.canClaimForSettlement(next)) continue;
                        layer.add(next);
                    }
                }
            }
            tiles.addAll(layer);
        }
        return tiles;
    }

    public List<Double> getAllColonyValues(Tile tile) {
        int LOW_SETTLEMENT_NUMBER = 3;
        int LONG_PATH_TILES = 12;
        double MOD_HAS_RESOURCE = 0.75;
        double MOD_FOOD_LOW = 0.75;
        double MOD_INITIAL_FOOD = 2.0;
        double MOD_STEAL = 0.5;
        double MOD_INLAND = 0.5;
        double MOD_OWNED_EUROPEAN = 0.67;
        double MOD_OWNED_NATIVE = 0.8;
        double MOD_HIGH_PRODUCTION = 1.2;
        double MOD_GOOD_PRODUCTION = 1.1;
        int DISTANCE_MAX = 5;
        double[] MOD_OWN_COLONY = new double[]{0.0, 0.0, 0.5, 1.5, 1.25};
        double[] MOD_ENEMY_COLONY = new double[]{0.0, 0.0, 0.4, 0.5, 0.7};
        double[] MOD_NEUTRAL_COLONY = new double[]{0.0, 0.0, 0.7, 0.8, 1.0};
        double[] MOD_ENEMY_UNIT = new double[]{0.4, 0.5, 0.6, 0.75, 0.9};
        int GOOD_PRODUCTION = 4;
        int HIGH_PRODUCTION = 8;
        int FOOD_LOW = 4;
        boolean FOOD_VERY_LOW = true;
        ArrayList<Double> values = new ArrayList<Double>();
        for (ColonyValueCategory c : ColonyValueCategory.values()) {
            values.add(1.0);
        }
        double development = (double)Math.min(3, this.settlements.size()) / 3.0;
        int portCount = this.getNumberOfPorts();
        if (tile.isPolar() && this.settlements.size() < 3) {
            values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.POLAR.getDouble());
            return values;
        }
        switch (this.canClaimToFoundSettlementReason(tile)) {
            case NONE: {
                break;
            }
            case TERRAIN: 
            case WATER: {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.TERRAIN.getDouble());
                return values;
            }
            case RUMOUR: {
                if (this.settlements.isEmpty()) {
                    values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.RUMOUR.getDouble());
                    return values;
                }
                values.set(ColonyValueCategory.A_TILE.ordinal(), development);
                break;
            }
            case OCCUPIED: {
                values.set(ColonyValueCategory.A_TILE.ordinal(), MOD_ENEMY_UNIT[0]);
                break;
            }
            case SETTLEMENT: 
            case WORKED: 
            case EUROPEANS: {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                return values;
            }
            case NATIVES: {
                if (tile.getOwningSettlement() != null && tile.getOwningSettlement().getTile() != null && tile.getOwningSettlement().getTile().isAdjacent(tile)) {
                    values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                    return values;
                }
                int price = this.getLandPrice(tile);
                if (price <= 0 || this.checkGold(price) || portCount <= 0) break;
                values.set(ColonyValueCategory.A_TILE.ordinal(), 0.5);
                break;
            }
            default: {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.BOGUS.getDouble());
                return values;
            }
        }
        Specification spec = this.getSpecification();
        TypeCountMap<GoodsType> production = new TypeCountMap<GoodsType>();
        int initialFood = 0;
        GoodsType foodType = spec.getPrimaryFoodType();
        for (ProductionType productionType : tile.getType().getAvailableProductionTypes(true)) {
            for (AbstractGoods abstractGoods : productionType.getOutputs()) {
                int amount;
                if (!abstractGoods.getType().isFoodType() || (amount = tile.getPotentialProduction(abstractGoods.getType(), null)) <= initialFood) continue;
                initialFood = amount;
            }
        }
        if (initialFood <= 1) {
            values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.FOOD.getDouble());
            return values;
        }
        production.incrementCount(foodType, initialFood);
        values.set(ColonyValueCategory.A_PROD.ordinal(), (double)initialFood * (double)foodType.getProductionWeight());
        int tilesToHighSeas = tile.getHighSeasCount();
        if (tilesToHighSeas < 0) {
            if (portCount < 3) {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.INLAND.getDouble());
                return values;
            }
            values.set(ColonyValueCategory.A_EUROPE.ordinal(), 0.5);
        } else if (tilesToHighSeas >= 12) {
            double trip = 12.0 / (double)tilesToHighSeas;
            values.set(ColonyValueCategory.A_EUROPE.ordinal(), Math.pow(trip, 2.0 - development));
        } else {
            values.set(ColonyValueCategory.A_EUROPE.ordinal(), 1.0 + 0.25 * (12.0 / (double)(12 - tilesToHighSeas)));
        }
        values.set(ColonyValueCategory.A_RESOURCE.ordinal(), tile.hasResource() ? 0.75 : 1.0);
        HashSet<GoodsType> highProduction = new HashSet<GoodsType>();
        HashSet<GoodsType> goodProduction = new HashSet<GoodsType>();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.getType() == null) continue;
            if (t.getSettlement() != null) {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                return values;
            }
            double pf = 1.0;
            if (t.getOwner() != null && !this.owns(t)) {
                if (t.getOwner().isEuropean()) {
                    if (portCount < 3) {
                        values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                        return values;
                    }
                    values.set(ColonyValueCategory.A_ADJACENT.ordinal(), (Double)values.get(ColonyValueCategory.A_ADJACENT.ordinal()) * 0.67 * development);
                    continue;
                }
                pf = 0.8;
                if (portCount > 0) {
                    pf *= development;
                }
            }
            for (AbstractGoods abstractGoods : t.getSortedPotential()) {
                GoodsType type = abstractGoods.getType();
                if (type.isFoodType()) {
                    type = foodType;
                }
                int amount = abstractGoods.getAmount();
                if (!t.isLand()) {
                    amount = (int)((double)amount * development);
                }
                values.set(ColonyValueCategory.A_PROD.ordinal(), (Double)values.get(ColonyValueCategory.A_PROD.ordinal()) + (double)((float)amount * type.getProductionWeight()) * pf);
                production.incrementCount(type, amount);
                if (amount > 8) {
                    highProduction.add(type);
                    continue;
                }
                if (amount <= 4) continue;
                goodProduction.add(type);
            }
            for (Unit unit : t.getUnitList()) {
                if (this.owns(unit) || !unit.isOffensiveUnit() || !this.atWarWith(unit.getOwner())) continue;
                values.set(ColonyValueCategory.A_ADJACENT.ordinal(), (Double)values.get(ColonyValueCategory.A_ADJACENT.ordinal()) * MOD_ENEMY_UNIT[1]);
            }
        }
        for (GoodsType g : highProduction) {
            values.set(ColonyValueCategory.A_LEVEL.ordinal(), (Double)values.get(ColonyValueCategory.A_LEVEL.ordinal()) * 1.2);
            goodProduction.remove(g);
        }
        if (!goodProduction.isEmpty()) {
            values.set(ColonyValueCategory.A_LEVEL.ordinal(), (Double)values.get(ColonyValueCategory.A_LEVEL.ordinal()) * 1.1 * (double)goodProduction.size());
        }
        boolean bl = false;
        for (int radius = 2; radius < 5; ++radius) {
            for (Tile t : this.getGame().getMap().getCircleTiles(tile, false, radius)) {
                Settlement settlement = t.getSettlement();
                if (settlement != null) {
                    if (this.owns(settlement)) {
                        boolean bl2;
                        if (!bl2) {
                            bl2 = true;
                            values.set(ColonyValueCategory.A_NEARBY.ordinal(), (Double)values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_OWN_COLONY[radius]);
                        }
                    } else if (this.atWarWith(settlement.getOwner())) {
                        values.set(ColonyValueCategory.A_NEARBY.ordinal(), (Double)values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_ENEMY_COLONY[radius]);
                    } else {
                        values.set(ColonyValueCategory.A_NEARBY.ordinal(), (Double)values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_NEUTRAL_COLONY[radius]);
                    }
                }
                for (Unit u : t.getUnitList()) {
                    if (this.owns(u) || !u.isOffensiveUnit() || !this.atWarWith(u.getOwner())) continue;
                    values.set(ColonyValueCategory.A_NEARBY.ordinal(), (Double)values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_ENEMY_UNIT[radius]);
                }
            }
        }
        if (production.getCount(foodType) < 4) {
            values.set(ColonyValueCategory.A_FOOD.ordinal(), (Double)values.get(ColonyValueCategory.A_FOOD.ordinal()) * 0.75);
        }
        int a = ColonyValueCategory.A_GOODS.ordinal() - 1;
        for (GoodsType type : production.keySet()) {
            Integer amount = production.getCount(type);
            double d = type.getLowProductionThreshold();
            if (!(d > 0.0)) continue;
            if (++a == values.size()) {
                values.add(1.0);
            }
            if (!((double)amount.intValue() < d)) continue;
            double fraction = (double)amount.intValue() / d;
            double zeroValue = type.getZeroProductionFactor();
            values.set(a, (1.0 - fraction) * zeroValue + fraction);
        }
        return values;
    }

    public int getColonyValue(Tile tile) {
        List<Double> values = this.getAllColonyValues(tile);
        if (values.get(0) < 0.0) {
            return (int)Math.round(values.get(0));
        }
        double v = 1.0;
        for (Double d : values) {
            v *= d.doubleValue();
        }
        return (int)Math.round(v);
    }

    public void logCheat(String what) {
        logger.finest("CHEAT: " + this.getGame().getTurn().getNumber() + " " + StringUtils.lastPart(this.getNationId(), ".") + " " + what);
    }

    public int getMaximumFoodConsumption() {
        if (this.maximumFoodConsumption < 0) {
            Specification spec = this.getSpecification();
            for (UnitType unitType : spec.getUnitTypeList()) {
                if (!unitType.isAvailableTo(this)) continue;
                int foodConsumption = 0;
                for (GoodsType foodType : spec.getFoodGoodsTypeList()) {
                    foodConsumption += unitType.getConsumptionOf(foodType);
                }
                if (foodConsumption <= this.maximumFoodConsumption) continue;
                this.maximumFoodConsumption = foodConsumption;
            }
        }
        return this.maximumFoodConsumption;
    }

    public boolean owns(Ownable ownable) {
        return ownable == null ? false : this.equals(ownable.getOwner());
    }

    public <T extends FreeColGameObject> T getOurFreeColGameObject(String id, Class<T> returnClass) throws IllegalStateException {
        T t = this.getGame().getFreeColGameObject(id, returnClass);
        if (t == null) {
            throw new IllegalStateException("Not a " + returnClass.getName() + ": " + id);
        }
        if (t instanceof Ownable) {
            if (!this.owns((Ownable)t)) {
                throw new IllegalStateException(returnClass.getName() + " not owned by " + this.getId() + ": " + id);
            }
        } else {
            throw new IllegalStateException("Not ownable: " + id);
        }
        return t;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        for (Unit unit : this.getUnits()) {
            if (unit.getOwner() == null) {
                if (fix) {
                    unit.setOwner(this);
                    logger.warning("Fixed missing owner for: " + unit.getId());
                    result = 0;
                } else {
                    logger.warning("Missing owner for: " + unit.getId());
                    result = -1;
                }
            }
            result = Math.min(result, unit.checkIntegrity(fix));
        }
        if (this.monarch != null) {
            result = Math.min(result, this.monarch.checkIntegrity(fix));
        }
        return result;
    }

    @Override
    public final FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(USERNAME_TAG, this.name);
        xw.writeAttribute(NATION_ID_TAG, this.nationId);
        if (this.nationType != null) {
            xw.writeAttribute(NATION_TYPE_TAG, this.nationType);
        }
        xw.writeAttribute(ADMIN_TAG, this.admin);
        xw.writeAttribute(READY_TAG, this.ready);
        xw.writeAttribute(DEAD_TAG, this.dead);
        xw.writeAttribute(PLAYER_TYPE_TAG, this.playerType);
        xw.writeAttribute(AI_TAG, this.ai);
        if (xw.validFor(this)) {
            xw.writeAttribute(BANKRUPT_TAG, this.bankrupt);
            xw.writeAttribute(TAX_TAG, this.tax);
            xw.writeAttribute(GOLD_TAG, this.gold);
            xw.writeAttribute(IMMIGRATION_TAG, this.immigration);
            xw.writeAttribute(LIBERTY_TAG, this.liberty);
            xw.writeAttribute(INTERVENTION_BELLS_TAG, this.interventionBells);
            if (this.currentFather != null) {
                xw.writeAttribute(CURRENT_FATHER_TAG, this.currentFather);
            }
            xw.writeAttribute(IMMIGRATION_REQUIRED_TAG, this.immigrationRequired);
            xw.writeAttribute(ATTACKED_BY_PRIVATEERS_TAG, this.attackedByPrivateers);
            xw.writeAttribute(OLD_SOL_TAG, this.oldSoL);
            xw.writeAttribute(SCORE_TAG, this.score);
        }
        if (this.newLandName != null) {
            xw.writeAttribute(NEW_LAND_NAME_TAG, this.newLandName);
        }
        if (this.independentNationName != null) {
            xw.writeAttribute(INDEPENDENT_NATION_NAME_TAG, this.independentNationName);
        }
        if (this.entryLocation != null) {
            xw.writeLocationAttribute(ENTRY_LOCATION_TAG, this.entryLocation);
        }
        for (Region.RegionType regionType : Region.RegionType.values()) {
            String key = regionType.getNameIndexKey();
            int index = this.getNameIndex(key);
            if (index <= 0) continue;
            xw.writeAttribute(key, index);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.market != null) {
            this.market.toXML(xw);
        }
        if (xw.validFor(this)) {
            for (Ability ability : this.getSortedAbilities()) {
                if (!ability.isIndependent()) continue;
                ability.toXML(xw);
            }
            Turn turn = this.getGame().getTurn();
            for (Modifier modifier : this.getSortedModifiers()) {
                if (!modifier.isTemporary() || modifier.isOutOfDate(turn)) continue;
                modifier.toXML(xw);
            }
            for (Player player : Player.getSortedCopy(this.tension.keySet())) {
                xw.writeStartElement(TENSION_TAG);
                xw.writeAttribute(PLAYER_TAG, player);
                xw.writeAttribute("value", this.tension.get(player).getValue());
                xw.writeEndElement();
            }
            if (this.bannedMissions != null) {
                for (Player player : Player.getSortedCopy(this.bannedMissions)) {
                    xw.writeStartElement(BAN_MISSIONS_TAG);
                    xw.writeAttribute(PLAYER_TAG, player.getId());
                    xw.writeEndElement();
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.stance.keySet());
            Collections.sort(arrayList);
            for (String pid : arrayList) {
                Stance s = this.stance.get(pid);
                if (s == Stance.UNCONTACTED) continue;
                xw.writeStartElement(STANCE_TAG);
                xw.writeAttribute(PLAYER_TAG, pid);
                xw.writeAttribute("value", this.stance.get(pid));
                xw.writeEndElement();
            }
            for (HistoryEvent event : this.history) {
                event.toXML(xw);
            }
            for (TradeRoute route : Player.getSortedCopy(this.tradeRoutes)) {
                route.toXML(xw);
            }
            if (this.highSeas != null) {
                this.highSeas.toXML(xw);
            }
            xw.writeToListElement(FOUNDING_FATHERS_TAG, this.foundingFathers);
            xw.writeToListElement(OFFERED_FATHERS_TAG, this.offeredFathers);
            if (this.europe != null) {
                this.europe.toXML(xw);
            }
            if (this.monarch != null) {
                this.monarch.toXML(xw);
            }
            for (ModelMessage m : this.getModelMessages()) {
                m.toXML(xw);
            }
            if (this.lastSales != null) {
                for (LastSale ls : Player.getSortedCopy(this.lastSales.values())) {
                    ls.toXML(xw);
                }
            }
        } else {
            Stance stance;
            Player player = xw.getClientPlayer();
            Tension tension = this.getTension(player);
            if (tension != null) {
                xw.writeStartElement(TENSION_TAG);
                xw.writeAttribute(PLAYER_TAG, player);
                xw.writeAttribute("value", tension.getValue());
                xw.writeEndElement();
            }
            if (this.missionsBanned(player)) {
                xw.writeStartElement(BAN_MISSIONS_TAG);
                xw.writeAttribute(PLAYER_TAG, player.getId());
                xw.writeEndElement();
            }
            if ((stance = this.getStance(player)) != null && stance != Stance.UNCONTACTED) {
                xw.writeStartElement(STANCE_TAG);
                xw.writeAttribute(PLAYER_TAG, player);
                xw.writeAttribute("value", stance);
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.name = xr.getAttribute(USERNAME_TAG, null);
        this.nationId = xr.getAttribute(NATION_ID_TAG, xr.getAttribute(OLD_NATION_ID_TAG, null));
        this.nationType = this.isUnknownEnemy() ? null : xr.getType(spec, NATION_TYPE_TAG, NationType.class, null);
        this.admin = xr.getAttribute(ADMIN_TAG, false);
        this.gold = xr.getAttribute(GOLD_TAG, 0);
        this.immigration = xr.getAttribute(IMMIGRATION_TAG, 0);
        this.liberty = xr.getAttribute(LIBERTY_TAG, 0);
        this.interventionBells = xr.getAttribute(INTERVENTION_BELLS_TAG, 0);
        this.oldSoL = xr.getAttribute(OLD_SOL_TAG, 0);
        this.score = xr.getAttribute(SCORE_TAG, 0);
        this.ready = xr.getAttribute(READY_TAG, false);
        this.ai = xr.getAttribute(AI_TAG, false);
        this.dead = xr.getAttribute(DEAD_TAG, false);
        this.bankrupt = xr.getAttribute(BANKRUPT_TAG, false);
        this.tax = xr.getAttribute(TAX_TAG, 0);
        this.changePlayerType(xr.getAttribute(PLAYER_TYPE_TAG, PlayerType.class, null));
        this.currentFather = xr.getType(spec, CURRENT_FATHER_TAG, FoundingFather.class, null);
        this.immigrationRequired = xr.getAttribute(IMMIGRATION_REQUIRED_TAG, 12);
        this.newLandName = xr.getAttribute(NEW_LAND_NAME_TAG, null);
        this.independentNationName = xr.getAttribute(INDEPENDENT_NATION_NAME_TAG, null);
        this.attackedByPrivateers = xr.getAttribute(ATTACKED_BY_PRIVATEERS_TAG, false);
        this.entryLocation = xr.getLocationAttribute(game, ENTRY_LOCATION_TAG, true);
        for (Region.RegionType regionType : Region.RegionType.values()) {
            String key = regionType.getNameIndexKey();
            int index = xr.getAttribute(key, -1);
            if (index <= 0) continue;
            this.setNameIndex(key, index);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.tension.clear();
        if (this.bannedMissions != null) {
            this.bannedMissions.clear();
        }
        this.stance.clear();
        this.foundingFathers.clear();
        this.offeredFathers.clear();
        this.europe = null;
        this.monarch = null;
        this.history.clear();
        this.tradeRoutes.clear();
        this.clearModelMessages();
        this.lastSales = null;
        this.highSeas = null;
        this.featureContainer.clear();
        if (this.nationType != null) {
            this.addFeatures(this.nationType);
        }
        super.readChildren(xr);
        Specification spec = this.getSpecification();
        for (Modifier m : this.getModifiers()) {
            String type;
            if (m.getSource() == null || (type = spec.fatherGoodsFixMap.get(m.getSource().getId())) == null || !m.getId().equals(type)) continue;
            m.requireNegatedPersonScope();
        }
        this.recalculateBellsBonus();
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (BAN_MISSIONS_TAG.equals(tag)) {
            Player player = xr.makeFreeColGameObject(game, PLAYER_TAG, Player.class, true);
            if (player != null && player.isEuropean()) {
                this.addMissionBan(player);
            }
            xr.closeTag(BAN_MISSIONS_TAG);
        } else if (FOUNDING_FATHERS_TAG.equals(tag)) {
            List<FoundingFather> ffs = xr.readList(spec, FOUNDING_FATHERS_TAG, FoundingFather.class);
            if (ffs != null) {
                for (FoundingFather ff : ffs) {
                    this.addFather(ff);
                }
            }
        } else if (OFFERED_FATHERS_TAG.equals(tag)) {
            List<FoundingFather> ofs = xr.readList(spec, OFFERED_FATHERS_TAG, FoundingFather.class);
            this.offeredFathers.addAll(ofs);
        } else if (STANCE_TAG.equals(tag)) {
            Player player = xr.makeFreeColGameObject(game, PLAYER_TAG, Player.class, true);
            this.stance.put(player.getId(), xr.getAttribute("value", Stance.class, Stance.UNCONTACTED));
            xr.closeTag(STANCE_TAG);
        } else if (TENSION_TAG.equals(tag)) {
            this.tension.put(xr.makeFreeColGameObject(game, PLAYER_TAG, Player.class, true), new Tension(xr.getAttribute("value", 0)));
            xr.closeTag(TENSION_TAG);
        } else if (Ability.getXMLElementTagName().equals(tag)) {
            Ability ability = new Ability(xr, spec);
            if (ability.isIndependent()) {
                this.addAbility(ability);
            }
        } else if (Europe.getXMLElementTagName().equals(tag)) {
            this.europe = xr.readFreeColGameObject(game, Europe.class);
        } else if (HighSeas.getXMLElementTagName().equals(tag)) {
            this.highSeas = xr.readFreeColGameObject(game, HighSeas.class);
        } else if (HistoryEvent.getXMLElementTagName().equals(tag)) {
            this.getHistory().add(new HistoryEvent(xr));
        } else if (LastSale.getXMLElementTagName().equals(tag)) {
            this.addLastSale(new LastSale(xr));
        } else if (Market.getXMLElementTagName().equals(tag)) {
            this.market = xr.readFreeColGameObject(game, Market.class);
        } else if (ModelMessage.getXMLElementTagName().equals(tag)) {
            this.addModelMessage(new ModelMessage(xr));
        } else if (Modifier.getXMLElementTagName().equals(tag)) {
            Modifier modifier = new Modifier(xr, spec);
            if (modifier.isIndependent()) {
                this.addModifier(modifier);
            }
        } else if (Monarch.getXMLElementTagName().equals(tag)) {
            this.monarch = xr.readFreeColGameObject(game, Monarch.class);
        } else if (TradeRoute.getXMLElementTagName().equals(tag)) {
            this.tradeRoutes.add(xr.readFreeColGameObject(game, TradeRoute.class));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.nationId;
    }

    @Override
    public String getXMLTagName() {
        return Player.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return PLAYER_TAG;
    }

    public static enum NoClaimReason {
        NONE,
        TERRAIN,
        RUMOUR,
        WATER,
        OCCUPIED,
        SETTLEMENT,
        WORKED,
        EUROPEANS,
        NATIVES;

    }

    public static enum Stance {
        UNCONTACTED,
        ALLIANCE,
        PEACE,
        CEASE_FIRE,
        WAR;


        private void badStance() {
            throw new IllegalStateException("Bogus stance");
        }

        private void badTransition(Stance newStance) {
            throw new IllegalStateException("Bad transition: " + (Object)((Object)this) + " -> " + (Object)((Object)newStance));
        }

        public Stance getStanceFromTension(Tension tension) {
            int value = tension.getValue();
            switch (this) {
                case WAR: {
                    if (value > Tension.Level.CONTENT.getLimit() - 10) break;
                    return CEASE_FIRE;
                }
                case CEASE_FIRE: {
                    if (value <= Tension.Level.HAPPY.getLimit() - 10) {
                        return PEACE;
                    }
                }
                case ALLIANCE: 
                case PEACE: {
                    if (value <= Tension.Level.HATEFUL.getLimit() + 10) break;
                    return WAR;
                }
                case UNCONTACTED: {
                    break;
                }
                default: {
                    this.badStance();
                }
            }
            return this;
        }

        public int getTensionModifier(Stance newStance) throws IllegalStateException {
            switch (newStance) {
                case UNCONTACTED: {
                    this.badTransition(newStance);
                }
                case ALLIANCE: {
                    switch (this) {
                        case UNCONTACTED: {
                            this.badTransition(newStance);
                        }
                        case ALLIANCE: {
                            return 0;
                        }
                        case PEACE: {
                            return -500;
                        }
                        case CEASE_FIRE: {
                            return -750;
                        }
                        case WAR: {
                            return -1000;
                        }
                    }
                    this.badStance();
                }
                case PEACE: {
                    switch (this) {
                        case UNCONTACTED: {
                            return 0;
                        }
                        case ALLIANCE: {
                            return 200;
                        }
                        case PEACE: {
                            return 0;
                        }
                        case CEASE_FIRE: {
                            return -250;
                        }
                        case WAR: {
                            return -500;
                        }
                    }
                    this.badStance();
                }
                case CEASE_FIRE: {
                    switch (this) {
                        case UNCONTACTED: {
                            this.badTransition(newStance);
                        }
                        case ALLIANCE: {
                            this.badTransition(newStance);
                        }
                        case PEACE: {
                            this.badTransition(newStance);
                        }
                        case CEASE_FIRE: {
                            return 0;
                        }
                        case WAR: {
                            return -250;
                        }
                    }
                    this.badStance();
                }
                case WAR: {
                    switch (this) {
                        case UNCONTACTED: {
                            return Tension.WAR_MODIFIER;
                        }
                        case ALLIANCE: {
                            return Tension.WAR_MODIFIER;
                        }
                        case PEACE: {
                            return Tension.WAR_MODIFIER;
                        }
                        case CEASE_FIRE: {
                            return 750;
                        }
                        case WAR: {
                            return 0;
                        }
                    }
                    this.badStance();
                }
            }
            throw new IllegalStateException("Bogus newStance");
        }

        public String getKey() {
            return this.toString().toLowerCase(Locale.US);
        }

        public StringTemplate getLabel() {
            return StringTemplate.template("model.stance." + this.getKey());
        }
    }

    public static class UnitIterator
    implements Iterator<Unit> {
        private final Player owner;
        private final UnitPredicate predicate;
        private final List<Unit> units = new ArrayList<Unit>();

        public UnitIterator(Player owner, UnitPredicate predicate) {
            this.owner = owner;
            this.predicate = predicate;
            this.update();
        }

        private final void update() {
            this.units.clear();
            for (Unit u : this.owner.getUnits()) {
                if (!this.predicate.obtains(u)) continue;
                this.units.add(u);
            }
            Collections.sort(this.units, xyComparator);
        }

        public boolean setNext(Unit unit) {
            if (this.predicate.obtains(unit)) {
                Unit first;
                Unit unit2 = first = this.units.isEmpty() ? null : this.units.get(0);
                while (!this.units.isEmpty()) {
                    if (this.units.get(0) == unit) {
                        return true;
                    }
                    this.units.remove(0);
                }
                this.update();
                while (!this.units.isEmpty() && this.units.get(0) != first) {
                    if (this.units.get(0) == unit) {
                        return true;
                    }
                    this.units.remove(0);
                }
            }
            return false;
        }

        public boolean remove(Unit u) {
            return this.units.remove(u);
        }

        public void reset() {
            this.update();
        }

        @Override
        public boolean hasNext() {
            while (!this.units.isEmpty()) {
                if (this.predicate.obtains(this.units.get(0))) {
                    return true;
                }
                this.units.remove(0);
            }
            this.update();
            return !this.units.isEmpty();
        }

        @Override
        public Unit next() {
            return this.hasNext() ? this.units.remove(0) : null;
        }

        @Override
        public void remove() {
            this.next();
        }
    }

    public class GoingToPredicate
    extends UnitPredicate {
        private final Player player;
        private final boolean tradeRoute;

        public GoingToPredicate(Player player, boolean tradeRoute) {
            this.player = player;
            this.tradeRoute = tradeRoute;
        }

        @Override
        public boolean obtains(Unit unit) {
            return !unit.isDisposed() && unit.getOwner() == this.player && unit.getState() != Unit.UnitState.FORTIFYING && unit.getState() != Unit.UnitState.SKIPPED && unit.getMovesLeft() > 0 && !unit.isDamaged() && !unit.isAtSea() && !unit.isOnCarrier() && !unit.isInColony() && (!this.tradeRoute && unit.getDestination() != null || this.tradeRoute && unit.getTradeRoute() != null);
        }
    }

    public class ActivePredicate
    extends UnitPredicate {
        @Override
        public boolean obtains(Unit unit) {
            return unit.couldMove() && unit.getState() != Unit.UnitState.SKIPPED;
        }
    }

    public abstract class UnitPredicate {
        public abstract boolean obtains(Unit var1);
    }

    public static enum NoValueType {
        BOGUS(-1),
        TERRAIN(-2),
        RUMOUR(-3),
        SETTLED(-4),
        FOOD(-5),
        INLAND(-6),
        POLAR(-7);

        private static final int MAX;
        private final int value;

        private NoValueType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public double getDouble() {
            return this.value;
        }

        public static NoValueType fromValue(int i) {
            int n = -i - 1;
            return n >= 0 && n < MAX ? NoValueType.values()[n] : BOGUS;
        }

        static {
            MAX = NoValueType.values().length;
        }
    }

    public static enum ColonyValueCategory {
        A_OVERRIDE,
        A_PROD,
        A_TILE,
        A_EUROPE,
        A_RESOURCE,
        A_ADJACENT,
        A_FOOD,
        A_LEVEL,
        A_NEARBY,
        A_GOODS;


        public String toString() {
            return super.toString().substring(2);
        }
    }

    public static enum PlayerType {
        NATIVE,
        COLONIAL,
        REBEL,
        INDEPENDENT,
        ROYAL,
        UNDEAD,
        RETIRED;

    }
}

