/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.util.LogBuilder;

public class PathNode {
    private static final int TURN_FACTOR = 100;
    private final Location location;
    private int movesLeft;
    private int turns;
    private boolean onCarrier = false;
    public PathNode next = null;
    public PathNode previous = null;

    public PathNode(Location location, int movesLeft, int turns, boolean onCarrier, PathNode previous, PathNode next) {
        this.location = location;
        this.movesLeft = movesLeft;
        this.turns = turns;
        this.onCarrier = onCarrier;
        this.previous = previous;
        this.next = next;
    }

    public Location getLocation() {
        return this.location;
    }

    public Tile getTile() {
        return this.location == null ? null : this.location.getTile();
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public void setMovesLeft(int movesLeft) {
        this.movesLeft = movesLeft;
    }

    public int getTurns() {
        return this.turns;
    }

    public void setTurns(int turns) {
        this.turns = turns;
    }

    public void addTurns(int turns) {
        PathNode p = this;
        while (p != null) {
            p.setTurns(p.getTurns() + turns);
            p = p.next;
        }
    }

    public boolean isOnCarrier() {
        return this.onCarrier;
    }

    public void setOnCarrier(boolean onCarrier) {
        this.onCarrier = onCarrier;
    }

    public int getLength() {
        int n = 0;
        PathNode temp = this;
        while (temp != null) {
            ++n;
            temp = temp.next;
        }
        return n;
    }

    public Map.Direction getDirection() {
        if (this.previous == null || this.previous.getTile() == null || this.getTile() == null) {
            return null;
        }
        Tile prev = this.previous.getTile();
        return prev.getMap().getDirection(prev, this.getTile());
    }

    public PathNode getTransportDropNode() {
        PathNode p = this;
        while (p.next != null && p.isOnCarrier()) {
            p = p.next;
        }
        return p;
    }

    public PathNode getFirstNode() {
        PathNode path = this;
        while (path.previous != null) {
            path = path.previous;
        }
        return path;
    }

    public PathNode getLastNode() {
        PathNode path = this;
        while (path.next != null) {
            path = path.next;
        }
        return path;
    }

    public int getTotalTurns() {
        PathNode path = this.getLastNode();
        int n = path.getTurns();
        if (path.getMovesLeft() == 0) {
            ++n;
        }
        return n;
    }

    public int getTransportDropTurns() {
        return this.getTransportDropNode().getTurns();
    }

    public static int getCost(int turns, int movesLeft) {
        return turns >= 21262214 ? Integer.MAX_VALUE : 100 * turns + (100 - movesLeft);
    }

    public int getCost() {
        return PathNode.getCost(this.turns, this.movesLeft);
    }

    public PathNode getCarrierMove() {
        PathNode p = this;
        while (p != null) {
            if (p.isOnCarrier()) {
                return p;
            }
            p = p.next;
        }
        return null;
    }

    public boolean usesCarrier() {
        return this.getFirstNode().getCarrierMove() != null;
    }

    public boolean embarkedThisTurn(int turns) {
        PathNode p = this;
        while (p != null) {
            if (p.getTurns() < turns) {
                return false;
            }
            if (!p.isOnCarrier()) {
                return true;
            }
            p = p.previous;
        }
        return false;
    }

    public void convertToGoodsDeliveryPath() {
        PathNode p = this;
        while (p.next != null) {
            p.onCarrier = true;
            p = p.next;
        }
        p.onCarrier = true;
        this.ensureDisembark();
    }

    public void ensureDisembark() {
        PathNode p = this.getLastNode();
        if (p.isOnCarrier()) {
            p.next = new PathNode(p.location, p.movesLeft, p.turns, false, p, null);
        }
    }

    public String toString() {
        LogBuilder lb = new LogBuilder(256);
        lb.add(new Object[]{"PathNode loc=", this.location, " movesLeft=", this.movesLeft, " turns=", this.turns, " onCarrier=", this.onCarrier, " direction=", this.getDirection(), " cost=", this.getCost()});
        return lb.toString();
    }

    public String fullPathToString() {
        LogBuilder lb = new LogBuilder(500);
        PathNode p = this;
        while (p != null) {
            lb.add(p, "\n");
            p = p.next;
        }
        return lb.toString();
    }
}

