/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.util.Utils;

public class Operand
extends Scope {
    private static final Logger logger = Logger.getLogger(Operand.class.getName());
    private OperandType operandType = OperandType.NONE;
    private ScopeLevel scopeLevel = ScopeLevel.NONE;
    private Integer value = null;
    private static final String OPERAND_TYPE_TAG = "operandType";
    private static final String SCOPE_LEVEL_TAG = "scopeLevel";

    public Operand() {
    }

    public Operand(int value) {
        this.value = value;
    }

    public Operand(OperandType operandType, ScopeLevel scopeLevel) {
        this.operandType = operandType;
        this.scopeLevel = scopeLevel;
    }

    protected Operand(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final OperandType getOperandType() {
        return this.operandType;
    }

    public final void setOperandType(OperandType newOperandType) {
        this.operandType = newOperandType;
    }

    public final ScopeLevel getScopeLevel() {
        return this.scopeLevel;
    }

    public final void setScopeLevel(ScopeLevel newScopeLevel) {
        this.scopeLevel = newScopeLevel;
    }

    public final Integer getValue() {
        return this.value;
    }

    public final void setValue(Integer newValue) {
        this.value = newValue;
    }

    public Integer getValue(Game game) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.GAME) {
                return this.calculateGameValue(game);
            }
            return null;
        }
        return this.value;
    }

    private Integer calculateGameValue(Game game) {
        switch (this.operandType) {
            case NONE: {
                if (this.getMethodName() != null) {
                    try {
                        Method method = game.getClass().getMethod(this.getMethodName(), new Class[0]);
                        if (method != null && Integer.class.isAssignableFrom(method.getReturnType())) {
                            return (Integer)method.invoke((Object)game, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Unable to invoke: " + this.getMethodName(), e);
                    }
                }
                return null;
            }
            case YEAR: {
                return game.getTurn().getYear();
            }
            case OPTION: {
                return game.getSpecification().getInteger(this.getType());
            }
        }
        LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
        block13: for (Player player : game.getLivePlayers(null)) {
            switch (this.operandType) {
                case UNITS: {
                    list.addAll(player.getUnits());
                    break;
                }
                case BUILDINGS: {
                    for (Colony colony : player.getColonies()) {
                        list.addAll(colony.getBuildings());
                    }
                    continue block13;
                }
                case SETTLEMENTS: {
                    list.addAll(player.getSettlements());
                    break;
                }
                case FOUNDING_FATHERS: {
                    list.addAll(player.getFathers());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return this.count(list);
    }

    public Integer getValue(Player player) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.PLAYER) {
                LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
                switch (this.operandType) {
                    case UNITS: {
                        list.addAll(player.getUnits());
                        break;
                    }
                    case BUILDINGS: {
                        for (Colony colony : player.getColonies()) {
                            list.addAll(colony.getBuildings());
                        }
                        break;
                    }
                    case SETTLEMENTS: {
                        list.addAll(player.getSettlements());
                        break;
                    }
                    case FOUNDING_FATHERS: {
                        list.addAll(player.getFathers());
                        break;
                    }
                    default: {
                        if (this.getMethodName() != null) {
                            try {
                                Method method = player.getClass().getMethod(this.getMethodName(), new Class[0]);
                                if (method != null && (Integer.TYPE.equals(method.getReturnType()) || Integer.class.equals(method.getReturnType()))) {
                                    return (Integer)method.invoke((Object)player, new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Unable to invoke: " + this.getMethodName(), e);
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return this.count(list);
            }
            if (this.scopeLevel == ScopeLevel.GAME) {
                return this.getValue(player.getGame());
            }
            return null;
        }
        return this.value;
    }

    public Integer getValue(Settlement settlement) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.SETTLEMENT && settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
                switch (this.operandType) {
                    case UNITS: {
                        list.addAll(colony.getUnitList());
                        break;
                    }
                    case BUILDINGS: {
                        list.addAll(colony.getBuildings());
                        break;
                    }
                    default: {
                        if (this.getMethodName() != null) {
                            try {
                                Method method = colony.getClass().getMethod(this.getMethodName(), new Class[0]);
                                if (method != null && Integer.class.isAssignableFrom(method.getReturnType())) {
                                    return (Integer)method.invoke((Object)colony, new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Unable to invoke: " + this.getMethodName(), e);
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return this.count(list);
            }
            return null;
        }
        return this.value;
    }

    private int count(List<FreeColObject> objects) {
        int result = 0;
        for (FreeColObject object : objects) {
            if (!this.appliesTo(object)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Operand) {
            Operand op = (Operand)o;
            return this.operandType == op.operandType && this.scopeLevel == op.scopeLevel && Utils.equals(this.value, op.value) && super.equals(o);
        }
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OPERAND_TYPE_TAG, this.operandType.toString());
        xw.writeAttribute(SCOPE_LEVEL_TAG, this.scopeLevel.toString());
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.operandType = xr.getAttribute(OPERAND_TYPE_TAG, OperandType.class, OperandType.NONE);
        this.scopeLevel = xr.getAttribute(SCOPE_LEVEL_TAG, ScopeLevel.class, ScopeLevel.NONE);
        int val = xr.getAttribute("value", Integer.MAX_VALUE);
        if (val != Integer.MAX_VALUE) {
            this.value = val;
        }
    }

    @Override
    public String toString() {
        return this.value != null ? Integer.toString(this.value) : (Object)((Object)this.scopeLevel) + "'s number of " + (Object)((Object)this.operandType) + "s";
    }

    public static enum ScopeLevel {
        SETTLEMENT,
        PLAYER,
        GAME,
        NONE;

    }

    public static enum OperandType {
        UNITS,
        BUILDINGS,
        SETTLEMENTS,
        FOUNDING_FATHERS,
        YEAR,
        OPTION,
        NONE;

    }
}

