/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Specification;

public class NationOptions
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(NationOptions.class.getName());
    private final Specification specification;
    private Advantages nationalAdvantages;
    private final Map<Nation, NationState> nations = new HashMap<Nation, NationState>();
    private static final String NATIONAL_ADVANTAGES_TAG = "nationalAdvantages";
    private static final String NATION_TAG = "Nation";
    private static final String NATIONS_TAG = "Nations";
    private static final String STATE_TAG = "state";

    public NationOptions(Specification specification) {
        this.specification = specification;
        this.nationalAdvantages = FreeCol.getAdvantages();
        if (specification != null) {
            int counter = 0;
            int maxEuropeans = FreeCol.getEuropeanCount();
            for (Nation nation : specification.getNations()) {
                if (nation.isUnknownEnemy() || nation.getType().isREF()) continue;
                if (nation.getType().isEuropean() && nation.isSelectable()) {
                    if (counter < maxEuropeans) {
                        this.nations.put(nation, NationState.AVAILABLE);
                        ++counter;
                        continue;
                    }
                    this.nations.put(nation, NationState.NOT_AVAILABLE);
                    continue;
                }
                this.nations.put(nation, NationState.AI_ONLY);
            }
        }
    }

    public NationOptions(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    public final Map<Nation, NationState> getNations() {
        return this.nations;
    }

    public final Advantages getNationalAdvantages() {
        return this.nationalAdvantages;
    }

    public final NationState getNationState(Nation nation) {
        return this.nations.get(nation);
    }

    public final void setNationState(Nation nation, NationState state) {
        this.nations.put(nation, state);
    }

    @Override
    public void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(NATIONAL_ADVANTAGES_TAG, this.nationalAdvantages);
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        xw.writeStartElement(NATIONS_TAG);
        for (Nation nation : NationOptions.getSortedCopy(this.nations.keySet())) {
            xw.writeStartElement(NATION_TAG);
            xw.writeAttribute("id", nation);
            xw.writeAttribute(STATE_TAG, this.nations.get(nation));
            xw.writeEndElement();
        }
        xw.writeEndElement();
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.nationalAdvantages = xr.getAttribute(NATIONAL_ADVANTAGES_TAG, Advantages.class, Advantages.SELECTABLE);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.nations.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (NATIONS_TAG.equals(tag)) {
            while (xr.nextTag() != 2) {
                tag = xr.getLocalName();
                if (NATION_TAG.equals(tag)) {
                    Nation nation = null;
                    try {
                        nation = xr.getType(this.specification, "id", Nation.class, null);
                    }
                    catch (IllegalArgumentException iae) {
                        logger.warning("Bad nation tag: " + xr.readId());
                    }
                    if (nation != null) {
                        NationState state = xr.getAttribute(STATE_TAG, NationState.class, null);
                        this.nations.put(nation, state);
                    }
                    xr.closeTag(NATION_TAG);
                    continue;
                }
                throw new XMLStreamException("Bogus Nation tag: " + tag);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(NATIONAL_ADVANTAGES_TAG).append(": ").append(this.nationalAdvantages).append("\n").append(NATIONS_TAG).append(":\n");
        for (Map.Entry<Nation, NationState> entry : this.nations.entrySet()) {
            sb.append("   ").append(entry.getKey().getId()).append(" ").append((Object)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return NationOptions.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "nationOptions";
    }

    public static enum NationState {
        AVAILABLE,
        AI_ONLY,
        NOT_AVAILABLE;

    }

    public static enum Advantages implements Named
    {
        NONE,
        FIXED,
        SELECTABLE;


        @Override
        public String getNameKey() {
            return Messages.nameKey("playerOptions." + this);
        }
    }
}

