/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;

public class MarketData
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(MarketData.class.getName());
    public static final int MINIMUM_PRICE = 1;
    public static final int MAXIMUM_PRICE = 19;
    private GoodsType goodsType;
    private int costToBuy;
    private int paidForSale;
    private int amountInMarket;
    private int initialPrice;
    private int arrears;
    private int sales;
    private int incomeBeforeTaxes;
    private int incomeAfterTaxes;
    private int oldPrice;
    private boolean traded;
    private static final String AMOUNT_TAG = "amount";
    private static final String ARREARS_TAG = "arrears";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String INCOME_AFTER_TAXES_TAG = "incomeAfterTaxes";
    private static final String INCOME_BEFORE_TAXES_TAG = "incomeBeforeTaxes";
    private static final String INITIAL_PRICE_TAG = "initialPrice";
    private static final String SALES_TAG = "sales";
    private static final String TRADED_TAG = "traded";

    public MarketData(Game game, GoodsType goodsType) {
        super(game);
        this.goodsType = goodsType;
        this.paidForSale = goodsType.getInitialSellPrice();
        this.costToBuy = goodsType.getInitialBuyPrice();
        this.amountInMarket = goodsType.getInitialAmount();
        this.initialPrice = goodsType.getInitialSellPrice();
        this.arrears = 0;
        this.sales = 0;
        this.incomeBeforeTaxes = 0;
        this.incomeAfterTaxes = 0;
        this.oldPrice = this.costToBuy;
        this.traded = false;
    }

    public MarketData(Game game, String id) {
        super(game, id);
    }

    public final GoodsType getGoodsType() {
        return this.goodsType;
    }

    public final int getCostToBuy() {
        return this.costToBuy;
    }

    public final void setCostToBuy(int newCostToBuy) {
        this.costToBuy = newCostToBuy;
    }

    public final int getPaidForSale() {
        return this.paidForSale;
    }

    public final void setPaidForSale(int newPaidForSale) {
        this.paidForSale = newPaidForSale;
    }

    public final int getAmountInMarket() {
        return this.amountInMarket;
    }

    public final void setAmountInMarket(int newAmountInMarket) {
        this.amountInMarket = newAmountInMarket;
    }

    public final int getInitialPrice() {
        return this.initialPrice;
    }

    public final void setInitialPrice(int newInitialPrice) {
        this.initialPrice = newInitialPrice;
    }

    public final int getArrears() {
        return this.arrears;
    }

    public final void setArrears(int newArrears) {
        this.arrears = newArrears;
    }

    public final int getSales() {
        return this.sales;
    }

    public final void setSales(int newSales) {
        this.sales = newSales;
    }

    public final int getIncomeBeforeTaxes() {
        return this.incomeBeforeTaxes;
    }

    public final void setIncomeBeforeTaxes(int newIncomeBeforeTaxes) {
        this.incomeBeforeTaxes = newIncomeBeforeTaxes;
    }

    public final int getIncomeAfterTaxes() {
        return this.incomeAfterTaxes;
    }

    public final void setIncomeAfterTaxes(int newIncomeAfterTaxes) {
        this.incomeAfterTaxes = newIncomeAfterTaxes;
    }

    public final int getOldPrice() {
        return this.oldPrice;
    }

    public void setOldPrice(int oldPrice) {
        this.oldPrice = oldPrice;
    }

    public final boolean getTraded() {
        return this.traded;
    }

    public void setTraded(boolean traded) {
        this.traded = traded;
    }

    public boolean price() {
        if (!this.goodsType.isStorable()) {
            return false;
        }
        int diff = this.goodsType.getPriceDifference();
        float amountPrice = (float)this.initialPrice * ((float)this.goodsType.getInitialAmount() / (float)this.amountInMarket);
        int newSalePrice = Math.round(amountPrice);
        int newPrice = newSalePrice + diff;
        if ((this.goodsType.isNewWorldGoodsType() || this.goodsType.getInputType() != null && this.goodsType.getInputType().isNewWorldGoodsType()) && newSalePrice > this.initialPrice + 2) {
            newSalePrice = this.initialPrice + 2;
            newPrice = newSalePrice + diff;
        }
        if (this.costToBuy > 0) {
            if (newPrice > this.costToBuy + diff) {
                this.amountInMarket = Math.round((float)this.goodsType.getInitialAmount() * ((float)this.initialPrice / (amountPrice -= (float)(newPrice - (this.costToBuy + diff)))));
                logger.info("Clamped price rise for " + this.getId() + " from " + newPrice + " to " + (this.costToBuy + diff));
                newPrice = this.costToBuy + diff;
            } else if (newPrice < this.costToBuy - diff) {
                this.amountInMarket = Math.round((float)this.goodsType.getInitialAmount() * ((float)this.initialPrice / (amountPrice += (float)(this.costToBuy - diff - newPrice))));
                logger.info("Clamped price fall for " + this.getId() + " from " + newPrice + " to " + (this.costToBuy - diff));
                newPrice = this.costToBuy - diff;
            }
            newSalePrice = newPrice - diff;
        }
        if (newPrice > 19) {
            newPrice = 19;
            newSalePrice = newPrice - diff;
        } else if (newSalePrice < 1) {
            newSalePrice = 1;
            newPrice = newSalePrice + diff;
        }
        int oldCostToBuy = this.costToBuy;
        int oldPaidForSale = this.paidForSale;
        this.costToBuy = newPrice;
        this.paidForSale = newSalePrice;
        return this.costToBuy != oldCostToBuy || this.paidForSale != oldPaidForSale;
    }

    public void update() {
        this.costToBuy = -1;
        this.price();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(GOODS_TYPE_TAG, this.goodsType);
        xw.writeAttribute(AMOUNT_TAG, this.amountInMarket);
        xw.writeAttribute(INITIAL_PRICE_TAG, this.initialPrice);
        xw.writeAttribute(ARREARS_TAG, this.arrears);
        xw.writeAttribute(SALES_TAG, this.sales);
        xw.writeAttribute(INCOME_AFTER_TAXES_TAG, this.incomeAfterTaxes);
        xw.writeAttribute(INCOME_BEFORE_TAXES_TAG, this.incomeBeforeTaxes);
        xw.writeAttribute(TRADED_TAG, this.traded);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.goodsType = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
        this.amountInMarket = xr.getAttribute(AMOUNT_TAG, 0);
        this.initialPrice = xr.getAttribute(INITIAL_PRICE_TAG, -1);
        this.arrears = xr.getAttribute(ARREARS_TAG, 0);
        this.sales = xr.getAttribute(SALES_TAG, 0);
        this.incomeBeforeTaxes = xr.getAttribute(INCOME_BEFORE_TAXES_TAG, 0);
        this.incomeAfterTaxes = xr.getAttribute(INCOME_AFTER_TAXES_TAG, 0);
        this.traded = xr.getAttribute(TRADED_TAG, this.sales != 0);
        this.update();
        this.oldPrice = this.costToBuy;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("[").append(this.getId()).append(" ").append(this.goodsType.getId()).append(" costToBuy=").append(this.costToBuy).append(" paidForSale=").append(this.paidForSale).append(" amountInMarket=").append(this.amountInMarket).append(" initialPrice=").append(this.initialPrice).append(" arrears=").append(this.arrears).append(" sales=").append(this.sales).append(" incomeBeforeTaxes=").append(this.incomeBeforeTaxes).append(" incomeAfterTaxes=").append(this.incomeAfterTaxes).append(" oldPrice=").append(this.oldPrice).append(" traded=").append(this.traded).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return MarketData.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "marketData";
    }
}

