/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

public class Goods
extends AbstractGoods
implements Locatable,
Ownable {
    private static final Logger logger = Logger.getLogger(Goods.class.getName());
    private final Game game;
    private Location location;
    private static final String LOCATION_TAG = "location";

    public Goods(Game game, Location location, GoodsType type, int amount) {
        if (game == null) {
            throw new IllegalArgumentException("Null game.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type.");
        }
        if (location != null && location.getGoodsContainer() == null) {
            throw new IllegalArgumentException("Can not store goods at: " + location);
        }
        this.game = game;
        this.setId(type.getId());
        this.setSpecification(game.getSpecification());
        this.setType(type);
        this.setAmount(amount);
        this.location = location;
    }

    public Goods(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this.game = game;
        this.setSpecification(game.getSpecification());
        this.readFromXML(xr);
    }

    public Goods(Game game, Element e) {
        this.game = game;
        this.setSpecification(game.getSpecification());
        this.readFromXMLElement(e);
    }

    public Game getGame() {
        return this.game;
    }

    public StringTemplate getLabel(boolean sellable) {
        return StringTemplate.template(sellable ? "model.goods.goodsAmount" : "model.goods.goodsBoycotted").addAmount("%amount%", this.getAmount()).add("%goods%", this.getType().getNameKey());
    }

    public void adjustAmount() {
        if (this.location == null) {
            return;
        }
        GoodsContainer gc = this.location.getGoodsContainer();
        if (gc != null) {
            int maxAmount = gc.getGoodsCount(this.getType());
            if (this.getAmount() > maxAmount) {
                this.setAmount(maxAmount);
            }
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean setLocation(Location location) {
        this.location = location;
        return true;
    }

    @Override
    public boolean isInEurope() {
        return this.location instanceof Europe || this.location instanceof Unit && ((Unit)this.location).isInEurope();
    }

    @Override
    public Tile getTile() {
        return this.location == null ? null : this.location.getTile();
    }

    @Override
    public int getSpaceTaken() {
        return 1;
    }

    @Override
    public Player getOwner() {
        return this.location instanceof Ownable ? ((Ownable)((Object)this.location)).getOwner() : null;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Goods) {
            Goods g = (Goods)o;
            return this.location == g.location && super.equals(g);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Utils.hashCode(this.location);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.location != null) {
            xw.writeLocationAttribute(LOCATION_TAG, this.location);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.location = xr.getLocationAttribute(this.game, LOCATION_TAG, true);
    }

    @Override
    public String getXMLTagName() {
        return Goods.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goods";
    }
}

