/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class FreeColObject
implements Comparable<FreeColObject>,
ObjectWithId {
    protected static final Logger logger = Logger.getLogger(FreeColObject.class.getName());
    public static final int INFINITY = Integer.MAX_VALUE;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    private String id;
    private Specification specification;
    private PropertyChangeSupport pcs = null;
    public static final String ID_ATTRIBUTE_TAG = "id";
    public static final String ID_ATTRIBUTE = "ID";
    public static final String ARRAY_SIZE_TAG = "xLength";
    private static final String PARTIAL_ATTRIBUTE_TAG = "partial";
    private static final String OLD_PARTIAL_ATTRIBUTE_TAG = "PARTIAL";
    protected static final String VALUE_TAG = "value";

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void internId(String newId) {
        this.setId(newId);
    }

    public final String getSuffix(String prefix) {
        return this.getId().startsWith(prefix) ? this.getId().substring(prefix.length()) : this.getId();
    }

    public final String getSuffix() {
        String id = this.getId();
        return id == null ? null : StringUtils.lastPart(id, ".");
    }

    public Specification getSpecification() {
        return this.specification;
    }

    protected void setSpecification(Specification specification) {
        this.specification = specification;
    }

    public static String getIdType(String id) {
        if (id != null) {
            int col = id.indexOf(58);
            return col >= 0 ? id.substring(0, col) : id;
        }
        return null;
    }

    public String getIdType() {
        return FreeColObject.getIdType(this.getId());
    }

    public int getIdNumber() {
        int col;
        if (this.id != null && (col = this.id.indexOf(58)) >= 0) {
            try {
                return Integer.parseInt(this.id.substring(col + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int compareIds(FreeColObject fco1, FreeColObject fco2) {
        if (fco1 == null) {
            return fco2 == null ? 0 : -1;
        }
        if (fco2 == null) {
            return 1;
        }
        String id1 = fco1.getId();
        String id2 = fco2.getId();
        if (id1 == null) {
            return id2 == null ? 0 : -1;
        }
        if (id2 == null) {
            return 1;
        }
        int cmp = fco1.getIdType().compareTo(fco2.getIdType());
        if (cmp == 0) {
            cmp = fco1.getIdNumber() - fco2.getIdNumber();
        }
        if (cmp == 0) {
            cmp = fco1.hashCode() - fco2.hashCode();
        }
        return cmp;
    }

    @Override
    public int compareTo(FreeColObject other) {
        return FreeColObject.compareIds(this, other);
    }

    public static <T extends FreeColObject> List<T> getSortedCopy(Collection<T> c) {
        ArrayList<T> newC = new ArrayList<T>(c);
        Collections.sort(newC);
        return newC;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.pcs == null) {
            return new PropertyChangeListener[0];
        }
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.pcs == null) {
            return new PropertyChangeListener[0];
        }
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        if (this.pcs == null) {
            return false;
        }
        return this.pcs.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyName, listener);
        }
    }

    public FeatureContainer getFeatureContainer() {
        return null;
    }

    public final boolean hasAbility(String id) {
        return this.hasAbility(id, null);
    }

    public final boolean hasAbility(String id, FreeColGameObjectType fcgot) {
        return this.hasAbility(id, fcgot, null);
    }

    public final boolean hasAbility(String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.hasAbility(this.getAbilities(id, fcgot, turn));
    }

    public boolean containsAbilityKey(String key) {
        return !this.getAbilities(key, null, null).isEmpty();
    }

    public final List<Ability> getSortedAbilities() {
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        abilities.addAll(this.getAbilities());
        Collections.sort(abilities);
        return abilities;
    }

    public final Set<Ability> getAbilities() {
        return this.getAbilities(null);
    }

    public final Set<Ability> getAbilities(String id) {
        return this.getAbilities(id, null);
    }

    public final Set<Ability> getAbilities(String id, FreeColGameObjectType fcgot) {
        return this.getAbilities(id, fcgot, null);
    }

    public Set<Ability> getAbilities(String id, FreeColGameObjectType fcgot, Turn turn) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? Collections.emptySet() : fc.getAbilities(id, fcgot, turn);
    }

    public boolean addAbility(Ability ability) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? false : fc.addAbility(ability);
    }

    public Ability removeAbility(Ability ability) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? null : fc.removeAbility(ability);
    }

    public void removeAbilities(String id) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.removeAbilities(id);
        }
    }

    public final boolean hasModifier(String id) {
        return this.hasModifier(id, null);
    }

    public final boolean hasModifier(String id, FreeColGameObjectType fcgot) {
        return this.hasModifier(id, fcgot, null);
    }

    public boolean hasModifier(String id, FreeColGameObjectType fcgot, Turn turn) {
        return !this.getModifiers(id, fcgot, turn).isEmpty();
    }

    public final boolean containsModifierKey(String key) {
        Set<Modifier> set = this.getModifiers(key);
        return set == null ? false : !set.isEmpty();
    }

    public final List<Modifier> getSortedModifiers() {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        modifiers.addAll(this.getModifiers());
        Collections.sort(modifiers);
        return modifiers;
    }

    public final Set<Modifier> getModifiers() {
        return this.getModifiers(null);
    }

    public final Set<Modifier> getModifiers(String id) {
        return this.getModifiers(id, null);
    }

    public final Set<Modifier> getModifiers(String id, FreeColGameObjectType fcgot) {
        return this.getModifiers(id, fcgot, null);
    }

    public Set<Modifier> getModifiers(String id, FreeColGameObjectType fcgot, Turn turn) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? Collections.emptySet() : fc.getModifiers(id, fcgot, turn);
    }

    public final float applyModifiers(float number, Turn turn, String id) {
        return this.applyModifiers(number, turn, id, null);
    }

    public final float applyModifiers(float number, Turn turn, String id, FreeColGameObjectType fcgot) {
        return FreeColObject.applyModifiers(number, turn, this.getModifiers(id, fcgot, turn));
    }

    public static final float applyModifiers(float number, Turn turn, Collection<Modifier> mods) {
        return FeatureContainer.applyModifiers(number, turn, mods);
    }

    public boolean addModifier(Modifier modifier) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc == null) {
            return false;
        }
        return fc.addModifier(modifier);
    }

    public Modifier removeModifier(Modifier modifier) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc == null) {
            return null;
        }
        return fc.removeModifier(modifier);
    }

    public void removeModifiers(String id) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.removeModifiers(id);
        }
    }

    public void addFeatures(FreeColObject fco) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.addFeatures(fco);
        }
    }

    public void removeFeatures(FreeColObject fco) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.removeFeatures(fco);
        }
    }

    public Set<Modifier> getDefenceModifiers() {
        return this.getModifiers("model.modifier.defence");
    }

    public Element toXMLElement(Document document) {
        return this.toXMLElement(document, FreeColXMLWriter.WriteScope.toServer());
    }

    public Element toXMLElement(Document document, Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Null player for toXMLElement(doc, player)");
        }
        return this.toXMLElement(document, FreeColXMLWriter.WriteScope.toClient(player));
    }

    public Element toXMLElement(Document document, FreeColXMLWriter.WriteScope writeScope) {
        if (!writeScope.isValid()) {
            throw new IllegalStateException("Invalid write scope: " + (Object)((Object)writeScope));
        }
        return this.toXMLElement(document, writeScope, null);
    }

    public Element toXMLElementPartial(Document document, String ... fields) {
        return this.toXMLElement(document, FreeColXMLWriter.WriteScope.toServer(), fields);
    }

    private Element toXMLElement(Document document, FreeColXMLWriter.WriteScope writeScope, String[] fields) {
        StringWriter sw = new StringWriter();
        FreeColXMLWriter xw = null;
        try {
            xw = new FreeColXMLWriter(sw, writeScope);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter,", ioe);
            return null;
        }
        try {
            if (fields == null) {
                this.toXML(xw);
            } else {
                this.toXMLPartial(xw, fields);
            }
            xw.close();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document tempDocument = null;
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                tempDocument = builder.parse(new InputSource(new StringReader(sw.toString())));
                return (Element)document.importNode(tempDocument.getDocumentElement(), true);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                throw new RuntimeException("Parse fail", ex);
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Error writing stream", e);
        }
    }

    public static String readId(Element element) {
        String id = element.getAttribute(ID_ATTRIBUTE_TAG);
        if (id == null) {
            id = element.getAttribute(ID_ATTRIBUTE);
        }
        return id;
    }

    public void readFromXMLElement(Element element) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer xmlTransformer = factory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            xmlTransformer.transform(new DOMSource(element), new StreamResult(stringWriter));
            String xml = stringWriter.toString();
            try (FreeColXMLReader xr = new FreeColXMLReader(new StringReader(xml));){
                xr.nextTag();
                this.readFromXML(xr);
            }
            catch (XMLStreamException xe) {
                throw new IllegalStateException("XML failure", xe);
            }
        }
        catch (IOException | TransformerException ex) {
            throw new RuntimeException("Read failure", ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FreeColObject) {
            FreeColObject fco = (FreeColObject)o;
            return Utils.equals(this.id, fco.id);
        }
        return false;
    }

    public int hashCode() {
        return Utils.hashCode(this.id);
    }

    public void dumpObject() {
        this.save(System.err, FreeColXMLWriter.WriteScope.toSave(), false);
    }

    public static <T extends FreeColObject> void dumpCollection(Collection<T> items) {
        System.err.println("[Collection begin ");
        for (FreeColObject t : items) {
            t.dumpObject();
        }
        System.err.println(" collection end]");
    }

    public boolean save(File file) throws FileNotFoundException {
        return this.save(file, FreeColXMLWriter.WriteScope.toSave());
    }

    public boolean save(File file, FreeColXMLWriter.WriteScope scope) throws FileNotFoundException {
        return this.save(file, scope, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(File file, FreeColXMLWriter.WriteScope scope, boolean pretty) throws FileNotFoundException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            boolean bl = this.save(fos, scope, pretty);
            return bl;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FileOutputStream", ioe);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(OutputStream out, FreeColXMLWriter.WriteScope scope, boolean pretty) {
        try (FreeColXMLWriter xw = new FreeColXMLWriter(out, scope, pretty);){
            xw.writeStartDocument("UTF-8", "1.0");
            this.toXML(xw);
            xw.writeEndDocument();
            xw.flush();
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Exception writing object.", xse);
            return false;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter.", ioe);
        }
        return false;
    }

    public String serialize(FreeColXMLWriter.WriteScope scope) throws XMLStreamException {
        StringWriter sw = new StringWriter();
        try (FreeColXMLWriter xw = new FreeColXMLWriter(sw, scope);){
            this.toXML(xw);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter,", ioe);
            return null;
        }
        return sw.toString();
    }

    public String serialize() throws XMLStreamException {
        return this.serialize(FreeColXMLWriter.WriteScope.toServer());
    }

    public <T extends FreeColObject> T copy(Game game, Class<T> returnClass) {
        T ret = null;
        try (FreeColXMLReader xr = new FreeColXMLReader(new StringReader(this.serialize()));){
            ret = xr.copy(game, returnClass);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to copy: " + this.getId(), e);
        }
        return ret;
    }

    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        this.toXML(xw, this.getXMLTagName());
    }

    public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        xw.writeStartElement(tag);
        this.writeAttributes(xw);
        this.writeChildren(xw);
        xw.writeEndElement();
    }

    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.getId() == null) {
            logger.warning("FreeColObject with null identifier: " + this);
        } else {
            xw.writeAttribute(ID_ATTRIBUTE_TAG, this.getId());
        }
    }

    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
    }

    public final void toXMLPartial(FreeColXMLWriter xw, String[] fields) throws XMLStreamException {
        Class<?> theClass = this.getClass();
        try {
            xw.writeStartElement(this.getXMLTagName());
            xw.writeAttribute(ID_ATTRIBUTE_TAG, this.getId());
            xw.writeAttribute(PARTIAL_ATTRIBUTE_TAG, true);
            for (String field : fields) {
                Introspector intro = new Introspector(theClass, field);
                xw.writeAttribute(field, intro.getter(this));
            }
            xw.writeEndElement();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Partial write failed for " + theClass.getName(), e);
        }
    }

    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.hasAttribute(PARTIAL_ATTRIBUTE_TAG) || xr.hasAttribute(OLD_PARTIAL_ATTRIBUTE_TAG)) {
            this.readFromXMLPartial(xr);
        } else {
            this.readAttributes(xr);
            this.readChildren(xr);
        }
    }

    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        String newId = xr.readId();
        if (newId != null) {
            if (xr.shouldIntern()) {
                this.internId(newId);
            } else {
                this.setId(newId);
            }
        }
    }

    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (tag == null) {
            throw new XMLStreamException("Parse error, null opening tag.");
        }
        while (xr.nextTag() != 2) {
            this.readChild(xr);
        }
        xr.expectTag(tag);
    }

    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        throw new XMLStreamException("In " + this.getXMLTagName() + ", unexpected tag " + xr.getLocalName() + ", at: " + xr.currentTag());
    }

    public final void readFromXMLPartial(FreeColXMLReader xr) throws XMLStreamException {
        Class<?> theClass = this.getClass();
        String tag = xr.getLocalName();
        int n = xr.getAttributeCount();
        this.internId(xr.readId());
        for (int i = 0; i < n; ++i) {
            String name = xr.getAttributeLocalName(i);
            if (ID_ATTRIBUTE_TAG.equals(name) || ID_ATTRIBUTE.equals(name) || PARTIAL_ATTRIBUTE_TAG.equals(name)) continue;
            try {
                Introspector intro = new Introspector(theClass, name);
                intro.setter(this, xr.getAttributeValue(i));
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set field " + name, e);
            }
        }
        xr.closeTag(tag);
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId();
    }

    public abstract String getXMLTagName();

    public static String getXMLElementTagName() {
        return null;
    }
}

