/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;

public class Effect
extends FreeColGameObjectType {
    public static final String DAMAGED_UNIT = "model.disaster.effect.damagedUnit";
    public static final String LOSS_OF_UNIT = "model.disaster.effect.lossOfUnit";
    public static final String LOSS_OF_MONEY = "model.disaster.effect.lossOfMoney";
    public static final String LOSS_OF_GOODS = "model.disaster.effect.lossOfGoods";
    public static final String LOSS_OF_TILE_PRODUCTION = "model.disaster.effect.lossOfTileProduction";
    public static final String LOSS_OF_BUILDING = "model.disaster.effect.lossOfBuilding";
    public static final String LOSS_OF_BUILDING_PRODUCTION = "model.disaster.effect.lossOfBuildingProduction";
    private int probability;
    private List<Scope> scopes = null;
    private static final String PROBABILITY_TAG = "probability";

    protected Effect() {
    }

    public Effect(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(xr);
    }

    public Effect(Effect template) {
        this.setId(template.getId());
        this.setSpecification(template.getSpecification());
        this.probability = template.probability;
        this.scopes = template.scopes;
        this.addFeatures(template);
    }

    public final int getProbability() {
        return this.probability;
    }

    public final List<Scope> getScopes() {
        return this.scopes == null ? Collections.emptyList() : this.scopes;
    }

    private void addScope(Scope scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public boolean appliesTo(FreeColGameObjectType objectType) {
        if (this.scopes == null || this.scopes.isEmpty()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(objectType)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(PROBABILITY_TAG, this.probability);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Scope scope : this.getScopes()) {
            scope.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.probability = xr.getAttribute(PROBABILITY_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.scopes = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (Scope.getXMLElementTagName().equals(tag)) {
            this.addScope(new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" probability=").append(this.probability).append("%");
        for (Scope scope : this.getScopes()) {
            sb.append(" ").append(scope);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Effect.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "effect";
    }
}

