/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;

public class ColonyTradeItem
extends TradeItem {
    private String colonyId;
    private String colonyName;
    private static final String COLONY_TAG = "colony";
    private static final String COLONY_NAME_TAG = "colonyName";

    public ColonyTradeItem(Game game, Player source, Player destination, Colony colony) {
        super(game, "tradeItem.colony", source, destination);
        this.colonyId = colony.getId();
        this.colonyName = colony.getName();
        if (colony.getOwner() != source) {
            throw new IllegalArgumentException("Bad source for colony " + colony.getId());
        }
        if (destination == null || !destination.isEuropean()) {
            throw new IllegalArgumentException("Bad destination: " + destination);
        }
    }

    public ColonyTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.colonyId != null;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return StringTemplate.template("tradeItem.colony.long").addName("%colony%", this.colonyName);
    }

    @Override
    public Colony getColony(Game game) {
        return game.getFreeColGameObject(this.colonyId, Colony.class);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLONY_TAG, this.colonyId);
        xw.writeAttribute(COLONY_NAME_TAG, this.colonyName);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colonyId = xr.getAttribute(COLONY_TAG, null);
        this.colonyName = xr.getAttribute(COLONY_NAME_TAG, null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append(this.colonyName).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return ColonyTradeItem.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "colonyTradeItem";
    }
}

