/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;

public class BuildQueue<T extends BuildableType>
implements Consumer {
    private List<T> buildQueue = new ArrayList<T>();
    private CompletionAction completionAction = CompletionAction.REMOVE;
    private int priority = 500;
    private final Colony colony;

    public BuildQueue(Colony colony, CompletionAction action, int priority) {
        this.colony = colony;
        this.completionAction = action;
        this.priority = priority;
    }

    public T getCurrentlyBuilding() {
        return (T)(this.buildQueue.isEmpty() ? null : (BuildableType)this.buildQueue.get(0));
    }

    public void setCurrentlyBuilding(T buildable) {
        if (buildable instanceof BuildingType && this.buildQueue.contains(buildable)) {
            this.buildQueue.remove(buildable);
        }
        this.buildQueue.add(0, buildable);
    }

    public void clear() {
        this.buildQueue.clear();
    }

    public void add(T buildable) {
        this.buildQueue.add(buildable);
    }

    public List<T> getValues() {
        return this.buildQueue;
    }

    public void setValues(List<T> values) {
        this.buildQueue = values;
    }

    public void remove(int index) {
        this.buildQueue.remove(index);
    }

    public int size() {
        return this.buildQueue.size();
    }

    public boolean isEmpty() {
        return this.buildQueue.isEmpty();
    }

    public final CompletionAction getCompletionAction() {
        return this.completionAction;
    }

    public final void setCompletionAction(CompletionAction newCompletionAction) {
        this.completionAction = newCompletionAction;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        T current = this.getCurrentlyBuilding();
        return current == null ? new ArrayList() : ((BuildableType)current).getRequiredGoods();
    }

    public ProductionInfo getProductionInfo(List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        T current = this.getCurrentlyBuilding();
        if (current != null) {
            boolean overflow = this.colony.getSpecification().getBoolean("model.option.saveProductionOverflow");
            ArrayList<AbstractGoods> consumption = new ArrayList<AbstractGoods>();
            for (AbstractGoods ag : ((BuildableType)current).getRequiredGoods()) {
                boolean satisfied = false;
                AbstractGoods available = AbstractGoods.findByType(ag.getType(), input);
                if (available != null && ag.getAmount() <= available.getAmount()) {
                    int amount = overflow || ag.getType().isStorable() ? ag.getAmount() : available.getAmount();
                    consumption.add(new AbstractGoods(ag.getType(), amount));
                    satisfied = true;
                }
                if (satisfied) continue;
                return result;
            }
            result.setConsumption(consumption);
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean hasAbility(String id) {
        return "model.ability.consumeAllOrNothing".equals(id);
    }

    @Override
    public Set<Modifier> getModifiers(String id) {
        return Collections.emptySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[BuildQueue (").append(this.colony.getName()).append(")");
        for (BuildableType item : this.buildQueue) {
            sb.append(" ").append(item.getId());
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum CompletionAction {
        REMOVE,
        REMOVE_EXCEPT_LAST,
        SHUFFLE,
        ADD_RANDOM;

    }
}

