/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.util.CollectionUtils;

public class FreeColTcFile
extends FreeColModFile {
    private static final Set<String> FILE_ENDINGS = CollectionUtils.makeUnmodifiableSet(".ftc", ".zip");

    public FreeColTcFile(File file) throws IOException {
        super(file);
    }

    public FreeColTcFile(String id) throws IOException {
        super(new File(FreeColDirectories.getRulesDirectory(), id));
    }

    public Specification getSpecification() throws IOException {
        InputStream si = this.getSpecificationInputStream();
        if (si == null) {
            return null;
        }
        Specification specification = new Specification(si);
        si.close();
        return specification;
    }

    @Override
    public ResourceMapping getResourceMapping() {
        ResourceMapping result = new ResourceMapping();
        try {
            if (this.getParent() != null) {
                FreeColTcFile parentTcData = new FreeColTcFile(this.getParent());
                result.addAll(parentTcData.getResourceMapping());
            }
            result.addAll(super.getResourceMapping());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected static Set<String> getFileEndings() {
        return FILE_ENDINGS;
    }
}

