/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.util.CollectionUtils;

public class FreeColModFile
extends FreeColDataFile
implements ObjectWithId {
    private static final Set<String> FILE_ENDINGS = CollectionUtils.makeUnmodifiableSet(".fmd", ".zip");
    public static final String SPECIFICATION_FILE = "specification.xml";
    public static final String MOD_DESCRIPTOR_FILE = "mod.xml";
    private String id;
    private String parent;

    public FreeColModFile(File file) throws IOException {
        super(file);
        this.readModDescriptor();
    }

    public InputStream getSpecificationInputStream() throws IOException {
        try {
            return this.getInputStream(SPECIFICATION_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected void readModDescriptor() throws IOException {
        try (FreeColXMLReader xr = new FreeColXMLReader(this.getModDescriptorInputStream());){
            xr.nextTag();
            this.id = xr.readId();
            this.parent = xr.getAttribute("parent", null);
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private InputStream getModDescriptorInputStream() throws IOException {
        return this.getInputStream(MOD_DESCRIPTOR_FILE);
    }

    protected static Set<String> getFileEndings() {
        return FILE_ENDINGS;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }
}

