/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.common.i18n.Messages;

public class FreeColFileFilter
extends FileFilter {
    private final String[] extensions;
    private final boolean allowSubdirs;
    private final String description;
    public static final FileFilter freeColSaveDirectoryFilter = new FreeColFileFilter(".fsg", true, "filter.savedGames");

    public FreeColFileFilter(String extension, boolean allowSubdirs, String description) {
        this.extensions = new String[]{extension};
        this.allowSubdirs = allowSubdirs;
        this.description = Messages.message(description);
    }

    @Override
    public boolean accept(File f) {
        if (this.allowSubdirs && f.isDirectory()) {
            return true;
        }
        if (!f.isFile()) {
            return false;
        }
        for (String x : this.extensions) {
            if (!f.getName().endsWith(x) || f.getName().length() <= x.length()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

